<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$method_view = new method_view();

// Run the page
$method_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$method_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$method->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmethodview = currentForm = new ew.Form("fmethodview", "view");

// Form_CustomValidate event
fmethodview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmethodview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmethodview.lists["x_grp"] = <?php echo $method_view->grp->Lookup->toClientList() ?>;
fmethodview.lists["x_grp"].options = <?php echo JsonEncode($method_view->grp->lookupOptions()) ?>;
fmethodview.lists["x_status"] = <?php echo $method_view->status->Lookup->toClientList() ?>;
fmethodview.lists["x_status"].options = <?php echo JsonEncode($method_view->status->options(FALSE, TRUE)) ?>;
fmethodview.lists["x_operator"] = <?php echo $method_view->operator->Lookup->toClientList() ?>;
fmethodview.lists["x_operator"].options = <?php echo JsonEncode($method_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$method->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $method_view->ExportOptions->render("body") ?>
<?php $method_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $method_view->showPageHeader(); ?>
<?php
$method_view->showMessage();
?>
<form name="fmethodview" id="fmethodview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($method_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $method_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="method">
<input type="hidden" name="modal" value="<?php echo (int)$method_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($method->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $method_view->TableLeftColumnClass ?>"><span id="elh_method_id"><?php echo $method->id->caption() ?></span></td>
		<td data-name="id"<?php echo $method->id->cellAttributes() ?>>
<span id="el_method_id">
<span<?php echo $method->id->viewAttributes() ?>>
<?php echo $method->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($method->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $method_view->TableLeftColumnClass ?>"><span id="elh_method_grp"><?php echo $method->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $method->grp->cellAttributes() ?>>
<span id="el_method_grp">
<span<?php echo $method->grp->viewAttributes() ?>>
<?php echo $method->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($method->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $method_view->TableLeftColumnClass ?>"><span id="elh_method_item"><?php echo $method->item->caption() ?></span></td>
		<td data-name="item"<?php echo $method->item->cellAttributes() ?>>
<span id="el_method_item">
<span<?php echo $method->item->viewAttributes() ?>>
<?php echo $method->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($method->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $method_view->TableLeftColumnClass ?>"><span id="elh_method_status"><?php echo $method->status->caption() ?></span></td>
		<td data-name="status"<?php echo $method->status->cellAttributes() ?>>
<span id="el_method_status">
<span<?php echo $method->status->viewAttributes() ?>>
<?php echo $method->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($method->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $method_view->TableLeftColumnClass ?>"><span id="elh_method_operator"><?php echo $method->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $method->operator->cellAttributes() ?>>
<span id="el_method_operator">
<span<?php echo $method->operator->viewAttributes() ?>>
<?php echo $method->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($method->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $method_view->TableLeftColumnClass ?>"><span id="elh_method_datetime"><?php echo $method->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $method->datetime->cellAttributes() ?>>
<span id="el_method_datetime">
<span<?php echo $method->datetime->viewAttributes() ?>>
<?php echo $method->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$method_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$method->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$method_view->terminate();
?>