<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mgs_certificate_data_list = new mgs_certificate_data_list();

// Run the page
$mgs_certificate_data_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mgs_certificate_data_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mgs_certificate_data->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmgs_certificate_datalist = currentForm = new ew.Form("fmgs_certificate_datalist", "list");
fmgs_certificate_datalist.formKeyCountName = '<?php echo $mgs_certificate_data_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmgs_certificate_datalist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmgs_certificate_datalist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmgs_certificate_datalist.lists["x_certificate_id"] = <?php echo $mgs_certificate_data_list->certificate_id->Lookup->toClientList() ?>;
fmgs_certificate_datalist.lists["x_certificate_id"].options = <?php echo JsonEncode($mgs_certificate_data_list->certificate_id->lookupOptions()) ?>;

// Form object for search
var fmgs_certificate_datalistsrch = currentSearchForm = new ew.Form("fmgs_certificate_datalistsrch");

// Filters
fmgs_certificate_datalistsrch.filterList = <?php echo $mgs_certificate_data_list->getFilterList() ?>;

// Init search panel as collapsed
fmgs_certificate_datalistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mgs_certificate_data->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mgs_certificate_data_list->TotalRecs > 0 && $mgs_certificate_data_list->ExportOptions->visible()) { ?>
<?php $mgs_certificate_data_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mgs_certificate_data_list->ImportOptions->visible()) { ?>
<?php $mgs_certificate_data_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mgs_certificate_data_list->SearchOptions->visible()) { ?>
<?php $mgs_certificate_data_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mgs_certificate_data_list->FilterOptions->visible()) { ?>
<?php $mgs_certificate_data_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$mgs_certificate_data_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mgs_certificate_data->isExport() && !$mgs_certificate_data->CurrentAction) { ?>
<form name="fmgs_certificate_datalistsrch" id="fmgs_certificate_datalistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($mgs_certificate_data_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmgs_certificate_datalistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mgs_certificate_data">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($mgs_certificate_data_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($mgs_certificate_data_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $mgs_certificate_data_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($mgs_certificate_data_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($mgs_certificate_data_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($mgs_certificate_data_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($mgs_certificate_data_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $mgs_certificate_data_list->showPageHeader(); ?>
<?php
$mgs_certificate_data_list->showMessage();
?>
<?php if ($mgs_certificate_data_list->TotalRecs > 0 || $mgs_certificate_data->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mgs_certificate_data_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mgs_certificate_data">
<?php if (!$mgs_certificate_data->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$mgs_certificate_data->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mgs_certificate_data_list->Pager)) $mgs_certificate_data_list->Pager = new PrevNextPager($mgs_certificate_data_list->StartRec, $mgs_certificate_data_list->DisplayRecs, $mgs_certificate_data_list->TotalRecs, $mgs_certificate_data_list->AutoHidePager) ?>
<?php if ($mgs_certificate_data_list->Pager->RecordCount > 0 && $mgs_certificate_data_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mgs_certificate_data_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mgs_certificate_data_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mgs_certificate_data_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mgs_certificate_data_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mgs_certificate_data_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mgs_certificate_data_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mgs_certificate_data_list->TotalRecs > 0 && (!$mgs_certificate_data_list->AutoHidePageSizeSelector || $mgs_certificate_data_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mgs_certificate_data">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mgs_certificate_data_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mgs_certificate_data_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mgs_certificate_data_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mgs_certificate_data_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mgs_certificate_data_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mgs_certificate_data->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mgs_certificate_data_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmgs_certificate_datalist" id="fmgs_certificate_datalist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mgs_certificate_data_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mgs_certificate_data_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mgs_certificate_data">
<div id="gmp_mgs_certificate_data" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($mgs_certificate_data_list->TotalRecs > 0 || $mgs_certificate_data->isGridEdit()) { ?>
<table id="tbl_mgs_certificate_datalist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mgs_certificate_data_list->RowType = ROWTYPE_HEADER;

// Render list options
$mgs_certificate_data_list->renderListOptions();

// Render list options (header, left)
$mgs_certificate_data_list->ListOptions->render("header", "left");
?>
<?php if ($mgs_certificate_data->id->Visible) { // id ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->id) == "") { ?>
		<th data-name="id" class="<?php echo $mgs_certificate_data->id->headerCellClass() ?>"><div id="elh_mgs_certificate_data_id" class="mgs_certificate_data_id"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $mgs_certificate_data->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->id) ?>',2);"><div id="elh_mgs_certificate_data_id" class="mgs_certificate_data_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->certificate_id->Visible) { // certificate_id ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->certificate_id) == "") { ?>
		<th data-name="certificate_id" class="<?php echo $mgs_certificate_data->certificate_id->headerCellClass() ?>"><div id="elh_mgs_certificate_data_certificate_id" class="mgs_certificate_data_certificate_id"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->certificate_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="certificate_id" class="<?php echo $mgs_certificate_data->certificate_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->certificate_id) ?>',2);"><div id="elh_mgs_certificate_data_certificate_id" class="mgs_certificate_data_certificate_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->certificate_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->certificate_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->certificate_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->name->Visible) { // name ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->name) == "") { ?>
		<th data-name="name" class="<?php echo $mgs_certificate_data->name->headerCellClass() ?>"><div id="elh_mgs_certificate_data_name" class="mgs_certificate_data_name"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $mgs_certificate_data->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->name) ?>',2);"><div id="elh_mgs_certificate_data_name" class="mgs_certificate_data_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->line_1->Visible) { // line_1 ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->line_1) == "") { ?>
		<th data-name="line_1" class="<?php echo $mgs_certificate_data->line_1->headerCellClass() ?>"><div id="elh_mgs_certificate_data_line_1" class="mgs_certificate_data_line_1"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->line_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="line_1" class="<?php echo $mgs_certificate_data->line_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->line_1) ?>',2);"><div id="elh_mgs_certificate_data_line_1" class="mgs_certificate_data_line_1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->line_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->line_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->line_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->line_2->Visible) { // line_2 ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->line_2) == "") { ?>
		<th data-name="line_2" class="<?php echo $mgs_certificate_data->line_2->headerCellClass() ?>"><div id="elh_mgs_certificate_data_line_2" class="mgs_certificate_data_line_2"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->line_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="line_2" class="<?php echo $mgs_certificate_data->line_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->line_2) ?>',2);"><div id="elh_mgs_certificate_data_line_2" class="mgs_certificate_data_line_2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->line_2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->line_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->line_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->e_mail->Visible) { // e_mail ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->e_mail) == "") { ?>
		<th data-name="e_mail" class="<?php echo $mgs_certificate_data->e_mail->headerCellClass() ?>"><div id="elh_mgs_certificate_data_e_mail" class="mgs_certificate_data_e_mail"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->e_mail->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_mail" class="<?php echo $mgs_certificate_data->e_mail->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->e_mail) ?>',2);"><div id="elh_mgs_certificate_data_e_mail" class="mgs_certificate_data_e_mail">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->e_mail->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->e_mail->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->e_mail->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->updated->Visible) { // updated ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->updated) == "") { ?>
		<th data-name="updated" class="<?php echo $mgs_certificate_data->updated->headerCellClass() ?>"><div id="elh_mgs_certificate_data_updated" class="mgs_certificate_data_updated"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="updated" class="<?php echo $mgs_certificate_data->updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->updated) ?>',2);"><div id="elh_mgs_certificate_data_updated" class="mgs_certificate_data_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->updated->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->jpg->Visible) { // jpg ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->jpg) == "") { ?>
		<th data-name="jpg" class="<?php echo $mgs_certificate_data->jpg->headerCellClass() ?>"><div id="elh_mgs_certificate_data_jpg" class="mgs_certificate_data_jpg"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->jpg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jpg" class="<?php echo $mgs_certificate_data->jpg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->jpg) ?>',2);"><div id="elh_mgs_certificate_data_jpg" class="mgs_certificate_data_jpg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->jpg->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->jpg->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->jpg->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->pdf->Visible) { // pdf ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->pdf) == "") { ?>
		<th data-name="pdf" class="<?php echo $mgs_certificate_data->pdf->headerCellClass() ?>"><div id="elh_mgs_certificate_data_pdf" class="mgs_certificate_data_pdf"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->pdf->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pdf" class="<?php echo $mgs_certificate_data->pdf->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->pdf) ?>',2);"><div id="elh_mgs_certificate_data_pdf" class="mgs_certificate_data_pdf">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->pdf->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->pdf->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->pdf->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->mail_status->Visible) { // mail_status ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->mail_status) == "") { ?>
		<th data-name="mail_status" class="<?php echo $mgs_certificate_data->mail_status->headerCellClass() ?>"><div id="elh_mgs_certificate_data_mail_status" class="mgs_certificate_data_mail_status"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->mail_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mail_status" class="<?php echo $mgs_certificate_data->mail_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->mail_status) ?>',2);"><div id="elh_mgs_certificate_data_mail_status" class="mgs_certificate_data_mail_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->mail_status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->mail_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->mail_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->operator->Visible) { // operator ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $mgs_certificate_data->operator->headerCellClass() ?>"><div id="elh_mgs_certificate_data_operator" class="mgs_certificate_data_operator"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $mgs_certificate_data->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->operator) ?>',2);"><div id="elh_mgs_certificate_data_operator" class="mgs_certificate_data_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate_data->datetime->Visible) { // datetime ?>
	<?php if ($mgs_certificate_data->sortUrl($mgs_certificate_data->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $mgs_certificate_data->datetime->headerCellClass() ?>"><div id="elh_mgs_certificate_data_datetime" class="mgs_certificate_data_datetime"><div class="ew-table-header-caption"><?php echo $mgs_certificate_data->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $mgs_certificate_data->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate_data->SortUrl($mgs_certificate_data->datetime) ?>',2);"><div id="elh_mgs_certificate_data_datetime" class="mgs_certificate_data_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate_data->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate_data->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate_data->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mgs_certificate_data_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mgs_certificate_data->ExportAll && $mgs_certificate_data->isExport()) {
	$mgs_certificate_data_list->StopRec = $mgs_certificate_data_list->TotalRecs;
} else {

	// Set the last record to display
	if ($mgs_certificate_data_list->TotalRecs > $mgs_certificate_data_list->StartRec + $mgs_certificate_data_list->DisplayRecs - 1)
		$mgs_certificate_data_list->StopRec = $mgs_certificate_data_list->StartRec + $mgs_certificate_data_list->DisplayRecs - 1;
	else
		$mgs_certificate_data_list->StopRec = $mgs_certificate_data_list->TotalRecs;
}
$mgs_certificate_data_list->RecCnt = $mgs_certificate_data_list->StartRec - 1;
if ($mgs_certificate_data_list->Recordset && !$mgs_certificate_data_list->Recordset->EOF) {
	$mgs_certificate_data_list->Recordset->moveFirst();
	$selectLimit = $mgs_certificate_data_list->UseSelectLimit;
	if (!$selectLimit && $mgs_certificate_data_list->StartRec > 1)
		$mgs_certificate_data_list->Recordset->move($mgs_certificate_data_list->StartRec - 1);
} elseif (!$mgs_certificate_data->AllowAddDeleteRow && $mgs_certificate_data_list->StopRec == 0) {
	$mgs_certificate_data_list->StopRec = $mgs_certificate_data->GridAddRowCount;
}

// Initialize aggregate
$mgs_certificate_data->RowType = ROWTYPE_AGGREGATEINIT;
$mgs_certificate_data->resetAttributes();
$mgs_certificate_data_list->renderRow();
while ($mgs_certificate_data_list->RecCnt < $mgs_certificate_data_list->StopRec) {
	$mgs_certificate_data_list->RecCnt++;
	if ($mgs_certificate_data_list->RecCnt >= $mgs_certificate_data_list->StartRec) {
		$mgs_certificate_data_list->RowCnt++;

		// Set up key count
		$mgs_certificate_data_list->KeyCount = $mgs_certificate_data_list->RowIndex;

		// Init row class and style
		$mgs_certificate_data->resetAttributes();
		$mgs_certificate_data->CssClass = "";
		if ($mgs_certificate_data->isGridAdd()) {
		} else {
			$mgs_certificate_data_list->loadRowValues($mgs_certificate_data_list->Recordset); // Load row values
		}
		$mgs_certificate_data->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$mgs_certificate_data->RowAttrs = array_merge($mgs_certificate_data->RowAttrs, array('data-rowindex'=>$mgs_certificate_data_list->RowCnt, 'id'=>'r' . $mgs_certificate_data_list->RowCnt . '_mgs_certificate_data', 'data-rowtype'=>$mgs_certificate_data->RowType));

		// Render row
		$mgs_certificate_data_list->renderRow();

		// Render list options
		$mgs_certificate_data_list->renderListOptions();
?>
	<tr<?php echo $mgs_certificate_data->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mgs_certificate_data_list->ListOptions->render("body", "left", $mgs_certificate_data_list->RowCnt);
?>
	<?php if ($mgs_certificate_data->id->Visible) { // id ?>
		<td data-name="id"<?php echo $mgs_certificate_data->id->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_id" class="mgs_certificate_data_id">
<span<?php echo $mgs_certificate_data->id->viewAttributes() ?>>
<?php echo $mgs_certificate_data->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->certificate_id->Visible) { // certificate_id ?>
		<td data-name="certificate_id"<?php echo $mgs_certificate_data->certificate_id->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_certificate_id" class="mgs_certificate_data_certificate_id">
<span<?php echo $mgs_certificate_data->certificate_id->viewAttributes() ?>>
<?php echo $mgs_certificate_data->certificate_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->name->Visible) { // name ?>
		<td data-name="name"<?php echo $mgs_certificate_data->name->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_name" class="mgs_certificate_data_name">
<span<?php echo $mgs_certificate_data->name->viewAttributes() ?>>
<?php echo $mgs_certificate_data->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->line_1->Visible) { // line_1 ?>
		<td data-name="line_1"<?php echo $mgs_certificate_data->line_1->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_line_1" class="mgs_certificate_data_line_1">
<span<?php echo $mgs_certificate_data->line_1->viewAttributes() ?>>
<?php echo $mgs_certificate_data->line_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->line_2->Visible) { // line_2 ?>
		<td data-name="line_2"<?php echo $mgs_certificate_data->line_2->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_line_2" class="mgs_certificate_data_line_2">
<span<?php echo $mgs_certificate_data->line_2->viewAttributes() ?>>
<?php echo $mgs_certificate_data->line_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->e_mail->Visible) { // e_mail ?>
		<td data-name="e_mail"<?php echo $mgs_certificate_data->e_mail->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_e_mail" class="mgs_certificate_data_e_mail">
<span<?php echo $mgs_certificate_data->e_mail->viewAttributes() ?>>
<?php echo $mgs_certificate_data->e_mail->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->updated->Visible) { // updated ?>
		<td data-name="updated"<?php echo $mgs_certificate_data->updated->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_updated" class="mgs_certificate_data_updated">
<span<?php echo $mgs_certificate_data->updated->viewAttributes() ?>>
<?php echo $mgs_certificate_data->updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->jpg->Visible) { // jpg ?>
		<td data-name="jpg"<?php echo $mgs_certificate_data->jpg->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_jpg" class="mgs_certificate_data_jpg">
<span<?php echo $mgs_certificate_data->jpg->viewAttributes() ?>>
<?php echo GetFileViewTag($mgs_certificate_data->jpg, $mgs_certificate_data->jpg->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->pdf->Visible) { // pdf ?>
		<td data-name="pdf"<?php echo $mgs_certificate_data->pdf->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_pdf" class="mgs_certificate_data_pdf">
<span<?php echo $mgs_certificate_data->pdf->viewAttributes() ?>>
<?php if ((!EmptyString($mgs_certificate_data->pdf->getViewValue())) && $mgs_certificate_data->pdf->linkAttributes() <> "") { ?>
<a<?php echo $mgs_certificate_data->pdf->linkAttributes() ?>><?php echo $mgs_certificate_data->pdf->getViewValue() ?></a>
<?php } else { ?>
<?php echo $mgs_certificate_data->pdf->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->mail_status->Visible) { // mail_status ?>
		<td data-name="mail_status"<?php echo $mgs_certificate_data->mail_status->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_mail_status" class="mgs_certificate_data_mail_status">
<span<?php echo $mgs_certificate_data->mail_status->viewAttributes() ?>>
<?php echo $mgs_certificate_data->mail_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $mgs_certificate_data->operator->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_operator" class="mgs_certificate_data_operator">
<span<?php echo $mgs_certificate_data->operator->viewAttributes() ?>>
<?php echo $mgs_certificate_data->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate_data->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $mgs_certificate_data->datetime->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_data_list->RowCnt ?>_mgs_certificate_data_datetime" class="mgs_certificate_data_datetime">
<span<?php echo $mgs_certificate_data->datetime->viewAttributes() ?>>
<?php echo $mgs_certificate_data->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mgs_certificate_data_list->ListOptions->render("body", "right", $mgs_certificate_data_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$mgs_certificate_data->isGridAdd())
		$mgs_certificate_data_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$mgs_certificate_data->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mgs_certificate_data_list->Recordset)
	$mgs_certificate_data_list->Recordset->Close();
?>
<?php if (!$mgs_certificate_data->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mgs_certificate_data->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mgs_certificate_data_list->Pager)) $mgs_certificate_data_list->Pager = new PrevNextPager($mgs_certificate_data_list->StartRec, $mgs_certificate_data_list->DisplayRecs, $mgs_certificate_data_list->TotalRecs, $mgs_certificate_data_list->AutoHidePager) ?>
<?php if ($mgs_certificate_data_list->Pager->RecordCount > 0 && $mgs_certificate_data_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mgs_certificate_data_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mgs_certificate_data_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mgs_certificate_data_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mgs_certificate_data_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mgs_certificate_data_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mgs_certificate_data_list->pageUrl() ?>start=<?php echo $mgs_certificate_data_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mgs_certificate_data_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mgs_certificate_data_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mgs_certificate_data_list->TotalRecs > 0 && (!$mgs_certificate_data_list->AutoHidePageSizeSelector || $mgs_certificate_data_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mgs_certificate_data">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mgs_certificate_data_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mgs_certificate_data_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mgs_certificate_data_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mgs_certificate_data_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mgs_certificate_data_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mgs_certificate_data->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mgs_certificate_data_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mgs_certificate_data_list->TotalRecs == 0 && !$mgs_certificate_data->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mgs_certificate_data_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mgs_certificate_data_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mgs_certificate_data->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$mgs_certificate_data->isExport()) { ?>
<script>
ew.scrollableTable("gmp_mgs_certificate_data", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mgs_certificate_data_list->terminate();
?>