<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mgs_certificate_data_search = new mgs_certificate_data_search();

// Run the page
$mgs_certificate_data_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mgs_certificate_data_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($mgs_certificate_data_search->IsModal) { ?>
var fmgs_certificate_datasearch = currentAdvancedSearchForm = new ew.Form("fmgs_certificate_datasearch", "search");
<?php } else { ?>
var fmgs_certificate_datasearch = currentForm = new ew.Form("fmgs_certificate_datasearch", "search");
<?php } ?>

// Form_CustomValidate event
fmgs_certificate_datasearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmgs_certificate_datasearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmgs_certificate_datasearch.lists["x_certificate_id"] = <?php echo $mgs_certificate_data_search->certificate_id->Lookup->toClientList() ?>;
fmgs_certificate_datasearch.lists["x_certificate_id"].options = <?php echo JsonEncode($mgs_certificate_data_search->certificate_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmgs_certificate_datasearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mgs_certificate_data->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_updated");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mgs_certificate_data->updated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mgs_certificate_data->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mgs_certificate_data->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $mgs_certificate_data_search->showPageHeader(); ?>
<?php
$mgs_certificate_data_search->showMessage();
?>
<form name="fmgs_certificate_datasearch" id="fmgs_certificate_datasearch" class="<?php echo $mgs_certificate_data_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mgs_certificate_data_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mgs_certificate_data_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mgs_certificate_data">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$mgs_certificate_data_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($mgs_certificate_data->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_id"><?php echo $mgs_certificate_data->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->id->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_id">
<input type="text" data-table="mgs_certificate_data" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($mgs_certificate_data->id->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->id->EditValue ?>"<?php echo $mgs_certificate_data->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->certificate_id->Visible) { // certificate_id ?>
	<div id="r_certificate_id" class="form-group row">
		<label for="x_certificate_id" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_certificate_id"><?php echo $mgs_certificate_data->certificate_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_certificate_id" id="z_certificate_id" value="="></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->certificate_id->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_certificate_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mgs_certificate_data" data-field="x_certificate_id" data-value-separator="<?php echo $mgs_certificate_data->certificate_id->displayValueSeparatorAttribute() ?>" id="x_certificate_id" name="x_certificate_id"<?php echo $mgs_certificate_data->certificate_id->editAttributes() ?>>
		<?php echo $mgs_certificate_data->certificate_id->selectOptionListHtml("x_certificate_id") ?>
	</select>
</div>
<?php echo $mgs_certificate_data->certificate_id->Lookup->getParamTag("p_x_certificate_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_name"><?php echo $mgs_certificate_data->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->name->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_name">
<input type="text" data-table="mgs_certificate_data" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($mgs_certificate_data->name->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->name->EditValue ?>"<?php echo $mgs_certificate_data->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->line_1->Visible) { // line_1 ?>
	<div id="r_line_1" class="form-group row">
		<label for="x_line_1" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_line_1"><?php echo $mgs_certificate_data->line_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_line_1" id="z_line_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->line_1->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_line_1">
<input type="text" data-table="mgs_certificate_data" data-field="x_line_1" name="x_line_1" id="x_line_1" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($mgs_certificate_data->line_1->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->line_1->EditValue ?>"<?php echo $mgs_certificate_data->line_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->line_2->Visible) { // line_2 ?>
	<div id="r_line_2" class="form-group row">
		<label for="x_line_2" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_line_2"><?php echo $mgs_certificate_data->line_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_line_2" id="z_line_2" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->line_2->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_line_2">
<input type="text" data-table="mgs_certificate_data" data-field="x_line_2" name="x_line_2" id="x_line_2" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($mgs_certificate_data->line_2->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->line_2->EditValue ?>"<?php echo $mgs_certificate_data->line_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->e_mail->Visible) { // e_mail ?>
	<div id="r_e_mail" class="form-group row">
		<label for="x_e_mail" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_e_mail"><?php echo $mgs_certificate_data->e_mail->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_e_mail" id="z_e_mail" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->e_mail->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_e_mail">
<input type="text" data-table="mgs_certificate_data" data-field="x_e_mail" name="x_e_mail" id="x_e_mail" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($mgs_certificate_data->e_mail->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->e_mail->EditValue ?>"<?php echo $mgs_certificate_data->e_mail->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_updated"><?php echo $mgs_certificate_data->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_updated" id="z_updated" value="="></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->updated->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_updated">
<input type="text" data-table="mgs_certificate_data" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($mgs_certificate_data->updated->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->updated->EditValue ?>"<?php echo $mgs_certificate_data->updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->jpg->Visible) { // jpg ?>
	<div id="r_jpg" class="form-group row">
		<label class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_jpg"><?php echo $mgs_certificate_data->jpg->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_jpg" id="z_jpg" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->jpg->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_jpg">
<input type="text" data-table="mgs_certificate_data" data-field="x_jpg" name="x_jpg" id="x_jpg" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($mgs_certificate_data->jpg->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->jpg->EditValue ?>"<?php echo $mgs_certificate_data->jpg->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->pdf->Visible) { // pdf ?>
	<div id="r_pdf" class="form-group row">
		<label for="x_pdf" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_pdf"><?php echo $mgs_certificate_data->pdf->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pdf" id="z_pdf" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->pdf->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_pdf">
<input type="text" data-table="mgs_certificate_data" data-field="x_pdf" name="x_pdf" id="x_pdf" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($mgs_certificate_data->pdf->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->pdf->EditValue ?>"<?php echo $mgs_certificate_data->pdf->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->mail_status->Visible) { // mail_status ?>
	<div id="r_mail_status" class="form-group row">
		<label for="x_mail_status" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_mail_status"><?php echo $mgs_certificate_data->mail_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mail_status" id="z_mail_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->mail_status->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_mail_status">
<input type="text" data-table="mgs_certificate_data" data-field="x_mail_status" name="x_mail_status" id="x_mail_status" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($mgs_certificate_data->mail_status->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->mail_status->EditValue ?>"<?php echo $mgs_certificate_data->mail_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_operator"><?php echo $mgs_certificate_data->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->operator->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_operator">
<input type="text" data-table="mgs_certificate_data" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($mgs_certificate_data->operator->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->operator->EditValue ?>"<?php echo $mgs_certificate_data->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mgs_certificate_data->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $mgs_certificate_data_search->LeftColumnClass ?>"><span id="elh_mgs_certificate_data_datetime"><?php echo $mgs_certificate_data->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $mgs_certificate_data_search->RightColumnClass ?>"><div<?php echo $mgs_certificate_data->datetime->cellAttributes() ?>>
			<span id="el_mgs_certificate_data_datetime">
<input type="text" data-table="mgs_certificate_data" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($mgs_certificate_data->datetime->getPlaceHolder()) ?>" value="<?php echo $mgs_certificate_data->datetime->EditValue ?>"<?php echo $mgs_certificate_data->datetime->editAttributes() ?>>
<?php if (!$mgs_certificate_data->datetime->ReadOnly && !$mgs_certificate_data->datetime->Disabled && !isset($mgs_certificate_data->datetime->EditAttrs["readonly"]) && !isset($mgs_certificate_data->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmgs_certificate_datasearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$mgs_certificate_data_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $mgs_certificate_data_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$mgs_certificate_data_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$mgs_certificate_data_search->terminate();
?>