<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mgs_certificate_list = new mgs_certificate_list();

// Run the page
$mgs_certificate_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mgs_certificate_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mgs_certificate->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmgs_certificatelist = currentForm = new ew.Form("fmgs_certificatelist", "list");
fmgs_certificatelist.formKeyCountName = '<?php echo $mgs_certificate_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmgs_certificatelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmgs_certificatelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmgs_certificatelist.lists["x_status"] = <?php echo $mgs_certificate_list->status->Lookup->toClientList() ?>;
fmgs_certificatelist.lists["x_status"].options = <?php echo JsonEncode($mgs_certificate_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fmgs_certificatelistsrch = currentSearchForm = new ew.Form("fmgs_certificatelistsrch");

// Filters
fmgs_certificatelistsrch.filterList = <?php echo $mgs_certificate_list->getFilterList() ?>;

// Init search panel as collapsed
fmgs_certificatelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mgs_certificate->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mgs_certificate_list->TotalRecs > 0 && $mgs_certificate_list->ExportOptions->visible()) { ?>
<?php $mgs_certificate_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mgs_certificate_list->ImportOptions->visible()) { ?>
<?php $mgs_certificate_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mgs_certificate_list->SearchOptions->visible()) { ?>
<?php $mgs_certificate_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mgs_certificate_list->FilterOptions->visible()) { ?>
<?php $mgs_certificate_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$mgs_certificate_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mgs_certificate->isExport() && !$mgs_certificate->CurrentAction) { ?>
<form name="fmgs_certificatelistsrch" id="fmgs_certificatelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($mgs_certificate_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmgs_certificatelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mgs_certificate">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($mgs_certificate_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($mgs_certificate_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $mgs_certificate_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($mgs_certificate_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($mgs_certificate_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($mgs_certificate_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($mgs_certificate_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $mgs_certificate_list->showPageHeader(); ?>
<?php
$mgs_certificate_list->showMessage();
?>
<?php if ($mgs_certificate_list->TotalRecs > 0 || $mgs_certificate->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mgs_certificate_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mgs_certificate">
<?php if (!$mgs_certificate->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$mgs_certificate->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mgs_certificate_list->Pager)) $mgs_certificate_list->Pager = new PrevNextPager($mgs_certificate_list->StartRec, $mgs_certificate_list->DisplayRecs, $mgs_certificate_list->TotalRecs, $mgs_certificate_list->AutoHidePager) ?>
<?php if ($mgs_certificate_list->Pager->RecordCount > 0 && $mgs_certificate_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mgs_certificate_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mgs_certificate_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mgs_certificate_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mgs_certificate_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mgs_certificate_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mgs_certificate_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mgs_certificate_list->TotalRecs > 0 && (!$mgs_certificate_list->AutoHidePageSizeSelector || $mgs_certificate_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mgs_certificate">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mgs_certificate_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mgs_certificate_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mgs_certificate_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mgs_certificate_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mgs_certificate_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mgs_certificate->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mgs_certificate_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmgs_certificatelist" id="fmgs_certificatelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mgs_certificate_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mgs_certificate_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mgs_certificate">
<div id="gmp_mgs_certificate" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($mgs_certificate_list->TotalRecs > 0 || $mgs_certificate->isGridEdit()) { ?>
<table id="tbl_mgs_certificatelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mgs_certificate_list->RowType = ROWTYPE_HEADER;

// Render list options
$mgs_certificate_list->renderListOptions();

// Render list options (header, left)
$mgs_certificate_list->ListOptions->render("header", "left");
?>
<?php if ($mgs_certificate->id->Visible) { // id ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->id) == "") { ?>
		<th data-name="id" class="<?php echo $mgs_certificate->id->headerCellClass() ?>"><div id="elh_mgs_certificate_id" class="mgs_certificate_id"><div class="ew-table-header-caption"><?php echo $mgs_certificate->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $mgs_certificate->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->id) ?>',2);"><div id="elh_mgs_certificate_id" class="mgs_certificate_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->dated->Visible) { // dated ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $mgs_certificate->dated->headerCellClass() ?>"><div id="elh_mgs_certificate_dated" class="mgs_certificate_dated"><div class="ew-table-header-caption"><?php echo $mgs_certificate->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $mgs_certificate->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->dated) ?>',2);"><div id="elh_mgs_certificate_dated" class="mgs_certificate_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->title->Visible) { // title ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->title) == "") { ?>
		<th data-name="title" class="<?php echo $mgs_certificate->title->headerCellClass() ?>"><div id="elh_mgs_certificate_title" class="mgs_certificate_title"><div class="ew-table-header-caption"><?php echo $mgs_certificate->title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="title" class="<?php echo $mgs_certificate->title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->title) ?>',2);"><div id="elh_mgs_certificate_title" class="mgs_certificate_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->m_from->Visible) { // m_from ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->m_from) == "") { ?>
		<th data-name="m_from" class="<?php echo $mgs_certificate->m_from->headerCellClass() ?>"><div id="elh_mgs_certificate_m_from" class="mgs_certificate_m_from"><div class="ew-table-header-caption"><?php echo $mgs_certificate->m_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_from" class="<?php echo $mgs_certificate->m_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->m_from) ?>',2);"><div id="elh_mgs_certificate_m_from" class="mgs_certificate_m_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->m_from->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->m_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->m_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->reply_to->Visible) { // reply_to ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->reply_to) == "") { ?>
		<th data-name="reply_to" class="<?php echo $mgs_certificate->reply_to->headerCellClass() ?>"><div id="elh_mgs_certificate_reply_to" class="mgs_certificate_reply_to"><div class="ew-table-header-caption"><?php echo $mgs_certificate->reply_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reply_to" class="<?php echo $mgs_certificate->reply_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->reply_to) ?>',2);"><div id="elh_mgs_certificate_reply_to" class="mgs_certificate_reply_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->reply_to->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->reply_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->reply_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->certificate_image->Visible) { // certificate_image ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->certificate_image) == "") { ?>
		<th data-name="certificate_image" class="<?php echo $mgs_certificate->certificate_image->headerCellClass() ?>"><div id="elh_mgs_certificate_certificate_image" class="mgs_certificate_certificate_image"><div class="ew-table-header-caption"><?php echo $mgs_certificate->certificate_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="certificate_image" class="<?php echo $mgs_certificate->certificate_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->certificate_image) ?>',2);"><div id="elh_mgs_certificate_certificate_image" class="mgs_certificate_certificate_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->certificate_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->certificate_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->certificate_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->font->Visible) { // font ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->font) == "") { ?>
		<th data-name="font" class="<?php echo $mgs_certificate->font->headerCellClass() ?>"><div id="elh_mgs_certificate_font" class="mgs_certificate_font"><div class="ew-table-header-caption"><?php echo $mgs_certificate->font->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="font" class="<?php echo $mgs_certificate->font->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->font) ?>',2);"><div id="elh_mgs_certificate_font" class="mgs_certificate_font">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->font->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->font->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->font->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->status->Visible) { // status ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->status) == "") { ?>
		<th data-name="status" class="<?php echo $mgs_certificate->status->headerCellClass() ?>"><div id="elh_mgs_certificate_status" class="mgs_certificate_status"><div class="ew-table-header-caption"><?php echo $mgs_certificate->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $mgs_certificate->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->status) ?>',2);"><div id="elh_mgs_certificate_status" class="mgs_certificate_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->operator->Visible) { // operator ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $mgs_certificate->operator->headerCellClass() ?>"><div id="elh_mgs_certificate_operator" class="mgs_certificate_operator"><div class="ew-table-header-caption"><?php echo $mgs_certificate->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $mgs_certificate->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->operator) ?>',2);"><div id="elh_mgs_certificate_operator" class="mgs_certificate_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->datetime->Visible) { // datetime ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $mgs_certificate->datetime->headerCellClass() ?>"><div id="elh_mgs_certificate_datetime" class="mgs_certificate_datetime"><div class="ew-table-header-caption"><?php echo $mgs_certificate->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $mgs_certificate->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->datetime) ?>',2);"><div id="elh_mgs_certificate_datetime" class="mgs_certificate_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mgs_certificate->m_from_name->Visible) { // m_from_name ?>
	<?php if ($mgs_certificate->sortUrl($mgs_certificate->m_from_name) == "") { ?>
		<th data-name="m_from_name" class="<?php echo $mgs_certificate->m_from_name->headerCellClass() ?>"><div id="elh_mgs_certificate_m_from_name" class="mgs_certificate_m_from_name"><div class="ew-table-header-caption"><?php echo $mgs_certificate->m_from_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_from_name" class="<?php echo $mgs_certificate->m_from_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mgs_certificate->SortUrl($mgs_certificate->m_from_name) ?>',2);"><div id="elh_mgs_certificate_m_from_name" class="mgs_certificate_m_from_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mgs_certificate->m_from_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mgs_certificate->m_from_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mgs_certificate->m_from_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mgs_certificate_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mgs_certificate->ExportAll && $mgs_certificate->isExport()) {
	$mgs_certificate_list->StopRec = $mgs_certificate_list->TotalRecs;
} else {

	// Set the last record to display
	if ($mgs_certificate_list->TotalRecs > $mgs_certificate_list->StartRec + $mgs_certificate_list->DisplayRecs - 1)
		$mgs_certificate_list->StopRec = $mgs_certificate_list->StartRec + $mgs_certificate_list->DisplayRecs - 1;
	else
		$mgs_certificate_list->StopRec = $mgs_certificate_list->TotalRecs;
}
$mgs_certificate_list->RecCnt = $mgs_certificate_list->StartRec - 1;
if ($mgs_certificate_list->Recordset && !$mgs_certificate_list->Recordset->EOF) {
	$mgs_certificate_list->Recordset->moveFirst();
	$selectLimit = $mgs_certificate_list->UseSelectLimit;
	if (!$selectLimit && $mgs_certificate_list->StartRec > 1)
		$mgs_certificate_list->Recordset->move($mgs_certificate_list->StartRec - 1);
} elseif (!$mgs_certificate->AllowAddDeleteRow && $mgs_certificate_list->StopRec == 0) {
	$mgs_certificate_list->StopRec = $mgs_certificate->GridAddRowCount;
}

// Initialize aggregate
$mgs_certificate->RowType = ROWTYPE_AGGREGATEINIT;
$mgs_certificate->resetAttributes();
$mgs_certificate_list->renderRow();
while ($mgs_certificate_list->RecCnt < $mgs_certificate_list->StopRec) {
	$mgs_certificate_list->RecCnt++;
	if ($mgs_certificate_list->RecCnt >= $mgs_certificate_list->StartRec) {
		$mgs_certificate_list->RowCnt++;

		// Set up key count
		$mgs_certificate_list->KeyCount = $mgs_certificate_list->RowIndex;

		// Init row class and style
		$mgs_certificate->resetAttributes();
		$mgs_certificate->CssClass = "";
		if ($mgs_certificate->isGridAdd()) {
		} else {
			$mgs_certificate_list->loadRowValues($mgs_certificate_list->Recordset); // Load row values
		}
		$mgs_certificate->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$mgs_certificate->RowAttrs = array_merge($mgs_certificate->RowAttrs, array('data-rowindex'=>$mgs_certificate_list->RowCnt, 'id'=>'r' . $mgs_certificate_list->RowCnt . '_mgs_certificate', 'data-rowtype'=>$mgs_certificate->RowType));

		// Render row
		$mgs_certificate_list->renderRow();

		// Render list options
		$mgs_certificate_list->renderListOptions();
?>
	<tr<?php echo $mgs_certificate->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mgs_certificate_list->ListOptions->render("body", "left", $mgs_certificate_list->RowCnt);
?>
	<?php if ($mgs_certificate->id->Visible) { // id ?>
		<td data-name="id"<?php echo $mgs_certificate->id->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_id" class="mgs_certificate_id">
<span<?php echo $mgs_certificate->id->viewAttributes() ?>>
<?php echo $mgs_certificate->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $mgs_certificate->dated->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_dated" class="mgs_certificate_dated">
<span<?php echo $mgs_certificate->dated->viewAttributes() ?>>
<?php echo $mgs_certificate->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->title->Visible) { // title ?>
		<td data-name="title"<?php echo $mgs_certificate->title->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_title" class="mgs_certificate_title">
<span<?php echo $mgs_certificate->title->viewAttributes() ?>>
<?php echo $mgs_certificate->title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->m_from->Visible) { // m_from ?>
		<td data-name="m_from"<?php echo $mgs_certificate->m_from->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_m_from" class="mgs_certificate_m_from">
<span<?php echo $mgs_certificate->m_from->viewAttributes() ?>>
<?php echo $mgs_certificate->m_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->reply_to->Visible) { // reply_to ?>
		<td data-name="reply_to"<?php echo $mgs_certificate->reply_to->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_reply_to" class="mgs_certificate_reply_to">
<span<?php echo $mgs_certificate->reply_to->viewAttributes() ?>>
<?php echo $mgs_certificate->reply_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->certificate_image->Visible) { // certificate_image ?>
		<td data-name="certificate_image"<?php echo $mgs_certificate->certificate_image->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_certificate_image" class="mgs_certificate_certificate_image">
<span<?php echo $mgs_certificate->certificate_image->viewAttributes() ?>>
<?php echo GetFileViewTag($mgs_certificate->certificate_image, $mgs_certificate->certificate_image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->font->Visible) { // font ?>
		<td data-name="font"<?php echo $mgs_certificate->font->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_font" class="mgs_certificate_font">
<span<?php echo $mgs_certificate->font->viewAttributes() ?>>
<?php echo GetFileViewTag($mgs_certificate->font, $mgs_certificate->font->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->status->Visible) { // status ?>
		<td data-name="status"<?php echo $mgs_certificate->status->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_status" class="mgs_certificate_status">
<span<?php echo $mgs_certificate->status->viewAttributes() ?>>
<?php echo $mgs_certificate->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $mgs_certificate->operator->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_operator" class="mgs_certificate_operator">
<span<?php echo $mgs_certificate->operator->viewAttributes() ?>>
<?php echo $mgs_certificate->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $mgs_certificate->datetime->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_datetime" class="mgs_certificate_datetime">
<span<?php echo $mgs_certificate->datetime->viewAttributes() ?>>
<?php echo $mgs_certificate->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mgs_certificate->m_from_name->Visible) { // m_from_name ?>
		<td data-name="m_from_name"<?php echo $mgs_certificate->m_from_name->cellAttributes() ?>>
<span id="el<?php echo $mgs_certificate_list->RowCnt ?>_mgs_certificate_m_from_name" class="mgs_certificate_m_from_name">
<span<?php echo $mgs_certificate->m_from_name->viewAttributes() ?>>
<?php echo $mgs_certificate->m_from_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mgs_certificate_list->ListOptions->render("body", "right", $mgs_certificate_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$mgs_certificate->isGridAdd())
		$mgs_certificate_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$mgs_certificate->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mgs_certificate_list->Recordset)
	$mgs_certificate_list->Recordset->Close();
?>
<?php if (!$mgs_certificate->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mgs_certificate->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mgs_certificate_list->Pager)) $mgs_certificate_list->Pager = new PrevNextPager($mgs_certificate_list->StartRec, $mgs_certificate_list->DisplayRecs, $mgs_certificate_list->TotalRecs, $mgs_certificate_list->AutoHidePager) ?>
<?php if ($mgs_certificate_list->Pager->RecordCount > 0 && $mgs_certificate_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mgs_certificate_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mgs_certificate_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mgs_certificate_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mgs_certificate_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mgs_certificate_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mgs_certificate_list->pageUrl() ?>start=<?php echo $mgs_certificate_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mgs_certificate_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mgs_certificate_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mgs_certificate_list->TotalRecs > 0 && (!$mgs_certificate_list->AutoHidePageSizeSelector || $mgs_certificate_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mgs_certificate">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mgs_certificate_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mgs_certificate_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mgs_certificate_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mgs_certificate_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mgs_certificate_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mgs_certificate->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mgs_certificate_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mgs_certificate_list->TotalRecs == 0 && !$mgs_certificate->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mgs_certificate_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mgs_certificate_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mgs_certificate->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$mgs_certificate->isExport()) { ?>
<script>
ew.scrollableTable("gmp_mgs_certificate", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mgs_certificate_list->terminate();
?>