<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mgs_certificate_view = new mgs_certificate_view();

// Run the page
$mgs_certificate_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mgs_certificate_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mgs_certificate->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmgs_certificateview = currentForm = new ew.Form("fmgs_certificateview", "view");

// Form_CustomValidate event
fmgs_certificateview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmgs_certificateview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmgs_certificateview.lists["x_status"] = <?php echo $mgs_certificate_view->status->Lookup->toClientList() ?>;
fmgs_certificateview.lists["x_status"].options = <?php echo JsonEncode($mgs_certificate_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mgs_certificate->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $mgs_certificate_view->ExportOptions->render("body") ?>
<?php $mgs_certificate_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $mgs_certificate_view->showPageHeader(); ?>
<?php
$mgs_certificate_view->showMessage();
?>
<form name="fmgs_certificateview" id="fmgs_certificateview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mgs_certificate_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mgs_certificate_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mgs_certificate">
<input type="hidden" name="modal" value="<?php echo (int)$mgs_certificate_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($mgs_certificate->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_id"><?php echo $mgs_certificate->id->caption() ?></span></td>
		<td data-name="id"<?php echo $mgs_certificate->id->cellAttributes() ?>>
<span id="el_mgs_certificate_id">
<span<?php echo $mgs_certificate->id->viewAttributes() ?>>
<?php echo $mgs_certificate->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_dated"><?php echo $mgs_certificate->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $mgs_certificate->dated->cellAttributes() ?>>
<span id="el_mgs_certificate_dated">
<span<?php echo $mgs_certificate->dated->viewAttributes() ?>>
<?php echo $mgs_certificate->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->title->Visible) { // title ?>
	<tr id="r_title">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_title"><?php echo $mgs_certificate->title->caption() ?></span></td>
		<td data-name="title"<?php echo $mgs_certificate->title->cellAttributes() ?>>
<span id="el_mgs_certificate_title">
<span<?php echo $mgs_certificate->title->viewAttributes() ?>>
<?php echo $mgs_certificate->title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->m_from->Visible) { // m_from ?>
	<tr id="r_m_from">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_m_from"><?php echo $mgs_certificate->m_from->caption() ?></span></td>
		<td data-name="m_from"<?php echo $mgs_certificate->m_from->cellAttributes() ?>>
<span id="el_mgs_certificate_m_from">
<span<?php echo $mgs_certificate->m_from->viewAttributes() ?>>
<?php echo $mgs_certificate->m_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->reply_to->Visible) { // reply_to ?>
	<tr id="r_reply_to">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_reply_to"><?php echo $mgs_certificate->reply_to->caption() ?></span></td>
		<td data-name="reply_to"<?php echo $mgs_certificate->reply_to->cellAttributes() ?>>
<span id="el_mgs_certificate_reply_to">
<span<?php echo $mgs_certificate->reply_to->viewAttributes() ?>>
<?php echo $mgs_certificate->reply_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->subject->Visible) { // subject ?>
	<tr id="r_subject">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_subject"><?php echo $mgs_certificate->subject->caption() ?></span></td>
		<td data-name="subject"<?php echo $mgs_certificate->subject->cellAttributes() ?>>
<span id="el_mgs_certificate_subject">
<span<?php echo $mgs_certificate->subject->viewAttributes() ?>>
<?php echo $mgs_certificate->subject->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->message->Visible) { // message ?>
	<tr id="r_message">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_message"><?php echo $mgs_certificate->message->caption() ?></span></td>
		<td data-name="message"<?php echo $mgs_certificate->message->cellAttributes() ?>>
<span id="el_mgs_certificate_message">
<span<?php echo $mgs_certificate->message->viewAttributes() ?>>
<?php echo $mgs_certificate->message->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->certificate_image->Visible) { // certificate_image ?>
	<tr id="r_certificate_image">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_certificate_image"><?php echo $mgs_certificate->certificate_image->caption() ?></span></td>
		<td data-name="certificate_image"<?php echo $mgs_certificate->certificate_image->cellAttributes() ?>>
<span id="el_mgs_certificate_certificate_image">
<span<?php echo $mgs_certificate->certificate_image->viewAttributes() ?>>
<?php echo GetFileViewTag($mgs_certificate->certificate_image, $mgs_certificate->certificate_image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->font->Visible) { // font ?>
	<tr id="r_font">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_font"><?php echo $mgs_certificate->font->caption() ?></span></td>
		<td data-name="font"<?php echo $mgs_certificate->font->cellAttributes() ?>>
<span id="el_mgs_certificate_font">
<span<?php echo $mgs_certificate->font->viewAttributes() ?>>
<?php echo GetFileViewTag($mgs_certificate->font, $mgs_certificate->font->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_status"><?php echo $mgs_certificate->status->caption() ?></span></td>
		<td data-name="status"<?php echo $mgs_certificate->status->cellAttributes() ?>>
<span id="el_mgs_certificate_status">
<span<?php echo $mgs_certificate->status->viewAttributes() ?>>
<?php echo $mgs_certificate->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_operator"><?php echo $mgs_certificate->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $mgs_certificate->operator->cellAttributes() ?>>
<span id="el_mgs_certificate_operator">
<span<?php echo $mgs_certificate->operator->viewAttributes() ?>>
<?php echo $mgs_certificate->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_datetime"><?php echo $mgs_certificate->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $mgs_certificate->datetime->cellAttributes() ?>>
<span id="el_mgs_certificate_datetime">
<span<?php echo $mgs_certificate->datetime->viewAttributes() ?>>
<?php echo $mgs_certificate->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mgs_certificate->m_from_name->Visible) { // m_from_name ?>
	<tr id="r_m_from_name">
		<td class="<?php echo $mgs_certificate_view->TableLeftColumnClass ?>"><span id="elh_mgs_certificate_m_from_name"><?php echo $mgs_certificate->m_from_name->caption() ?></span></td>
		<td data-name="m_from_name"<?php echo $mgs_certificate->m_from_name->cellAttributes() ?>>
<span id="el_mgs_certificate_m_from_name">
<span<?php echo $mgs_certificate->m_from_name->viewAttributes() ?>>
<?php echo $mgs_certificate->m_from_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$mgs_certificate_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mgs_certificate->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mgs_certificate_view->terminate();
?>