<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$minimum_inventory_level_edit = new minimum_inventory_level_edit();

// Run the page
$minimum_inventory_level_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$minimum_inventory_level_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fminimum_inventory_leveledit = currentForm = new ew.Form("fminimum_inventory_leveledit", "edit");

// Validate form
fminimum_inventory_leveledit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($minimum_inventory_level_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->id->caption(), $minimum_inventory_level->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($minimum_inventory_level_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->location->caption(), $minimum_inventory_level->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($minimum_inventory_level_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->rid->caption(), $minimum_inventory_level->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($minimum_inventory_level_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->packing_type->caption(), $minimum_inventory_level->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($minimum_inventory_level_edit->mil->Required) { ?>
			elm = this.getElements("x" + infix + "_mil");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->mil->caption(), $minimum_inventory_level->mil->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mil");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($minimum_inventory_level->mil->errorMessage()) ?>");
		<?php if ($minimum_inventory_level_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->operator->caption(), $minimum_inventory_level->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($minimum_inventory_level_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $minimum_inventory_level->datetime->caption(), $minimum_inventory_level->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fminimum_inventory_leveledit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fminimum_inventory_leveledit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fminimum_inventory_leveledit.lists["x_location"] = <?php echo $minimum_inventory_level_edit->location->Lookup->toClientList() ?>;
fminimum_inventory_leveledit.lists["x_location"].options = <?php echo JsonEncode($minimum_inventory_level_edit->location->lookupOptions()) ?>;
fminimum_inventory_leveledit.lists["x_rid"] = <?php echo $minimum_inventory_level_edit->rid->Lookup->toClientList() ?>;
fminimum_inventory_leveledit.lists["x_rid"].options = <?php echo JsonEncode($minimum_inventory_level_edit->rid->lookupOptions()) ?>;
fminimum_inventory_leveledit.lists["x_packing_type"] = <?php echo $minimum_inventory_level_edit->packing_type->Lookup->toClientList() ?>;
fminimum_inventory_leveledit.lists["x_packing_type"].options = <?php echo JsonEncode($minimum_inventory_level_edit->packing_type->lookupOptions()) ?>;
fminimum_inventory_leveledit.lists["x_operator"] = <?php echo $minimum_inventory_level_edit->operator->Lookup->toClientList() ?>;
fminimum_inventory_leveledit.lists["x_operator"].options = <?php echo JsonEncode($minimum_inventory_level_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $minimum_inventory_level_edit->showPageHeader(); ?>
<?php
$minimum_inventory_level_edit->showMessage();
?>
<form name="fminimum_inventory_leveledit" id="fminimum_inventory_leveledit" class="<?php echo $minimum_inventory_level_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($minimum_inventory_level_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $minimum_inventory_level_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="minimum_inventory_level">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$minimum_inventory_level_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($minimum_inventory_level->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_minimum_inventory_level_id" class="<?php echo $minimum_inventory_level_edit->LeftColumnClass ?>"><?php echo $minimum_inventory_level->id->caption() ?><?php echo ($minimum_inventory_level->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $minimum_inventory_level_edit->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->id->cellAttributes() ?>>
<span id="el_minimum_inventory_level_id">
<span<?php echo $minimum_inventory_level->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($minimum_inventory_level->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="minimum_inventory_level" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($minimum_inventory_level->id->CurrentValue) ?>">
<?php echo $minimum_inventory_level->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_minimum_inventory_level_location" for="x_location" class="<?php echo $minimum_inventory_level_edit->LeftColumnClass ?>"><?php echo $minimum_inventory_level->location->caption() ?><?php echo ($minimum_inventory_level->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $minimum_inventory_level_edit->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->location->cellAttributes() ?>>
<span id="el_minimum_inventory_level_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_location" data-value-separator="<?php echo $minimum_inventory_level->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $minimum_inventory_level->location->editAttributes() ?>>
		<?php echo $minimum_inventory_level->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $minimum_inventory_level->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_minimum_inventory_level_rid" for="x_rid" class="<?php echo $minimum_inventory_level_edit->LeftColumnClass ?>"><?php echo $minimum_inventory_level->rid->caption() ?><?php echo ($minimum_inventory_level->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $minimum_inventory_level_edit->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->rid->cellAttributes() ?>>
<span id="el_minimum_inventory_level_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_rid" data-value-separator="<?php echo $minimum_inventory_level->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $minimum_inventory_level->rid->editAttributes() ?>>
		<?php echo $minimum_inventory_level->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $minimum_inventory_level->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_minimum_inventory_level_packing_type" for="x_packing_type" class="<?php echo $minimum_inventory_level_edit->LeftColumnClass ?>"><?php echo $minimum_inventory_level->packing_type->caption() ?><?php echo ($minimum_inventory_level->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $minimum_inventory_level_edit->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->packing_type->cellAttributes() ?>>
<span id="el_minimum_inventory_level_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_packing_type" data-value-separator="<?php echo $minimum_inventory_level->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $minimum_inventory_level->packing_type->editAttributes() ?>>
		<?php echo $minimum_inventory_level->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $minimum_inventory_level->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->mil->Visible) { // mil ?>
	<div id="r_mil" class="form-group row">
		<label id="elh_minimum_inventory_level_mil" for="x_mil" class="<?php echo $minimum_inventory_level_edit->LeftColumnClass ?>"><?php echo $minimum_inventory_level->mil->caption() ?><?php echo ($minimum_inventory_level->mil->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $minimum_inventory_level_edit->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->mil->cellAttributes() ?>>
<span id="el_minimum_inventory_level_mil">
<input type="text" data-table="minimum_inventory_level" data-field="x_mil" name="x_mil" id="x_mil" size="30" placeholder="<?php echo HtmlEncode($minimum_inventory_level->mil->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->mil->EditValue ?>"<?php echo $minimum_inventory_level->mil->editAttributes() ?>>
</span>
<?php echo $minimum_inventory_level->mil->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$minimum_inventory_level_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $minimum_inventory_level_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $minimum_inventory_level_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$minimum_inventory_level_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$minimum_inventory_level_edit->terminate();
?>