<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$minimum_inventory_level_list = new minimum_inventory_level_list();

// Run the page
$minimum_inventory_level_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$minimum_inventory_level_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fminimum_inventory_levellist = currentForm = new ew.Form("fminimum_inventory_levellist", "list");
fminimum_inventory_levellist.formKeyCountName = '<?php echo $minimum_inventory_level_list->FormKeyCountName ?>';

// Form_CustomValidate event
fminimum_inventory_levellist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fminimum_inventory_levellist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fminimum_inventory_levellist.lists["x_location"] = <?php echo $minimum_inventory_level_list->location->Lookup->toClientList() ?>;
fminimum_inventory_levellist.lists["x_location"].options = <?php echo JsonEncode($minimum_inventory_level_list->location->lookupOptions()) ?>;
fminimum_inventory_levellist.lists["x_rid"] = <?php echo $minimum_inventory_level_list->rid->Lookup->toClientList() ?>;
fminimum_inventory_levellist.lists["x_rid"].options = <?php echo JsonEncode($minimum_inventory_level_list->rid->lookupOptions()) ?>;
fminimum_inventory_levellist.lists["x_packing_type"] = <?php echo $minimum_inventory_level_list->packing_type->Lookup->toClientList() ?>;
fminimum_inventory_levellist.lists["x_packing_type"].options = <?php echo JsonEncode($minimum_inventory_level_list->packing_type->lookupOptions()) ?>;
fminimum_inventory_levellist.lists["x_operator"] = <?php echo $minimum_inventory_level_list->operator->Lookup->toClientList() ?>;
fminimum_inventory_levellist.lists["x_operator"].options = <?php echo JsonEncode($minimum_inventory_level_list->operator->lookupOptions()) ?>;

// Form object for search
var fminimum_inventory_levellistsrch = currentSearchForm = new ew.Form("fminimum_inventory_levellistsrch");

// Validate function for search
fminimum_inventory_levellistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($minimum_inventory_level->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fminimum_inventory_levellistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fminimum_inventory_levellistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fminimum_inventory_levellistsrch.lists["x_operator"] = <?php echo $minimum_inventory_level_list->operator->Lookup->toClientList() ?>;
fminimum_inventory_levellistsrch.lists["x_operator"].options = <?php echo JsonEncode($minimum_inventory_level_list->operator->lookupOptions()) ?>;

// Filters
fminimum_inventory_levellistsrch.filterList = <?php echo $minimum_inventory_level_list->getFilterList() ?>;

// Init search panel as collapsed
fminimum_inventory_levellistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($minimum_inventory_level_list->TotalRecs > 0 && $minimum_inventory_level_list->ExportOptions->visible()) { ?>
<?php $minimum_inventory_level_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($minimum_inventory_level_list->ImportOptions->visible()) { ?>
<?php $minimum_inventory_level_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($minimum_inventory_level_list->SearchOptions->visible()) { ?>
<?php $minimum_inventory_level_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($minimum_inventory_level_list->FilterOptions->visible()) { ?>
<?php $minimum_inventory_level_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$minimum_inventory_level_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$minimum_inventory_level->isExport() && !$minimum_inventory_level->CurrentAction) { ?>
<form name="fminimum_inventory_levellistsrch" id="fminimum_inventory_levellistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($minimum_inventory_level_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fminimum_inventory_levellistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="minimum_inventory_level">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$minimum_inventory_level_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$minimum_inventory_level->RowType = ROWTYPE_SEARCH;

// Render row
$minimum_inventory_level->resetAttributes();
$minimum_inventory_level_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($minimum_inventory_level->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $minimum_inventory_level->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="minimum_inventory_level" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($minimum_inventory_level->id->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->id->EditValue ?>"<?php echo $minimum_inventory_level->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->operator->Visible) { // operator ?>
	<div id="xsc_operator" class="ew-cell form-group">
		<label for="x_operator" class="ew-search-caption ew-label"><?php echo $minimum_inventory_level->operator->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_operator" data-value-separator="<?php echo $minimum_inventory_level->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $minimum_inventory_level->operator->editAttributes() ?>>
		<?php echo $minimum_inventory_level->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $minimum_inventory_level->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="minimum_inventory_level" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($minimum_inventory_level->datetime->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->datetime->EditValue ?>"<?php echo $minimum_inventory_level->datetime->editAttributes() ?>>
<?php if (!$minimum_inventory_level->datetime->ReadOnly && !$minimum_inventory_level->datetime->Disabled && !isset($minimum_inventory_level->datetime->EditAttrs["readonly"]) && !isset($minimum_inventory_level->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fminimum_inventory_levellistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="minimum_inventory_level" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($minimum_inventory_level->datetime->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->datetime->EditValue2 ?>"<?php echo $minimum_inventory_level->datetime->editAttributes() ?>>
<?php if (!$minimum_inventory_level->datetime->ReadOnly && !$minimum_inventory_level->datetime->Disabled && !isset($minimum_inventory_level->datetime->EditAttrs["readonly"]) && !isset($minimum_inventory_level->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fminimum_inventory_levellistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($minimum_inventory_level_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($minimum_inventory_level_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $minimum_inventory_level_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($minimum_inventory_level_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($minimum_inventory_level_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($minimum_inventory_level_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($minimum_inventory_level_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $minimum_inventory_level_list->showPageHeader(); ?>
<?php
$minimum_inventory_level_list->showMessage();
?>
<?php if ($minimum_inventory_level_list->TotalRecs > 0 || $minimum_inventory_level->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($minimum_inventory_level_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> minimum_inventory_level">
<?php if (!$minimum_inventory_level->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$minimum_inventory_level->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($minimum_inventory_level_list->Pager)) $minimum_inventory_level_list->Pager = new PrevNextPager($minimum_inventory_level_list->StartRec, $minimum_inventory_level_list->DisplayRecs, $minimum_inventory_level_list->TotalRecs, $minimum_inventory_level_list->AutoHidePager) ?>
<?php if ($minimum_inventory_level_list->Pager->RecordCount > 0 && $minimum_inventory_level_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($minimum_inventory_level_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($minimum_inventory_level_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $minimum_inventory_level_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($minimum_inventory_level_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($minimum_inventory_level_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($minimum_inventory_level_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($minimum_inventory_level_list->TotalRecs > 0 && (!$minimum_inventory_level_list->AutoHidePageSizeSelector || $minimum_inventory_level_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="minimum_inventory_level">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($minimum_inventory_level_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($minimum_inventory_level_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($minimum_inventory_level_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($minimum_inventory_level_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($minimum_inventory_level_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($minimum_inventory_level->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $minimum_inventory_level_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fminimum_inventory_levellist" id="fminimum_inventory_levellist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($minimum_inventory_level_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $minimum_inventory_level_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="minimum_inventory_level">
<div id="gmp_minimum_inventory_level" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($minimum_inventory_level_list->TotalRecs > 0 || $minimum_inventory_level->isGridEdit()) { ?>
<table id="tbl_minimum_inventory_levellist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$minimum_inventory_level_list->RowType = ROWTYPE_HEADER;

// Render list options
$minimum_inventory_level_list->renderListOptions();

// Render list options (header, left)
$minimum_inventory_level_list->ListOptions->render("header", "left");
?>
<?php if ($minimum_inventory_level->id->Visible) { // id ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->id) == "") { ?>
		<th data-name="id" class="<?php echo $minimum_inventory_level->id->headerCellClass() ?>"><div id="elh_minimum_inventory_level_id" class="minimum_inventory_level_id"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $minimum_inventory_level->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->id) ?>',2);"><div id="elh_minimum_inventory_level_id" class="minimum_inventory_level_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($minimum_inventory_level->location->Visible) { // location ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->location) == "") { ?>
		<th data-name="location" class="<?php echo $minimum_inventory_level->location->headerCellClass() ?>"><div id="elh_minimum_inventory_level_location" class="minimum_inventory_level_location"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $minimum_inventory_level->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->location) ?>',2);"><div id="elh_minimum_inventory_level_location" class="minimum_inventory_level_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($minimum_inventory_level->rid->Visible) { // rid ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $minimum_inventory_level->rid->headerCellClass() ?>"><div id="elh_minimum_inventory_level_rid" class="minimum_inventory_level_rid"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $minimum_inventory_level->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->rid) ?>',2);"><div id="elh_minimum_inventory_level_rid" class="minimum_inventory_level_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($minimum_inventory_level->packing_type->Visible) { // packing_type ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $minimum_inventory_level->packing_type->headerCellClass() ?>"><div id="elh_minimum_inventory_level_packing_type" class="minimum_inventory_level_packing_type"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $minimum_inventory_level->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->packing_type) ?>',2);"><div id="elh_minimum_inventory_level_packing_type" class="minimum_inventory_level_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($minimum_inventory_level->mil->Visible) { // mil ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->mil) == "") { ?>
		<th data-name="mil" class="<?php echo $minimum_inventory_level->mil->headerCellClass() ?>"><div id="elh_minimum_inventory_level_mil" class="minimum_inventory_level_mil"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->mil->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mil" class="<?php echo $minimum_inventory_level->mil->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->mil) ?>',2);"><div id="elh_minimum_inventory_level_mil" class="minimum_inventory_level_mil">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->mil->caption() ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->mil->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->mil->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($minimum_inventory_level->operator->Visible) { // operator ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $minimum_inventory_level->operator->headerCellClass() ?>"><div id="elh_minimum_inventory_level_operator" class="minimum_inventory_level_operator"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $minimum_inventory_level->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->operator) ?>',2);"><div id="elh_minimum_inventory_level_operator" class="minimum_inventory_level_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($minimum_inventory_level->datetime->Visible) { // datetime ?>
	<?php if ($minimum_inventory_level->sortUrl($minimum_inventory_level->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $minimum_inventory_level->datetime->headerCellClass() ?>"><div id="elh_minimum_inventory_level_datetime" class="minimum_inventory_level_datetime"><div class="ew-table-header-caption"><?php echo $minimum_inventory_level->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $minimum_inventory_level->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $minimum_inventory_level->SortUrl($minimum_inventory_level->datetime) ?>',2);"><div id="elh_minimum_inventory_level_datetime" class="minimum_inventory_level_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $minimum_inventory_level->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($minimum_inventory_level->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($minimum_inventory_level->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$minimum_inventory_level_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($minimum_inventory_level->ExportAll && $minimum_inventory_level->isExport()) {
	$minimum_inventory_level_list->StopRec = $minimum_inventory_level_list->TotalRecs;
} else {

	// Set the last record to display
	if ($minimum_inventory_level_list->TotalRecs > $minimum_inventory_level_list->StartRec + $minimum_inventory_level_list->DisplayRecs - 1)
		$minimum_inventory_level_list->StopRec = $minimum_inventory_level_list->StartRec + $minimum_inventory_level_list->DisplayRecs - 1;
	else
		$minimum_inventory_level_list->StopRec = $minimum_inventory_level_list->TotalRecs;
}
$minimum_inventory_level_list->RecCnt = $minimum_inventory_level_list->StartRec - 1;
if ($minimum_inventory_level_list->Recordset && !$minimum_inventory_level_list->Recordset->EOF) {
	$minimum_inventory_level_list->Recordset->moveFirst();
	$selectLimit = $minimum_inventory_level_list->UseSelectLimit;
	if (!$selectLimit && $minimum_inventory_level_list->StartRec > 1)
		$minimum_inventory_level_list->Recordset->move($minimum_inventory_level_list->StartRec - 1);
} elseif (!$minimum_inventory_level->AllowAddDeleteRow && $minimum_inventory_level_list->StopRec == 0) {
	$minimum_inventory_level_list->StopRec = $minimum_inventory_level->GridAddRowCount;
}

// Initialize aggregate
$minimum_inventory_level->RowType = ROWTYPE_AGGREGATEINIT;
$minimum_inventory_level->resetAttributes();
$minimum_inventory_level_list->renderRow();
while ($minimum_inventory_level_list->RecCnt < $minimum_inventory_level_list->StopRec) {
	$minimum_inventory_level_list->RecCnt++;
	if ($minimum_inventory_level_list->RecCnt >= $minimum_inventory_level_list->StartRec) {
		$minimum_inventory_level_list->RowCnt++;

		// Set up key count
		$minimum_inventory_level_list->KeyCount = $minimum_inventory_level_list->RowIndex;

		// Init row class and style
		$minimum_inventory_level->resetAttributes();
		$minimum_inventory_level->CssClass = "";
		if ($minimum_inventory_level->isGridAdd()) {
		} else {
			$minimum_inventory_level_list->loadRowValues($minimum_inventory_level_list->Recordset); // Load row values
		}
		$minimum_inventory_level->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$minimum_inventory_level->RowAttrs = array_merge($minimum_inventory_level->RowAttrs, array('data-rowindex'=>$minimum_inventory_level_list->RowCnt, 'id'=>'r' . $minimum_inventory_level_list->RowCnt . '_minimum_inventory_level', 'data-rowtype'=>$minimum_inventory_level->RowType));

		// Render row
		$minimum_inventory_level_list->renderRow();

		// Render list options
		$minimum_inventory_level_list->renderListOptions();
?>
	<tr<?php echo $minimum_inventory_level->rowAttributes() ?>>
<?php

// Render list options (body, left)
$minimum_inventory_level_list->ListOptions->render("body", "left", $minimum_inventory_level_list->RowCnt);
?>
	<?php if ($minimum_inventory_level->id->Visible) { // id ?>
		<td data-name="id"<?php echo $minimum_inventory_level->id->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_id" class="minimum_inventory_level_id">
<span<?php echo $minimum_inventory_level->id->viewAttributes() ?>>
<?php echo $minimum_inventory_level->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($minimum_inventory_level->location->Visible) { // location ?>
		<td data-name="location"<?php echo $minimum_inventory_level->location->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_location" class="minimum_inventory_level_location">
<span<?php echo $minimum_inventory_level->location->viewAttributes() ?>>
<?php echo $minimum_inventory_level->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($minimum_inventory_level->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $minimum_inventory_level->rid->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_rid" class="minimum_inventory_level_rid">
<span<?php echo $minimum_inventory_level->rid->viewAttributes() ?>>
<?php echo $minimum_inventory_level->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($minimum_inventory_level->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $minimum_inventory_level->packing_type->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_packing_type" class="minimum_inventory_level_packing_type">
<span<?php echo $minimum_inventory_level->packing_type->viewAttributes() ?>>
<?php echo $minimum_inventory_level->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($minimum_inventory_level->mil->Visible) { // mil ?>
		<td data-name="mil"<?php echo $minimum_inventory_level->mil->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_mil" class="minimum_inventory_level_mil">
<span<?php echo $minimum_inventory_level->mil->viewAttributes() ?>>
<?php echo $minimum_inventory_level->mil->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($minimum_inventory_level->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $minimum_inventory_level->operator->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_operator" class="minimum_inventory_level_operator">
<span<?php echo $minimum_inventory_level->operator->viewAttributes() ?>>
<?php echo $minimum_inventory_level->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($minimum_inventory_level->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $minimum_inventory_level->datetime->cellAttributes() ?>>
<span id="el<?php echo $minimum_inventory_level_list->RowCnt ?>_minimum_inventory_level_datetime" class="minimum_inventory_level_datetime">
<span<?php echo $minimum_inventory_level->datetime->viewAttributes() ?>>
<?php echo $minimum_inventory_level->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$minimum_inventory_level_list->ListOptions->render("body", "right", $minimum_inventory_level_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$minimum_inventory_level->isGridAdd())
		$minimum_inventory_level_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$minimum_inventory_level->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($minimum_inventory_level_list->Recordset)
	$minimum_inventory_level_list->Recordset->Close();
?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$minimum_inventory_level->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($minimum_inventory_level_list->Pager)) $minimum_inventory_level_list->Pager = new PrevNextPager($minimum_inventory_level_list->StartRec, $minimum_inventory_level_list->DisplayRecs, $minimum_inventory_level_list->TotalRecs, $minimum_inventory_level_list->AutoHidePager) ?>
<?php if ($minimum_inventory_level_list->Pager->RecordCount > 0 && $minimum_inventory_level_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($minimum_inventory_level_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($minimum_inventory_level_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $minimum_inventory_level_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($minimum_inventory_level_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($minimum_inventory_level_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $minimum_inventory_level_list->pageUrl() ?>start=<?php echo $minimum_inventory_level_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($minimum_inventory_level_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $minimum_inventory_level_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($minimum_inventory_level_list->TotalRecs > 0 && (!$minimum_inventory_level_list->AutoHidePageSizeSelector || $minimum_inventory_level_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="minimum_inventory_level">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($minimum_inventory_level_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($minimum_inventory_level_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($minimum_inventory_level_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($minimum_inventory_level_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($minimum_inventory_level_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($minimum_inventory_level->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $minimum_inventory_level_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($minimum_inventory_level_list->TotalRecs == 0 && !$minimum_inventory_level->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $minimum_inventory_level_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$minimum_inventory_level_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<script>
ew.scrollableTable("gmp_minimum_inventory_level", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$minimum_inventory_level_list->terminate();
?>