<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$minimum_inventory_level_search = new minimum_inventory_level_search();

// Run the page
$minimum_inventory_level_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$minimum_inventory_level_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($minimum_inventory_level_search->IsModal) { ?>
var fminimum_inventory_levelsearch = currentAdvancedSearchForm = new ew.Form("fminimum_inventory_levelsearch", "search");
<?php } else { ?>
var fminimum_inventory_levelsearch = currentForm = new ew.Form("fminimum_inventory_levelsearch", "search");
<?php } ?>

// Form_CustomValidate event
fminimum_inventory_levelsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fminimum_inventory_levelsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fminimum_inventory_levelsearch.lists["x_location"] = <?php echo $minimum_inventory_level_search->location->Lookup->toClientList() ?>;
fminimum_inventory_levelsearch.lists["x_location"].options = <?php echo JsonEncode($minimum_inventory_level_search->location->lookupOptions()) ?>;
fminimum_inventory_levelsearch.lists["x_rid"] = <?php echo $minimum_inventory_level_search->rid->Lookup->toClientList() ?>;
fminimum_inventory_levelsearch.lists["x_rid"].options = <?php echo JsonEncode($minimum_inventory_level_search->rid->lookupOptions()) ?>;
fminimum_inventory_levelsearch.lists["x_packing_type"] = <?php echo $minimum_inventory_level_search->packing_type->Lookup->toClientList() ?>;
fminimum_inventory_levelsearch.lists["x_packing_type"].options = <?php echo JsonEncode($minimum_inventory_level_search->packing_type->lookupOptions()) ?>;
fminimum_inventory_levelsearch.lists["x_operator"] = <?php echo $minimum_inventory_level_search->operator->Lookup->toClientList() ?>;
fminimum_inventory_levelsearch.lists["x_operator"].options = <?php echo JsonEncode($minimum_inventory_level_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fminimum_inventory_levelsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($minimum_inventory_level->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_mil");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($minimum_inventory_level->mil->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $minimum_inventory_level_search->showPageHeader(); ?>
<?php
$minimum_inventory_level_search->showMessage();
?>
<form name="fminimum_inventory_levelsearch" id="fminimum_inventory_levelsearch" class="<?php echo $minimum_inventory_level_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($minimum_inventory_level_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $minimum_inventory_level_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="minimum_inventory_level">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$minimum_inventory_level_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($minimum_inventory_level->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_id"><?php echo $minimum_inventory_level->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->id->cellAttributes() ?>>
			<span id="el_minimum_inventory_level_id">
<input type="text" data-table="minimum_inventory_level" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($minimum_inventory_level->id->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->id->EditValue ?>"<?php echo $minimum_inventory_level->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_location"><?php echo $minimum_inventory_level->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->location->cellAttributes() ?>>
			<span id="el_minimum_inventory_level_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_location" data-value-separator="<?php echo $minimum_inventory_level->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $minimum_inventory_level->location->editAttributes() ?>>
		<?php echo $minimum_inventory_level->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_rid"><?php echo $minimum_inventory_level->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->rid->cellAttributes() ?>>
			<span id="el_minimum_inventory_level_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_rid" data-value-separator="<?php echo $minimum_inventory_level->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $minimum_inventory_level->rid->editAttributes() ?>>
		<?php echo $minimum_inventory_level->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_packing_type"><?php echo $minimum_inventory_level->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->packing_type->cellAttributes() ?>>
			<span id="el_minimum_inventory_level_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_packing_type" data-value-separator="<?php echo $minimum_inventory_level->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $minimum_inventory_level->packing_type->editAttributes() ?>>
		<?php echo $minimum_inventory_level->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->mil->Visible) { // mil ?>
	<div id="r_mil" class="form-group row">
		<label for="x_mil" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_mil"><?php echo $minimum_inventory_level->mil->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mil" id="z_mil" value="="></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->mil->cellAttributes() ?>>
			<span id="el_minimum_inventory_level_mil">
<input type="text" data-table="minimum_inventory_level" data-field="x_mil" name="x_mil" id="x_mil" size="30" placeholder="<?php echo HtmlEncode($minimum_inventory_level->mil->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->mil->EditValue ?>"<?php echo $minimum_inventory_level->mil->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_operator"><?php echo $minimum_inventory_level->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->operator->cellAttributes() ?>>
			<span id="el_minimum_inventory_level_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="minimum_inventory_level" data-field="x_operator" data-value-separator="<?php echo $minimum_inventory_level->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $minimum_inventory_level->operator->editAttributes() ?>>
		<?php echo $minimum_inventory_level->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $minimum_inventory_level->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($minimum_inventory_level->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $minimum_inventory_level_search->LeftColumnClass ?>"><span id="elh_minimum_inventory_level_datetime"><?php echo $minimum_inventory_level->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $minimum_inventory_level_search->RightColumnClass ?>"><div<?php echo $minimum_inventory_level->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($minimum_inventory_level->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_minimum_inventory_level_datetime">
<input type="text" data-table="minimum_inventory_level" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($minimum_inventory_level->datetime->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->datetime->EditValue ?>"<?php echo $minimum_inventory_level->datetime->editAttributes() ?>>
<?php if (!$minimum_inventory_level->datetime->ReadOnly && !$minimum_inventory_level->datetime->Disabled && !isset($minimum_inventory_level->datetime->EditAttrs["readonly"]) && !isset($minimum_inventory_level->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fminimum_inventory_levelsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_minimum_inventory_level_datetime" class="btw1_datetime d-none">
<input type="text" data-table="minimum_inventory_level" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($minimum_inventory_level->datetime->getPlaceHolder()) ?>" value="<?php echo $minimum_inventory_level->datetime->EditValue2 ?>"<?php echo $minimum_inventory_level->datetime->editAttributes() ?>>
<?php if (!$minimum_inventory_level->datetime->ReadOnly && !$minimum_inventory_level->datetime->Disabled && !isset($minimum_inventory_level->datetime->EditAttrs["readonly"]) && !isset($minimum_inventory_level->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fminimum_inventory_levelsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$minimum_inventory_level_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $minimum_inventory_level_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$minimum_inventory_level_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$minimum_inventory_level_search->terminate();
?>