<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$minimum_inventory_level_view = new minimum_inventory_level_view();

// Run the page
$minimum_inventory_level_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$minimum_inventory_level_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fminimum_inventory_levelview = currentForm = new ew.Form("fminimum_inventory_levelview", "view");

// Form_CustomValidate event
fminimum_inventory_levelview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fminimum_inventory_levelview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fminimum_inventory_levelview.lists["x_location"] = <?php echo $minimum_inventory_level_view->location->Lookup->toClientList() ?>;
fminimum_inventory_levelview.lists["x_location"].options = <?php echo JsonEncode($minimum_inventory_level_view->location->lookupOptions()) ?>;
fminimum_inventory_levelview.lists["x_rid"] = <?php echo $minimum_inventory_level_view->rid->Lookup->toClientList() ?>;
fminimum_inventory_levelview.lists["x_rid"].options = <?php echo JsonEncode($minimum_inventory_level_view->rid->lookupOptions()) ?>;
fminimum_inventory_levelview.lists["x_packing_type"] = <?php echo $minimum_inventory_level_view->packing_type->Lookup->toClientList() ?>;
fminimum_inventory_levelview.lists["x_packing_type"].options = <?php echo JsonEncode($minimum_inventory_level_view->packing_type->lookupOptions()) ?>;
fminimum_inventory_levelview.lists["x_operator"] = <?php echo $minimum_inventory_level_view->operator->Lookup->toClientList() ?>;
fminimum_inventory_levelview.lists["x_operator"].options = <?php echo JsonEncode($minimum_inventory_level_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $minimum_inventory_level_view->ExportOptions->render("body") ?>
<?php $minimum_inventory_level_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $minimum_inventory_level_view->showPageHeader(); ?>
<?php
$minimum_inventory_level_view->showMessage();
?>
<form name="fminimum_inventory_levelview" id="fminimum_inventory_levelview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($minimum_inventory_level_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $minimum_inventory_level_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="minimum_inventory_level">
<input type="hidden" name="modal" value="<?php echo (int)$minimum_inventory_level_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($minimum_inventory_level->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_id"><?php echo $minimum_inventory_level->id->caption() ?></span></td>
		<td data-name="id"<?php echo $minimum_inventory_level->id->cellAttributes() ?>>
<span id="el_minimum_inventory_level_id">
<span<?php echo $minimum_inventory_level->id->viewAttributes() ?>>
<?php echo $minimum_inventory_level->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($minimum_inventory_level->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_location"><?php echo $minimum_inventory_level->location->caption() ?></span></td>
		<td data-name="location"<?php echo $minimum_inventory_level->location->cellAttributes() ?>>
<span id="el_minimum_inventory_level_location">
<span<?php echo $minimum_inventory_level->location->viewAttributes() ?>>
<?php echo $minimum_inventory_level->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($minimum_inventory_level->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_rid"><?php echo $minimum_inventory_level->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $minimum_inventory_level->rid->cellAttributes() ?>>
<span id="el_minimum_inventory_level_rid">
<span<?php echo $minimum_inventory_level->rid->viewAttributes() ?>>
<?php echo $minimum_inventory_level->rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($minimum_inventory_level->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_packing_type"><?php echo $minimum_inventory_level->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $minimum_inventory_level->packing_type->cellAttributes() ?>>
<span id="el_minimum_inventory_level_packing_type">
<span<?php echo $minimum_inventory_level->packing_type->viewAttributes() ?>>
<?php echo $minimum_inventory_level->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($minimum_inventory_level->mil->Visible) { // mil ?>
	<tr id="r_mil">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_mil"><?php echo $minimum_inventory_level->mil->caption() ?></span></td>
		<td data-name="mil"<?php echo $minimum_inventory_level->mil->cellAttributes() ?>>
<span id="el_minimum_inventory_level_mil">
<span<?php echo $minimum_inventory_level->mil->viewAttributes() ?>>
<?php echo $minimum_inventory_level->mil->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($minimum_inventory_level->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_operator"><?php echo $minimum_inventory_level->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $minimum_inventory_level->operator->cellAttributes() ?>>
<span id="el_minimum_inventory_level_operator">
<span<?php echo $minimum_inventory_level->operator->viewAttributes() ?>>
<?php echo $minimum_inventory_level->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($minimum_inventory_level->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $minimum_inventory_level_view->TableLeftColumnClass ?>"><span id="elh_minimum_inventory_level_datetime"><?php echo $minimum_inventory_level->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $minimum_inventory_level->datetime->cellAttributes() ?>>
<span id="el_minimum_inventory_level_datetime">
<span<?php echo $minimum_inventory_level->datetime->viewAttributes() ?>>
<?php echo $minimum_inventory_level->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$minimum_inventory_level_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$minimum_inventory_level->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$minimum_inventory_level_view->terminate();
?>