<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_items_edit = new misc_items_edit();

// Run the page
$misc_items_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_items_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmisc_itemsedit = currentForm = new ew.Form("fmisc_itemsedit", "edit");

// Validate form
fmisc_itemsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($misc_items_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->id->caption(), $misc_items->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_items_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->item->caption(), $misc_items->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_items_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->code->caption(), $misc_items->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_items_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->grp->caption(), $misc_items->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_items_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->status->caption(), $misc_items->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_items_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->operator->caption(), $misc_items->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_items_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc_items->datetime->caption(), $misc_items->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmisc_itemsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmisc_itemsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmisc_itemsedit.lists["x_grp"] = <?php echo $misc_items_edit->grp->Lookup->toClientList() ?>;
fmisc_itemsedit.lists["x_grp"].options = <?php echo JsonEncode($misc_items_edit->grp->options(FALSE, TRUE)) ?>;
fmisc_itemsedit.lists["x_status"] = <?php echo $misc_items_edit->status->Lookup->toClientList() ?>;
fmisc_itemsedit.lists["x_status"].options = <?php echo JsonEncode($misc_items_edit->status->options(FALSE, TRUE)) ?>;
fmisc_itemsedit.lists["x_operator"] = <?php echo $misc_items_edit->operator->Lookup->toClientList() ?>;
fmisc_itemsedit.lists["x_operator"].options = <?php echo JsonEncode($misc_items_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $misc_items_edit->showPageHeader(); ?>
<?php
$misc_items_edit->showMessage();
?>
<form name="fmisc_itemsedit" id="fmisc_itemsedit" class="<?php echo $misc_items_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($misc_items_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_items_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="misc_items">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$misc_items_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($misc_items->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_misc_items_id" class="<?php echo $misc_items_edit->LeftColumnClass ?>"><?php echo $misc_items->id->caption() ?><?php echo ($misc_items->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $misc_items_edit->RightColumnClass ?>"><div<?php echo $misc_items->id->cellAttributes() ?>>
<span id="el_misc_items_id">
<span<?php echo $misc_items->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($misc_items->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="misc_items" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($misc_items->id->CurrentValue) ?>">
<?php echo $misc_items->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($misc_items->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_misc_items_item" for="x_item" class="<?php echo $misc_items_edit->LeftColumnClass ?>"><?php echo $misc_items->item->caption() ?><?php echo ($misc_items->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $misc_items_edit->RightColumnClass ?>"><div<?php echo $misc_items->item->cellAttributes() ?>>
<span id="el_misc_items_item">
<span<?php echo $misc_items->item->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($misc_items->item->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="misc_items" data-field="x_item" name="x_item" id="x_item" value="<?php echo HtmlEncode($misc_items->item->CurrentValue) ?>">
<?php echo $misc_items->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($misc_items->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_misc_items_code" for="x_code" class="<?php echo $misc_items_edit->LeftColumnClass ?>"><?php echo $misc_items->code->caption() ?><?php echo ($misc_items->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $misc_items_edit->RightColumnClass ?>"><div<?php echo $misc_items->code->cellAttributes() ?>>
<span id="el_misc_items_code">
<span<?php echo $misc_items->code->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($misc_items->code->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="misc_items" data-field="x_code" name="x_code" id="x_code" value="<?php echo HtmlEncode($misc_items->code->CurrentValue) ?>">
<?php echo $misc_items->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($misc_items->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_misc_items_grp" for="x_grp" class="<?php echo $misc_items_edit->LeftColumnClass ?>"><?php echo $misc_items->grp->caption() ?><?php echo ($misc_items->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $misc_items_edit->RightColumnClass ?>"><div<?php echo $misc_items->grp->cellAttributes() ?>>
<span id="el_misc_items_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="misc_items" data-field="x_grp" data-value-separator="<?php echo $misc_items->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $misc_items->grp->editAttributes() ?>>
		<?php echo $misc_items->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $misc_items->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($misc_items->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_misc_items_status" for="x_status" class="<?php echo $misc_items_edit->LeftColumnClass ?>"><?php echo $misc_items->status->caption() ?><?php echo ($misc_items->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $misc_items_edit->RightColumnClass ?>"><div<?php echo $misc_items->status->cellAttributes() ?>>
<span id="el_misc_items_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="misc_items" data-field="x_status" data-value-separator="<?php echo $misc_items->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $misc_items->status->editAttributes() ?>>
		<?php echo $misc_items->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $misc_items->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$misc_items_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $misc_items_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $misc_items_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$misc_items_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$misc_items_edit->terminate();
?>