<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_items_list = new misc_items_list();

// Run the page
$misc_items_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_items_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$misc_items->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmisc_itemslist = currentForm = new ew.Form("fmisc_itemslist", "list");
fmisc_itemslist.formKeyCountName = '<?php echo $misc_items_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmisc_itemslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmisc_itemslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmisc_itemslist.lists["x_grp"] = <?php echo $misc_items_list->grp->Lookup->toClientList() ?>;
fmisc_itemslist.lists["x_grp"].options = <?php echo JsonEncode($misc_items_list->grp->options(FALSE, TRUE)) ?>;
fmisc_itemslist.lists["x_status"] = <?php echo $misc_items_list->status->Lookup->toClientList() ?>;
fmisc_itemslist.lists["x_status"].options = <?php echo JsonEncode($misc_items_list->status->options(FALSE, TRUE)) ?>;
fmisc_itemslist.lists["x_operator"] = <?php echo $misc_items_list->operator->Lookup->toClientList() ?>;
fmisc_itemslist.lists["x_operator"].options = <?php echo JsonEncode($misc_items_list->operator->lookupOptions()) ?>;

// Form object for search
var fmisc_itemslistsrch = currentSearchForm = new ew.Form("fmisc_itemslistsrch");

// Filters
fmisc_itemslistsrch.filterList = <?php echo $misc_items_list->getFilterList() ?>;

// Init search panel as collapsed
fmisc_itemslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$misc_items->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($misc_items_list->TotalRecs > 0 && $misc_items_list->ExportOptions->visible()) { ?>
<?php $misc_items_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($misc_items_list->ImportOptions->visible()) { ?>
<?php $misc_items_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($misc_items_list->SearchOptions->visible()) { ?>
<?php $misc_items_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($misc_items_list->FilterOptions->visible()) { ?>
<?php $misc_items_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$misc_items_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$misc_items->isExport() && !$misc_items->CurrentAction) { ?>
<form name="fmisc_itemslistsrch" id="fmisc_itemslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($misc_items_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmisc_itemslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="misc_items">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($misc_items_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($misc_items_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $misc_items_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($misc_items_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($misc_items_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($misc_items_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($misc_items_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $misc_items_list->showPageHeader(); ?>
<?php
$misc_items_list->showMessage();
?>
<?php if ($misc_items_list->TotalRecs > 0 || $misc_items->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($misc_items_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> misc_items">
<?php if (!$misc_items->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$misc_items->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($misc_items_list->Pager)) $misc_items_list->Pager = new PrevNextPager($misc_items_list->StartRec, $misc_items_list->DisplayRecs, $misc_items_list->TotalRecs, $misc_items_list->AutoHidePager) ?>
<?php if ($misc_items_list->Pager->RecordCount > 0 && $misc_items_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($misc_items_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($misc_items_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $misc_items_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($misc_items_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($misc_items_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $misc_items_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($misc_items_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $misc_items_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $misc_items_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $misc_items_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($misc_items_list->TotalRecs > 0 && (!$misc_items_list->AutoHidePageSizeSelector || $misc_items_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="misc_items">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($misc_items_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($misc_items_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($misc_items_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($misc_items_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($misc_items_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($misc_items->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $misc_items_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmisc_itemslist" id="fmisc_itemslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($misc_items_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_items_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="misc_items">
<div id="gmp_misc_items" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($misc_items_list->TotalRecs > 0 || $misc_items->isGridEdit()) { ?>
<table id="tbl_misc_itemslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$misc_items_list->RowType = ROWTYPE_HEADER;

// Render list options
$misc_items_list->renderListOptions();

// Render list options (header, left)
$misc_items_list->ListOptions->render("header", "left");
?>
<?php if ($misc_items->id->Visible) { // id ?>
	<?php if ($misc_items->sortUrl($misc_items->id) == "") { ?>
		<th data-name="id" class="<?php echo $misc_items->id->headerCellClass() ?>"><div id="elh_misc_items_id" class="misc_items_id"><div class="ew-table-header-caption"><?php echo $misc_items->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $misc_items->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->id) ?>',2);"><div id="elh_misc_items_id" class="misc_items_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc_items->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc_items->item->Visible) { // item ?>
	<?php if ($misc_items->sortUrl($misc_items->item) == "") { ?>
		<th data-name="item" class="<?php echo $misc_items->item->headerCellClass() ?>"><div id="elh_misc_items_item" class="misc_items_item"><div class="ew-table-header-caption"><?php echo $misc_items->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $misc_items->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->item) ?>',2);"><div id="elh_misc_items_item" class="misc_items_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($misc_items->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc_items->code->Visible) { // code ?>
	<?php if ($misc_items->sortUrl($misc_items->code) == "") { ?>
		<th data-name="code" class="<?php echo $misc_items->code->headerCellClass() ?>"><div id="elh_misc_items_code" class="misc_items_code"><div class="ew-table-header-caption"><?php echo $misc_items->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $misc_items->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->code) ?>',2);"><div id="elh_misc_items_code" class="misc_items_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($misc_items->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc_items->grp->Visible) { // grp ?>
	<?php if ($misc_items->sortUrl($misc_items->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $misc_items->grp->headerCellClass() ?>"><div id="elh_misc_items_grp" class="misc_items_grp"><div class="ew-table-header-caption"><?php echo $misc_items->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $misc_items->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->grp) ?>',2);"><div id="elh_misc_items_grp" class="misc_items_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc_items->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc_items->status->Visible) { // status ?>
	<?php if ($misc_items->sortUrl($misc_items->status) == "") { ?>
		<th data-name="status" class="<?php echo $misc_items->status->headerCellClass() ?>"><div id="elh_misc_items_status" class="misc_items_status"><div class="ew-table-header-caption"><?php echo $misc_items->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $misc_items->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->status) ?>',2);"><div id="elh_misc_items_status" class="misc_items_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc_items->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc_items->operator->Visible) { // operator ?>
	<?php if ($misc_items->sortUrl($misc_items->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $misc_items->operator->headerCellClass() ?>"><div id="elh_misc_items_operator" class="misc_items_operator"><div class="ew-table-header-caption"><?php echo $misc_items->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $misc_items->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->operator) ?>',2);"><div id="elh_misc_items_operator" class="misc_items_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc_items->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc_items->datetime->Visible) { // datetime ?>
	<?php if ($misc_items->sortUrl($misc_items->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $misc_items->datetime->headerCellClass() ?>"><div id="elh_misc_items_datetime" class="misc_items_datetime"><div class="ew-table-header-caption"><?php echo $misc_items->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $misc_items->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc_items->SortUrl($misc_items->datetime) ?>',2);"><div id="elh_misc_items_datetime" class="misc_items_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc_items->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc_items->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc_items->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$misc_items_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($misc_items->ExportAll && $misc_items->isExport()) {
	$misc_items_list->StopRec = $misc_items_list->TotalRecs;
} else {

	// Set the last record to display
	if ($misc_items_list->TotalRecs > $misc_items_list->StartRec + $misc_items_list->DisplayRecs - 1)
		$misc_items_list->StopRec = $misc_items_list->StartRec + $misc_items_list->DisplayRecs - 1;
	else
		$misc_items_list->StopRec = $misc_items_list->TotalRecs;
}
$misc_items_list->RecCnt = $misc_items_list->StartRec - 1;
if ($misc_items_list->Recordset && !$misc_items_list->Recordset->EOF) {
	$misc_items_list->Recordset->moveFirst();
	$selectLimit = $misc_items_list->UseSelectLimit;
	if (!$selectLimit && $misc_items_list->StartRec > 1)
		$misc_items_list->Recordset->move($misc_items_list->StartRec - 1);
} elseif (!$misc_items->AllowAddDeleteRow && $misc_items_list->StopRec == 0) {
	$misc_items_list->StopRec = $misc_items->GridAddRowCount;
}

// Initialize aggregate
$misc_items->RowType = ROWTYPE_AGGREGATEINIT;
$misc_items->resetAttributes();
$misc_items_list->renderRow();
while ($misc_items_list->RecCnt < $misc_items_list->StopRec) {
	$misc_items_list->RecCnt++;
	if ($misc_items_list->RecCnt >= $misc_items_list->StartRec) {
		$misc_items_list->RowCnt++;

		// Set up key count
		$misc_items_list->KeyCount = $misc_items_list->RowIndex;

		// Init row class and style
		$misc_items->resetAttributes();
		$misc_items->CssClass = "";
		if ($misc_items->isGridAdd()) {
		} else {
			$misc_items_list->loadRowValues($misc_items_list->Recordset); // Load row values
		}
		$misc_items->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$misc_items->RowAttrs = array_merge($misc_items->RowAttrs, array('data-rowindex'=>$misc_items_list->RowCnt, 'id'=>'r' . $misc_items_list->RowCnt . '_misc_items', 'data-rowtype'=>$misc_items->RowType));

		// Render row
		$misc_items_list->renderRow();

		// Render list options
		$misc_items_list->renderListOptions();
?>
	<tr<?php echo $misc_items->rowAttributes() ?>>
<?php

// Render list options (body, left)
$misc_items_list->ListOptions->render("body", "left", $misc_items_list->RowCnt);
?>
	<?php if ($misc_items->id->Visible) { // id ?>
		<td data-name="id"<?php echo $misc_items->id->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_id" class="misc_items_id">
<span<?php echo $misc_items->id->viewAttributes() ?>>
<?php echo $misc_items->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc_items->item->Visible) { // item ?>
		<td data-name="item"<?php echo $misc_items->item->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_item" class="misc_items_item">
<span<?php echo $misc_items->item->viewAttributes() ?>>
<?php echo $misc_items->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc_items->code->Visible) { // code ?>
		<td data-name="code"<?php echo $misc_items->code->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_code" class="misc_items_code">
<span<?php echo $misc_items->code->viewAttributes() ?>>
<?php echo $misc_items->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc_items->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $misc_items->grp->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_grp" class="misc_items_grp">
<span<?php echo $misc_items->grp->viewAttributes() ?>>
<?php echo $misc_items->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc_items->status->Visible) { // status ?>
		<td data-name="status"<?php echo $misc_items->status->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_status" class="misc_items_status">
<span<?php echo $misc_items->status->viewAttributes() ?>>
<?php echo $misc_items->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc_items->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $misc_items->operator->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_operator" class="misc_items_operator">
<span<?php echo $misc_items->operator->viewAttributes() ?>>
<?php echo $misc_items->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc_items->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $misc_items->datetime->cellAttributes() ?>>
<span id="el<?php echo $misc_items_list->RowCnt ?>_misc_items_datetime" class="misc_items_datetime">
<span<?php echo $misc_items->datetime->viewAttributes() ?>>
<?php echo $misc_items->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$misc_items_list->ListOptions->render("body", "right", $misc_items_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$misc_items->isGridAdd())
		$misc_items_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$misc_items->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($misc_items_list->Recordset)
	$misc_items_list->Recordset->Close();
?>
<?php if (!$misc_items->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$misc_items->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($misc_items_list->Pager)) $misc_items_list->Pager = new PrevNextPager($misc_items_list->StartRec, $misc_items_list->DisplayRecs, $misc_items_list->TotalRecs, $misc_items_list->AutoHidePager) ?>
<?php if ($misc_items_list->Pager->RecordCount > 0 && $misc_items_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($misc_items_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($misc_items_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $misc_items_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($misc_items_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($misc_items_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $misc_items_list->pageUrl() ?>start=<?php echo $misc_items_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $misc_items_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($misc_items_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $misc_items_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $misc_items_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $misc_items_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($misc_items_list->TotalRecs > 0 && (!$misc_items_list->AutoHidePageSizeSelector || $misc_items_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="misc_items">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($misc_items_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($misc_items_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($misc_items_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($misc_items_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($misc_items_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($misc_items->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $misc_items_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($misc_items_list->TotalRecs == 0 && !$misc_items->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $misc_items_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$misc_items_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$misc_items->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$misc_items->isExport()) { ?>
<script>
ew.scrollableTable("gmp_misc_items", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$misc_items_list->terminate();
?>