<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_items_view = new misc_items_view();

// Run the page
$misc_items_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_items_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$misc_items->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmisc_itemsview = currentForm = new ew.Form("fmisc_itemsview", "view");

// Form_CustomValidate event
fmisc_itemsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmisc_itemsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmisc_itemsview.lists["x_grp"] = <?php echo $misc_items_view->grp->Lookup->toClientList() ?>;
fmisc_itemsview.lists["x_grp"].options = <?php echo JsonEncode($misc_items_view->grp->options(FALSE, TRUE)) ?>;
fmisc_itemsview.lists["x_status"] = <?php echo $misc_items_view->status->Lookup->toClientList() ?>;
fmisc_itemsview.lists["x_status"].options = <?php echo JsonEncode($misc_items_view->status->options(FALSE, TRUE)) ?>;
fmisc_itemsview.lists["x_operator"] = <?php echo $misc_items_view->operator->Lookup->toClientList() ?>;
fmisc_itemsview.lists["x_operator"].options = <?php echo JsonEncode($misc_items_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$misc_items->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $misc_items_view->ExportOptions->render("body") ?>
<?php $misc_items_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $misc_items_view->showPageHeader(); ?>
<?php
$misc_items_view->showMessage();
?>
<form name="fmisc_itemsview" id="fmisc_itemsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($misc_items_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_items_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="misc_items">
<input type="hidden" name="modal" value="<?php echo (int)$misc_items_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($misc_items->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_id"><?php echo $misc_items->id->caption() ?></span></td>
		<td data-name="id"<?php echo $misc_items->id->cellAttributes() ?>>
<span id="el_misc_items_id">
<span<?php echo $misc_items->id->viewAttributes() ?>>
<?php echo $misc_items->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc_items->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_item"><?php echo $misc_items->item->caption() ?></span></td>
		<td data-name="item"<?php echo $misc_items->item->cellAttributes() ?>>
<span id="el_misc_items_item">
<span<?php echo $misc_items->item->viewAttributes() ?>>
<?php echo $misc_items->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc_items->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_code"><?php echo $misc_items->code->caption() ?></span></td>
		<td data-name="code"<?php echo $misc_items->code->cellAttributes() ?>>
<span id="el_misc_items_code">
<span<?php echo $misc_items->code->viewAttributes() ?>>
<?php echo $misc_items->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc_items->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_grp"><?php echo $misc_items->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $misc_items->grp->cellAttributes() ?>>
<span id="el_misc_items_grp">
<span<?php echo $misc_items->grp->viewAttributes() ?>>
<?php echo $misc_items->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc_items->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_status"><?php echo $misc_items->status->caption() ?></span></td>
		<td data-name="status"<?php echo $misc_items->status->cellAttributes() ?>>
<span id="el_misc_items_status">
<span<?php echo $misc_items->status->viewAttributes() ?>>
<?php echo $misc_items->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc_items->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_operator"><?php echo $misc_items->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $misc_items->operator->cellAttributes() ?>>
<span id="el_misc_items_operator">
<span<?php echo $misc_items->operator->viewAttributes() ?>>
<?php echo $misc_items->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc_items->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $misc_items_view->TableLeftColumnClass ?>"><span id="elh_misc_items_datetime"><?php echo $misc_items->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $misc_items->datetime->cellAttributes() ?>>
<span id="el_misc_items_datetime">
<span<?php echo $misc_items->datetime->viewAttributes() ?>>
<?php echo $misc_items->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$misc_items_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$misc_items->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$misc_items_view->terminate();
?>