<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_addopt = new misc_addopt();

// Run the page
$misc_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fmiscaddopt = currentForm = new ew.Form("fmiscaddopt", "addopt");

// Validate form
fmiscaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($misc_addopt->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc->item->caption(), $misc->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc->grp->caption(), $misc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc->status->caption(), $misc->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc->operator->caption(), $misc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($misc_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $misc->datetime->caption(), $misc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmiscaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmiscaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmiscaddopt.lists["x_grp"] = <?php echo $misc_addopt->grp->Lookup->toClientList() ?>;
fmiscaddopt.lists["x_grp"].options = <?php echo JsonEncode($misc_addopt->grp->lookupOptions()) ?>;
fmiscaddopt.lists["x_status"] = <?php echo $misc_addopt->status->Lookup->toClientList() ?>;
fmiscaddopt.lists["x_status"].options = <?php echo JsonEncode($misc_addopt->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $misc_addopt->showPageHeader(); ?>
<?php
$misc_addopt->showMessage();
?>
<form name="fmiscaddopt" id="fmiscaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($misc_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $misc_addopt->TableVar ?>">
<?php if ($misc->item->Visible) { // item ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_item"><?php echo $misc->item->caption() ?><?php echo ($misc->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="misc" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($misc->item->getPlaceHolder()) ?>" value="<?php echo $misc->item->EditValue ?>"<?php echo $misc->item->editAttributes() ?>>
<?php echo $misc->item->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($misc->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $misc->grp->caption() ?><?php echo ($misc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="misc" data-field="x_grp" data-value-separator="<?php echo $misc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $misc->grp->editAttributes() ?>>
		<?php echo $misc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $misc->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $misc->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($misc->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $misc->status->caption() ?><?php echo ($misc->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="misc" data-field="x_status" data-value-separator="<?php echo $misc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $misc->status->editAttributes() ?>>
		<?php echo $misc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $misc->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($misc->operator->Visible) { // operator ?>
	<input type="hidden" data-table="misc" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($misc->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($misc->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="misc" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($misc->datetime->CurrentValue) ?>">
	<?php if (!$misc->datetime->ReadOnly && !$misc->datetime->Disabled && !isset($misc->datetime->EditAttrs["readonly"]) && !isset($misc->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fmiscaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$misc_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$misc_addopt->terminate();
?>