<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_delete = new misc_delete();

// Run the page
$misc_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fmiscdelete = currentForm = new ew.Form("fmiscdelete", "delete");

// Form_CustomValidate event
fmiscdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmiscdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmiscdelete.lists["x_grp"] = <?php echo $misc_delete->grp->Lookup->toClientList() ?>;
fmiscdelete.lists["x_grp"].options = <?php echo JsonEncode($misc_delete->grp->lookupOptions()) ?>;
fmiscdelete.lists["x_status"] = <?php echo $misc_delete->status->Lookup->toClientList() ?>;
fmiscdelete.lists["x_status"].options = <?php echo JsonEncode($misc_delete->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $misc_delete->showPageHeader(); ?>
<?php
$misc_delete->showMessage();
?>
<form name="fmiscdelete" id="fmiscdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($misc_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="misc">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($misc_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($misc->id->Visible) { // id ?>
		<th class="<?php echo $misc->id->headerCellClass() ?>"><span id="elh_misc_id" class="misc_id"><?php echo $misc->id->caption() ?></span></th>
<?php } ?>
<?php if ($misc->item->Visible) { // item ?>
		<th class="<?php echo $misc->item->headerCellClass() ?>"><span id="elh_misc_item" class="misc_item"><?php echo $misc->item->caption() ?></span></th>
<?php } ?>
<?php if ($misc->grp->Visible) { // grp ?>
		<th class="<?php echo $misc->grp->headerCellClass() ?>"><span id="elh_misc_grp" class="misc_grp"><?php echo $misc->grp->caption() ?></span></th>
<?php } ?>
<?php if ($misc->status->Visible) { // status ?>
		<th class="<?php echo $misc->status->headerCellClass() ?>"><span id="elh_misc_status" class="misc_status"><?php echo $misc->status->caption() ?></span></th>
<?php } ?>
<?php if ($misc->operator->Visible) { // operator ?>
		<th class="<?php echo $misc->operator->headerCellClass() ?>"><span id="elh_misc_operator" class="misc_operator"><?php echo $misc->operator->caption() ?></span></th>
<?php } ?>
<?php if ($misc->datetime->Visible) { // datetime ?>
		<th class="<?php echo $misc->datetime->headerCellClass() ?>"><span id="elh_misc_datetime" class="misc_datetime"><?php echo $misc->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$misc_delete->RecCnt = 0;
$i = 0;
while (!$misc_delete->Recordset->EOF) {
	$misc_delete->RecCnt++;
	$misc_delete->RowCnt++;

	// Set row properties
	$misc->resetAttributes();
	$misc->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$misc_delete->loadRowValues($misc_delete->Recordset);

	// Render row
	$misc_delete->renderRow();
?>
	<tr<?php echo $misc->rowAttributes() ?>>
<?php if ($misc->id->Visible) { // id ?>
		<td<?php echo $misc->id->cellAttributes() ?>>
<span id="el<?php echo $misc_delete->RowCnt ?>_misc_id" class="misc_id">
<span<?php echo $misc->id->viewAttributes() ?>>
<?php echo $misc->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($misc->item->Visible) { // item ?>
		<td<?php echo $misc->item->cellAttributes() ?>>
<span id="el<?php echo $misc_delete->RowCnt ?>_misc_item" class="misc_item">
<span<?php echo $misc->item->viewAttributes() ?>>
<?php echo $misc->item->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($misc->grp->Visible) { // grp ?>
		<td<?php echo $misc->grp->cellAttributes() ?>>
<span id="el<?php echo $misc_delete->RowCnt ?>_misc_grp" class="misc_grp">
<span<?php echo $misc->grp->viewAttributes() ?>>
<?php echo $misc->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($misc->status->Visible) { // status ?>
		<td<?php echo $misc->status->cellAttributes() ?>>
<span id="el<?php echo $misc_delete->RowCnt ?>_misc_status" class="misc_status">
<span<?php echo $misc->status->viewAttributes() ?>>
<?php echo $misc->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($misc->operator->Visible) { // operator ?>
		<td<?php echo $misc->operator->cellAttributes() ?>>
<span id="el<?php echo $misc_delete->RowCnt ?>_misc_operator" class="misc_operator">
<span<?php echo $misc->operator->viewAttributes() ?>>
<?php echo $misc->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($misc->datetime->Visible) { // datetime ?>
		<td<?php echo $misc->datetime->cellAttributes() ?>>
<span id="el<?php echo $misc_delete->RowCnt ?>_misc_datetime" class="misc_datetime">
<span<?php echo $misc->datetime->viewAttributes() ?>>
<?php echo $misc->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$misc_delete->Recordset->moveNext();
}
$misc_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $misc_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$misc_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$misc_delete->terminate();
?>