<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_list = new misc_list();

// Run the page
$misc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$misc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmisclist = currentForm = new ew.Form("fmisclist", "list");
fmisclist.formKeyCountName = '<?php echo $misc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmisclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmisclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmisclist.lists["x_grp"] = <?php echo $misc_list->grp->Lookup->toClientList() ?>;
fmisclist.lists["x_grp"].options = <?php echo JsonEncode($misc_list->grp->lookupOptions()) ?>;
fmisclist.lists["x_status"] = <?php echo $misc_list->status->Lookup->toClientList() ?>;
fmisclist.lists["x_status"].options = <?php echo JsonEncode($misc_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fmisclistsrch = currentSearchForm = new ew.Form("fmisclistsrch");

// Filters
fmisclistsrch.filterList = <?php echo $misc_list->getFilterList() ?>;

// Init search panel as collapsed
fmisclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$misc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($misc_list->TotalRecs > 0 && $misc_list->ExportOptions->visible()) { ?>
<?php $misc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($misc_list->ImportOptions->visible()) { ?>
<?php $misc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($misc_list->SearchOptions->visible()) { ?>
<?php $misc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($misc_list->FilterOptions->visible()) { ?>
<?php $misc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$misc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$misc->isExport() && !$misc->CurrentAction) { ?>
<form name="fmisclistsrch" id="fmisclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($misc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmisclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="misc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($misc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($misc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $misc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($misc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($misc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($misc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($misc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $misc_list->showPageHeader(); ?>
<?php
$misc_list->showMessage();
?>
<?php if ($misc_list->TotalRecs > 0 || $misc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($misc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> misc">
<?php if (!$misc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$misc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($misc_list->Pager)) $misc_list->Pager = new PrevNextPager($misc_list->StartRec, $misc_list->DisplayRecs, $misc_list->TotalRecs, $misc_list->AutoHidePager) ?>
<?php if ($misc_list->Pager->RecordCount > 0 && $misc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($misc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($misc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $misc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($misc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($misc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $misc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($misc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $misc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $misc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $misc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($misc_list->TotalRecs > 0 && (!$misc_list->AutoHidePageSizeSelector || $misc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="misc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($misc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($misc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($misc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($misc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($misc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($misc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $misc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmisclist" id="fmisclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($misc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="misc">
<div id="gmp_misc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($misc_list->TotalRecs > 0 || $misc->isGridEdit()) { ?>
<table id="tbl_misclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$misc_list->RowType = ROWTYPE_HEADER;

// Render list options
$misc_list->renderListOptions();

// Render list options (header, left)
$misc_list->ListOptions->render("header", "left");
?>
<?php if ($misc->id->Visible) { // id ?>
	<?php if ($misc->sortUrl($misc->id) == "") { ?>
		<th data-name="id" class="<?php echo $misc->id->headerCellClass() ?>"><div id="elh_misc_id" class="misc_id"><div class="ew-table-header-caption"><?php echo $misc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $misc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc->SortUrl($misc->id) ?>',2);"><div id="elh_misc_id" class="misc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc->item->Visible) { // item ?>
	<?php if ($misc->sortUrl($misc->item) == "") { ?>
		<th data-name="item" class="<?php echo $misc->item->headerCellClass() ?>"><div id="elh_misc_item" class="misc_item"><div class="ew-table-header-caption"><?php echo $misc->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $misc->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc->SortUrl($misc->item) ?>',2);"><div id="elh_misc_item" class="misc_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($misc->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc->grp->Visible) { // grp ?>
	<?php if ($misc->sortUrl($misc->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $misc->grp->headerCellClass() ?>"><div id="elh_misc_grp" class="misc_grp"><div class="ew-table-header-caption"><?php echo $misc->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $misc->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc->SortUrl($misc->grp) ?>',2);"><div id="elh_misc_grp" class="misc_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc->status->Visible) { // status ?>
	<?php if ($misc->sortUrl($misc->status) == "") { ?>
		<th data-name="status" class="<?php echo $misc->status->headerCellClass() ?>"><div id="elh_misc_status" class="misc_status"><div class="ew-table-header-caption"><?php echo $misc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $misc->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc->SortUrl($misc->status) ?>',2);"><div id="elh_misc_status" class="misc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc->operator->Visible) { // operator ?>
	<?php if ($misc->sortUrl($misc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $misc->operator->headerCellClass() ?>"><div id="elh_misc_operator" class="misc_operator"><div class="ew-table-header-caption"><?php echo $misc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $misc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc->SortUrl($misc->operator) ?>',2);"><div id="elh_misc_operator" class="misc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($misc->datetime->Visible) { // datetime ?>
	<?php if ($misc->sortUrl($misc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $misc->datetime->headerCellClass() ?>"><div id="elh_misc_datetime" class="misc_datetime"><div class="ew-table-header-caption"><?php echo $misc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $misc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $misc->SortUrl($misc->datetime) ?>',2);"><div id="elh_misc_datetime" class="misc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $misc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($misc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($misc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$misc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($misc->ExportAll && $misc->isExport()) {
	$misc_list->StopRec = $misc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($misc_list->TotalRecs > $misc_list->StartRec + $misc_list->DisplayRecs - 1)
		$misc_list->StopRec = $misc_list->StartRec + $misc_list->DisplayRecs - 1;
	else
		$misc_list->StopRec = $misc_list->TotalRecs;
}
$misc_list->RecCnt = $misc_list->StartRec - 1;
if ($misc_list->Recordset && !$misc_list->Recordset->EOF) {
	$misc_list->Recordset->moveFirst();
	$selectLimit = $misc_list->UseSelectLimit;
	if (!$selectLimit && $misc_list->StartRec > 1)
		$misc_list->Recordset->move($misc_list->StartRec - 1);
} elseif (!$misc->AllowAddDeleteRow && $misc_list->StopRec == 0) {
	$misc_list->StopRec = $misc->GridAddRowCount;
}

// Initialize aggregate
$misc->RowType = ROWTYPE_AGGREGATEINIT;
$misc->resetAttributes();
$misc_list->renderRow();
while ($misc_list->RecCnt < $misc_list->StopRec) {
	$misc_list->RecCnt++;
	if ($misc_list->RecCnt >= $misc_list->StartRec) {
		$misc_list->RowCnt++;

		// Set up key count
		$misc_list->KeyCount = $misc_list->RowIndex;

		// Init row class and style
		$misc->resetAttributes();
		$misc->CssClass = "";
		if ($misc->isGridAdd()) {
		} else {
			$misc_list->loadRowValues($misc_list->Recordset); // Load row values
		}
		$misc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$misc->RowAttrs = array_merge($misc->RowAttrs, array('data-rowindex'=>$misc_list->RowCnt, 'id'=>'r' . $misc_list->RowCnt . '_misc', 'data-rowtype'=>$misc->RowType));

		// Render row
		$misc_list->renderRow();

		// Render list options
		$misc_list->renderListOptions();
?>
	<tr<?php echo $misc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$misc_list->ListOptions->render("body", "left", $misc_list->RowCnt);
?>
	<?php if ($misc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $misc->id->cellAttributes() ?>>
<span id="el<?php echo $misc_list->RowCnt ?>_misc_id" class="misc_id">
<span<?php echo $misc->id->viewAttributes() ?>>
<?php echo $misc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc->item->Visible) { // item ?>
		<td data-name="item"<?php echo $misc->item->cellAttributes() ?>>
<span id="el<?php echo $misc_list->RowCnt ?>_misc_item" class="misc_item">
<span<?php echo $misc->item->viewAttributes() ?>>
<?php echo $misc->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $misc->grp->cellAttributes() ?>>
<span id="el<?php echo $misc_list->RowCnt ?>_misc_grp" class="misc_grp">
<span<?php echo $misc->grp->viewAttributes() ?>>
<?php echo $misc->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $misc->status->cellAttributes() ?>>
<span id="el<?php echo $misc_list->RowCnt ?>_misc_status" class="misc_status">
<span<?php echo $misc->status->viewAttributes() ?>>
<?php echo $misc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $misc->operator->cellAttributes() ?>>
<span id="el<?php echo $misc_list->RowCnt ?>_misc_operator" class="misc_operator">
<span<?php echo $misc->operator->viewAttributes() ?>>
<?php echo $misc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($misc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $misc->datetime->cellAttributes() ?>>
<span id="el<?php echo $misc_list->RowCnt ?>_misc_datetime" class="misc_datetime">
<span<?php echo $misc->datetime->viewAttributes() ?>>
<?php echo $misc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$misc_list->ListOptions->render("body", "right", $misc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$misc->isGridAdd())
		$misc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$misc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($misc_list->Recordset)
	$misc_list->Recordset->Close();
?>
<?php if (!$misc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$misc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($misc_list->Pager)) $misc_list->Pager = new PrevNextPager($misc_list->StartRec, $misc_list->DisplayRecs, $misc_list->TotalRecs, $misc_list->AutoHidePager) ?>
<?php if ($misc_list->Pager->RecordCount > 0 && $misc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($misc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($misc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $misc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($misc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($misc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $misc_list->pageUrl() ?>start=<?php echo $misc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $misc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($misc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $misc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $misc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $misc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($misc_list->TotalRecs > 0 && (!$misc_list->AutoHidePageSizeSelector || $misc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="misc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($misc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($misc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($misc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($misc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($misc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($misc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $misc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($misc_list->TotalRecs == 0 && !$misc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $misc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$misc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$misc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$misc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_misc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$misc_list->terminate();
?>