<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$misc_view = new misc_view();

// Run the page
$misc_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$misc_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$misc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmiscview = currentForm = new ew.Form("fmiscview", "view");

// Form_CustomValidate event
fmiscview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmiscview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmiscview.lists["x_grp"] = <?php echo $misc_view->grp->Lookup->toClientList() ?>;
fmiscview.lists["x_grp"].options = <?php echo JsonEncode($misc_view->grp->lookupOptions()) ?>;
fmiscview.lists["x_status"] = <?php echo $misc_view->status->Lookup->toClientList() ?>;
fmiscview.lists["x_status"].options = <?php echo JsonEncode($misc_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$misc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $misc_view->ExportOptions->render("body") ?>
<?php $misc_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $misc_view->showPageHeader(); ?>
<?php
$misc_view->showMessage();
?>
<form name="fmiscview" id="fmiscview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($misc_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $misc_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="misc">
<input type="hidden" name="modal" value="<?php echo (int)$misc_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($misc->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $misc_view->TableLeftColumnClass ?>"><span id="elh_misc_id"><?php echo $misc->id->caption() ?></span></td>
		<td data-name="id"<?php echo $misc->id->cellAttributes() ?>>
<span id="el_misc_id">
<span<?php echo $misc->id->viewAttributes() ?>>
<?php echo $misc->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $misc_view->TableLeftColumnClass ?>"><span id="elh_misc_item"><?php echo $misc->item->caption() ?></span></td>
		<td data-name="item"<?php echo $misc->item->cellAttributes() ?>>
<span id="el_misc_item">
<span<?php echo $misc->item->viewAttributes() ?>>
<?php echo $misc->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $misc_view->TableLeftColumnClass ?>"><span id="elh_misc_grp"><?php echo $misc->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $misc->grp->cellAttributes() ?>>
<span id="el_misc_grp">
<span<?php echo $misc->grp->viewAttributes() ?>>
<?php echo $misc->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $misc_view->TableLeftColumnClass ?>"><span id="elh_misc_status"><?php echo $misc->status->caption() ?></span></td>
		<td data-name="status"<?php echo $misc->status->cellAttributes() ?>>
<span id="el_misc_status">
<span<?php echo $misc->status->viewAttributes() ?>>
<?php echo $misc->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $misc_view->TableLeftColumnClass ?>"><span id="elh_misc_operator"><?php echo $misc->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $misc->operator->cellAttributes() ?>>
<span id="el_misc_operator">
<span<?php echo $misc->operator->viewAttributes() ?>>
<?php echo $misc->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($misc->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $misc_view->TableLeftColumnClass ?>"><span id="elh_misc_datetime"><?php echo $misc->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $misc->datetime->cellAttributes() ?>>
<span id="el_misc_datetime">
<span<?php echo $misc->datetime->viewAttributes() ?>>
<?php echo $misc->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$misc_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$misc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$misc_view->terminate();
?>