<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mn_record_list = new mn_record_list();

// Run the page
$mn_record_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mn_record_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mn_record->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmn_recordlist = currentForm = new ew.Form("fmn_recordlist", "list");
fmn_recordlist.formKeyCountName = '<?php echo $mn_record_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmn_recordlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmn_recordlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fmn_recordlistsrch = currentSearchForm = new ew.Form("fmn_recordlistsrch");

// Filters
fmn_recordlistsrch.filterList = <?php echo $mn_record_list->getFilterList() ?>;

// Init search panel as collapsed
fmn_recordlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mn_record->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mn_record_list->TotalRecs > 0 && $mn_record_list->ExportOptions->visible()) { ?>
<?php $mn_record_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mn_record_list->ImportOptions->visible()) { ?>
<?php $mn_record_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mn_record_list->SearchOptions->visible()) { ?>
<?php $mn_record_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mn_record_list->FilterOptions->visible()) { ?>
<?php $mn_record_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$mn_record_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mn_record->isExport() && !$mn_record->CurrentAction) { ?>
<form name="fmn_recordlistsrch" id="fmn_recordlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($mn_record_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmn_recordlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mn_record">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($mn_record_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($mn_record_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $mn_record_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($mn_record_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($mn_record_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($mn_record_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($mn_record_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $mn_record_list->showPageHeader(); ?>
<?php
$mn_record_list->showMessage();
?>
<?php if ($mn_record_list->TotalRecs > 0 || $mn_record->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mn_record_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mn_record">
<?php if (!$mn_record->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$mn_record->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mn_record_list->Pager)) $mn_record_list->Pager = new PrevNextPager($mn_record_list->StartRec, $mn_record_list->DisplayRecs, $mn_record_list->TotalRecs, $mn_record_list->AutoHidePager) ?>
<?php if ($mn_record_list->Pager->RecordCount > 0 && $mn_record_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mn_record_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mn_record_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mn_record_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mn_record_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mn_record_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mn_record_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mn_record_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mn_record_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mn_record_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mn_record_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mn_record_list->TotalRecs > 0 && (!$mn_record_list->AutoHidePageSizeSelector || $mn_record_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mn_record">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mn_record_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mn_record_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mn_record_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mn_record_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mn_record_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mn_record->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mn_record_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmn_recordlist" id="fmn_recordlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mn_record_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mn_record_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mn_record">
<div id="gmp_mn_record" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($mn_record_list->TotalRecs > 0 || $mn_record->isGridEdit()) { ?>
<table id="tbl_mn_recordlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mn_record_list->RowType = ROWTYPE_HEADER;

// Render list options
$mn_record_list->renderListOptions();

// Render list options (header, left)
$mn_record_list->ListOptions->render("header", "left");
?>
<?php if ($mn_record->id->Visible) { // id ?>
	<?php if ($mn_record->sortUrl($mn_record->id) == "") { ?>
		<th data-name="id" class="<?php echo $mn_record->id->headerCellClass() ?>"><div id="elh_mn_record_id" class="mn_record_id"><div class="ew-table-header-caption"><?php echo $mn_record->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $mn_record->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->id) ?>',2);"><div id="elh_mn_record_id" class="mn_record_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mn_record->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->subject->Visible) { // subject ?>
	<?php if ($mn_record->sortUrl($mn_record->subject) == "") { ?>
		<th data-name="subject" class="<?php echo $mn_record->subject->headerCellClass() ?>"><div id="elh_mn_record_subject" class="mn_record_subject"><div class="ew-table-header-caption"><?php echo $mn_record->subject->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="subject" class="<?php echo $mn_record->subject->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->subject) ?>',2);"><div id="elh_mn_record_subject" class="mn_record_subject">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->subject->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mn_record->subject->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->subject->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->mobile_token->Visible) { // mobile_token ?>
	<?php if ($mn_record->sortUrl($mn_record->mobile_token) == "") { ?>
		<th data-name="mobile_token" class="<?php echo $mn_record->mobile_token->headerCellClass() ?>"><div id="elh_mn_record_mobile_token" class="mn_record_mobile_token"><div class="ew-table-header-caption"><?php echo $mn_record->mobile_token->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_token" class="<?php echo $mn_record->mobile_token->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->mobile_token) ?>',2);"><div id="elh_mn_record_mobile_token" class="mn_record_mobile_token">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->mobile_token->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mn_record->mobile_token->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->mobile_token->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->_response->Visible) { // response ?>
	<?php if ($mn_record->sortUrl($mn_record->_response) == "") { ?>
		<th data-name="_response" class="<?php echo $mn_record->_response->headerCellClass() ?>"><div id="elh_mn_record__response" class="mn_record__response"><div class="ew-table-header-caption"><?php echo $mn_record->_response->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_response" class="<?php echo $mn_record->_response->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->_response) ?>',2);"><div id="elh_mn_record__response" class="mn_record__response">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->_response->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mn_record->_response->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->_response->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->status->Visible) { // status ?>
	<?php if ($mn_record->sortUrl($mn_record->status) == "") { ?>
		<th data-name="status" class="<?php echo $mn_record->status->headerCellClass() ?>"><div id="elh_mn_record_status" class="mn_record_status"><div class="ew-table-header-caption"><?php echo $mn_record->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $mn_record->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->status) ?>',2);"><div id="elh_mn_record_status" class="mn_record_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($mn_record->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->operator->Visible) { // operator ?>
	<?php if ($mn_record->sortUrl($mn_record->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $mn_record->operator->headerCellClass() ?>"><div id="elh_mn_record_operator" class="mn_record_operator"><div class="ew-table-header-caption"><?php echo $mn_record->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $mn_record->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->operator) ?>',2);"><div id="elh_mn_record_operator" class="mn_record_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($mn_record->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->datetime->Visible) { // datetime ?>
	<?php if ($mn_record->sortUrl($mn_record->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $mn_record->datetime->headerCellClass() ?>"><div id="elh_mn_record_datetime" class="mn_record_datetime"><div class="ew-table-header-caption"><?php echo $mn_record->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $mn_record->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->datetime) ?>',2);"><div id="elh_mn_record_datetime" class="mn_record_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($mn_record->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->company_id->Visible) { // company_id ?>
	<?php if ($mn_record->sortUrl($mn_record->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $mn_record->company_id->headerCellClass() ?>"><div id="elh_mn_record_company_id" class="mn_record_company_id"><div class="ew-table-header-caption"><?php echo $mn_record->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $mn_record->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->company_id) ?>',2);"><div id="elh_mn_record_company_id" class="mn_record_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mn_record->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->sender_id->Visible) { // sender_id ?>
	<?php if ($mn_record->sortUrl($mn_record->sender_id) == "") { ?>
		<th data-name="sender_id" class="<?php echo $mn_record->sender_id->headerCellClass() ?>"><div id="elh_mn_record_sender_id" class="mn_record_sender_id"><div class="ew-table-header-caption"><?php echo $mn_record->sender_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sender_id" class="<?php echo $mn_record->sender_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->sender_id) ?>',2);"><div id="elh_mn_record_sender_id" class="mn_record_sender_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->sender_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mn_record->sender_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->sender_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mn_record->user_id->Visible) { // user_id ?>
	<?php if ($mn_record->sortUrl($mn_record->user_id) == "") { ?>
		<th data-name="user_id" class="<?php echo $mn_record->user_id->headerCellClass() ?>"><div id="elh_mn_record_user_id" class="mn_record_user_id"><div class="ew-table-header-caption"><?php echo $mn_record->user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_id" class="<?php echo $mn_record->user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mn_record->SortUrl($mn_record->user_id) ?>',2);"><div id="elh_mn_record_user_id" class="mn_record_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mn_record->user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mn_record->user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mn_record->user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mn_record_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mn_record->ExportAll && $mn_record->isExport()) {
	$mn_record_list->StopRec = $mn_record_list->TotalRecs;
} else {

	// Set the last record to display
	if ($mn_record_list->TotalRecs > $mn_record_list->StartRec + $mn_record_list->DisplayRecs - 1)
		$mn_record_list->StopRec = $mn_record_list->StartRec + $mn_record_list->DisplayRecs - 1;
	else
		$mn_record_list->StopRec = $mn_record_list->TotalRecs;
}
$mn_record_list->RecCnt = $mn_record_list->StartRec - 1;
if ($mn_record_list->Recordset && !$mn_record_list->Recordset->EOF) {
	$mn_record_list->Recordset->moveFirst();
	$selectLimit = $mn_record_list->UseSelectLimit;
	if (!$selectLimit && $mn_record_list->StartRec > 1)
		$mn_record_list->Recordset->move($mn_record_list->StartRec - 1);
} elseif (!$mn_record->AllowAddDeleteRow && $mn_record_list->StopRec == 0) {
	$mn_record_list->StopRec = $mn_record->GridAddRowCount;
}

// Initialize aggregate
$mn_record->RowType = ROWTYPE_AGGREGATEINIT;
$mn_record->resetAttributes();
$mn_record_list->renderRow();
while ($mn_record_list->RecCnt < $mn_record_list->StopRec) {
	$mn_record_list->RecCnt++;
	if ($mn_record_list->RecCnt >= $mn_record_list->StartRec) {
		$mn_record_list->RowCnt++;

		// Set up key count
		$mn_record_list->KeyCount = $mn_record_list->RowIndex;

		// Init row class and style
		$mn_record->resetAttributes();
		$mn_record->CssClass = "";
		if ($mn_record->isGridAdd()) {
		} else {
			$mn_record_list->loadRowValues($mn_record_list->Recordset); // Load row values
		}
		$mn_record->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$mn_record->RowAttrs = array_merge($mn_record->RowAttrs, array('data-rowindex'=>$mn_record_list->RowCnt, 'id'=>'r' . $mn_record_list->RowCnt . '_mn_record', 'data-rowtype'=>$mn_record->RowType));

		// Render row
		$mn_record_list->renderRow();

		// Render list options
		$mn_record_list->renderListOptions();
?>
	<tr<?php echo $mn_record->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mn_record_list->ListOptions->render("body", "left", $mn_record_list->RowCnt);
?>
	<?php if ($mn_record->id->Visible) { // id ?>
		<td data-name="id"<?php echo $mn_record->id->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_id" class="mn_record_id">
<span<?php echo $mn_record->id->viewAttributes() ?>>
<?php echo $mn_record->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->subject->Visible) { // subject ?>
		<td data-name="subject"<?php echo $mn_record->subject->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_subject" class="mn_record_subject">
<span<?php echo $mn_record->subject->viewAttributes() ?>>
<?php echo $mn_record->subject->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->mobile_token->Visible) { // mobile_token ?>
		<td data-name="mobile_token"<?php echo $mn_record->mobile_token->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_mobile_token" class="mn_record_mobile_token">
<span<?php echo $mn_record->mobile_token->viewAttributes() ?>>
<?php echo $mn_record->mobile_token->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->_response->Visible) { // response ?>
		<td data-name="_response"<?php echo $mn_record->_response->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record__response" class="mn_record__response">
<span<?php echo $mn_record->_response->viewAttributes() ?>>
<?php echo $mn_record->_response->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->status->Visible) { // status ?>
		<td data-name="status"<?php echo $mn_record->status->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_status" class="mn_record_status">
<span<?php echo $mn_record->status->viewAttributes() ?>>
<?php echo $mn_record->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $mn_record->operator->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_operator" class="mn_record_operator">
<span<?php echo $mn_record->operator->viewAttributes() ?>>
<?php echo $mn_record->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $mn_record->datetime->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_datetime" class="mn_record_datetime">
<span<?php echo $mn_record->datetime->viewAttributes() ?>>
<?php echo $mn_record->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $mn_record->company_id->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_company_id" class="mn_record_company_id">
<span<?php echo $mn_record->company_id->viewAttributes() ?>>
<?php echo $mn_record->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->sender_id->Visible) { // sender_id ?>
		<td data-name="sender_id"<?php echo $mn_record->sender_id->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_sender_id" class="mn_record_sender_id">
<span<?php echo $mn_record->sender_id->viewAttributes() ?>>
<?php echo $mn_record->sender_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mn_record->user_id->Visible) { // user_id ?>
		<td data-name="user_id"<?php echo $mn_record->user_id->cellAttributes() ?>>
<span id="el<?php echo $mn_record_list->RowCnt ?>_mn_record_user_id" class="mn_record_user_id">
<span<?php echo $mn_record->user_id->viewAttributes() ?>>
<?php echo $mn_record->user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mn_record_list->ListOptions->render("body", "right", $mn_record_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$mn_record->isGridAdd())
		$mn_record_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$mn_record->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mn_record_list->Recordset)
	$mn_record_list->Recordset->Close();
?>
<?php if (!$mn_record->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mn_record->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mn_record_list->Pager)) $mn_record_list->Pager = new PrevNextPager($mn_record_list->StartRec, $mn_record_list->DisplayRecs, $mn_record_list->TotalRecs, $mn_record_list->AutoHidePager) ?>
<?php if ($mn_record_list->Pager->RecordCount > 0 && $mn_record_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mn_record_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mn_record_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mn_record_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mn_record_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mn_record_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mn_record_list->pageUrl() ?>start=<?php echo $mn_record_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mn_record_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mn_record_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mn_record_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mn_record_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mn_record_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mn_record_list->TotalRecs > 0 && (!$mn_record_list->AutoHidePageSizeSelector || $mn_record_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mn_record">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mn_record_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mn_record_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mn_record_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mn_record_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mn_record_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mn_record->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mn_record_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mn_record_list->TotalRecs == 0 && !$mn_record->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mn_record_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mn_record_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mn_record->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$mn_record->isExport()) { ?>
<script>
ew.scrollableTable("gmp_mn_record", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mn_record_list->terminate();
?>