<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$monthly_production_buyerwise_list = new monthly_production_buyerwise_list();

// Run the page
$monthly_production_buyerwise_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$monthly_production_buyerwise_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$monthly_production_buyerwise->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmonthly_production_buyerwiselist = currentForm = new ew.Form("fmonthly_production_buyerwiselist", "list");
fmonthly_production_buyerwiselist.formKeyCountName = '<?php echo $monthly_production_buyerwise_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmonthly_production_buyerwiselist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmonthly_production_buyerwiselist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmonthly_production_buyerwiselist.lists["x_month"] = <?php echo $monthly_production_buyerwise_list->month->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselist.lists["x_month"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->month->lookupOptions()) ?>;
fmonthly_production_buyerwiselist.lists["x_buyers_id"] = <?php echo $monthly_production_buyerwise_list->buyers_id->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselist.lists["x_buyers_id"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->buyers_id->lookupOptions()) ?>;
fmonthly_production_buyerwiselist.lists["x_location"] = <?php echo $monthly_production_buyerwise_list->location->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselist.lists["x_location"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->location->lookupOptions()) ?>;
fmonthly_production_buyerwiselist.lists["x_category"] = <?php echo $monthly_production_buyerwise_list->category->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselist.lists["x_category"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->category->lookupOptions()) ?>;
fmonthly_production_buyerwiselist.lists["x_process"] = <?php echo $monthly_production_buyerwise_list->process->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselist.lists["x_process"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->process->lookupOptions()) ?>;
fmonthly_production_buyerwiselist.lists["x_payment_type"] = <?php echo $monthly_production_buyerwise_list->payment_type->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselist.lists["x_payment_type"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->payment_type->options(FALSE, TRUE)) ?>;

// Form object for search
var fmonthly_production_buyerwiselistsrch = currentSearchForm = new ew.Form("fmonthly_production_buyerwiselistsrch");

// Validate function for search
fmonthly_production_buyerwiselistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmonthly_production_buyerwiselistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmonthly_production_buyerwiselistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmonthly_production_buyerwiselistsrch.lists["x_month"] = <?php echo $monthly_production_buyerwise_list->month->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselistsrch.lists["x_month"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->month->lookupOptions()) ?>;
fmonthly_production_buyerwiselistsrch.lists["x_buyers_id"] = <?php echo $monthly_production_buyerwise_list->buyers_id->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselistsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->buyers_id->lookupOptions()) ?>;
fmonthly_production_buyerwiselistsrch.lists["x_location"] = <?php echo $monthly_production_buyerwise_list->location->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselistsrch.lists["x_location"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->location->lookupOptions()) ?>;
fmonthly_production_buyerwiselistsrch.lists["x_category"] = <?php echo $monthly_production_buyerwise_list->category->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselistsrch.lists["x_category"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->category->lookupOptions()) ?>;
fmonthly_production_buyerwiselistsrch.lists["x_process"] = <?php echo $monthly_production_buyerwise_list->process->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselistsrch.lists["x_process"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->process->lookupOptions()) ?>;
fmonthly_production_buyerwiselistsrch.lists["x_payment_type"] = <?php echo $monthly_production_buyerwise_list->payment_type->Lookup->toClientList() ?>;
fmonthly_production_buyerwiselistsrch.lists["x_payment_type"].options = <?php echo JsonEncode($monthly_production_buyerwise_list->payment_type->options(FALSE, TRUE)) ?>;

// Filters
fmonthly_production_buyerwiselistsrch.filterList = <?php echo $monthly_production_buyerwise_list->getFilterList() ?>;

// Init search panel as collapsed
fmonthly_production_buyerwiselistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$monthly_production_buyerwise->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($monthly_production_buyerwise_list->TotalRecs > 0 && $monthly_production_buyerwise_list->ExportOptions->visible()) { ?>
<?php $monthly_production_buyerwise_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->ImportOptions->visible()) { ?>
<?php $monthly_production_buyerwise_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->SearchOptions->visible()) { ?>
<?php $monthly_production_buyerwise_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->FilterOptions->visible()) { ?>
<?php $monthly_production_buyerwise_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$monthly_production_buyerwise_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$monthly_production_buyerwise->isExport() && !$monthly_production_buyerwise->CurrentAction) { ?>
<form name="fmonthly_production_buyerwiselistsrch" id="fmonthly_production_buyerwiselistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($monthly_production_buyerwise_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmonthly_production_buyerwiselistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="monthly_production_buyerwise">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$monthly_production_buyerwise_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$monthly_production_buyerwise->RowType = ROWTYPE_SEARCH;

// Render row
$monthly_production_buyerwise->resetAttributes();
$monthly_production_buyerwise_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($monthly_production_buyerwise->month->Visible) { // month ?>
	<div id="xsc_month" class="ew-cell form-group">
		<label for="x_month" class="ew-search-caption ew-label"><?php echo $monthly_production_buyerwise->month->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_month" id="z_month" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production_buyerwise" data-field="x_month" data-value-separator="<?php echo $monthly_production_buyerwise->month->displayValueSeparatorAttribute() ?>" id="x_month" name="x_month"<?php echo $monthly_production_buyerwise->month->editAttributes() ?>>
		<?php echo $monthly_production_buyerwise->month->selectOptionListHtml("x_month") ?>
	</select>
</div>
<?php echo $monthly_production_buyerwise->month->Lookup->getParamTag("p_x_month") ?>
</span>
	</div>
<?php } ?>
<?php if ($monthly_production_buyerwise->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label for="x_buyers_id" class="ew-search-caption ew-label"><?php echo $monthly_production_buyerwise->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production_buyerwise" data-field="x_buyers_id" data-value-separator="<?php echo $monthly_production_buyerwise->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $monthly_production_buyerwise->buyers_id->editAttributes() ?>>
		<?php echo $monthly_production_buyerwise->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $monthly_production_buyerwise->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($monthly_production_buyerwise->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $monthly_production_buyerwise->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production_buyerwise" data-field="x_location" data-value-separator="<?php echo $monthly_production_buyerwise->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $monthly_production_buyerwise->location->editAttributes() ?>>
		<?php echo $monthly_production_buyerwise->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $monthly_production_buyerwise->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($monthly_production_buyerwise->category->Visible) { // category ?>
	<div id="xsc_category" class="ew-cell form-group">
		<label for="x_category" class="ew-search-caption ew-label"><?php echo $monthly_production_buyerwise->category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production_buyerwise" data-field="x_category" data-value-separator="<?php echo $monthly_production_buyerwise->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $monthly_production_buyerwise->category->editAttributes() ?>>
		<?php echo $monthly_production_buyerwise->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $monthly_production_buyerwise->category->Lookup->getParamTag("p_x_category") ?>
</span>
	</div>
<?php } ?>
<?php if ($monthly_production_buyerwise->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $monthly_production_buyerwise->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production_buyerwise" data-field="x_process" data-value-separator="<?php echo $monthly_production_buyerwise->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $monthly_production_buyerwise->process->editAttributes() ?>>
		<?php echo $monthly_production_buyerwise->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $monthly_production_buyerwise->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($monthly_production_buyerwise->payment_type->Visible) { // payment_type ?>
	<div id="xsc_payment_type" class="ew-cell form-group">
		<label for="x_payment_type" class="ew-search-caption ew-label"><?php echo $monthly_production_buyerwise->payment_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_type" id="z_payment_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production_buyerwise" data-field="x_payment_type" data-value-separator="<?php echo $monthly_production_buyerwise->payment_type->displayValueSeparatorAttribute() ?>" id="x_payment_type" name="x_payment_type"<?php echo $monthly_production_buyerwise->payment_type->editAttributes() ?>>
		<?php echo $monthly_production_buyerwise->payment_type->selectOptionListHtml("x_payment_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($monthly_production_buyerwise_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($monthly_production_buyerwise_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $monthly_production_buyerwise_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($monthly_production_buyerwise_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($monthly_production_buyerwise_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($monthly_production_buyerwise_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($monthly_production_buyerwise_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $monthly_production_buyerwise_list->showPageHeader(); ?>
<?php
$monthly_production_buyerwise_list->showMessage();
?>
<?php if ($monthly_production_buyerwise_list->TotalRecs > 0 || $monthly_production_buyerwise->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($monthly_production_buyerwise_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> monthly_production_buyerwise">
<?php if (!$monthly_production_buyerwise->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$monthly_production_buyerwise->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($monthly_production_buyerwise_list->Pager)) $monthly_production_buyerwise_list->Pager = new PrevNextPager($monthly_production_buyerwise_list->StartRec, $monthly_production_buyerwise_list->DisplayRecs, $monthly_production_buyerwise_list->TotalRecs, $monthly_production_buyerwise_list->AutoHidePager) ?>
<?php if ($monthly_production_buyerwise_list->Pager->RecordCount > 0 && $monthly_production_buyerwise_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $monthly_production_buyerwise_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->TotalRecs > 0 && (!$monthly_production_buyerwise_list->AutoHidePageSizeSelector || $monthly_production_buyerwise_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="monthly_production_buyerwise">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($monthly_production_buyerwise->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $monthly_production_buyerwise_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmonthly_production_buyerwiselist" id="fmonthly_production_buyerwiselist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($monthly_production_buyerwise_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $monthly_production_buyerwise_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="monthly_production_buyerwise">
<div id="gmp_monthly_production_buyerwise" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($monthly_production_buyerwise_list->TotalRecs > 0 || $monthly_production_buyerwise->isGridEdit()) { ?>
<table id="tbl_monthly_production_buyerwiselist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$monthly_production_buyerwise_list->RowType = ROWTYPE_HEADER;

// Render list options
$monthly_production_buyerwise_list->renderListOptions();

// Render list options (header, left)
$monthly_production_buyerwise_list->ListOptions->render("header", "left");
?>
<?php if ($monthly_production_buyerwise->month->Visible) { // month ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->month) == "") { ?>
		<th data-name="month" class="<?php echo $monthly_production_buyerwise->month->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_month" class="monthly_production_buyerwise_month"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month" class="<?php echo $monthly_production_buyerwise->month->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->month) ?>',2);"><div id="elh_monthly_production_buyerwise_month" class="monthly_production_buyerwise_month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->buyers_id->Visible) { // buyers_id ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $monthly_production_buyerwise->buyers_id->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_buyers_id" class="monthly_production_buyerwise_buyers_id"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $monthly_production_buyerwise->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->buyers_id) ?>',2);"><div id="elh_monthly_production_buyerwise_buyers_id" class="monthly_production_buyerwise_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->location->Visible) { // location ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->location) == "") { ?>
		<th data-name="location" class="<?php echo $monthly_production_buyerwise->location->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_location" class="monthly_production_buyerwise_location"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $monthly_production_buyerwise->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->location) ?>',2);"><div id="elh_monthly_production_buyerwise_location" class="monthly_production_buyerwise_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->category->Visible) { // category ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->category) == "") { ?>
		<th data-name="category" class="<?php echo $monthly_production_buyerwise->category->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_category" class="monthly_production_buyerwise_category"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $monthly_production_buyerwise->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->category) ?>',2);"><div id="elh_monthly_production_buyerwise_category" class="monthly_production_buyerwise_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->process->Visible) { // process ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->process) == "") { ?>
		<th data-name="process" class="<?php echo $monthly_production_buyerwise->process->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_process" class="monthly_production_buyerwise_process"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $monthly_production_buyerwise->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->process) ?>',2);"><div id="elh_monthly_production_buyerwise_process" class="monthly_production_buyerwise_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->payment_type->Visible) { // payment_type ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->payment_type) == "") { ?>
		<th data-name="payment_type" class="<?php echo $monthly_production_buyerwise->payment_type->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_payment_type" class="monthly_production_buyerwise_payment_type"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->payment_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_type" class="<?php echo $monthly_production_buyerwise->payment_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->payment_type) ?>',2);"><div id="elh_monthly_production_buyerwise_payment_type" class="monthly_production_buyerwise_payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->payment_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->payment_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->payment_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->pcs->Visible) { // pcs ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->pcs) == "") { ?>
		<th data-name="pcs" class="<?php echo $monthly_production_buyerwise->pcs->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_pcs" class="monthly_production_buyerwise_pcs"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->pcs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pcs" class="<?php echo $monthly_production_buyerwise->pcs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->pcs) ?>',2);"><div id="elh_monthly_production_buyerwise_pcs" class="monthly_production_buyerwise_pcs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->pcs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->pcs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->pcs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->sqm->Visible) { // sqm ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $monthly_production_buyerwise->sqm->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_sqm" class="monthly_production_buyerwise_sqm"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $monthly_production_buyerwise->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->sqm) ?>',2);"><div id="elh_monthly_production_buyerwise_sqm" class="monthly_production_buyerwise_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production_buyerwise->amount->Visible) { // amount ?>
	<?php if ($monthly_production_buyerwise->sortUrl($monthly_production_buyerwise->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $monthly_production_buyerwise->amount->headerCellClass() ?>"><div id="elh_monthly_production_buyerwise_amount" class="monthly_production_buyerwise_amount"><div class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $monthly_production_buyerwise->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production_buyerwise->SortUrl($monthly_production_buyerwise->amount) ?>',2);"><div id="elh_monthly_production_buyerwise_amount" class="monthly_production_buyerwise_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production_buyerwise->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production_buyerwise->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production_buyerwise->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$monthly_production_buyerwise_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($monthly_production_buyerwise->ExportAll && $monthly_production_buyerwise->isExport()) {
	$monthly_production_buyerwise_list->StopRec = $monthly_production_buyerwise_list->TotalRecs;
} else {

	// Set the last record to display
	if ($monthly_production_buyerwise_list->TotalRecs > $monthly_production_buyerwise_list->StartRec + $monthly_production_buyerwise_list->DisplayRecs - 1)
		$monthly_production_buyerwise_list->StopRec = $monthly_production_buyerwise_list->StartRec + $monthly_production_buyerwise_list->DisplayRecs - 1;
	else
		$monthly_production_buyerwise_list->StopRec = $monthly_production_buyerwise_list->TotalRecs;
}
$monthly_production_buyerwise_list->RecCnt = $monthly_production_buyerwise_list->StartRec - 1;
if ($monthly_production_buyerwise_list->Recordset && !$monthly_production_buyerwise_list->Recordset->EOF) {
	$monthly_production_buyerwise_list->Recordset->moveFirst();
	$selectLimit = $monthly_production_buyerwise_list->UseSelectLimit;
	if (!$selectLimit && $monthly_production_buyerwise_list->StartRec > 1)
		$monthly_production_buyerwise_list->Recordset->move($monthly_production_buyerwise_list->StartRec - 1);
} elseif (!$monthly_production_buyerwise->AllowAddDeleteRow && $monthly_production_buyerwise_list->StopRec == 0) {
	$monthly_production_buyerwise_list->StopRec = $monthly_production_buyerwise->GridAddRowCount;
}

// Initialize aggregate
$monthly_production_buyerwise->RowType = ROWTYPE_AGGREGATEINIT;
$monthly_production_buyerwise->resetAttributes();
$monthly_production_buyerwise_list->renderRow();
while ($monthly_production_buyerwise_list->RecCnt < $monthly_production_buyerwise_list->StopRec) {
	$monthly_production_buyerwise_list->RecCnt++;
	if ($monthly_production_buyerwise_list->RecCnt >= $monthly_production_buyerwise_list->StartRec) {
		$monthly_production_buyerwise_list->RowCnt++;

		// Set up key count
		$monthly_production_buyerwise_list->KeyCount = $monthly_production_buyerwise_list->RowIndex;

		// Init row class and style
		$monthly_production_buyerwise->resetAttributes();
		$monthly_production_buyerwise->CssClass = "";
		if ($monthly_production_buyerwise->isGridAdd()) {
		} else {
			$monthly_production_buyerwise_list->loadRowValues($monthly_production_buyerwise_list->Recordset); // Load row values
		}
		$monthly_production_buyerwise->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$monthly_production_buyerwise->RowAttrs = array_merge($monthly_production_buyerwise->RowAttrs, array('data-rowindex'=>$monthly_production_buyerwise_list->RowCnt, 'id'=>'r' . $monthly_production_buyerwise_list->RowCnt . '_monthly_production_buyerwise', 'data-rowtype'=>$monthly_production_buyerwise->RowType));

		// Render row
		$monthly_production_buyerwise_list->renderRow();

		// Render list options
		$monthly_production_buyerwise_list->renderListOptions();
?>
	<tr<?php echo $monthly_production_buyerwise->rowAttributes() ?>>
<?php

// Render list options (body, left)
$monthly_production_buyerwise_list->ListOptions->render("body", "left", $monthly_production_buyerwise_list->RowCnt);
?>
	<?php if ($monthly_production_buyerwise->month->Visible) { // month ?>
		<td data-name="month"<?php echo $monthly_production_buyerwise->month->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_month" class="monthly_production_buyerwise_month">
<span<?php echo $monthly_production_buyerwise->month->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->month->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $monthly_production_buyerwise->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_buyers_id" class="monthly_production_buyerwise_buyers_id">
<span<?php echo $monthly_production_buyerwise->buyers_id->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->location->Visible) { // location ?>
		<td data-name="location"<?php echo $monthly_production_buyerwise->location->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_location" class="monthly_production_buyerwise_location">
<span<?php echo $monthly_production_buyerwise->location->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->category->Visible) { // category ?>
		<td data-name="category"<?php echo $monthly_production_buyerwise->category->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_category" class="monthly_production_buyerwise_category">
<span<?php echo $monthly_production_buyerwise->category->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->process->Visible) { // process ?>
		<td data-name="process"<?php echo $monthly_production_buyerwise->process->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_process" class="monthly_production_buyerwise_process">
<span<?php echo $monthly_production_buyerwise->process->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->payment_type->Visible) { // payment_type ?>
		<td data-name="payment_type"<?php echo $monthly_production_buyerwise->payment_type->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_payment_type" class="monthly_production_buyerwise_payment_type">
<span<?php echo $monthly_production_buyerwise->payment_type->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->payment_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->pcs->Visible) { // pcs ?>
		<td data-name="pcs"<?php echo $monthly_production_buyerwise->pcs->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_pcs" class="monthly_production_buyerwise_pcs">
<span<?php echo $monthly_production_buyerwise->pcs->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->pcs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $monthly_production_buyerwise->sqm->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_sqm" class="monthly_production_buyerwise_sqm">
<span<?php echo $monthly_production_buyerwise->sqm->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $monthly_production_buyerwise->amount->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_buyerwise_list->RowCnt ?>_monthly_production_buyerwise_amount" class="monthly_production_buyerwise_amount">
<span<?php echo $monthly_production_buyerwise->amount->viewAttributes() ?>>
<?php echo $monthly_production_buyerwise->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$monthly_production_buyerwise_list->ListOptions->render("body", "right", $monthly_production_buyerwise_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$monthly_production_buyerwise->isGridAdd())
		$monthly_production_buyerwise_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$monthly_production_buyerwise->RowType = ROWTYPE_AGGREGATE;
$monthly_production_buyerwise->resetAttributes();
$monthly_production_buyerwise_list->renderRow();
?>
<?php if ($monthly_production_buyerwise_list->TotalRecs > 0 && !$monthly_production_buyerwise->isGridAdd() && !$monthly_production_buyerwise->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$monthly_production_buyerwise_list->renderListOptions();

// Render list options (footer, left)
$monthly_production_buyerwise_list->ListOptions->render("footer", "left");
?>
	<?php if ($monthly_production_buyerwise->month->Visible) { // month ?>
		<td data-name="month" class="<?php echo $monthly_production_buyerwise->month->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_month" class="monthly_production_buyerwise_month">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $monthly_production_buyerwise->buyers_id->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_buyers_id" class="monthly_production_buyerwise_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $monthly_production_buyerwise->location->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_location" class="monthly_production_buyerwise_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->category->Visible) { // category ?>
		<td data-name="category" class="<?php echo $monthly_production_buyerwise->category->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_category" class="monthly_production_buyerwise_category">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $monthly_production_buyerwise->process->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_process" class="monthly_production_buyerwise_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->payment_type->Visible) { // payment_type ?>
		<td data-name="payment_type" class="<?php echo $monthly_production_buyerwise->payment_type->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_payment_type" class="monthly_production_buyerwise_payment_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->pcs->Visible) { // pcs ?>
		<td data-name="pcs" class="<?php echo $monthly_production_buyerwise->pcs->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_pcs" class="monthly_production_buyerwise_pcs">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $monthly_production_buyerwise->pcs->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $monthly_production_buyerwise->sqm->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_sqm" class="monthly_production_buyerwise_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $monthly_production_buyerwise->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($monthly_production_buyerwise->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $monthly_production_buyerwise->amount->footerCellClass() ?>"><span id="elf_monthly_production_buyerwise_amount" class="monthly_production_buyerwise_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $monthly_production_buyerwise->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$monthly_production_buyerwise_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$monthly_production_buyerwise->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($monthly_production_buyerwise_list->Recordset)
	$monthly_production_buyerwise_list->Recordset->Close();
?>
<?php if (!$monthly_production_buyerwise->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$monthly_production_buyerwise->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($monthly_production_buyerwise_list->Pager)) $monthly_production_buyerwise_list->Pager = new PrevNextPager($monthly_production_buyerwise_list->StartRec, $monthly_production_buyerwise_list->DisplayRecs, $monthly_production_buyerwise_list->TotalRecs, $monthly_production_buyerwise_list->AutoHidePager) ?>
<?php if ($monthly_production_buyerwise_list->Pager->RecordCount > 0 && $monthly_production_buyerwise_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $monthly_production_buyerwise_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($monthly_production_buyerwise_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $monthly_production_buyerwise_list->pageUrl() ?>start=<?php echo $monthly_production_buyerwise_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $monthly_production_buyerwise_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($monthly_production_buyerwise_list->TotalRecs > 0 && (!$monthly_production_buyerwise_list->AutoHidePageSizeSelector || $monthly_production_buyerwise_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="monthly_production_buyerwise">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($monthly_production_buyerwise_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($monthly_production_buyerwise->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $monthly_production_buyerwise_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($monthly_production_buyerwise_list->TotalRecs == 0 && !$monthly_production_buyerwise->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $monthly_production_buyerwise_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$monthly_production_buyerwise_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$monthly_production_buyerwise->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$monthly_production_buyerwise->isExport()) { ?>
<script>
ew.scrollableTable("gmp_monthly_production_buyerwise", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$monthly_production_buyerwise_list->terminate();
?>