<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$monthly_production_list = new monthly_production_list();

// Run the page
$monthly_production_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$monthly_production_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$monthly_production->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmonthly_productionlist = currentForm = new ew.Form("fmonthly_productionlist", "list");
fmonthly_productionlist.formKeyCountName = '<?php echo $monthly_production_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmonthly_productionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmonthly_productionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmonthly_productionlist.lists["x_month"] = <?php echo $monthly_production_list->month->Lookup->toClientList() ?>;
fmonthly_productionlist.lists["x_month"].options = <?php echo JsonEncode($monthly_production_list->month->lookupOptions()) ?>;
fmonthly_productionlist.lists["x_location"] = <?php echo $monthly_production_list->location->Lookup->toClientList() ?>;
fmonthly_productionlist.lists["x_location"].options = <?php echo JsonEncode($monthly_production_list->location->lookupOptions()) ?>;
fmonthly_productionlist.lists["x_category"] = <?php echo $monthly_production_list->category->Lookup->toClientList() ?>;
fmonthly_productionlist.lists["x_category"].options = <?php echo JsonEncode($monthly_production_list->category->lookupOptions()) ?>;
fmonthly_productionlist.lists["x_process"] = <?php echo $monthly_production_list->process->Lookup->toClientList() ?>;
fmonthly_productionlist.lists["x_process"].options = <?php echo JsonEncode($monthly_production_list->process->lookupOptions()) ?>;

// Form object for search
var fmonthly_productionlistsrch = currentSearchForm = new ew.Form("fmonthly_productionlistsrch");

// Validate function for search
fmonthly_productionlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmonthly_productionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmonthly_productionlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmonthly_productionlistsrch.lists["x_month"] = <?php echo $monthly_production_list->month->Lookup->toClientList() ?>;
fmonthly_productionlistsrch.lists["x_month"].options = <?php echo JsonEncode($monthly_production_list->month->lookupOptions()) ?>;
fmonthly_productionlistsrch.lists["x_location"] = <?php echo $monthly_production_list->location->Lookup->toClientList() ?>;
fmonthly_productionlistsrch.lists["x_location"].options = <?php echo JsonEncode($monthly_production_list->location->lookupOptions()) ?>;
fmonthly_productionlistsrch.lists["x_process"] = <?php echo $monthly_production_list->process->Lookup->toClientList() ?>;
fmonthly_productionlistsrch.lists["x_process"].options = <?php echo JsonEncode($monthly_production_list->process->lookupOptions()) ?>;

// Filters
fmonthly_productionlistsrch.filterList = <?php echo $monthly_production_list->getFilterList() ?>;

// Init search panel as collapsed
fmonthly_productionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$monthly_production->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($monthly_production_list->TotalRecs > 0 && $monthly_production_list->ExportOptions->visible()) { ?>
<?php $monthly_production_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($monthly_production_list->ImportOptions->visible()) { ?>
<?php $monthly_production_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($monthly_production_list->SearchOptions->visible()) { ?>
<?php $monthly_production_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($monthly_production_list->FilterOptions->visible()) { ?>
<?php $monthly_production_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$monthly_production_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$monthly_production->isExport() && !$monthly_production->CurrentAction) { ?>
<form name="fmonthly_productionlistsrch" id="fmonthly_productionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($monthly_production_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmonthly_productionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="monthly_production">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$monthly_production_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$monthly_production->RowType = ROWTYPE_SEARCH;

// Render row
$monthly_production->resetAttributes();
$monthly_production_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($monthly_production->month->Visible) { // month ?>
	<div id="xsc_month" class="ew-cell form-group">
		<label for="x_month" class="ew-search-caption ew-label"><?php echo $monthly_production->month->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_month" id="z_month" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_month" data-value-separator="<?php echo $monthly_production->month->displayValueSeparatorAttribute() ?>" id="x_month" name="x_month"<?php echo $monthly_production->month->editAttributes() ?>>
		<?php echo $monthly_production->month->selectOptionListHtml("x_month") ?>
	</select>
</div>
<?php echo $monthly_production->month->Lookup->getParamTag("p_x_month") ?>
</span>
	</div>
<?php } ?>
<?php if ($monthly_production->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $monthly_production->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_location" data-value-separator="<?php echo $monthly_production->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $monthly_production->location->editAttributes() ?>>
		<?php echo $monthly_production->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $monthly_production->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($monthly_production->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $monthly_production->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_process" data-value-separator="<?php echo $monthly_production->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $monthly_production->process->editAttributes() ?>>
		<?php echo $monthly_production->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $monthly_production->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($monthly_production_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($monthly_production_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $monthly_production_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($monthly_production_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($monthly_production_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($monthly_production_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($monthly_production_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $monthly_production_list->showPageHeader(); ?>
<?php
$monthly_production_list->showMessage();
?>
<?php if ($monthly_production_list->TotalRecs > 0 || $monthly_production->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($monthly_production_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> monthly_production">
<?php if (!$monthly_production->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$monthly_production->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($monthly_production_list->Pager)) $monthly_production_list->Pager = new PrevNextPager($monthly_production_list->StartRec, $monthly_production_list->DisplayRecs, $monthly_production_list->TotalRecs, $monthly_production_list->AutoHidePager) ?>
<?php if ($monthly_production_list->Pager->RecordCount > 0 && $monthly_production_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($monthly_production_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($monthly_production_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $monthly_production_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($monthly_production_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($monthly_production_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $monthly_production_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($monthly_production_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $monthly_production_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $monthly_production_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $monthly_production_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($monthly_production_list->TotalRecs > 0 && (!$monthly_production_list->AutoHidePageSizeSelector || $monthly_production_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="monthly_production">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($monthly_production_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($monthly_production_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($monthly_production_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($monthly_production_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($monthly_production_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($monthly_production->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $monthly_production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmonthly_productionlist" id="fmonthly_productionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($monthly_production_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $monthly_production_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="monthly_production">
<div id="gmp_monthly_production" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($monthly_production_list->TotalRecs > 0 || $monthly_production->isGridEdit()) { ?>
<table id="tbl_monthly_productionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$monthly_production_list->RowType = ROWTYPE_HEADER;

// Render list options
$monthly_production_list->renderListOptions();

// Render list options (header, left)
$monthly_production_list->ListOptions->render("header", "left");
?>
<?php if ($monthly_production->month->Visible) { // month ?>
	<?php if ($monthly_production->sortUrl($monthly_production->month) == "") { ?>
		<th data-name="month" class="<?php echo $monthly_production->month->headerCellClass() ?>"><div id="elh_monthly_production_month" class="monthly_production_month"><div class="ew-table-header-caption"><?php echo $monthly_production->month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month" class="<?php echo $monthly_production->month->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production->SortUrl($monthly_production->month) ?>',2);"><div id="elh_monthly_production_month" class="monthly_production_month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production->month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production->month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production->location->Visible) { // location ?>
	<?php if ($monthly_production->sortUrl($monthly_production->location) == "") { ?>
		<th data-name="location" class="<?php echo $monthly_production->location->headerCellClass() ?>"><div id="elh_monthly_production_location" class="monthly_production_location"><div class="ew-table-header-caption"><?php echo $monthly_production->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $monthly_production->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production->SortUrl($monthly_production->location) ?>',2);"><div id="elh_monthly_production_location" class="monthly_production_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production->category->Visible) { // category ?>
	<?php if ($monthly_production->sortUrl($monthly_production->category) == "") { ?>
		<th data-name="category" class="<?php echo $monthly_production->category->headerCellClass() ?>"><div id="elh_monthly_production_category" class="monthly_production_category"><div class="ew-table-header-caption"><?php echo $monthly_production->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $monthly_production->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production->SortUrl($monthly_production->category) ?>',2);"><div id="elh_monthly_production_category" class="monthly_production_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production->process->Visible) { // process ?>
	<?php if ($monthly_production->sortUrl($monthly_production->process) == "") { ?>
		<th data-name="process" class="<?php echo $monthly_production->process->headerCellClass() ?>"><div id="elh_monthly_production_process" class="monthly_production_process"><div class="ew-table-header-caption"><?php echo $monthly_production->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $monthly_production->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production->SortUrl($monthly_production->process) ?>',2);"><div id="elh_monthly_production_process" class="monthly_production_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($monthly_production->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production->pcs->Visible) { // pcs ?>
	<?php if ($monthly_production->sortUrl($monthly_production->pcs) == "") { ?>
		<th data-name="pcs" class="<?php echo $monthly_production->pcs->headerCellClass() ?>"><div id="elh_monthly_production_pcs" class="monthly_production_pcs"><div class="ew-table-header-caption"><?php echo $monthly_production->pcs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pcs" class="<?php echo $monthly_production->pcs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production->SortUrl($monthly_production->pcs) ?>',2);"><div id="elh_monthly_production_pcs" class="monthly_production_pcs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production->pcs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($monthly_production->pcs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production->pcs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($monthly_production->sqm->Visible) { // sqm ?>
	<?php if ($monthly_production->sortUrl($monthly_production->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $monthly_production->sqm->headerCellClass() ?>"><div id="elh_monthly_production_sqm" class="monthly_production_sqm"><div class="ew-table-header-caption"><?php echo $monthly_production->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $monthly_production->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $monthly_production->SortUrl($monthly_production->sqm) ?>',2);"><div id="elh_monthly_production_sqm" class="monthly_production_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $monthly_production->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($monthly_production->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($monthly_production->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$monthly_production_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($monthly_production->ExportAll && $monthly_production->isExport()) {
	$monthly_production_list->StopRec = $monthly_production_list->TotalRecs;
} else {

	// Set the last record to display
	if ($monthly_production_list->TotalRecs > $monthly_production_list->StartRec + $monthly_production_list->DisplayRecs - 1)
		$monthly_production_list->StopRec = $monthly_production_list->StartRec + $monthly_production_list->DisplayRecs - 1;
	else
		$monthly_production_list->StopRec = $monthly_production_list->TotalRecs;
}
$monthly_production_list->RecCnt = $monthly_production_list->StartRec - 1;
if ($monthly_production_list->Recordset && !$monthly_production_list->Recordset->EOF) {
	$monthly_production_list->Recordset->moveFirst();
	$selectLimit = $monthly_production_list->UseSelectLimit;
	if (!$selectLimit && $monthly_production_list->StartRec > 1)
		$monthly_production_list->Recordset->move($monthly_production_list->StartRec - 1);
} elseif (!$monthly_production->AllowAddDeleteRow && $monthly_production_list->StopRec == 0) {
	$monthly_production_list->StopRec = $monthly_production->GridAddRowCount;
}

// Initialize aggregate
$monthly_production->RowType = ROWTYPE_AGGREGATEINIT;
$monthly_production->resetAttributes();
$monthly_production_list->renderRow();
while ($monthly_production_list->RecCnt < $monthly_production_list->StopRec) {
	$monthly_production_list->RecCnt++;
	if ($monthly_production_list->RecCnt >= $monthly_production_list->StartRec) {
		$monthly_production_list->RowCnt++;

		// Set up key count
		$monthly_production_list->KeyCount = $monthly_production_list->RowIndex;

		// Init row class and style
		$monthly_production->resetAttributes();
		$monthly_production->CssClass = "";
		if ($monthly_production->isGridAdd()) {
		} else {
			$monthly_production_list->loadRowValues($monthly_production_list->Recordset); // Load row values
		}
		$monthly_production->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$monthly_production->RowAttrs = array_merge($monthly_production->RowAttrs, array('data-rowindex'=>$monthly_production_list->RowCnt, 'id'=>'r' . $monthly_production_list->RowCnt . '_monthly_production', 'data-rowtype'=>$monthly_production->RowType));

		// Render row
		$monthly_production_list->renderRow();

		// Render list options
		$monthly_production_list->renderListOptions();
?>
	<tr<?php echo $monthly_production->rowAttributes() ?>>
<?php

// Render list options (body, left)
$monthly_production_list->ListOptions->render("body", "left", $monthly_production_list->RowCnt);
?>
	<?php if ($monthly_production->month->Visible) { // month ?>
		<td data-name="month"<?php echo $monthly_production->month->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_list->RowCnt ?>_monthly_production_month" class="monthly_production_month">
<span<?php echo $monthly_production->month->viewAttributes() ?>>
<?php echo $monthly_production->month->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production->location->Visible) { // location ?>
		<td data-name="location"<?php echo $monthly_production->location->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_list->RowCnt ?>_monthly_production_location" class="monthly_production_location">
<span<?php echo $monthly_production->location->viewAttributes() ?>>
<?php echo $monthly_production->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production->category->Visible) { // category ?>
		<td data-name="category"<?php echo $monthly_production->category->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_list->RowCnt ?>_monthly_production_category" class="monthly_production_category">
<span<?php echo $monthly_production->category->viewAttributes() ?>>
<?php echo $monthly_production->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production->process->Visible) { // process ?>
		<td data-name="process"<?php echo $monthly_production->process->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_list->RowCnt ?>_monthly_production_process" class="monthly_production_process">
<span<?php echo $monthly_production->process->viewAttributes() ?>>
<?php echo $monthly_production->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production->pcs->Visible) { // pcs ?>
		<td data-name="pcs"<?php echo $monthly_production->pcs->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_list->RowCnt ?>_monthly_production_pcs" class="monthly_production_pcs">
<span<?php echo $monthly_production->pcs->viewAttributes() ?>>
<?php echo $monthly_production->pcs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($monthly_production->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $monthly_production->sqm->cellAttributes() ?>>
<span id="el<?php echo $monthly_production_list->RowCnt ?>_monthly_production_sqm" class="monthly_production_sqm">
<span<?php echo $monthly_production->sqm->viewAttributes() ?>>
<?php echo $monthly_production->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$monthly_production_list->ListOptions->render("body", "right", $monthly_production_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$monthly_production->isGridAdd())
		$monthly_production_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$monthly_production->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($monthly_production_list->Recordset)
	$monthly_production_list->Recordset->Close();
?>
<?php if (!$monthly_production->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$monthly_production->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($monthly_production_list->Pager)) $monthly_production_list->Pager = new PrevNextPager($monthly_production_list->StartRec, $monthly_production_list->DisplayRecs, $monthly_production_list->TotalRecs, $monthly_production_list->AutoHidePager) ?>
<?php if ($monthly_production_list->Pager->RecordCount > 0 && $monthly_production_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($monthly_production_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($monthly_production_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $monthly_production_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($monthly_production_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($monthly_production_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $monthly_production_list->pageUrl() ?>start=<?php echo $monthly_production_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $monthly_production_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($monthly_production_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $monthly_production_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $monthly_production_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $monthly_production_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($monthly_production_list->TotalRecs > 0 && (!$monthly_production_list->AutoHidePageSizeSelector || $monthly_production_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="monthly_production">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($monthly_production_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($monthly_production_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($monthly_production_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($monthly_production_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($monthly_production_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($monthly_production->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $monthly_production_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($monthly_production_list->TotalRecs == 0 && !$monthly_production->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $monthly_production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$monthly_production_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$monthly_production->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$monthly_production->isExport()) { ?>
<script>
ew.scrollableTable("gmp_monthly_production", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$monthly_production_list->terminate();
?>