<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$monthly_production_search = new monthly_production_search();

// Run the page
$monthly_production_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$monthly_production_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($monthly_production_search->IsModal) { ?>
var fmonthly_productionsearch = currentAdvancedSearchForm = new ew.Form("fmonthly_productionsearch", "search");
<?php } else { ?>
var fmonthly_productionsearch = currentForm = new ew.Form("fmonthly_productionsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmonthly_productionsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmonthly_productionsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmonthly_productionsearch.lists["x_month"] = <?php echo $monthly_production_search->month->Lookup->toClientList() ?>;
fmonthly_productionsearch.lists["x_month"].options = <?php echo JsonEncode($monthly_production_search->month->lookupOptions()) ?>;
fmonthly_productionsearch.lists["x_location"] = <?php echo $monthly_production_search->location->Lookup->toClientList() ?>;
fmonthly_productionsearch.lists["x_location"].options = <?php echo JsonEncode($monthly_production_search->location->lookupOptions()) ?>;
fmonthly_productionsearch.lists["x_category"] = <?php echo $monthly_production_search->category->Lookup->toClientList() ?>;
fmonthly_productionsearch.lists["x_category"].options = <?php echo JsonEncode($monthly_production_search->category->lookupOptions()) ?>;
fmonthly_productionsearch.lists["x_process"] = <?php echo $monthly_production_search->process->Lookup->toClientList() ?>;
fmonthly_productionsearch.lists["x_process"].options = <?php echo JsonEncode($monthly_production_search->process->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmonthly_productionsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_pcs");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($monthly_production->pcs->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($monthly_production->sqm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $monthly_production_search->showPageHeader(); ?>
<?php
$monthly_production_search->showMessage();
?>
<form name="fmonthly_productionsearch" id="fmonthly_productionsearch" class="<?php echo $monthly_production_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($monthly_production_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $monthly_production_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="monthly_production">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$monthly_production_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($monthly_production->month->Visible) { // month ?>
	<div id="r_month" class="form-group row">
		<label for="x_month" class="<?php echo $monthly_production_search->LeftColumnClass ?>"><span id="elh_monthly_production_month"><?php echo $monthly_production->month->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_month" id="z_month" value="LIKE"></span>
		</label>
		<div class="<?php echo $monthly_production_search->RightColumnClass ?>"><div<?php echo $monthly_production->month->cellAttributes() ?>>
			<span id="el_monthly_production_month">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_month" data-value-separator="<?php echo $monthly_production->month->displayValueSeparatorAttribute() ?>" id="x_month" name="x_month"<?php echo $monthly_production->month->editAttributes() ?>>
		<?php echo $monthly_production->month->selectOptionListHtml("x_month") ?>
	</select>
</div>
<?php echo $monthly_production->month->Lookup->getParamTag("p_x_month") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($monthly_production->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $monthly_production_search->LeftColumnClass ?>"><span id="elh_monthly_production_location"><?php echo $monthly_production->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $monthly_production_search->RightColumnClass ?>"><div<?php echo $monthly_production->location->cellAttributes() ?>>
			<span id="el_monthly_production_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_location" data-value-separator="<?php echo $monthly_production->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $monthly_production->location->editAttributes() ?>>
		<?php echo $monthly_production->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $monthly_production->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($monthly_production->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $monthly_production_search->LeftColumnClass ?>"><span id="elh_monthly_production_category"><?php echo $monthly_production->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $monthly_production_search->RightColumnClass ?>"><div<?php echo $monthly_production->category->cellAttributes() ?>>
			<span id="el_monthly_production_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_category" data-value-separator="<?php echo $monthly_production->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $monthly_production->category->editAttributes() ?>>
		<?php echo $monthly_production->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $monthly_production->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($monthly_production->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $monthly_production_search->LeftColumnClass ?>"><span id="elh_monthly_production_process"><?php echo $monthly_production->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $monthly_production_search->RightColumnClass ?>"><div<?php echo $monthly_production->process->cellAttributes() ?>>
			<span id="el_monthly_production_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="monthly_production" data-field="x_process" data-value-separator="<?php echo $monthly_production->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $monthly_production->process->editAttributes() ?>>
		<?php echo $monthly_production->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $monthly_production->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($monthly_production->pcs->Visible) { // pcs ?>
	<div id="r_pcs" class="form-group row">
		<label for="x_pcs" class="<?php echo $monthly_production_search->LeftColumnClass ?>"><span id="elh_monthly_production_pcs"><?php echo $monthly_production->pcs->caption() ?></span>
		</label>
		<div class="<?php echo $monthly_production_search->RightColumnClass ?>"><div<?php echo $monthly_production->pcs->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pcs" id="z_pcs" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($monthly_production->pcs->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_monthly_production_pcs">
<input type="text" data-table="monthly_production" data-field="x_pcs" name="x_pcs" id="x_pcs" size="30" placeholder="<?php echo HtmlEncode($monthly_production->pcs->getPlaceHolder()) ?>" value="<?php echo $monthly_production->pcs->EditValue ?>"<?php echo $monthly_production->pcs->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pcs d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_monthly_production_pcs" class="btw1_pcs d-none">
<input type="text" data-table="monthly_production" data-field="x_pcs" name="y_pcs" id="y_pcs" size="30" placeholder="<?php echo HtmlEncode($monthly_production->pcs->getPlaceHolder()) ?>" value="<?php echo $monthly_production->pcs->EditValue2 ?>"<?php echo $monthly_production->pcs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($monthly_production->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $monthly_production_search->LeftColumnClass ?>"><span id="elh_monthly_production_sqm"><?php echo $monthly_production->sqm->caption() ?></span>
		</label>
		<div class="<?php echo $monthly_production_search->RightColumnClass ?>"><div<?php echo $monthly_production->sqm->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_sqm" id="z_sqm" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($monthly_production->sqm->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_monthly_production_sqm">
<input type="text" data-table="monthly_production" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($monthly_production->sqm->getPlaceHolder()) ?>" value="<?php echo $monthly_production->sqm->EditValue ?>"<?php echo $monthly_production->sqm->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_sqm d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_monthly_production_sqm" class="btw1_sqm d-none">
<input type="text" data-table="monthly_production" data-field="x_sqm" name="y_sqm" id="y_sqm" size="30" placeholder="<?php echo HtmlEncode($monthly_production->sqm->getPlaceHolder()) ?>" value="<?php echo $monthly_production->sqm->EditValue2 ?>"<?php echo $monthly_production->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$monthly_production_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $monthly_production_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$monthly_production_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$monthly_production_search->terminate();
?>