<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$multiple_price_list = new multiple_price_list();

// Run the page
$multiple_price_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$multiple_price_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$multiple_price->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmultiple_pricelist = currentForm = new ew.Form("fmultiple_pricelist", "list");
fmultiple_pricelist.formKeyCountName = '<?php echo $multiple_price_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmultiple_pricelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmultiple_pricelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmultiple_pricelist.lists["x_company_id"] = <?php echo $multiple_price_list->company_id->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_company_id"].options = <?php echo JsonEncode($multiple_price_list->company_id->lookupOptions()) ?>;
fmultiple_pricelist.lists["x_buyer"] = <?php echo $multiple_price_list->buyer->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_buyer"].options = <?php echo JsonEncode($multiple_price_list->buyer->options(FALSE, TRUE)) ?>;
fmultiple_pricelist.lists["x_grp"] = <?php echo $multiple_price_list->grp->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_grp"].options = <?php echo JsonEncode($multiple_price_list->grp->lookupOptions()) ?>;
fmultiple_pricelist.lists["x_product"] = <?php echo $multiple_price_list->product->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_product"].options = <?php echo JsonEncode($multiple_price_list->product->lookupOptions()) ?>;
fmultiple_pricelist.lists["x_code"] = <?php echo $multiple_price_list->code->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_code"].options = <?php echo JsonEncode($multiple_price_list->code->lookupOptions()) ?>;
fmultiple_pricelist.lists["x_packing_type"] = <?php echo $multiple_price_list->packing_type->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_packing_type"].options = <?php echo JsonEncode($multiple_price_list->packing_type->lookupOptions()) ?>;
fmultiple_pricelist.lists["x_level"] = <?php echo $multiple_price_list->level->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_level"].options = <?php echo JsonEncode($multiple_price_list->level->options(FALSE, TRUE)) ?>;
fmultiple_pricelist.lists["x_currency"] = <?php echo $multiple_price_list->currency->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_currency"].options = <?php echo JsonEncode($multiple_price_list->currency->lookupOptions()) ?>;
fmultiple_pricelist.lists["x_operator"] = <?php echo $multiple_price_list->operator->Lookup->toClientList() ?>;
fmultiple_pricelist.lists["x_operator"].options = <?php echo JsonEncode($multiple_price_list->operator->lookupOptions()) ?>;
fmultiple_pricelist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fmultiple_pricelistsrch = currentSearchForm = new ew.Form("fmultiple_pricelistsrch");

// Validate function for search
fmultiple_pricelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmultiple_pricelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmultiple_pricelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmultiple_pricelistsrch.lists["x_company_id"] = <?php echo $multiple_price_list->company_id->Lookup->toClientList() ?>;
fmultiple_pricelistsrch.lists["x_company_id"].options = <?php echo JsonEncode($multiple_price_list->company_id->lookupOptions()) ?>;
fmultiple_pricelistsrch.lists["x_grp"] = <?php echo $multiple_price_list->grp->Lookup->toClientList() ?>;
fmultiple_pricelistsrch.lists["x_grp"].options = <?php echo JsonEncode($multiple_price_list->grp->lookupOptions()) ?>;
fmultiple_pricelistsrch.lists["x_product"] = <?php echo $multiple_price_list->product->Lookup->toClientList() ?>;
fmultiple_pricelistsrch.lists["x_product"].options = <?php echo JsonEncode($multiple_price_list->product->lookupOptions()) ?>;
fmultiple_pricelistsrch.lists["x_code"] = <?php echo $multiple_price_list->code->Lookup->toClientList() ?>;
fmultiple_pricelistsrch.lists["x_code"].options = <?php echo JsonEncode($multiple_price_list->code->lookupOptions()) ?>;

// Filters
fmultiple_pricelistsrch.filterList = <?php echo $multiple_price_list->getFilterList() ?>;

// Init search panel as collapsed
fmultiple_pricelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #DC143C; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = true;
ew.PREVIEW_OVERLAY = true;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$multiple_price->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($multiple_price_list->TotalRecs > 0 && $multiple_price_list->ExportOptions->visible()) { ?>
<?php $multiple_price_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($multiple_price_list->ImportOptions->visible()) { ?>
<?php $multiple_price_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($multiple_price_list->SearchOptions->visible()) { ?>
<?php $multiple_price_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($multiple_price_list->FilterOptions->visible()) { ?>
<?php $multiple_price_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$multiple_price->isExport() || EXPORT_MASTER_RECORD && $multiple_price->isExport("print")) { ?>
<?php
if ($multiple_price_list->DbMasterFilter <> "" && $multiple_price->getCurrentMasterTable() == "ref") {
	if ($multiple_price_list->MasterRecordExists) {
		include_once "refmaster.php";
	}
}
?>
<?php } ?>
<?php
$multiple_price_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$multiple_price->isExport() && !$multiple_price->CurrentAction) { ?>
<form name="fmultiple_pricelistsrch" id="fmultiple_pricelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($multiple_price_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmultiple_pricelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="multiple_price">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$multiple_price_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$multiple_price->RowType = ROWTYPE_SEARCH;

// Render row
$multiple_price->resetAttributes();
$multiple_price_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($multiple_price->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label for="x_company_id" class="ew-search-caption ew-label"><?php echo $multiple_price->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_company_id" data-value-separator="<?php echo $multiple_price->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $multiple_price->company_id->editAttributes() ?>>
		<?php echo $multiple_price->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $multiple_price->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($multiple_price->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $multiple_price->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $multiple_price->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$multiple_price->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_grp" data-value-separator="<?php echo $multiple_price->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $multiple_price->grp->editAttributes() ?>>
		<?php echo $multiple_price->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $multiple_price->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($multiple_price->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $multiple_price->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php $multiple_price->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$multiple_price->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_product" data-value-separator="<?php echo $multiple_price->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $multiple_price->product->editAttributes() ?>>
		<?php echo $multiple_price->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $multiple_price->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($multiple_price->code->Visible) { // code ?>
	<div id="xsc_code" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $multiple_price->code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_code" class="ew-template"><input type="radio" class="form-check-input" data-table="multiple_price" data-field="x_code" data-value-separator="<?php echo $multiple_price->code->displayValueSeparatorAttribute() ?>" name="x_code" id="x_code" value="{value}"<?php echo $multiple_price->code->editAttributes() ?>></div>
<div id="dsl_x_code" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $multiple_price->code->radioButtonListHtml(FALSE, "x_code") ?>
</div></div>
<?php echo $multiple_price->code->Lookup->getParamTag("p_x_code") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($multiple_price_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($multiple_price_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $multiple_price_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($multiple_price_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($multiple_price_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($multiple_price_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($multiple_price_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $multiple_price_list->showPageHeader(); ?>
<?php
$multiple_price_list->showMessage();
?>
<?php if ($multiple_price_list->TotalRecs > 0 || $multiple_price->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($multiple_price_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> multiple_price">
<?php if (!$multiple_price->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$multiple_price->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($multiple_price_list->Pager)) $multiple_price_list->Pager = new PrevNextPager($multiple_price_list->StartRec, $multiple_price_list->DisplayRecs, $multiple_price_list->TotalRecs, $multiple_price_list->AutoHidePager) ?>
<?php if ($multiple_price_list->Pager->RecordCount > 0 && $multiple_price_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($multiple_price_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($multiple_price_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $multiple_price_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($multiple_price_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($multiple_price_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $multiple_price_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($multiple_price_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $multiple_price_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $multiple_price_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $multiple_price_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($multiple_price_list->TotalRecs > 0 && (!$multiple_price_list->AutoHidePageSizeSelector || $multiple_price_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="multiple_price">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($multiple_price_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($multiple_price_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($multiple_price_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($multiple_price_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($multiple_price_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($multiple_price->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $multiple_price_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmultiple_pricelist" id="fmultiple_pricelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($multiple_price_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $multiple_price_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="multiple_price">
<?php if ($multiple_price->getCurrentMasterTable() == "ref" && $multiple_price->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="ref">
<input type="hidden" name="fk_id" value="<?php echo $multiple_price->code->getSessionValue() ?>">
<?php } ?>
<div id="gmp_multiple_price" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($multiple_price_list->TotalRecs > 0 || $multiple_price->isGridEdit()) { ?>
<table id="tbl_multiple_pricelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$multiple_price_list->RowType = ROWTYPE_HEADER;

// Render list options
$multiple_price_list->renderListOptions();

// Render list options (header, left)
$multiple_price_list->ListOptions->render("header", "left");
?>
<?php if ($multiple_price->id->Visible) { // id ?>
	<?php if ($multiple_price->sortUrl($multiple_price->id) == "") { ?>
		<th data-name="id" class="<?php echo $multiple_price->id->headerCellClass() ?>"><div id="elh_multiple_price_id" class="multiple_price_id"><div class="ew-table-header-caption"><?php echo $multiple_price->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $multiple_price->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->id) ?>',2);"><div id="elh_multiple_price_id" class="multiple_price_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->company_id->Visible) { // company_id ?>
	<?php if ($multiple_price->sortUrl($multiple_price->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $multiple_price->company_id->headerCellClass() ?>"><div id="elh_multiple_price_company_id" class="multiple_price_company_id"><div class="ew-table-header-caption"><?php echo $multiple_price->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $multiple_price->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->company_id) ?>',2);"><div id="elh_multiple_price_company_id" class="multiple_price_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->buyer->Visible) { // buyer ?>
	<?php if ($multiple_price->sortUrl($multiple_price->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $multiple_price->buyer->headerCellClass() ?>"><div id="elh_multiple_price_buyer" class="multiple_price_buyer"><div class="ew-table-header-caption"><?php echo $multiple_price->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $multiple_price->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->buyer) ?>',2);"><div id="elh_multiple_price_buyer" class="multiple_price_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->buyer->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->buyer_id->Visible) { // buyer_id ?>
	<?php if ($multiple_price->sortUrl($multiple_price->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $multiple_price->buyer_id->headerCellClass() ?>"><div id="elh_multiple_price_buyer_id" class="multiple_price_buyer_id"><div class="ew-table-header-caption"><?php echo $multiple_price->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $multiple_price->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->buyer_id) ?>',2);"><div id="elh_multiple_price_buyer_id" class="multiple_price_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->buyer_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->grp->Visible) { // grp ?>
	<?php if ($multiple_price->sortUrl($multiple_price->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $multiple_price->grp->headerCellClass() ?>"><div id="elh_multiple_price_grp" class="multiple_price_grp"><div class="ew-table-header-caption"><?php echo $multiple_price->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $multiple_price->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->grp) ?>',2);"><div id="elh_multiple_price_grp" class="multiple_price_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->product->Visible) { // product ?>
	<?php if ($multiple_price->sortUrl($multiple_price->product) == "") { ?>
		<th data-name="product" class="<?php echo $multiple_price->product->headerCellClass() ?>"><div id="elh_multiple_price_product" class="multiple_price_product"><div class="ew-table-header-caption"><?php echo $multiple_price->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $multiple_price->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->product) ?>',2);"><div id="elh_multiple_price_product" class="multiple_price_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->code->Visible) { // code ?>
	<?php if ($multiple_price->sortUrl($multiple_price->code) == "") { ?>
		<th data-name="code" class="<?php echo $multiple_price->code->headerCellClass() ?>"><div id="elh_multiple_price_code" class="multiple_price_code"><div class="ew-table-header-caption"><?php echo $multiple_price->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $multiple_price->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->code) ?>',2);"><div id="elh_multiple_price_code" class="multiple_price_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->packing_type->Visible) { // packing_type ?>
	<?php if ($multiple_price->sortUrl($multiple_price->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $multiple_price->packing_type->headerCellClass() ?>"><div id="elh_multiple_price_packing_type" class="multiple_price_packing_type"><div class="ew-table-header-caption"><?php echo $multiple_price->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $multiple_price->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->packing_type) ?>',2);"><div id="elh_multiple_price_packing_type" class="multiple_price_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->level->Visible) { // level ?>
	<?php if ($multiple_price->sortUrl($multiple_price->level) == "") { ?>
		<th data-name="level" class="<?php echo $multiple_price->level->headerCellClass() ?>"><div id="elh_multiple_price_level" class="multiple_price_level"><div class="ew-table-header-caption"><?php echo $multiple_price->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $multiple_price->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->level) ?>',2);"><div id="elh_multiple_price_level" class="multiple_price_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->min_qty->Visible) { // min_qty ?>
	<?php if ($multiple_price->sortUrl($multiple_price->min_qty) == "") { ?>
		<th data-name="min_qty" class="<?php echo $multiple_price->min_qty->headerCellClass() ?>"><div id="elh_multiple_price_min_qty" class="multiple_price_min_qty"><div class="ew-table-header-caption"><?php echo $multiple_price->min_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="min_qty" class="<?php echo $multiple_price->min_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->min_qty) ?>',2);"><div id="elh_multiple_price_min_qty" class="multiple_price_min_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->min_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->min_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->min_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->max_qty->Visible) { // max_qty ?>
	<?php if ($multiple_price->sortUrl($multiple_price->max_qty) == "") { ?>
		<th data-name="max_qty" class="<?php echo $multiple_price->max_qty->headerCellClass() ?>"><div id="elh_multiple_price_max_qty" class="multiple_price_max_qty"><div class="ew-table-header-caption"><?php echo $multiple_price->max_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_qty" class="<?php echo $multiple_price->max_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->max_qty) ?>',2);"><div id="elh_multiple_price_max_qty" class="multiple_price_max_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->max_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->max_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->max_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->increment->Visible) { // increment ?>
	<?php if ($multiple_price->sortUrl($multiple_price->increment) == "") { ?>
		<th data-name="increment" class="<?php echo $multiple_price->increment->headerCellClass() ?>"><div id="elh_multiple_price_increment" class="multiple_price_increment"><div class="ew-table-header-caption"><?php echo $multiple_price->increment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="increment" class="<?php echo $multiple_price->increment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->increment) ?>',2);"><div id="elh_multiple_price_increment" class="multiple_price_increment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->increment->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->increment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->increment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->price_min_qty->Visible) { // price_min_qty ?>
	<?php if ($multiple_price->sortUrl($multiple_price->price_min_qty) == "") { ?>
		<th data-name="price_min_qty" class="<?php echo $multiple_price->price_min_qty->headerCellClass() ?>"><div id="elh_multiple_price_price_min_qty" class="multiple_price_price_min_qty"><div class="ew-table-header-caption"><?php echo $multiple_price->price_min_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_min_qty" class="<?php echo $multiple_price->price_min_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->price_min_qty) ?>',2);"><div id="elh_multiple_price_price_min_qty" class="multiple_price_price_min_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->price_min_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->price_min_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->price_min_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->currency->Visible) { // currency ?>
	<?php if ($multiple_price->sortUrl($multiple_price->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $multiple_price->currency->headerCellClass() ?>"><div id="elh_multiple_price_currency" class="multiple_price_currency"><div class="ew-table-header-caption"><?php echo $multiple_price->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $multiple_price->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->currency) ?>',2);"><div id="elh_multiple_price_currency" class="multiple_price_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->operator->Visible) { // operator ?>
	<?php if ($multiple_price->sortUrl($multiple_price->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $multiple_price->operator->headerCellClass() ?>"><div id="elh_multiple_price_operator" class="multiple_price_operator"><div class="ew-table-header-caption"><?php echo $multiple_price->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $multiple_price->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->operator) ?>',2);"><div id="elh_multiple_price_operator" class="multiple_price_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($multiple_price->datetime->Visible) { // datetime ?>
	<?php if ($multiple_price->sortUrl($multiple_price->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $multiple_price->datetime->headerCellClass() ?>"><div id="elh_multiple_price_datetime" class="multiple_price_datetime"><div class="ew-table-header-caption"><?php echo $multiple_price->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $multiple_price->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $multiple_price->SortUrl($multiple_price->datetime) ?>',2);"><div id="elh_multiple_price_datetime" class="multiple_price_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $multiple_price->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($multiple_price->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($multiple_price->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$multiple_price_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($multiple_price->ExportAll && $multiple_price->isExport()) {
	$multiple_price_list->StopRec = $multiple_price_list->TotalRecs;
} else {

	// Set the last record to display
	if ($multiple_price_list->TotalRecs > $multiple_price_list->StartRec + $multiple_price_list->DisplayRecs - 1)
		$multiple_price_list->StopRec = $multiple_price_list->StartRec + $multiple_price_list->DisplayRecs - 1;
	else
		$multiple_price_list->StopRec = $multiple_price_list->TotalRecs;
}
$multiple_price_list->RecCnt = $multiple_price_list->StartRec - 1;
if ($multiple_price_list->Recordset && !$multiple_price_list->Recordset->EOF) {
	$multiple_price_list->Recordset->moveFirst();
	$selectLimit = $multiple_price_list->UseSelectLimit;
	if (!$selectLimit && $multiple_price_list->StartRec > 1)
		$multiple_price_list->Recordset->move($multiple_price_list->StartRec - 1);
} elseif (!$multiple_price->AllowAddDeleteRow && $multiple_price_list->StopRec == 0) {
	$multiple_price_list->StopRec = $multiple_price->GridAddRowCount;
}

// Initialize aggregate
$multiple_price->RowType = ROWTYPE_AGGREGATEINIT;
$multiple_price->resetAttributes();
$multiple_price_list->renderRow();
while ($multiple_price_list->RecCnt < $multiple_price_list->StopRec) {
	$multiple_price_list->RecCnt++;
	if ($multiple_price_list->RecCnt >= $multiple_price_list->StartRec) {
		$multiple_price_list->RowCnt++;

		// Set up key count
		$multiple_price_list->KeyCount = $multiple_price_list->RowIndex;

		// Init row class and style
		$multiple_price->resetAttributes();
		$multiple_price->CssClass = "";
		if ($multiple_price->isGridAdd()) {
		} else {
			$multiple_price_list->loadRowValues($multiple_price_list->Recordset); // Load row values
		}
		$multiple_price->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$multiple_price->RowAttrs = array_merge($multiple_price->RowAttrs, array('data-rowindex'=>$multiple_price_list->RowCnt, 'id'=>'r' . $multiple_price_list->RowCnt . '_multiple_price', 'data-rowtype'=>$multiple_price->RowType));

		// Render row
		$multiple_price_list->renderRow();

		// Render list options
		$multiple_price_list->renderListOptions();
?>
	<tr<?php echo $multiple_price->rowAttributes() ?>>
<?php

// Render list options (body, left)
$multiple_price_list->ListOptions->render("body", "left", $multiple_price_list->RowCnt);
?>
	<?php if ($multiple_price->id->Visible) { // id ?>
		<td data-name="id"<?php echo $multiple_price->id->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_id" class="multiple_price_id">
<span<?php echo $multiple_price->id->viewAttributes() ?>>
<?php echo $multiple_price->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $multiple_price->company_id->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_company_id" class="multiple_price_company_id">
<span<?php echo $multiple_price->company_id->viewAttributes() ?>>
<?php echo $multiple_price->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $multiple_price->buyer->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_buyer" class="multiple_price_buyer">
<span<?php echo $multiple_price->buyer->viewAttributes() ?>>
<?php echo $multiple_price->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $multiple_price->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_buyer_id" class="multiple_price_buyer_id">
<span<?php echo $multiple_price->buyer_id->viewAttributes() ?>>
<?php echo $multiple_price->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $multiple_price->grp->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_grp" class="multiple_price_grp">
<span<?php echo $multiple_price->grp->viewAttributes() ?>>
<?php if ((!EmptyString($multiple_price->grp->getViewValue())) && $multiple_price->grp->linkAttributes() <> "") { ?>
<a<?php echo $multiple_price->grp->linkAttributes() ?>><?php echo $multiple_price->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $multiple_price->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->product->Visible) { // product ?>
		<td data-name="product"<?php echo $multiple_price->product->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_product" class="multiple_price_product">
<span<?php echo $multiple_price->product->viewAttributes() ?>>
<?php if ((!EmptyString($multiple_price->product->getViewValue())) && $multiple_price->product->linkAttributes() <> "") { ?>
<a<?php echo $multiple_price->product->linkAttributes() ?>><?php echo $multiple_price->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $multiple_price->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->code->Visible) { // code ?>
		<td data-name="code"<?php echo $multiple_price->code->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_code" class="multiple_price_code">
<span<?php echo $multiple_price->code->viewAttributes() ?>>
<?php if ((!EmptyString($multiple_price->code->getViewValue())) && $multiple_price->code->linkAttributes() <> "") { ?>
<a<?php echo $multiple_price->code->linkAttributes() ?>><?php echo $multiple_price->code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $multiple_price->code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $multiple_price->packing_type->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_packing_type" class="multiple_price_packing_type">
<span<?php echo $multiple_price->packing_type->viewAttributes() ?>>
<?php echo $multiple_price->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->level->Visible) { // level ?>
		<td data-name="level"<?php echo $multiple_price->level->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_level" class="multiple_price_level">
<span<?php echo $multiple_price->level->viewAttributes() ?>>
<?php if ((!EmptyString($multiple_price->level->getViewValue())) && $multiple_price->level->linkAttributes() <> "") { ?>
<a<?php echo $multiple_price->level->linkAttributes() ?>><?php echo $multiple_price->level->getViewValue() ?></a>
<?php } else { ?>
<?php echo $multiple_price->level->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->min_qty->Visible) { // min_qty ?>
		<td data-name="min_qty"<?php echo $multiple_price->min_qty->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_min_qty" class="multiple_price_min_qty">
<span<?php echo $multiple_price->min_qty->viewAttributes() ?>>
<?php echo $multiple_price->min_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->max_qty->Visible) { // max_qty ?>
		<td data-name="max_qty"<?php echo $multiple_price->max_qty->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_max_qty" class="multiple_price_max_qty">
<span<?php echo $multiple_price->max_qty->viewAttributes() ?>>
<?php echo $multiple_price->max_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->increment->Visible) { // increment ?>
		<td data-name="increment"<?php echo $multiple_price->increment->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_increment" class="multiple_price_increment">
<span<?php echo $multiple_price->increment->viewAttributes() ?>>
<?php echo $multiple_price->increment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->price_min_qty->Visible) { // price_min_qty ?>
		<td data-name="price_min_qty"<?php echo $multiple_price->price_min_qty->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_price_min_qty" class="multiple_price_price_min_qty">
<span<?php echo $multiple_price->price_min_qty->viewAttributes() ?>>
<?php echo $multiple_price->price_min_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $multiple_price->currency->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_currency" class="multiple_price_currency">
<span<?php echo $multiple_price->currency->viewAttributes() ?>>
<?php echo $multiple_price->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $multiple_price->operator->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_operator" class="multiple_price_operator">
<span<?php echo $multiple_price->operator->viewAttributes() ?>>
<?php if ((!EmptyString($multiple_price->operator->getViewValue())) && $multiple_price->operator->linkAttributes() <> "") { ?>
<a<?php echo $multiple_price->operator->linkAttributes() ?>><?php echo $multiple_price->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $multiple_price->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($multiple_price->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $multiple_price->datetime->cellAttributes() ?>>
<span id="el<?php echo $multiple_price_list->RowCnt ?>_multiple_price_datetime" class="multiple_price_datetime">
<span<?php echo $multiple_price->datetime->viewAttributes() ?>>
<?php echo $multiple_price->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$multiple_price_list->ListOptions->render("body", "right", $multiple_price_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$multiple_price->isGridAdd())
		$multiple_price_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$multiple_price->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($multiple_price_list->Recordset)
	$multiple_price_list->Recordset->Close();
?>
<?php if (!$multiple_price->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$multiple_price->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($multiple_price_list->Pager)) $multiple_price_list->Pager = new PrevNextPager($multiple_price_list->StartRec, $multiple_price_list->DisplayRecs, $multiple_price_list->TotalRecs, $multiple_price_list->AutoHidePager) ?>
<?php if ($multiple_price_list->Pager->RecordCount > 0 && $multiple_price_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($multiple_price_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($multiple_price_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $multiple_price_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($multiple_price_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($multiple_price_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $multiple_price_list->pageUrl() ?>start=<?php echo $multiple_price_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $multiple_price_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($multiple_price_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $multiple_price_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $multiple_price_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $multiple_price_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($multiple_price_list->TotalRecs > 0 && (!$multiple_price_list->AutoHidePageSizeSelector || $multiple_price_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="multiple_price">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($multiple_price_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($multiple_price_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($multiple_price_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($multiple_price_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($multiple_price_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($multiple_price->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $multiple_price_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($multiple_price_list->TotalRecs == 0 && !$multiple_price->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $multiple_price_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$multiple_price_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$multiple_price->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$multiple_price->isExport()) { ?>
<script>
ew.scrollableTable("gmp_multiple_price", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$multiple_price_list->terminate();
?>