<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$multiple_price_search = new multiple_price_search();

// Run the page
$multiple_price_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$multiple_price_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($multiple_price_search->IsModal) { ?>
var fmultiple_pricesearch = currentAdvancedSearchForm = new ew.Form("fmultiple_pricesearch", "search");
<?php } else { ?>
var fmultiple_pricesearch = currentForm = new ew.Form("fmultiple_pricesearch", "search");
<?php } ?>

// Form_CustomValidate event
fmultiple_pricesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmultiple_pricesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmultiple_pricesearch.lists["x_company_id"] = <?php echo $multiple_price_search->company_id->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_company_id"].options = <?php echo JsonEncode($multiple_price_search->company_id->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_buyer"] = <?php echo $multiple_price_search->buyer->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_buyer"].options = <?php echo JsonEncode($multiple_price_search->buyer->options(FALSE, TRUE)) ?>;
fmultiple_pricesearch.lists["x_buyer_1[]"] = <?php echo $multiple_price_search->buyer_1->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_buyer_1[]"].options = <?php echo JsonEncode($multiple_price_search->buyer_1->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_grp"] = <?php echo $multiple_price_search->grp->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_grp"].options = <?php echo JsonEncode($multiple_price_search->grp->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_product"] = <?php echo $multiple_price_search->product->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_product"].options = <?php echo JsonEncode($multiple_price_search->product->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_code"] = <?php echo $multiple_price_search->code->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_code"].options = <?php echo JsonEncode($multiple_price_search->code->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_packing_type"] = <?php echo $multiple_price_search->packing_type->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_packing_type"].options = <?php echo JsonEncode($multiple_price_search->packing_type->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_level"] = <?php echo $multiple_price_search->level->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_level"].options = <?php echo JsonEncode($multiple_price_search->level->options(FALSE, TRUE)) ?>;
fmultiple_pricesearch.lists["x_currency"] = <?php echo $multiple_price_search->currency->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_currency"].options = <?php echo JsonEncode($multiple_price_search->currency->lookupOptions()) ?>;
fmultiple_pricesearch.lists["x_operator"] = <?php echo $multiple_price_search->operator->Lookup->toClientList() ?>;
fmultiple_pricesearch.lists["x_operator"].options = <?php echo JsonEncode($multiple_price_search->operator->lookupOptions()) ?>;
fmultiple_pricesearch.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fmultiple_pricesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_min_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->min_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_max_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->max_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_increment");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->increment->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_min_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->price_min_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($multiple_price->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $multiple_price_search->showPageHeader(); ?>
<?php
$multiple_price_search->showMessage();
?>
<form name="fmultiple_pricesearch" id="fmultiple_pricesearch" class="<?php echo $multiple_price_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($multiple_price_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $multiple_price_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="multiple_price">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$multiple_price_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($multiple_price->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_id"><?php echo $multiple_price->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->id->cellAttributes() ?>>
			<span id="el_multiple_price_id">
<input type="text" data-table="multiple_price" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($multiple_price->id->getPlaceHolder()) ?>" value="<?php echo $multiple_price->id->EditValue ?>"<?php echo $multiple_price->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_company_id"><?php echo $multiple_price->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->company_id->cellAttributes() ?>>
			<span id="el_multiple_price_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_company_id" data-value-separator="<?php echo $multiple_price->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $multiple_price->company_id->editAttributes() ?>>
		<?php echo $multiple_price->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $multiple_price->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_buyer"><?php echo $multiple_price->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->buyer->cellAttributes() ?>>
			<span id="el_multiple_price_buyer">
<div id="tp_x_buyer" class="ew-template"><input type="radio" class="form-check-input" data-table="multiple_price" data-field="x_buyer" data-value-separator="<?php echo $multiple_price->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="{value}"<?php echo $multiple_price->buyer->editAttributes() ?>></div>
<div id="dsl_x_buyer" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $multiple_price->buyer->radioButtonListHtml(FALSE, "x_buyer") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->buyer_1->Visible) { // buyer_1 ?>
	<div id="r_buyer_1" class="form-group row">
		<label class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_buyer_1"><?php echo $multiple_price->buyer_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_1" id="z_buyer_1" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->buyer_1->cellAttributes() ?>>
			<span id="el_multiple_price_buyer_1">
<div id="tp_x_buyer_1" class="ew-template"><input type="checkbox" class="form-check-input" data-table="multiple_price" data-field="x_buyer_1" data-value-separator="<?php echo $multiple_price->buyer_1->displayValueSeparatorAttribute() ?>" name="x_buyer_1[]" id="x_buyer_1[]" value="{value}"<?php echo $multiple_price->buyer_1->editAttributes() ?>></div>
<div id="dsl_x_buyer_1" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $multiple_price->buyer_1->checkBoxListHtml(FALSE, "x_buyer_1[]") ?>
</div></div>
<?php echo $multiple_price->buyer_1->Lookup->getParamTag("p_x_buyer_1") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_buyer_id"><?php echo $multiple_price->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->buyer_id->cellAttributes() ?>>
			<span id="el_multiple_price_buyer_id">
<input type="text" data-table="multiple_price" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" placeholder="<?php echo HtmlEncode($multiple_price->buyer_id->getPlaceHolder()) ?>" value="<?php echo $multiple_price->buyer_id->EditValue ?>"<?php echo $multiple_price->buyer_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_grp"><?php echo $multiple_price->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->grp->cellAttributes() ?>>
			<span id="el_multiple_price_grp">
<?php $multiple_price->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$multiple_price->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_grp" data-value-separator="<?php echo $multiple_price->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $multiple_price->grp->editAttributes() ?>>
		<?php echo $multiple_price->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $multiple_price->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_product"><?php echo $multiple_price->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->product->cellAttributes() ?>>
			<span id="el_multiple_price_product">
<?php $multiple_price->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$multiple_price->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_product" data-value-separator="<?php echo $multiple_price->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $multiple_price->product->editAttributes() ?>>
		<?php echo $multiple_price->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $multiple_price->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_code"><?php echo $multiple_price->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_code" id="z_code" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->code->cellAttributes() ?>>
			<span id="el_multiple_price_code">
<div id="tp_x_code" class="ew-template"><input type="radio" class="form-check-input" data-table="multiple_price" data-field="x_code" data-value-separator="<?php echo $multiple_price->code->displayValueSeparatorAttribute() ?>" name="x_code" id="x_code" value="{value}"<?php echo $multiple_price->code->editAttributes() ?>></div>
<div id="dsl_x_code" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $multiple_price->code->radioButtonListHtml(FALSE, "x_code") ?>
</div></div>
<?php echo $multiple_price->code->Lookup->getParamTag("p_x_code") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_packing_type"><?php echo $multiple_price->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->packing_type->cellAttributes() ?>>
			<span id="el_multiple_price_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_packing_type" data-value-separator="<?php echo $multiple_price->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $multiple_price->packing_type->editAttributes() ?>>
		<?php echo $multiple_price->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $multiple_price->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label for="x_level" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_level"><?php echo $multiple_price->level->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_level" id="z_level" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->level->cellAttributes() ?>>
			<span id="el_multiple_price_level">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_level" data-value-separator="<?php echo $multiple_price->level->displayValueSeparatorAttribute() ?>" id="x_level" name="x_level"<?php echo $multiple_price->level->editAttributes() ?>>
		<?php echo $multiple_price->level->selectOptionListHtml("x_level") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->min_qty->Visible) { // min_qty ?>
	<div id="r_min_qty" class="form-group row">
		<label for="x_min_qty" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_min_qty"><?php echo $multiple_price->min_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_min_qty" id="z_min_qty" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->min_qty->cellAttributes() ?>>
			<span id="el_multiple_price_min_qty">
<input type="text" data-table="multiple_price" data-field="x_min_qty" name="x_min_qty" id="x_min_qty" size="30" placeholder="<?php echo HtmlEncode($multiple_price->min_qty->getPlaceHolder()) ?>" value="<?php echo $multiple_price->min_qty->EditValue ?>"<?php echo $multiple_price->min_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label for="x_max_qty" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_max_qty"><?php echo $multiple_price->max_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_max_qty" id="z_max_qty" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->max_qty->cellAttributes() ?>>
			<span id="el_multiple_price_max_qty">
<input type="text" data-table="multiple_price" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($multiple_price->max_qty->getPlaceHolder()) ?>" value="<?php echo $multiple_price->max_qty->EditValue ?>"<?php echo $multiple_price->max_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->increment->Visible) { // increment ?>
	<div id="r_increment" class="form-group row">
		<label for="x_increment" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_increment"><?php echo $multiple_price->increment->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_increment" id="z_increment" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->increment->cellAttributes() ?>>
			<span id="el_multiple_price_increment">
<input type="text" data-table="multiple_price" data-field="x_increment" name="x_increment" id="x_increment" size="30" placeholder="<?php echo HtmlEncode($multiple_price->increment->getPlaceHolder()) ?>" value="<?php echo $multiple_price->increment->EditValue ?>"<?php echo $multiple_price->increment->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->price_min_qty->Visible) { // price_min_qty ?>
	<div id="r_price_min_qty" class="form-group row">
		<label for="x_price_min_qty" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_price_min_qty"><?php echo $multiple_price->price_min_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_min_qty" id="z_price_min_qty" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->price_min_qty->cellAttributes() ?>>
			<span id="el_multiple_price_price_min_qty">
<input type="text" data-table="multiple_price" data-field="x_price_min_qty" name="x_price_min_qty" id="x_price_min_qty" size="30" placeholder="<?php echo HtmlEncode($multiple_price->price_min_qty->getPlaceHolder()) ?>" value="<?php echo $multiple_price->price_min_qty->EditValue ?>"<?php echo $multiple_price->price_min_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_currency"><?php echo $multiple_price->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->currency->cellAttributes() ?>>
			<span id="el_multiple_price_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="multiple_price" data-field="x_currency" data-value-separator="<?php echo $multiple_price->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $multiple_price->currency->editAttributes() ?>>
		<?php echo $multiple_price->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $multiple_price->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_operator"><?php echo $multiple_price->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->operator->cellAttributes() ?>>
			<span id="el_multiple_price_operator">
<?php
$wrkonchange = "" . trim(@$multiple_price->operator->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$multiple_price->operator->EditAttrs["onchange"] = "";
?>
<span id="as_x_operator" class="text-nowrap" style="z-index: 8840">
	<input type="text" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?php echo RemoveHtml($multiple_price->operator->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($multiple_price->operator->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($multiple_price->operator->getPlaceHolder()) ?>"<?php echo $multiple_price->operator->editAttributes() ?>>
</span>
<input type="hidden" data-table="multiple_price" data-field="x_operator" data-value-separator="<?php echo $multiple_price->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($multiple_price->operator->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmultiple_pricesearch.createAutoSuggest({"id":"x_operator","forceSelect":false});
</script>
<?php echo $multiple_price->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($multiple_price->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $multiple_price_search->LeftColumnClass ?>"><span id="elh_multiple_price_datetime"><?php echo $multiple_price->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $multiple_price_search->RightColumnClass ?>"><div<?php echo $multiple_price->datetime->cellAttributes() ?>>
			<span id="el_multiple_price_datetime">
<input type="text" data-table="multiple_price" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($multiple_price->datetime->getPlaceHolder()) ?>" value="<?php echo $multiple_price->datetime->EditValue ?>"<?php echo $multiple_price->datetime->editAttributes() ?>>
<?php if (!$multiple_price->datetime->ReadOnly && !$multiple_price->datetime->Disabled && !isset($multiple_price->datetime->EditAttrs["readonly"]) && !isset($multiple_price->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmultiple_pricesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$multiple_price_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $multiple_price_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$multiple_price_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$multiple_price_search->terminate();
?>