<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$news_letter_add = new news_letter_add();

// Run the page
$news_letter_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_letter_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fnews_letteradd = currentForm = new ew.Form("fnews_letteradd", "add");

// Validate form
fnews_letteradd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($news_letter_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $news_letter->_email->caption(), $news_letter->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($news_letter_add->ip->Required) { ?>
			elm = this.getElements("x" + infix + "_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $news_letter->ip->caption(), $news_letter->ip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($news_letter_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $news_letter->status->caption(), $news_letter->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($news_letter_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $news_letter->operator->caption(), $news_letter->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($news_letter_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $news_letter->datetime->caption(), $news_letter->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnews_letteradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnews_letteradd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnews_letteradd.lists["x_status"] = <?php echo $news_letter_add->status->Lookup->toClientList() ?>;
fnews_letteradd.lists["x_status"].options = <?php echo JsonEncode($news_letter_add->status->options(FALSE, TRUE)) ?>;
fnews_letteradd.lists["x_operator"] = <?php echo $news_letter_add->operator->Lookup->toClientList() ?>;
fnews_letteradd.lists["x_operator"].options = <?php echo JsonEncode($news_letter_add->operator->lookupOptions()) ?>;
fnews_letteradd.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $news_letter_add->showPageHeader(); ?>
<?php
$news_letter_add->showMessage();
?>
<form name="fnews_letteradd" id="fnews_letteradd" class="<?php echo $news_letter_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($news_letter_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $news_letter_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="news_letter">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$news_letter_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($news_letter->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_news_letter__email" for="x__email" class="<?php echo $news_letter_add->LeftColumnClass ?>"><?php echo $news_letter->_email->caption() ?><?php echo ($news_letter->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $news_letter_add->RightColumnClass ?>"><div<?php echo $news_letter->_email->cellAttributes() ?>>
<span id="el_news_letter__email">
<input type="text" data-table="news_letter" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($news_letter->_email->getPlaceHolder()) ?>" value="<?php echo $news_letter->_email->EditValue ?>"<?php echo $news_letter->_email->editAttributes() ?>>
</span>
<?php echo $news_letter->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($news_letter->ip->Visible) { // ip ?>
	<div id="r_ip" class="form-group row">
		<label id="elh_news_letter_ip" for="x_ip" class="<?php echo $news_letter_add->LeftColumnClass ?>"><?php echo $news_letter->ip->caption() ?><?php echo ($news_letter->ip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $news_letter_add->RightColumnClass ?>"><div<?php echo $news_letter->ip->cellAttributes() ?>>
<span id="el_news_letter_ip">
<input type="text" data-table="news_letter" data-field="x_ip" name="x_ip" id="x_ip" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($news_letter->ip->getPlaceHolder()) ?>" value="<?php echo $news_letter->ip->EditValue ?>"<?php echo $news_letter->ip->editAttributes() ?>>
</span>
<?php echo $news_letter->ip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($news_letter->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_news_letter_status" for="x_status" class="<?php echo $news_letter_add->LeftColumnClass ?>"><?php echo $news_letter->status->caption() ?><?php echo ($news_letter->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $news_letter_add->RightColumnClass ?>"><div<?php echo $news_letter->status->cellAttributes() ?>>
<span id="el_news_letter_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="news_letter" data-field="x_status" data-value-separator="<?php echo $news_letter->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $news_letter->status->editAttributes() ?>>
		<?php echo $news_letter->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $news_letter->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$news_letter_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $news_letter_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $news_letter_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$news_letter_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_letter_add->terminate();
?>