<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$news_letter_delete = new news_letter_delete();

// Run the page
$news_letter_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_letter_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fnews_letterdelete = currentForm = new ew.Form("fnews_letterdelete", "delete");

// Form_CustomValidate event
fnews_letterdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnews_letterdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnews_letterdelete.lists["x_status"] = <?php echo $news_letter_delete->status->Lookup->toClientList() ?>;
fnews_letterdelete.lists["x_status"].options = <?php echo JsonEncode($news_letter_delete->status->options(FALSE, TRUE)) ?>;
fnews_letterdelete.lists["x_operator"] = <?php echo $news_letter_delete->operator->Lookup->toClientList() ?>;
fnews_letterdelete.lists["x_operator"].options = <?php echo JsonEncode($news_letter_delete->operator->lookupOptions()) ?>;
fnews_letterdelete.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $news_letter_delete->showPageHeader(); ?>
<?php
$news_letter_delete->showMessage();
?>
<form name="fnews_letterdelete" id="fnews_letterdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($news_letter_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $news_letter_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="news_letter">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($news_letter_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($news_letter->id->Visible) { // id ?>
		<th class="<?php echo $news_letter->id->headerCellClass() ?>"><span id="elh_news_letter_id" class="news_letter_id"><?php echo $news_letter->id->caption() ?></span></th>
<?php } ?>
<?php if ($news_letter->_email->Visible) { // email ?>
		<th class="<?php echo $news_letter->_email->headerCellClass() ?>"><span id="elh_news_letter__email" class="news_letter__email"><?php echo $news_letter->_email->caption() ?></span></th>
<?php } ?>
<?php if ($news_letter->ip->Visible) { // ip ?>
		<th class="<?php echo $news_letter->ip->headerCellClass() ?>"><span id="elh_news_letter_ip" class="news_letter_ip"><?php echo $news_letter->ip->caption() ?></span></th>
<?php } ?>
<?php if ($news_letter->status->Visible) { // status ?>
		<th class="<?php echo $news_letter->status->headerCellClass() ?>"><span id="elh_news_letter_status" class="news_letter_status"><?php echo $news_letter->status->caption() ?></span></th>
<?php } ?>
<?php if ($news_letter->operator->Visible) { // operator ?>
		<th class="<?php echo $news_letter->operator->headerCellClass() ?>"><span id="elh_news_letter_operator" class="news_letter_operator"><?php echo $news_letter->operator->caption() ?></span></th>
<?php } ?>
<?php if ($news_letter->datetime->Visible) { // datetime ?>
		<th class="<?php echo $news_letter->datetime->headerCellClass() ?>"><span id="elh_news_letter_datetime" class="news_letter_datetime"><?php echo $news_letter->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$news_letter_delete->RecCnt = 0;
$i = 0;
while (!$news_letter_delete->Recordset->EOF) {
	$news_letter_delete->RecCnt++;
	$news_letter_delete->RowCnt++;

	// Set row properties
	$news_letter->resetAttributes();
	$news_letter->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$news_letter_delete->loadRowValues($news_letter_delete->Recordset);

	// Render row
	$news_letter_delete->renderRow();
?>
	<tr<?php echo $news_letter->rowAttributes() ?>>
<?php if ($news_letter->id->Visible) { // id ?>
		<td<?php echo $news_letter->id->cellAttributes() ?>>
<span id="el<?php echo $news_letter_delete->RowCnt ?>_news_letter_id" class="news_letter_id">
<span<?php echo $news_letter->id->viewAttributes() ?>>
<?php echo $news_letter->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news_letter->_email->Visible) { // email ?>
		<td<?php echo $news_letter->_email->cellAttributes() ?>>
<span id="el<?php echo $news_letter_delete->RowCnt ?>_news_letter__email" class="news_letter__email">
<span<?php echo $news_letter->_email->viewAttributes() ?>>
<?php echo $news_letter->_email->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news_letter->ip->Visible) { // ip ?>
		<td<?php echo $news_letter->ip->cellAttributes() ?>>
<span id="el<?php echo $news_letter_delete->RowCnt ?>_news_letter_ip" class="news_letter_ip">
<span<?php echo $news_letter->ip->viewAttributes() ?>>
<?php echo $news_letter->ip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news_letter->status->Visible) { // status ?>
		<td<?php echo $news_letter->status->cellAttributes() ?>>
<span id="el<?php echo $news_letter_delete->RowCnt ?>_news_letter_status" class="news_letter_status">
<span<?php echo $news_letter->status->viewAttributes() ?>>
<?php echo $news_letter->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news_letter->operator->Visible) { // operator ?>
		<td<?php echo $news_letter->operator->cellAttributes() ?>>
<span id="el<?php echo $news_letter_delete->RowCnt ?>_news_letter_operator" class="news_letter_operator">
<span<?php echo $news_letter->operator->viewAttributes() ?>>
<?php echo $news_letter->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news_letter->datetime->Visible) { // datetime ?>
		<td<?php echo $news_letter->datetime->cellAttributes() ?>>
<span id="el<?php echo $news_letter_delete->RowCnt ?>_news_letter_datetime" class="news_letter_datetime">
<span<?php echo $news_letter->datetime->viewAttributes() ?>>
<?php echo $news_letter->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$news_letter_delete->Recordset->moveNext();
}
$news_letter_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $news_letter_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$news_letter_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_letter_delete->terminate();
?>