<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$news_letter_list = new news_letter_list();

// Run the page
$news_letter_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_letter_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$news_letter->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fnews_letterlist = currentForm = new ew.Form("fnews_letterlist", "list");
fnews_letterlist.formKeyCountName = '<?php echo $news_letter_list->FormKeyCountName ?>';

// Form_CustomValidate event
fnews_letterlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnews_letterlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnews_letterlist.lists["x_status"] = <?php echo $news_letter_list->status->Lookup->toClientList() ?>;
fnews_letterlist.lists["x_status"].options = <?php echo JsonEncode($news_letter_list->status->options(FALSE, TRUE)) ?>;
fnews_letterlist.lists["x_operator"] = <?php echo $news_letter_list->operator->Lookup->toClientList() ?>;
fnews_letterlist.lists["x_operator"].options = <?php echo JsonEncode($news_letter_list->operator->lookupOptions()) ?>;
fnews_letterlist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fnews_letterlistsrch = currentSearchForm = new ew.Form("fnews_letterlistsrch");

// Filters
fnews_letterlistsrch.filterList = <?php echo $news_letter_list->getFilterList() ?>;

// Init search panel as collapsed
fnews_letterlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$news_letter->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($news_letter_list->TotalRecs > 0 && $news_letter_list->ExportOptions->visible()) { ?>
<?php $news_letter_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($news_letter_list->ImportOptions->visible()) { ?>
<?php $news_letter_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($news_letter_list->SearchOptions->visible()) { ?>
<?php $news_letter_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($news_letter_list->FilterOptions->visible()) { ?>
<?php $news_letter_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$news_letter_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$news_letter->isExport() && !$news_letter->CurrentAction) { ?>
<form name="fnews_letterlistsrch" id="fnews_letterlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($news_letter_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fnews_letterlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="news_letter">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($news_letter_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($news_letter_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $news_letter_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($news_letter_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($news_letter_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($news_letter_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($news_letter_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $news_letter_list->showPageHeader(); ?>
<?php
$news_letter_list->showMessage();
?>
<?php if ($news_letter_list->TotalRecs > 0 || $news_letter->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($news_letter_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> news_letter">
<?php if (!$news_letter->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$news_letter->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($news_letter_list->Pager)) $news_letter_list->Pager = new PrevNextPager($news_letter_list->StartRec, $news_letter_list->DisplayRecs, $news_letter_list->TotalRecs, $news_letter_list->AutoHidePager) ?>
<?php if ($news_letter_list->Pager->RecordCount > 0 && $news_letter_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($news_letter_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($news_letter_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $news_letter_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($news_letter_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($news_letter_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $news_letter_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($news_letter_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $news_letter_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $news_letter_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $news_letter_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($news_letter_list->TotalRecs > 0 && (!$news_letter_list->AutoHidePageSizeSelector || $news_letter_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="news_letter">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($news_letter_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($news_letter_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($news_letter_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($news_letter_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($news_letter_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($news_letter->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $news_letter_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fnews_letterlist" id="fnews_letterlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($news_letter_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $news_letter_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="news_letter">
<div id="gmp_news_letter" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($news_letter_list->TotalRecs > 0 || $news_letter->isGridEdit()) { ?>
<table id="tbl_news_letterlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$news_letter_list->RowType = ROWTYPE_HEADER;

// Render list options
$news_letter_list->renderListOptions();

// Render list options (header, left)
$news_letter_list->ListOptions->render("header", "left");
?>
<?php if ($news_letter->id->Visible) { // id ?>
	<?php if ($news_letter->sortUrl($news_letter->id) == "") { ?>
		<th data-name="id" class="<?php echo $news_letter->id->headerCellClass() ?>"><div id="elh_news_letter_id" class="news_letter_id"><div class="ew-table-header-caption"><?php echo $news_letter->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $news_letter->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $news_letter->SortUrl($news_letter->id) ?>',2);"><div id="elh_news_letter_id" class="news_letter_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $news_letter->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($news_letter->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($news_letter->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($news_letter->_email->Visible) { // email ?>
	<?php if ($news_letter->sortUrl($news_letter->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $news_letter->_email->headerCellClass() ?>"><div id="elh_news_letter__email" class="news_letter__email"><div class="ew-table-header-caption"><?php echo $news_letter->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $news_letter->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $news_letter->SortUrl($news_letter->_email) ?>',2);"><div id="elh_news_letter__email" class="news_letter__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $news_letter->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($news_letter->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($news_letter->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($news_letter->ip->Visible) { // ip ?>
	<?php if ($news_letter->sortUrl($news_letter->ip) == "") { ?>
		<th data-name="ip" class="<?php echo $news_letter->ip->headerCellClass() ?>"><div id="elh_news_letter_ip" class="news_letter_ip"><div class="ew-table-header-caption"><?php echo $news_letter->ip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ip" class="<?php echo $news_letter->ip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $news_letter->SortUrl($news_letter->ip) ?>',2);"><div id="elh_news_letter_ip" class="news_letter_ip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $news_letter->ip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($news_letter->ip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($news_letter->ip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($news_letter->status->Visible) { // status ?>
	<?php if ($news_letter->sortUrl($news_letter->status) == "") { ?>
		<th data-name="status" class="<?php echo $news_letter->status->headerCellClass() ?>"><div id="elh_news_letter_status" class="news_letter_status"><div class="ew-table-header-caption"><?php echo $news_letter->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $news_letter->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $news_letter->SortUrl($news_letter->status) ?>',2);"><div id="elh_news_letter_status" class="news_letter_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $news_letter->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($news_letter->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($news_letter->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($news_letter->operator->Visible) { // operator ?>
	<?php if ($news_letter->sortUrl($news_letter->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $news_letter->operator->headerCellClass() ?>"><div id="elh_news_letter_operator" class="news_letter_operator"><div class="ew-table-header-caption"><?php echo $news_letter->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $news_letter->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $news_letter->SortUrl($news_letter->operator) ?>',2);"><div id="elh_news_letter_operator" class="news_letter_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $news_letter->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($news_letter->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($news_letter->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($news_letter->datetime->Visible) { // datetime ?>
	<?php if ($news_letter->sortUrl($news_letter->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $news_letter->datetime->headerCellClass() ?>"><div id="elh_news_letter_datetime" class="news_letter_datetime"><div class="ew-table-header-caption"><?php echo $news_letter->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $news_letter->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $news_letter->SortUrl($news_letter->datetime) ?>',2);"><div id="elh_news_letter_datetime" class="news_letter_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $news_letter->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($news_letter->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($news_letter->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$news_letter_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($news_letter->ExportAll && $news_letter->isExport()) {
	$news_letter_list->StopRec = $news_letter_list->TotalRecs;
} else {

	// Set the last record to display
	if ($news_letter_list->TotalRecs > $news_letter_list->StartRec + $news_letter_list->DisplayRecs - 1)
		$news_letter_list->StopRec = $news_letter_list->StartRec + $news_letter_list->DisplayRecs - 1;
	else
		$news_letter_list->StopRec = $news_letter_list->TotalRecs;
}
$news_letter_list->RecCnt = $news_letter_list->StartRec - 1;
if ($news_letter_list->Recordset && !$news_letter_list->Recordset->EOF) {
	$news_letter_list->Recordset->moveFirst();
	$selectLimit = $news_letter_list->UseSelectLimit;
	if (!$selectLimit && $news_letter_list->StartRec > 1)
		$news_letter_list->Recordset->move($news_letter_list->StartRec - 1);
} elseif (!$news_letter->AllowAddDeleteRow && $news_letter_list->StopRec == 0) {
	$news_letter_list->StopRec = $news_letter->GridAddRowCount;
}

// Initialize aggregate
$news_letter->RowType = ROWTYPE_AGGREGATEINIT;
$news_letter->resetAttributes();
$news_letter_list->renderRow();
while ($news_letter_list->RecCnt < $news_letter_list->StopRec) {
	$news_letter_list->RecCnt++;
	if ($news_letter_list->RecCnt >= $news_letter_list->StartRec) {
		$news_letter_list->RowCnt++;

		// Set up key count
		$news_letter_list->KeyCount = $news_letter_list->RowIndex;

		// Init row class and style
		$news_letter->resetAttributes();
		$news_letter->CssClass = "";
		if ($news_letter->isGridAdd()) {
		} else {
			$news_letter_list->loadRowValues($news_letter_list->Recordset); // Load row values
		}
		$news_letter->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$news_letter->RowAttrs = array_merge($news_letter->RowAttrs, array('data-rowindex'=>$news_letter_list->RowCnt, 'id'=>'r' . $news_letter_list->RowCnt . '_news_letter', 'data-rowtype'=>$news_letter->RowType));

		// Render row
		$news_letter_list->renderRow();

		// Render list options
		$news_letter_list->renderListOptions();
?>
	<tr<?php echo $news_letter->rowAttributes() ?>>
<?php

// Render list options (body, left)
$news_letter_list->ListOptions->render("body", "left", $news_letter_list->RowCnt);
?>
	<?php if ($news_letter->id->Visible) { // id ?>
		<td data-name="id"<?php echo $news_letter->id->cellAttributes() ?>>
<span id="el<?php echo $news_letter_list->RowCnt ?>_news_letter_id" class="news_letter_id">
<span<?php echo $news_letter->id->viewAttributes() ?>>
<?php echo $news_letter->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($news_letter->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $news_letter->_email->cellAttributes() ?>>
<span id="el<?php echo $news_letter_list->RowCnt ?>_news_letter__email" class="news_letter__email">
<span<?php echo $news_letter->_email->viewAttributes() ?>>
<?php echo $news_letter->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($news_letter->ip->Visible) { // ip ?>
		<td data-name="ip"<?php echo $news_letter->ip->cellAttributes() ?>>
<span id="el<?php echo $news_letter_list->RowCnt ?>_news_letter_ip" class="news_letter_ip">
<span<?php echo $news_letter->ip->viewAttributes() ?>>
<?php echo $news_letter->ip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($news_letter->status->Visible) { // status ?>
		<td data-name="status"<?php echo $news_letter->status->cellAttributes() ?>>
<span id="el<?php echo $news_letter_list->RowCnt ?>_news_letter_status" class="news_letter_status">
<span<?php echo $news_letter->status->viewAttributes() ?>>
<?php echo $news_letter->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($news_letter->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $news_letter->operator->cellAttributes() ?>>
<span id="el<?php echo $news_letter_list->RowCnt ?>_news_letter_operator" class="news_letter_operator">
<span<?php echo $news_letter->operator->viewAttributes() ?>>
<?php echo $news_letter->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($news_letter->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $news_letter->datetime->cellAttributes() ?>>
<span id="el<?php echo $news_letter_list->RowCnt ?>_news_letter_datetime" class="news_letter_datetime">
<span<?php echo $news_letter->datetime->viewAttributes() ?>>
<?php echo $news_letter->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$news_letter_list->ListOptions->render("body", "right", $news_letter_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$news_letter->isGridAdd())
		$news_letter_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$news_letter->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($news_letter_list->Recordset)
	$news_letter_list->Recordset->Close();
?>
<?php if (!$news_letter->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$news_letter->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($news_letter_list->Pager)) $news_letter_list->Pager = new PrevNextPager($news_letter_list->StartRec, $news_letter_list->DisplayRecs, $news_letter_list->TotalRecs, $news_letter_list->AutoHidePager) ?>
<?php if ($news_letter_list->Pager->RecordCount > 0 && $news_letter_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($news_letter_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($news_letter_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $news_letter_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($news_letter_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($news_letter_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $news_letter_list->pageUrl() ?>start=<?php echo $news_letter_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $news_letter_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($news_letter_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $news_letter_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $news_letter_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $news_letter_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($news_letter_list->TotalRecs > 0 && (!$news_letter_list->AutoHidePageSizeSelector || $news_letter_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="news_letter">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($news_letter_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($news_letter_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($news_letter_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($news_letter_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($news_letter_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($news_letter->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $news_letter_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($news_letter_list->TotalRecs == 0 && !$news_letter->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $news_letter_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$news_letter_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$news_letter->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$news_letter->isExport()) { ?>
<script>
ew.scrollableTable("gmp_news_letter", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$news_letter_list->terminate();
?>