<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$news_letter_view = new news_letter_view();

// Run the page
$news_letter_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_letter_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$news_letter->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fnews_letterview = currentForm = new ew.Form("fnews_letterview", "view");

// Form_CustomValidate event
fnews_letterview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnews_letterview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnews_letterview.lists["x_status"] = <?php echo $news_letter_view->status->Lookup->toClientList() ?>;
fnews_letterview.lists["x_status"].options = <?php echo JsonEncode($news_letter_view->status->options(FALSE, TRUE)) ?>;
fnews_letterview.lists["x_operator"] = <?php echo $news_letter_view->operator->Lookup->toClientList() ?>;
fnews_letterview.lists["x_operator"].options = <?php echo JsonEncode($news_letter_view->operator->lookupOptions()) ?>;
fnews_letterview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$news_letter->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $news_letter_view->ExportOptions->render("body") ?>
<?php $news_letter_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $news_letter_view->showPageHeader(); ?>
<?php
$news_letter_view->showMessage();
?>
<form name="fnews_letterview" id="fnews_letterview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($news_letter_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $news_letter_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="news_letter">
<input type="hidden" name="modal" value="<?php echo (int)$news_letter_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($news_letter->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $news_letter_view->TableLeftColumnClass ?>"><span id="elh_news_letter_id"><?php echo $news_letter->id->caption() ?></span></td>
		<td data-name="id"<?php echo $news_letter->id->cellAttributes() ?>>
<span id="el_news_letter_id">
<span<?php echo $news_letter->id->viewAttributes() ?>>
<?php echo $news_letter->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news_letter->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $news_letter_view->TableLeftColumnClass ?>"><span id="elh_news_letter__email"><?php echo $news_letter->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $news_letter->_email->cellAttributes() ?>>
<span id="el_news_letter__email">
<span<?php echo $news_letter->_email->viewAttributes() ?>>
<?php echo $news_letter->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news_letter->ip->Visible) { // ip ?>
	<tr id="r_ip">
		<td class="<?php echo $news_letter_view->TableLeftColumnClass ?>"><span id="elh_news_letter_ip"><?php echo $news_letter->ip->caption() ?></span></td>
		<td data-name="ip"<?php echo $news_letter->ip->cellAttributes() ?>>
<span id="el_news_letter_ip">
<span<?php echo $news_letter->ip->viewAttributes() ?>>
<?php echo $news_letter->ip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news_letter->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $news_letter_view->TableLeftColumnClass ?>"><span id="elh_news_letter_status"><?php echo $news_letter->status->caption() ?></span></td>
		<td data-name="status"<?php echo $news_letter->status->cellAttributes() ?>>
<span id="el_news_letter_status">
<span<?php echo $news_letter->status->viewAttributes() ?>>
<?php echo $news_letter->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news_letter->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $news_letter_view->TableLeftColumnClass ?>"><span id="elh_news_letter_operator"><?php echo $news_letter->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $news_letter->operator->cellAttributes() ?>>
<span id="el_news_letter_operator">
<span<?php echo $news_letter->operator->viewAttributes() ?>>
<?php echo $news_letter->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news_letter->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $news_letter_view->TableLeftColumnClass ?>"><span id="elh_news_letter_datetime"><?php echo $news_letter->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $news_letter->datetime->cellAttributes() ?>>
<span id="el_news_letter_datetime">
<span<?php echo $news_letter->datetime->viewAttributes() ?>>
<?php echo $news_letter->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$news_letter_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$news_letter->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$news_letter_view->terminate();
?>