<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$not_month_add = new not_month_add();

// Run the page
$not_month_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$not_month_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fnot_monthadd = currentForm = new ew.Form("fnot_monthadd", "add");

// Validate form
fnot_monthadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($not_month_add->month->Required) { ?>
			elm = this.getElements("x" + infix + "_month");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->month->caption(), $not_month->month->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_add->month_year->Required) { ?>
			elm = this.getElements("x" + infix + "_month_year");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->month_year->caption(), $not_month->month_year->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->operator->caption(), $not_month->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->datetime->caption(), $not_month->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnot_monthadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnot_monthadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnot_monthadd.lists["x_operator"] = <?php echo $not_month_add->operator->Lookup->toClientList() ?>;
fnot_monthadd.lists["x_operator"].options = <?php echo JsonEncode($not_month_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $not_month_add->showPageHeader(); ?>
<?php
$not_month_add->showMessage();
?>
<form name="fnot_monthadd" id="fnot_monthadd" class="<?php echo $not_month_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($not_month_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $not_month_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="not_month">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$not_month_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($not_month->month->Visible) { // month ?>
	<div id="r_month" class="form-group row">
		<label id="elh_not_month_month" for="x_month" class="<?php echo $not_month_add->LeftColumnClass ?>"><?php echo $not_month->month->caption() ?><?php echo ($not_month->month->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $not_month_add->RightColumnClass ?>"><div<?php echo $not_month->month->cellAttributes() ?>>
<span id="el_not_month_month">
<input type="text" data-table="not_month" data-field="x_month" name="x_month" id="x_month" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($not_month->month->getPlaceHolder()) ?>" value="<?php echo $not_month->month->EditValue ?>"<?php echo $not_month->month->editAttributes() ?>>
</span>
<?php echo $not_month->month->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($not_month->month_year->Visible) { // month_year ?>
	<div id="r_month_year" class="form-group row">
		<label id="elh_not_month_month_year" for="x_month_year" class="<?php echo $not_month_add->LeftColumnClass ?>"><?php echo $not_month->month_year->caption() ?><?php echo ($not_month->month_year->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $not_month_add->RightColumnClass ?>"><div<?php echo $not_month->month_year->cellAttributes() ?>>
<span id="el_not_month_month_year">
<input type="text" data-table="not_month" data-field="x_month_year" name="x_month_year" id="x_month_year" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($not_month->month_year->getPlaceHolder()) ?>" value="<?php echo $not_month->month_year->EditValue ?>"<?php echo $not_month->month_year->editAttributes() ?>>
</span>
<?php echo $not_month->month_year->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$not_month_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $not_month_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $not_month_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$not_month_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$not_month_add->terminate();
?>