<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$not_month_edit = new not_month_edit();

// Run the page
$not_month_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$not_month_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fnot_monthedit = currentForm = new ew.Form("fnot_monthedit", "edit");

// Validate form
fnot_monthedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($not_month_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->id->caption(), $not_month->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_edit->month->Required) { ?>
			elm = this.getElements("x" + infix + "_month");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->month->caption(), $not_month->month->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_edit->month_year->Required) { ?>
			elm = this.getElements("x" + infix + "_month_year");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->month_year->caption(), $not_month->month_year->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->operator->caption(), $not_month->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($not_month_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $not_month->datetime->caption(), $not_month->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnot_monthedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnot_monthedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fnot_monthedit.lists["x_operator"] = <?php echo $not_month_edit->operator->Lookup->toClientList() ?>;
fnot_monthedit.lists["x_operator"].options = <?php echo JsonEncode($not_month_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $not_month_edit->showPageHeader(); ?>
<?php
$not_month_edit->showMessage();
?>
<form name="fnot_monthedit" id="fnot_monthedit" class="<?php echo $not_month_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($not_month_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $not_month_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="not_month">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$not_month_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($not_month->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_not_month_id" class="<?php echo $not_month_edit->LeftColumnClass ?>"><?php echo $not_month->id->caption() ?><?php echo ($not_month->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $not_month_edit->RightColumnClass ?>"><div<?php echo $not_month->id->cellAttributes() ?>>
<span id="el_not_month_id">
<span<?php echo $not_month->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($not_month->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="not_month" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($not_month->id->CurrentValue) ?>">
<?php echo $not_month->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($not_month->month->Visible) { // month ?>
	<div id="r_month" class="form-group row">
		<label id="elh_not_month_month" for="x_month" class="<?php echo $not_month_edit->LeftColumnClass ?>"><?php echo $not_month->month->caption() ?><?php echo ($not_month->month->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $not_month_edit->RightColumnClass ?>"><div<?php echo $not_month->month->cellAttributes() ?>>
<span id="el_not_month_month">
<input type="text" data-table="not_month" data-field="x_month" name="x_month" id="x_month" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($not_month->month->getPlaceHolder()) ?>" value="<?php echo $not_month->month->EditValue ?>"<?php echo $not_month->month->editAttributes() ?>>
</span>
<?php echo $not_month->month->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($not_month->month_year->Visible) { // month_year ?>
	<div id="r_month_year" class="form-group row">
		<label id="elh_not_month_month_year" for="x_month_year" class="<?php echo $not_month_edit->LeftColumnClass ?>"><?php echo $not_month->month_year->caption() ?><?php echo ($not_month->month_year->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $not_month_edit->RightColumnClass ?>"><div<?php echo $not_month->month_year->cellAttributes() ?>>
<span id="el_not_month_month_year">
<input type="text" data-table="not_month" data-field="x_month_year" name="x_month_year" id="x_month_year" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($not_month->month_year->getPlaceHolder()) ?>" value="<?php echo $not_month->month_year->EditValue ?>"<?php echo $not_month->month_year->editAttributes() ?>>
</span>
<?php echo $not_month->month_year->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$not_month_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $not_month_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $not_month_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$not_month_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$not_month_edit->terminate();
?>