<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$oms_table_2_list = new oms_table_2_list();

// Run the page
$oms_table_2_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$oms_table_2_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$oms_table_2->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var foms_table_2list = currentForm = new ew.Form("foms_table_2list", "list");
foms_table_2list.formKeyCountName = '<?php echo $oms_table_2_list->FormKeyCountName ?>';

// Form_CustomValidate event
foms_table_2list.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_table_2list.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_table_2list.lists["x_buyers_id"] = <?php echo $oms_table_2_list->buyers_id->Lookup->toClientList() ?>;
foms_table_2list.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_2_list->buyers_id->lookupOptions()) ?>;
foms_table_2list.lists["x_reports_to"] = <?php echo $oms_table_2_list->reports_to->Lookup->toClientList() ?>;
foms_table_2list.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_2_list->reports_to->lookupOptions()) ?>;
foms_table_2list.lists["x_order_week"] = <?php echo $oms_table_2_list->order_week->Lookup->toClientList() ?>;
foms_table_2list.lists["x_order_week"].options = <?php echo JsonEncode($oms_table_2_list->order_week->lookupOptions()) ?>;
foms_table_2list.lists["x_ex_factory"] = <?php echo $oms_table_2_list->ex_factory->Lookup->toClientList() ?>;
foms_table_2list.lists["x_ex_factory"].options = <?php echo JsonEncode($oms_table_2_list->ex_factory->lookupOptions()) ?>;
foms_table_2list.lists["x_ex_factory_p[]"] = <?php echo $oms_table_2_list->ex_factory_p->Lookup->toClientList() ?>;
foms_table_2list.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_2_list->ex_factory_p->lookupOptions()) ?>;
foms_table_2list.lists["x_category"] = <?php echo $oms_table_2_list->category->Lookup->toClientList() ?>;
foms_table_2list.lists["x_category"].options = <?php echo JsonEncode($oms_table_2_list->category->lookupOptions()) ?>;
foms_table_2list.lists["x_cs"] = <?php echo $oms_table_2_list->cs->Lookup->toClientList() ?>;
foms_table_2list.lists["x_cs"].options = <?php echo JsonEncode($oms_table_2_list->cs->options(FALSE, TRUE)) ?>;
foms_table_2list.lists["x_weaving_works"] = <?php echo $oms_table_2_list->weaving_works->Lookup->toClientList() ?>;
foms_table_2list.lists["x_weaving_works"].options = <?php echo JsonEncode($oms_table_2_list->weaving_works->lookupOptions()) ?>;
foms_table_2list.lists["x_current_works"] = <?php echo $oms_table_2_list->current_works->Lookup->toClientList() ?>;
foms_table_2list.lists["x_current_works"].options = <?php echo JsonEncode($oms_table_2_list->current_works->lookupOptions()) ?>;
foms_table_2list.lists["x_status[]"] = <?php echo $oms_table_2_list->status->Lookup->toClientList() ?>;
foms_table_2list.lists["x_status[]"].options = <?php echo JsonEncode($oms_table_2_list->status->lookupOptions()) ?>;
foms_table_2list.lists["x_completed[]"] = <?php echo $oms_table_2_list->completed->Lookup->toClientList() ?>;
foms_table_2list.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_2_list->completed->options(FALSE, TRUE)) ?>;

// Form object for search
var foms_table_2listsrch = currentSearchForm = new ew.Form("foms_table_2listsrch");

// Validate function for search
foms_table_2listsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->pending->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
foms_table_2listsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_table_2listsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_table_2listsrch.lists["x_buyers_id"] = <?php echo $oms_table_2_list->buyers_id->Lookup->toClientList() ?>;
foms_table_2listsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_2_list->buyers_id->lookupOptions()) ?>;
foms_table_2listsrch.lists["x_reports_to"] = <?php echo $oms_table_2_list->reports_to->Lookup->toClientList() ?>;
foms_table_2listsrch.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_2_list->reports_to->lookupOptions()) ?>;
foms_table_2listsrch.lists["x_ex_factory_p[]"] = <?php echo $oms_table_2_list->ex_factory_p->Lookup->toClientList() ?>;
foms_table_2listsrch.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_2_list->ex_factory_p->lookupOptions()) ?>;
foms_table_2listsrch.lists["x_completed[]"] = <?php echo $oms_table_2_list->completed->Lookup->toClientList() ?>;
foms_table_2listsrch.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_2_list->completed->options(FALSE, TRUE)) ?>;

// Filters
foms_table_2listsrch.filterList = <?php echo $oms_table_2_list->getFilterList() ?>;

// Init search panel as collapsed
foms_table_2listsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$oms_table_2->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($oms_table_2_list->TotalRecs > 0 && $oms_table_2_list->ExportOptions->visible()) { ?>
<?php $oms_table_2_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($oms_table_2_list->ImportOptions->visible()) { ?>
<?php $oms_table_2_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($oms_table_2_list->SearchOptions->visible()) { ?>
<?php $oms_table_2_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($oms_table_2_list->FilterOptions->visible()) { ?>
<?php $oms_table_2_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$oms_table_2_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$oms_table_2->isExport() && !$oms_table_2->CurrentAction) { ?>
<form name="foms_table_2listsrch" id="foms_table_2listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($oms_table_2_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="foms_table_2listsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="oms_table_2">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$oms_table_2_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$oms_table_2->RowType = ROWTYPE_SEARCH;

// Render row
$oms_table_2->resetAttributes();
$oms_table_2_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($oms_table_2->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label for="x_buyers_id" class="ew-search-caption ew-label"><?php echo $oms_table_2->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_buyers_id" data-value-separator="<?php echo $oms_table_2->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $oms_table_2->buyers_id->editAttributes() ?>>
		<?php echo $oms_table_2->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $oms_table_2->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($oms_table_2->reports_to->Visible) { // reports_to ?>
	<div id="xsc_reports_to" class="ew-cell form-group">
		<label for="x_reports_to" class="ew-search-caption ew-label"><?php echo $oms_table_2->reports_to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_reports_to" data-value-separator="<?php echo $oms_table_2->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $oms_table_2->reports_to->editAttributes() ?>>
		<?php echo $oms_table_2->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $oms_table_2->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
	</div>
<?php } ?>
<?php if ($oms_table_2->buyer_order->Visible) { // buyer_order ?>
	<div id="xsc_buyer_order" class="ew-cell form-group">
		<label for="x_buyer_order" class="ew-search-caption ew-label"><?php echo $oms_table_2->buyer_order->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table_2" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table_2->buyer_order->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->buyer_order->EditValue ?>"<?php echo $oms_table_2->buyer_order->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($oms_table_2->ex_factory_p->Visible) { // ex_factory_p ?>
	<div id="xsc_ex_factory_p" class="ew-cell form-group">
		<label for="x_ex_factory_p" class="ew-search-caption ew-label"><?php echo $oms_table_2->ex_factory_p->caption() ?></label>
		<span class="ew-search-operator"><select name="z_ex_factory_p" id="z_ex_factory_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table_2->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table_2->ex_factory_p->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table_2->ex_factory_p->checkBoxListHtml(TRUE, "x_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table_2" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table_2->ex_factory_p->displayValueSeparatorAttribute() ?>" name="x_ex_factory_p[]" id="x_ex_factory_p[]" value="{value}"<?php echo $oms_table_2->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table_2->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table_2->ex_factory_p->Lookup->getParamTag("p_x_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		<span class="ew-search-cond btw1_ex_factory_p style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_ex_factory_p style="d-none"">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table_2->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table_2->ex_factory_p->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table_2->ex_factory_p->checkBoxListHtml(TRUE, "y_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table_2" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table_2->ex_factory_p->displayValueSeparatorAttribute() ?>" name="y_ex_factory_p[]" id="y_ex_factory_p[]" value="{value}"<?php echo $oms_table_2->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table_2->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table_2->ex_factory_p->Lookup->getParamTag("p_y_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
<?php if ($oms_table_2->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $oms_table_2->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table_2" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->po->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->po->EditValue ?>"<?php echo $oms_table_2->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="oms_table_2" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->po->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->po->EditValue2 ?>"<?php echo $oms_table_2->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($oms_table_2->design->Visible) { // design ?>
	<div id="xsc_design" class="ew-cell form-group">
		<label for="x_design" class="ew-search-caption ew-label"><?php echo $oms_table_2->design->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table_2" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($oms_table_2->design->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->design->EditValue ?>"<?php echo $oms_table_2->design->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($oms_table_2->pending->Visible) { // pending ?>
	<div id="xsc_pending" class="ew-cell form-group">
		<label for="x_pending" class="ew-search-caption ew-label"><?php echo $oms_table_2->pending->caption() ?></label>
		<span class="ew-search-operator"><select name="z_pending" id="z_pending" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table_2" data-field="x_pending" name="x_pending" id="x_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending->EditValue ?>"<?php echo $oms_table_2->pending->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_pending style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_pending style="d-none"">
<input type="text" data-table="oms_table_2" data-field="x_pending" name="y_pending" id="y_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending->EditValue2 ?>"<?php echo $oms_table_2->pending->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($oms_table_2->pl_no->Visible) { // pl_no ?>
	<div id="xsc_pl_no" class="ew-cell form-group">
		<label for="x_pl_no" class="ew-search-caption ew-label"><?php echo $oms_table_2->pl_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table_2" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" placeholder="<?php echo HtmlEncode($oms_table_2->pl_no->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pl_no->EditValue ?>"<?php echo $oms_table_2->pl_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($oms_table_2->completed->Visible) { // completed ?>
	<div id="xsc_completed" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $oms_table_2->completed->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_completed" id="z_completed" value="LIKE"></span>
		<span class="ew-search-field">
<div id="tp_x_completed" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table_2" data-field="x_completed" data-value-separator="<?php echo $oms_table_2->completed->displayValueSeparatorAttribute() ?>" name="x_completed[]" id="x_completed[]" value="{value}"<?php echo $oms_table_2->completed->editAttributes() ?>></div>
<div id="dsl_x_completed" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $oms_table_2->completed->checkBoxListHtml(FALSE, "x_completed[]") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($oms_table_2_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($oms_table_2_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $oms_table_2_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($oms_table_2_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($oms_table_2_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($oms_table_2_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($oms_table_2_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $oms_table_2_list->showPageHeader(); ?>
<?php
$oms_table_2_list->showMessage();
?>
<?php if ($oms_table_2_list->TotalRecs > 0 || $oms_table_2->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($oms_table_2_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> oms_table_2">
<?php if (!$oms_table_2->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$oms_table_2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($oms_table_2_list->Pager)) $oms_table_2_list->Pager = new PrevNextPager($oms_table_2_list->StartRec, $oms_table_2_list->DisplayRecs, $oms_table_2_list->TotalRecs, $oms_table_2_list->AutoHidePager) ?>
<?php if ($oms_table_2_list->Pager->RecordCount > 0 && $oms_table_2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($oms_table_2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($oms_table_2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $oms_table_2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($oms_table_2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($oms_table_2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $oms_table_2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($oms_table_2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $oms_table_2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $oms_table_2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $oms_table_2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($oms_table_2_list->TotalRecs > 0 && (!$oms_table_2_list->AutoHidePageSizeSelector || $oms_table_2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="oms_table_2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($oms_table_2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($oms_table_2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($oms_table_2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($oms_table_2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($oms_table_2_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($oms_table_2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $oms_table_2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="foms_table_2list" id="foms_table_2list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($oms_table_2_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $oms_table_2_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="oms_table_2">
<div id="gmp_oms_table_2" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($oms_table_2_list->TotalRecs > 0 || $oms_table_2->isGridEdit()) { ?>
<table id="tbl_oms_table_2list" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$oms_table_2_list->RowType = ROWTYPE_HEADER;

// Render list options
$oms_table_2_list->renderListOptions();

// Render list options (header, left)
$oms_table_2_list->ListOptions->render("header", "left");
?>
<?php if ($oms_table_2->id->Visible) { // id ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->id) == "") { ?>
		<th data-name="id" class="<?php echo $oms_table_2->id->headerCellClass() ?>"><div id="elh_oms_table_2_id" class="oms_table_2_id"><div class="ew-table-header-caption"><?php echo $oms_table_2->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $oms_table_2->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->id) ?>',2);"><div id="elh_oms_table_2_id" class="oms_table_2_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->buyers_id->Visible) { // buyers_id ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $oms_table_2->buyers_id->headerCellClass() ?>"><div id="elh_oms_table_2_buyers_id" class="oms_table_2_buyers_id"><div class="ew-table-header-caption"><?php echo $oms_table_2->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $oms_table_2->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->buyers_id) ?>',2);"><div id="elh_oms_table_2_buyers_id" class="oms_table_2_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->reports_to->Visible) { // reports_to ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $oms_table_2->reports_to->headerCellClass() ?>"><div id="elh_oms_table_2_reports_to" class="oms_table_2_reports_to"><div class="ew-table-header-caption"><?php echo $oms_table_2->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $oms_table_2->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->reports_to) ?>',2);"><div id="elh_oms_table_2_reports_to" class="oms_table_2_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->buyer_order->Visible) { // buyer_order ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->buyer_order) == "") { ?>
		<th data-name="buyer_order" class="<?php echo $oms_table_2->buyer_order->headerCellClass() ?>"><div id="elh_oms_table_2_buyer_order" class="oms_table_2_buyer_order"><div class="ew-table-header-caption"><?php echo $oms_table_2->buyer_order->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_order" class="<?php echo $oms_table_2->buyer_order->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->buyer_order) ?>',2);"><div id="elh_oms_table_2_buyer_order" class="oms_table_2_buyer_order">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->buyer_order->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->buyer_order->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->buyer_order->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->item->Visible) { // item ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->item) == "") { ?>
		<th data-name="item" class="<?php echo $oms_table_2->item->headerCellClass() ?>"><div id="elh_oms_table_2_item" class="oms_table_2_item"><div class="ew-table-header-caption"><?php echo $oms_table_2->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $oms_table_2->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->item) ?>',2);"><div id="elh_oms_table_2_item" class="oms_table_2_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $oms_table_2->buyer_ref->headerCellClass() ?>"><div id="elh_oms_table_2_buyer_ref" class="oms_table_2_buyer_ref"><div class="ew-table-header-caption"><?php echo $oms_table_2->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $oms_table_2->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->buyer_ref) ?>',2);"><div id="elh_oms_table_2_buyer_ref" class="oms_table_2_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->order_week->Visible) { // order_week ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->order_week) == "") { ?>
		<th data-name="order_week" class="<?php echo $oms_table_2->order_week->headerCellClass() ?>"><div id="elh_oms_table_2_order_week" class="oms_table_2_order_week"><div class="ew-table-header-caption"><?php echo $oms_table_2->order_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_week" class="<?php echo $oms_table_2->order_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->order_week) ?>',2);"><div id="elh_oms_table_2_order_week" class="oms_table_2_order_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->order_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->order_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->order_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->order_date->Visible) { // order_date ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $oms_table_2->order_date->headerCellClass() ?>"><div id="elh_oms_table_2_order_date" class="oms_table_2_order_date"><div class="ew-table-header-caption"><?php echo $oms_table_2->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $oms_table_2->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->order_date) ?>',2);"><div id="elh_oms_table_2_order_date" class="oms_table_2_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->ex_factory->Visible) { // ex_factory ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->ex_factory) == "") { ?>
		<th data-name="ex_factory" class="<?php echo $oms_table_2->ex_factory->headerCellClass() ?>"><div id="elh_oms_table_2_ex_factory" class="oms_table_2_ex_factory"><div class="ew-table-header-caption"><?php echo $oms_table_2->ex_factory->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory" class="<?php echo $oms_table_2->ex_factory->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->ex_factory) ?>',2);"><div id="elh_oms_table_2_ex_factory" class="oms_table_2_ex_factory">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->ex_factory->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->ex_factory->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->ex_factory->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->ex_factory_p->Visible) { // ex_factory_p ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->ex_factory_p) == "") { ?>
		<th data-name="ex_factory_p" class="<?php echo $oms_table_2->ex_factory_p->headerCellClass() ?>"><div id="elh_oms_table_2_ex_factory_p" class="oms_table_2_ex_factory_p"><div class="ew-table-header-caption"><?php echo $oms_table_2->ex_factory_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory_p" class="<?php echo $oms_table_2->ex_factory_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->ex_factory_p) ?>',2);"><div id="elh_oms_table_2_ex_factory_p" class="oms_table_2_ex_factory_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->ex_factory_p->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->ex_factory_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->ex_factory_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->shipping_mode->Visible) { // shipping_mode ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->shipping_mode) == "") { ?>
		<th data-name="shipping_mode" class="<?php echo $oms_table_2->shipping_mode->headerCellClass() ?>"><div id="elh_oms_table_2_shipping_mode" class="oms_table_2_shipping_mode"><div class="ew-table-header-caption"><?php echo $oms_table_2->shipping_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_mode" class="<?php echo $oms_table_2->shipping_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->shipping_mode) ?>',2);"><div id="elh_oms_table_2_shipping_mode" class="oms_table_2_shipping_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->shipping_mode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->shipping_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->shipping_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->category->Visible) { // category ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->category) == "") { ?>
		<th data-name="category" class="<?php echo $oms_table_2->category->headerCellClass() ?>"><div id="elh_oms_table_2_category" class="oms_table_2_category"><div class="ew-table-header-caption"><?php echo $oms_table_2->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $oms_table_2->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->category) ?>',2);"><div id="elh_oms_table_2_category" class="oms_table_2_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->cs->Visible) { // cs ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->cs) == "") { ?>
		<th data-name="cs" class="<?php echo $oms_table_2->cs->headerCellClass() ?>"><div id="elh_oms_table_2_cs" class="oms_table_2_cs"><div class="ew-table-header-caption"><?php echo $oms_table_2->cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs" class="<?php echo $oms_table_2->cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->cs) ?>',2);"><div id="elh_oms_table_2_cs" class="oms_table_2_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->po->Visible) { // po ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->po) == "") { ?>
		<th data-name="po" class="<?php echo $oms_table_2->po->headerCellClass() ?>"><div id="elh_oms_table_2_po" class="oms_table_2_po"><div class="ew-table-header-caption"><?php echo $oms_table_2->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $oms_table_2->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->po) ?>',2);"><div id="elh_oms_table_2_po" class="oms_table_2_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->design->Visible) { // design ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->design) == "") { ?>
		<th data-name="design" class="<?php echo $oms_table_2->design->headerCellClass() ?>"><div id="elh_oms_table_2_design" class="oms_table_2_design"><div class="ew-table-header-caption"><?php echo $oms_table_2->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $oms_table_2->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->design) ?>',2);"><div id="elh_oms_table_2_design" class="oms_table_2_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->size_buyer->Visible) { // size_buyer ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->size_buyer) == "") { ?>
		<th data-name="size_buyer" class="<?php echo $oms_table_2->size_buyer->headerCellClass() ?>"><div id="elh_oms_table_2_size_buyer" class="oms_table_2_size_buyer"><div class="ew-table-header-caption"><?php echo $oms_table_2->size_buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_buyer" class="<?php echo $oms_table_2->size_buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->size_buyer) ?>',2);"><div id="elh_oms_table_2_size_buyer" class="oms_table_2_size_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->size_buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->size_buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->size_buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->width->Visible) { // width ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->width) == "") { ?>
		<th data-name="width" class="<?php echo $oms_table_2->width->headerCellClass() ?>"><div id="elh_oms_table_2_width" class="oms_table_2_width"><div class="ew-table-header-caption"><?php echo $oms_table_2->width->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="width" class="<?php echo $oms_table_2->width->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->width) ?>',2);"><div id="elh_oms_table_2_width" class="oms_table_2_width">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->width->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->width->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->width->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->length->Visible) { // length ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->length) == "") { ?>
		<th data-name="length" class="<?php echo $oms_table_2->length->headerCellClass() ?>"><div id="elh_oms_table_2_length" class="oms_table_2_length"><div class="ew-table-header-caption"><?php echo $oms_table_2->length->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="length" class="<?php echo $oms_table_2->length->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->length) ?>',2);"><div id="elh_oms_table_2_length" class="oms_table_2_length">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->length->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->length->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->length->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->qty->Visible) { // qty ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $oms_table_2->qty->headerCellClass() ?>"><div id="elh_oms_table_2_qty" class="oms_table_2_qty"><div class="ew-table-header-caption"><?php echo $oms_table_2->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $oms_table_2->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->qty) ?>',2);"><div id="elh_oms_table_2_qty" class="oms_table_2_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->revised_qty->Visible) { // revised_qty ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->revised_qty) == "") { ?>
		<th data-name="revised_qty" class="<?php echo $oms_table_2->revised_qty->headerCellClass() ?>"><div id="elh_oms_table_2_revised_qty" class="oms_table_2_revised_qty"><div class="ew-table-header-caption"><?php echo $oms_table_2->revised_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="revised_qty" class="<?php echo $oms_table_2->revised_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->revised_qty) ?>',2);"><div id="elh_oms_table_2_revised_qty" class="oms_table_2_revised_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->revised_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->revised_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->revised_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->sqm->Visible) { // sqm ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $oms_table_2->sqm->headerCellClass() ?>"><div id="elh_oms_table_2_sqm" class="oms_table_2_sqm"><div class="ew-table-header-caption"><?php echo $oms_table_2->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $oms_table_2->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->sqm) ?>',2);"><div id="elh_oms_table_2_sqm" class="oms_table_2_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->d_qty->Visible) { // d_qty ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->d_qty) == "") { ?>
		<th data-name="d_qty" class="<?php echo $oms_table_2->d_qty->headerCellClass() ?>"><div id="elh_oms_table_2_d_qty" class="oms_table_2_d_qty"><div class="ew-table-header-caption"><?php echo $oms_table_2->d_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_qty" class="<?php echo $oms_table_2->d_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->d_qty) ?>',2);"><div id="elh_oms_table_2_d_qty" class="oms_table_2_d_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->d_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->d_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->d_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->pending->Visible) { // pending ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->pending) == "") { ?>
		<th data-name="pending" class="<?php echo $oms_table_2->pending->headerCellClass() ?>"><div id="elh_oms_table_2_pending" class="oms_table_2_pending"><div class="ew-table-header-caption"><?php echo $oms_table_2->pending->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending" class="<?php echo $oms_table_2->pending->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->pending) ?>',2);"><div id="elh_oms_table_2_pending" class="oms_table_2_pending">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->pending->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->pending->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->pending->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->pending_sqm->Visible) { // pending_sqm ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->pending_sqm) == "") { ?>
		<th data-name="pending_sqm" class="<?php echo $oms_table_2->pending_sqm->headerCellClass() ?>"><div id="elh_oms_table_2_pending_sqm" class="oms_table_2_pending_sqm"><div class="ew-table-header-caption"><?php echo $oms_table_2->pending_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_sqm" class="<?php echo $oms_table_2->pending_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->pending_sqm) ?>',2);"><div id="elh_oms_table_2_pending_sqm" class="oms_table_2_pending_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->pending_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->pending_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->pending_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->offloom->Visible) { // offloom ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->offloom) == "") { ?>
		<th data-name="offloom" class="<?php echo $oms_table_2->offloom->headerCellClass() ?>"><div id="elh_oms_table_2_offloom" class="oms_table_2_offloom"><div class="ew-table-header-caption"><?php echo $oms_table_2->offloom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="offloom" class="<?php echo $oms_table_2->offloom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->offloom) ?>',2);"><div id="elh_oms_table_2_offloom" class="oms_table_2_offloom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->offloom->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->offloom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->offloom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->pending_offloom->Visible) { // pending_offloom ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->pending_offloom) == "") { ?>
		<th data-name="pending_offloom" class="<?php echo $oms_table_2->pending_offloom->headerCellClass() ?>"><div id="elh_oms_table_2_pending_offloom" class="oms_table_2_pending_offloom"><div class="ew-table-header-caption"><?php echo $oms_table_2->pending_offloom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_offloom" class="<?php echo $oms_table_2->pending_offloom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->pending_offloom) ?>',2);"><div id="elh_oms_table_2_pending_offloom" class="oms_table_2_pending_offloom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->pending_offloom->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->pending_offloom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->pending_offloom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->pending_offloom_sqm) == "") { ?>
		<th data-name="pending_offloom_sqm" class="<?php echo $oms_table_2->pending_offloom_sqm->headerCellClass() ?>"><div id="elh_oms_table_2_pending_offloom_sqm" class="oms_table_2_pending_offloom_sqm"><div class="ew-table-header-caption"><?php echo $oms_table_2->pending_offloom_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_offloom_sqm" class="<?php echo $oms_table_2->pending_offloom_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->pending_offloom_sqm) ?>',2);"><div id="elh_oms_table_2_pending_offloom_sqm" class="oms_table_2_pending_offloom_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->pending_offloom_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->pending_offloom_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->pending_offloom_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->cbm->Visible) { // cbm ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $oms_table_2->cbm->headerCellClass() ?>"><div id="elh_oms_table_2_cbm" class="oms_table_2_cbm"><div class="ew-table-header-caption"><?php echo $oms_table_2->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $oms_table_2->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->cbm) ?>',2);"><div id="elh_oms_table_2_cbm" class="oms_table_2_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->total_cbm->Visible) { // total_cbm ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->total_cbm) == "") { ?>
		<th data-name="total_cbm" class="<?php echo $oms_table_2->total_cbm->headerCellClass() ?>"><div id="elh_oms_table_2_total_cbm" class="oms_table_2_total_cbm"><div class="ew-table-header-caption"><?php echo $oms_table_2->total_cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_cbm" class="<?php echo $oms_table_2->total_cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->total_cbm) ?>',2);"><div id="elh_oms_table_2_total_cbm" class="oms_table_2_total_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->total_cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->total_cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->total_cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->weaving_works->Visible) { // weaving_works ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $oms_table_2->weaving_works->headerCellClass() ?>"><div id="elh_oms_table_2_weaving_works" class="oms_table_2_weaving_works"><div class="ew-table-header-caption"><?php echo $oms_table_2->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $oms_table_2->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->weaving_works) ?>',2);"><div id="elh_oms_table_2_weaving_works" class="oms_table_2_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->current_works->Visible) { // current_works ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $oms_table_2->current_works->headerCellClass() ?>"><div id="elh_oms_table_2_current_works" class="oms_table_2_current_works"><div class="ew-table-header-caption"><?php echo $oms_table_2->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $oms_table_2->current_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->current_works) ?>',2);"><div id="elh_oms_table_2_current_works" class="oms_table_2_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->remarks->Visible) { // remarks ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $oms_table_2->remarks->headerCellClass() ?>"><div id="elh_oms_table_2_remarks" class="oms_table_2_remarks"><div class="ew-table-header-caption"><?php echo $oms_table_2->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $oms_table_2->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->remarks) ?>',2);"><div id="elh_oms_table_2_remarks" class="oms_table_2_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->pl_no->Visible) { // pl_no ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $oms_table_2->pl_no->headerCellClass() ?>"><div id="elh_oms_table_2_pl_no" class="oms_table_2_pl_no"><div class="ew-table-header-caption"><?php echo $oms_table_2->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $oms_table_2->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->pl_no) ?>',2);"><div id="elh_oms_table_2_pl_no" class="oms_table_2_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->pl_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->invoice_date->Visible) { // invoice_date ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->invoice_date) == "") { ?>
		<th data-name="invoice_date" class="<?php echo $oms_table_2->invoice_date->headerCellClass() ?>"><div id="elh_oms_table_2_invoice_date" class="oms_table_2_invoice_date"><div class="ew-table-header-caption"><?php echo $oms_table_2->invoice_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_date" class="<?php echo $oms_table_2->invoice_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->invoice_date) ?>',2);"><div id="elh_oms_table_2_invoice_date" class="oms_table_2_invoice_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->invoice_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->invoice_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->invoice_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->sailing_week->Visible) { // sailing_week ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->sailing_week) == "") { ?>
		<th data-name="sailing_week" class="<?php echo $oms_table_2->sailing_week->headerCellClass() ?>"><div id="elh_oms_table_2_sailing_week" class="oms_table_2_sailing_week"><div class="ew-table-header-caption"><?php echo $oms_table_2->sailing_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sailing_week" class="<?php echo $oms_table_2->sailing_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->sailing_week) ?>',2);"><div id="elh_oms_table_2_sailing_week" class="oms_table_2_sailing_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->sailing_week->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->sailing_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->sailing_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->status->Visible) { // status ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->status) == "") { ?>
		<th data-name="status" class="<?php echo $oms_table_2->status->headerCellClass() ?>"><div id="elh_oms_table_2_status" class="oms_table_2_status"><div class="ew-table-header-caption"><?php echo $oms_table_2->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $oms_table_2->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->status) ?>',2);"><div id="elh_oms_table_2_status" class="oms_table_2_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->completed->Visible) { // completed ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $oms_table_2->completed->headerCellClass() ?>"><div id="elh_oms_table_2_completed" class="oms_table_2_completed"><div class="ew-table-header-caption"><?php echo $oms_table_2->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $oms_table_2->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->completed) ?>',2);"><div id="elh_oms_table_2_completed" class="oms_table_2_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->rejection->Visible) { // rejection ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->rejection) == "") { ?>
		<th data-name="rejection" class="<?php echo $oms_table_2->rejection->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_oms_table_2_rejection" class="oms_table_2_rejection"><div class="ew-table-header-caption"><?php echo $oms_table_2->rejection->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rejection" class="<?php echo $oms_table_2->rejection->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->rejection) ?>',2);"><div id="elh_oms_table_2_rejection" class="oms_table_2_rejection">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->rejection->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->rejection->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->rejection->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->label->Visible) { // label ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->label) == "") { ?>
		<th data-name="label" class="<?php echo $oms_table_2->label->headerCellClass() ?>"><div id="elh_oms_table_2_label" class="oms_table_2_label"><div class="ew-table-header-caption"><?php echo $oms_table_2->label->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="label" class="<?php echo $oms_table_2->label->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->label) ?>',2);"><div id="elh_oms_table_2_label" class="oms_table_2_label">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->label->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->label->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->label->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table_2->weight_sqm->Visible) { // weight_sqm ?>
	<?php if ($oms_table_2->sortUrl($oms_table_2->weight_sqm) == "") { ?>
		<th data-name="weight_sqm" class="<?php echo $oms_table_2->weight_sqm->headerCellClass() ?>"><div id="elh_oms_table_2_weight_sqm" class="oms_table_2_weight_sqm"><div class="ew-table-header-caption"><?php echo $oms_table_2->weight_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_sqm" class="<?php echo $oms_table_2->weight_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table_2->SortUrl($oms_table_2->weight_sqm) ?>',2);"><div id="elh_oms_table_2_weight_sqm" class="oms_table_2_weight_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table_2->weight_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table_2->weight_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table_2->weight_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$oms_table_2_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($oms_table_2->ExportAll && $oms_table_2->isExport()) {
	$oms_table_2_list->StopRec = $oms_table_2_list->TotalRecs;
} else {

	// Set the last record to display
	if ($oms_table_2_list->TotalRecs > $oms_table_2_list->StartRec + $oms_table_2_list->DisplayRecs - 1)
		$oms_table_2_list->StopRec = $oms_table_2_list->StartRec + $oms_table_2_list->DisplayRecs - 1;
	else
		$oms_table_2_list->StopRec = $oms_table_2_list->TotalRecs;
}
$oms_table_2_list->RecCnt = $oms_table_2_list->StartRec - 1;
if ($oms_table_2_list->Recordset && !$oms_table_2_list->Recordset->EOF) {
	$oms_table_2_list->Recordset->moveFirst();
	$selectLimit = $oms_table_2_list->UseSelectLimit;
	if (!$selectLimit && $oms_table_2_list->StartRec > 1)
		$oms_table_2_list->Recordset->move($oms_table_2_list->StartRec - 1);
} elseif (!$oms_table_2->AllowAddDeleteRow && $oms_table_2_list->StopRec == 0) {
	$oms_table_2_list->StopRec = $oms_table_2->GridAddRowCount;
}

// Initialize aggregate
$oms_table_2->RowType = ROWTYPE_AGGREGATEINIT;
$oms_table_2->resetAttributes();
$oms_table_2_list->renderRow();
while ($oms_table_2_list->RecCnt < $oms_table_2_list->StopRec) {
	$oms_table_2_list->RecCnt++;
	if ($oms_table_2_list->RecCnt >= $oms_table_2_list->StartRec) {
		$oms_table_2_list->RowCnt++;

		// Set up key count
		$oms_table_2_list->KeyCount = $oms_table_2_list->RowIndex;

		// Init row class and style
		$oms_table_2->resetAttributes();
		$oms_table_2->CssClass = "";
		if ($oms_table_2->isGridAdd()) {
		} else {
			$oms_table_2_list->loadRowValues($oms_table_2_list->Recordset); // Load row values
		}
		$oms_table_2->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$oms_table_2->RowAttrs = array_merge($oms_table_2->RowAttrs, array('data-rowindex'=>$oms_table_2_list->RowCnt, 'id'=>'r' . $oms_table_2_list->RowCnt . '_oms_table_2', 'data-rowtype'=>$oms_table_2->RowType));

		// Render row
		$oms_table_2_list->renderRow();

		// Render list options
		$oms_table_2_list->renderListOptions();
?>
	<tr<?php echo $oms_table_2->rowAttributes() ?>>
<?php

// Render list options (body, left)
$oms_table_2_list->ListOptions->render("body", "left", $oms_table_2_list->RowCnt);
?>
	<?php if ($oms_table_2->id->Visible) { // id ?>
		<td data-name="id"<?php echo $oms_table_2->id->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_id" class="oms_table_2_id">
<span<?php echo $oms_table_2->id->viewAttributes() ?>>
<?php echo $oms_table_2->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $oms_table_2->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_buyers_id" class="oms_table_2_buyers_id">
<span<?php echo $oms_table_2->buyers_id->viewAttributes() ?>>
<?php echo $oms_table_2->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $oms_table_2->reports_to->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_reports_to" class="oms_table_2_reports_to">
<span<?php echo $oms_table_2->reports_to->viewAttributes() ?>>
<?php echo $oms_table_2->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->buyer_order->Visible) { // buyer_order ?>
		<td data-name="buyer_order"<?php echo $oms_table_2->buyer_order->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_buyer_order" class="oms_table_2_buyer_order">
<span<?php echo $oms_table_2->buyer_order->viewAttributes() ?>>
<?php echo $oms_table_2->buyer_order->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->item->Visible) { // item ?>
		<td data-name="item"<?php echo $oms_table_2->item->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_item" class="oms_table_2_item">
<span<?php echo $oms_table_2->item->viewAttributes() ?>>
<?php echo $oms_table_2->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $oms_table_2->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_buyer_ref" class="oms_table_2_buyer_ref">
<span<?php echo $oms_table_2->buyer_ref->viewAttributes() ?>>
<?php echo $oms_table_2->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->order_week->Visible) { // order_week ?>
		<td data-name="order_week"<?php echo $oms_table_2->order_week->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_order_week" class="oms_table_2_order_week">
<span<?php echo $oms_table_2->order_week->viewAttributes() ?>>
<?php echo $oms_table_2->order_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $oms_table_2->order_date->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_order_date" class="oms_table_2_order_date">
<span<?php echo $oms_table_2->order_date->viewAttributes() ?>>
<?php echo $oms_table_2->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->ex_factory->Visible) { // ex_factory ?>
		<td data-name="ex_factory"<?php echo $oms_table_2->ex_factory->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_ex_factory" class="oms_table_2_ex_factory">
<span<?php echo $oms_table_2->ex_factory->viewAttributes() ?>>
<?php echo $oms_table_2->ex_factory->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->ex_factory_p->Visible) { // ex_factory_p ?>
		<td data-name="ex_factory_p"<?php echo $oms_table_2->ex_factory_p->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_ex_factory_p" class="oms_table_2_ex_factory_p">
<span<?php echo $oms_table_2->ex_factory_p->viewAttributes() ?>>
<?php echo $oms_table_2->ex_factory_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->shipping_mode->Visible) { // shipping_mode ?>
		<td data-name="shipping_mode"<?php echo $oms_table_2->shipping_mode->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_shipping_mode" class="oms_table_2_shipping_mode">
<span<?php echo $oms_table_2->shipping_mode->viewAttributes() ?>>
<?php echo $oms_table_2->shipping_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->category->Visible) { // category ?>
		<td data-name="category"<?php echo $oms_table_2->category->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_category" class="oms_table_2_category">
<span<?php echo $oms_table_2->category->viewAttributes() ?>>
<?php echo $oms_table_2->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->cs->Visible) { // cs ?>
		<td data-name="cs"<?php echo $oms_table_2->cs->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_cs" class="oms_table_2_cs">
<span<?php echo $oms_table_2->cs->viewAttributes() ?>>
<?php echo $oms_table_2->cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->po->Visible) { // po ?>
		<td data-name="po"<?php echo $oms_table_2->po->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_po" class="oms_table_2_po">
<span<?php echo $oms_table_2->po->viewAttributes() ?>>
<?php echo $oms_table_2->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->design->Visible) { // design ?>
		<td data-name="design"<?php echo $oms_table_2->design->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_design" class="oms_table_2_design">
<span<?php echo $oms_table_2->design->viewAttributes() ?>>
<?php echo $oms_table_2->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer"<?php echo $oms_table_2->size_buyer->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_size_buyer" class="oms_table_2_size_buyer">
<span<?php echo $oms_table_2->size_buyer->viewAttributes() ?>>
<?php echo $oms_table_2->size_buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->width->Visible) { // width ?>
		<td data-name="width"<?php echo $oms_table_2->width->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_width" class="oms_table_2_width">
<span<?php echo $oms_table_2->width->viewAttributes() ?>>
<?php echo $oms_table_2->width->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->length->Visible) { // length ?>
		<td data-name="length"<?php echo $oms_table_2->length->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_length" class="oms_table_2_length">
<span<?php echo $oms_table_2->length->viewAttributes() ?>>
<?php echo $oms_table_2->length->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $oms_table_2->qty->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_qty" class="oms_table_2_qty">
<span<?php echo $oms_table_2->qty->viewAttributes() ?>>
<?php echo $oms_table_2->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->revised_qty->Visible) { // revised_qty ?>
		<td data-name="revised_qty"<?php echo $oms_table_2->revised_qty->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_revised_qty" class="oms_table_2_revised_qty">
<span<?php echo $oms_table_2->revised_qty->viewAttributes() ?>>
<?php echo $oms_table_2->revised_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $oms_table_2->sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_sqm" class="oms_table_2_sqm">
<span<?php echo $oms_table_2->sqm->viewAttributes() ?>>
<?php echo $oms_table_2->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->d_qty->Visible) { // d_qty ?>
		<td data-name="d_qty"<?php echo $oms_table_2->d_qty->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_d_qty" class="oms_table_2_d_qty">
<span<?php echo $oms_table_2->d_qty->viewAttributes() ?>>
<?php echo $oms_table_2->d_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->pending->Visible) { // pending ?>
		<td data-name="pending"<?php echo $oms_table_2->pending->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_pending" class="oms_table_2_pending">
<span<?php echo $oms_table_2->pending->viewAttributes() ?>>
<?php echo $oms_table_2->pending->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->pending_sqm->Visible) { // pending_sqm ?>
		<td data-name="pending_sqm"<?php echo $oms_table_2->pending_sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_pending_sqm" class="oms_table_2_pending_sqm">
<span<?php echo $oms_table_2->pending_sqm->viewAttributes() ?>>
<?php echo $oms_table_2->pending_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->offloom->Visible) { // offloom ?>
		<td data-name="offloom"<?php echo $oms_table_2->offloom->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_offloom" class="oms_table_2_offloom">
<span<?php echo $oms_table_2->offloom->viewAttributes() ?>>
<?php echo $oms_table_2->offloom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->pending_offloom->Visible) { // pending_offloom ?>
		<td data-name="pending_offloom"<?php echo $oms_table_2->pending_offloom->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_pending_offloom" class="oms_table_2_pending_offloom">
<span<?php echo $oms_table_2->pending_offloom->viewAttributes() ?>>
<?php echo $oms_table_2->pending_offloom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
		<td data-name="pending_offloom_sqm"<?php echo $oms_table_2->pending_offloom_sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_pending_offloom_sqm" class="oms_table_2_pending_offloom_sqm">
<span<?php echo $oms_table_2->pending_offloom_sqm->viewAttributes() ?>>
<?php echo $oms_table_2->pending_offloom_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $oms_table_2->cbm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_cbm" class="oms_table_2_cbm">
<span<?php echo $oms_table_2->cbm->viewAttributes() ?>>
<?php echo $oms_table_2->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->total_cbm->Visible) { // total_cbm ?>
		<td data-name="total_cbm"<?php echo $oms_table_2->total_cbm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_total_cbm" class="oms_table_2_total_cbm">
<span<?php echo $oms_table_2->total_cbm->viewAttributes() ?>>
<?php echo $oms_table_2->total_cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $oms_table_2->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_weaving_works" class="oms_table_2_weaving_works">
<span<?php echo $oms_table_2->weaving_works->viewAttributes() ?>>
<?php echo $oms_table_2->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $oms_table_2->current_works->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_current_works" class="oms_table_2_current_works">
<span<?php echo $oms_table_2->current_works->viewAttributes() ?>>
<?php echo $oms_table_2->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $oms_table_2->remarks->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_remarks" class="oms_table_2_remarks">
<span<?php echo $oms_table_2->remarks->viewAttributes() ?>>
<?php echo $oms_table_2->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $oms_table_2->pl_no->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_pl_no" class="oms_table_2_pl_no">
<span<?php echo $oms_table_2->pl_no->viewAttributes() ?>>
<?php echo $oms_table_2->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date"<?php echo $oms_table_2->invoice_date->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_invoice_date" class="oms_table_2_invoice_date">
<span<?php echo $oms_table_2->invoice_date->viewAttributes() ?>>
<?php echo $oms_table_2->invoice_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->sailing_week->Visible) { // sailing_week ?>
		<td data-name="sailing_week"<?php echo $oms_table_2->sailing_week->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_sailing_week" class="oms_table_2_sailing_week">
<span<?php echo $oms_table_2->sailing_week->viewAttributes() ?>>
<?php echo $oms_table_2->sailing_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->status->Visible) { // status ?>
		<td data-name="status"<?php echo $oms_table_2->status->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_status" class="oms_table_2_status">
<span<?php echo $oms_table_2->status->viewAttributes() ?>>
<?php echo $oms_table_2->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $oms_table_2->completed->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_completed" class="oms_table_2_completed">
<span<?php echo $oms_table_2->completed->viewAttributes() ?>>
<?php echo $oms_table_2->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->rejection->Visible) { // rejection ?>
		<td data-name="rejection"<?php echo $oms_table_2->rejection->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_rejection" class="oms_table_2_rejection">
<span<?php echo $oms_table_2->rejection->viewAttributes() ?>>
<?php echo $oms_table_2->rejection->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->label->Visible) { // label ?>
		<td data-name="label"<?php echo $oms_table_2->label->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_label" class="oms_table_2_label">
<span<?php echo $oms_table_2->label->viewAttributes() ?>>
<?php echo $oms_table_2->label->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table_2->weight_sqm->Visible) { // weight_sqm ?>
		<td data-name="weight_sqm"<?php echo $oms_table_2->weight_sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_2_list->RowCnt ?>_oms_table_2_weight_sqm" class="oms_table_2_weight_sqm">
<span<?php echo $oms_table_2->weight_sqm->viewAttributes() ?>>
<?php echo $oms_table_2->weight_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$oms_table_2_list->ListOptions->render("body", "right", $oms_table_2_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$oms_table_2->isGridAdd())
		$oms_table_2_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$oms_table_2->RowType = ROWTYPE_AGGREGATE;
$oms_table_2->resetAttributes();
$oms_table_2_list->renderRow();
?>
<?php if ($oms_table_2_list->TotalRecs > 0 && !$oms_table_2->isGridAdd() && !$oms_table_2->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$oms_table_2_list->renderListOptions();

// Render list options (footer, left)
$oms_table_2_list->ListOptions->render("footer", "left");
?>
	<?php if ($oms_table_2->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $oms_table_2->id->footerCellClass() ?>"><span id="elf_oms_table_2_id" class="oms_table_2_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $oms_table_2->buyers_id->footerCellClass() ?>"><span id="elf_oms_table_2_buyers_id" class="oms_table_2_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to" class="<?php echo $oms_table_2->reports_to->footerCellClass() ?>"><span id="elf_oms_table_2_reports_to" class="oms_table_2_reports_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->buyer_order->Visible) { // buyer_order ?>
		<td data-name="buyer_order" class="<?php echo $oms_table_2->buyer_order->footerCellClass() ?>"><span id="elf_oms_table_2_buyer_order" class="oms_table_2_buyer_order">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->item->Visible) { // item ?>
		<td data-name="item" class="<?php echo $oms_table_2->item->footerCellClass() ?>"><span id="elf_oms_table_2_item" class="oms_table_2_item">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $oms_table_2->buyer_ref->footerCellClass() ?>"><span id="elf_oms_table_2_buyer_ref" class="oms_table_2_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->order_week->Visible) { // order_week ?>
		<td data-name="order_week" class="<?php echo $oms_table_2->order_week->footerCellClass() ?>"><span id="elf_oms_table_2_order_week" class="oms_table_2_order_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->order_date->Visible) { // order_date ?>
		<td data-name="order_date" class="<?php echo $oms_table_2->order_date->footerCellClass() ?>"><span id="elf_oms_table_2_order_date" class="oms_table_2_order_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->ex_factory->Visible) { // ex_factory ?>
		<td data-name="ex_factory" class="<?php echo $oms_table_2->ex_factory->footerCellClass() ?>"><span id="elf_oms_table_2_ex_factory" class="oms_table_2_ex_factory">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->ex_factory_p->Visible) { // ex_factory_p ?>
		<td data-name="ex_factory_p" class="<?php echo $oms_table_2->ex_factory_p->footerCellClass() ?>"><span id="elf_oms_table_2_ex_factory_p" class="oms_table_2_ex_factory_p">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->shipping_mode->Visible) { // shipping_mode ?>
		<td data-name="shipping_mode" class="<?php echo $oms_table_2->shipping_mode->footerCellClass() ?>"><span id="elf_oms_table_2_shipping_mode" class="oms_table_2_shipping_mode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->category->Visible) { // category ?>
		<td data-name="category" class="<?php echo $oms_table_2->category->footerCellClass() ?>"><span id="elf_oms_table_2_category" class="oms_table_2_category">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->cs->Visible) { // cs ?>
		<td data-name="cs" class="<?php echo $oms_table_2->cs->footerCellClass() ?>"><span id="elf_oms_table_2_cs" class="oms_table_2_cs">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $oms_table_2->po->footerCellClass() ?>"><span id="elf_oms_table_2_po" class="oms_table_2_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->design->Visible) { // design ?>
		<td data-name="design" class="<?php echo $oms_table_2->design->footerCellClass() ?>"><span id="elf_oms_table_2_design" class="oms_table_2_design">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer" class="<?php echo $oms_table_2->size_buyer->footerCellClass() ?>"><span id="elf_oms_table_2_size_buyer" class="oms_table_2_size_buyer">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->width->Visible) { // width ?>
		<td data-name="width" class="<?php echo $oms_table_2->width->footerCellClass() ?>"><span id="elf_oms_table_2_width" class="oms_table_2_width">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->length->Visible) { // length ?>
		<td data-name="length" class="<?php echo $oms_table_2->length->footerCellClass() ?>"><span id="elf_oms_table_2_length" class="oms_table_2_length">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->qty->Visible) { // qty ?>
		<td data-name="qty" class="<?php echo $oms_table_2->qty->footerCellClass() ?>"><span id="elf_oms_table_2_qty" class="oms_table_2_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->revised_qty->Visible) { // revised_qty ?>
		<td data-name="revised_qty" class="<?php echo $oms_table_2->revised_qty->footerCellClass() ?>"><span id="elf_oms_table_2_revised_qty" class="oms_table_2_revised_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $oms_table_2->sqm->footerCellClass() ?>"><span id="elf_oms_table_2_sqm" class="oms_table_2_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->d_qty->Visible) { // d_qty ?>
		<td data-name="d_qty" class="<?php echo $oms_table_2->d_qty->footerCellClass() ?>"><span id="elf_oms_table_2_d_qty" class="oms_table_2_d_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->d_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->pending->Visible) { // pending ?>
		<td data-name="pending" class="<?php echo $oms_table_2->pending->footerCellClass() ?>"><span id="elf_oms_table_2_pending" class="oms_table_2_pending">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->pending->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->pending_sqm->Visible) { // pending_sqm ?>
		<td data-name="pending_sqm" class="<?php echo $oms_table_2->pending_sqm->footerCellClass() ?>"><span id="elf_oms_table_2_pending_sqm" class="oms_table_2_pending_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->pending_sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->offloom->Visible) { // offloom ?>
		<td data-name="offloom" class="<?php echo $oms_table_2->offloom->footerCellClass() ?>"><span id="elf_oms_table_2_offloom" class="oms_table_2_offloom">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->offloom->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->pending_offloom->Visible) { // pending_offloom ?>
		<td data-name="pending_offloom" class="<?php echo $oms_table_2->pending_offloom->footerCellClass() ?>"><span id="elf_oms_table_2_pending_offloom" class="oms_table_2_pending_offloom">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
		<td data-name="pending_offloom_sqm" class="<?php echo $oms_table_2->pending_offloom_sqm->footerCellClass() ?>"><span id="elf_oms_table_2_pending_offloom_sqm" class="oms_table_2_pending_offloom_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->cbm->Visible) { // cbm ?>
		<td data-name="cbm" class="<?php echo $oms_table_2->cbm->footerCellClass() ?>"><span id="elf_oms_table_2_cbm" class="oms_table_2_cbm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->total_cbm->Visible) { // total_cbm ?>
		<td data-name="total_cbm" class="<?php echo $oms_table_2->total_cbm->footerCellClass() ?>"><span id="elf_oms_table_2_total_cbm" class="oms_table_2_total_cbm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works" class="<?php echo $oms_table_2->weaving_works->footerCellClass() ?>"><span id="elf_oms_table_2_weaving_works" class="oms_table_2_weaving_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->current_works->Visible) { // current_works ?>
		<td data-name="current_works" class="<?php echo $oms_table_2->current_works->footerCellClass() ?>"><span id="elf_oms_table_2_current_works" class="oms_table_2_current_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $oms_table_2->remarks->footerCellClass() ?>"><span id="elf_oms_table_2_remarks" class="oms_table_2_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $oms_table_2->pl_no->footerCellClass() ?>"><span id="elf_oms_table_2_pl_no" class="oms_table_2_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date" class="<?php echo $oms_table_2->invoice_date->footerCellClass() ?>"><span id="elf_oms_table_2_invoice_date" class="oms_table_2_invoice_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->sailing_week->Visible) { // sailing_week ?>
		<td data-name="sailing_week" class="<?php echo $oms_table_2->sailing_week->footerCellClass() ?>"><span id="elf_oms_table_2_sailing_week" class="oms_table_2_sailing_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $oms_table_2->status->footerCellClass() ?>"><span id="elf_oms_table_2_status" class="oms_table_2_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->completed->Visible) { // completed ?>
		<td data-name="completed" class="<?php echo $oms_table_2->completed->footerCellClass() ?>"><span id="elf_oms_table_2_completed" class="oms_table_2_completed">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->rejection->Visible) { // rejection ?>
		<td data-name="rejection" class="<?php echo $oms_table_2->rejection->footerCellClass() ?>"><span id="elf_oms_table_2_rejection" class="oms_table_2_rejection">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table_2->rejection->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->label->Visible) { // label ?>
		<td data-name="label" class="<?php echo $oms_table_2->label->footerCellClass() ?>"><span id="elf_oms_table_2_label" class="oms_table_2_label">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table_2->weight_sqm->Visible) { // weight_sqm ?>
		<td data-name="weight_sqm" class="<?php echo $oms_table_2->weight_sqm->footerCellClass() ?>"><span id="elf_oms_table_2_weight_sqm" class="oms_table_2_weight_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$oms_table_2_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$oms_table_2->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($oms_table_2_list->Recordset)
	$oms_table_2_list->Recordset->Close();
?>
<?php if (!$oms_table_2->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$oms_table_2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($oms_table_2_list->Pager)) $oms_table_2_list->Pager = new PrevNextPager($oms_table_2_list->StartRec, $oms_table_2_list->DisplayRecs, $oms_table_2_list->TotalRecs, $oms_table_2_list->AutoHidePager) ?>
<?php if ($oms_table_2_list->Pager->RecordCount > 0 && $oms_table_2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($oms_table_2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($oms_table_2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $oms_table_2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($oms_table_2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($oms_table_2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $oms_table_2_list->pageUrl() ?>start=<?php echo $oms_table_2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $oms_table_2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($oms_table_2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $oms_table_2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $oms_table_2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $oms_table_2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($oms_table_2_list->TotalRecs > 0 && (!$oms_table_2_list->AutoHidePageSizeSelector || $oms_table_2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="oms_table_2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($oms_table_2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($oms_table_2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($oms_table_2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($oms_table_2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($oms_table_2_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($oms_table_2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $oms_table_2_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($oms_table_2_list->TotalRecs == 0 && !$oms_table_2->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $oms_table_2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$oms_table_2_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$oms_table_2->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$oms_table_2->isExport()) { ?>
<script>
ew.scrollableTable("gmp_oms_table_2", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$oms_table_2_list->terminate();
?>