<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$oms_table_2_search = new oms_table_2_search();

// Run the page
$oms_table_2_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$oms_table_2_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($oms_table_2_search->IsModal) { ?>
var foms_table_2search = currentAdvancedSearchForm = new ew.Form("foms_table_2search", "search");
<?php } else { ?>
var foms_table_2search = currentForm = new ew.Form("foms_table_2search", "search");
<?php } ?>

// Form_CustomValidate event
foms_table_2search.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_table_2search.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_table_2search.lists["x_buyers_id"] = <?php echo $oms_table_2_search->buyers_id->Lookup->toClientList() ?>;
foms_table_2search.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_2_search->buyers_id->lookupOptions()) ?>;
foms_table_2search.lists["x_reports_to"] = <?php echo $oms_table_2_search->reports_to->Lookup->toClientList() ?>;
foms_table_2search.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_2_search->reports_to->lookupOptions()) ?>;
foms_table_2search.lists["x_order_week"] = <?php echo $oms_table_2_search->order_week->Lookup->toClientList() ?>;
foms_table_2search.lists["x_order_week"].options = <?php echo JsonEncode($oms_table_2_search->order_week->lookupOptions()) ?>;
foms_table_2search.lists["x_ex_factory"] = <?php echo $oms_table_2_search->ex_factory->Lookup->toClientList() ?>;
foms_table_2search.lists["x_ex_factory"].options = <?php echo JsonEncode($oms_table_2_search->ex_factory->lookupOptions()) ?>;
foms_table_2search.lists["x_ex_factory_p[]"] = <?php echo $oms_table_2_search->ex_factory_p->Lookup->toClientList() ?>;
foms_table_2search.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_2_search->ex_factory_p->lookupOptions()) ?>;
foms_table_2search.lists["x_category"] = <?php echo $oms_table_2_search->category->Lookup->toClientList() ?>;
foms_table_2search.lists["x_category"].options = <?php echo JsonEncode($oms_table_2_search->category->lookupOptions()) ?>;
foms_table_2search.lists["x_cs"] = <?php echo $oms_table_2_search->cs->Lookup->toClientList() ?>;
foms_table_2search.lists["x_cs"].options = <?php echo JsonEncode($oms_table_2_search->cs->options(FALSE, TRUE)) ?>;
foms_table_2search.lists["x_weaving_works"] = <?php echo $oms_table_2_search->weaving_works->Lookup->toClientList() ?>;
foms_table_2search.lists["x_weaving_works"].options = <?php echo JsonEncode($oms_table_2_search->weaving_works->lookupOptions()) ?>;
foms_table_2search.lists["x_current_works"] = <?php echo $oms_table_2_search->current_works->Lookup->toClientList() ?>;
foms_table_2search.lists["x_current_works"].options = <?php echo JsonEncode($oms_table_2_search->current_works->lookupOptions()) ?>;
foms_table_2search.lists["x_status[]"] = <?php echo $oms_table_2_search->status->Lookup->toClientList() ?>;
foms_table_2search.lists["x_status[]"].options = <?php echo JsonEncode($oms_table_2_search->status->lookupOptions()) ?>;
foms_table_2search.lists["x_completed[]"] = <?php echo $oms_table_2_search->completed->Lookup->toClientList() ?>;
foms_table_2search.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_2_search->completed->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

foms_table_2search.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_width");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->width->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_length");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->length->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_revised_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->revised_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->d_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->pending->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->pending_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_offloom");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->offloom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_offloom");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->pending_offloom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_offloom_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->pending_offloom_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table_2->weight_sqm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $oms_table_2_search->showPageHeader(); ?>
<?php
$oms_table_2_search->showMessage();
?>
<form name="foms_table_2search" id="foms_table_2search" class="<?php echo $oms_table_2_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($oms_table_2_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $oms_table_2_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="oms_table_2">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$oms_table_2_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($oms_table_2->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_id"><?php echo $oms_table_2->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->id->cellAttributes() ?>>
			<span id="el_oms_table_2_id">
<input type="text" data-table="oms_table_2" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->id->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->id->EditValue ?>"<?php echo $oms_table_2->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_buyers_id"><?php echo $oms_table_2->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->buyers_id->cellAttributes() ?>>
			<span id="el_oms_table_2_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_buyers_id" data-value-separator="<?php echo $oms_table_2->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $oms_table_2->buyers_id->editAttributes() ?>>
		<?php echo $oms_table_2->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $oms_table_2->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_reports_to"><?php echo $oms_table_2->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->reports_to->cellAttributes() ?>>
			<span id="el_oms_table_2_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_reports_to" data-value-separator="<?php echo $oms_table_2->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $oms_table_2->reports_to->editAttributes() ?>>
		<?php echo $oms_table_2->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $oms_table_2->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->buyer_order->Visible) { // buyer_order ?>
	<div id="r_buyer_order" class="form-group row">
		<label for="x_buyer_order" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_buyer_order"><?php echo $oms_table_2->buyer_order->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->buyer_order->cellAttributes() ?>>
			<span id="el_oms_table_2_buyer_order">
<input type="text" data-table="oms_table_2" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table_2->buyer_order->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->buyer_order->EditValue ?>"<?php echo $oms_table_2->buyer_order->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_item"><?php echo $oms_table_2->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->item->cellAttributes() ?>>
			<span id="el_oms_table_2_item">
<input type="text" data-table="oms_table_2" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table_2->item->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->item->EditValue ?>"<?php echo $oms_table_2->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_buyer_ref"><?php echo $oms_table_2->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->buyer_ref->cellAttributes() ?>>
			<span id="el_oms_table_2_buyer_ref">
<input type="text" data-table="oms_table_2" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($oms_table_2->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->buyer_ref->EditValue ?>"<?php echo $oms_table_2->buyer_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->order_week->Visible) { // order_week ?>
	<div id="r_order_week" class="form-group row">
		<label for="x_order_week" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_order_week"><?php echo $oms_table_2->order_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_week" id="z_order_week" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->order_week->cellAttributes() ?>>
			<span id="el_oms_table_2_order_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_order_week" data-value-separator="<?php echo $oms_table_2->order_week->displayValueSeparatorAttribute() ?>" id="x_order_week" name="x_order_week"<?php echo $oms_table_2->order_week->editAttributes() ?>>
		<?php echo $oms_table_2->order_week->selectOptionListHtml("x_order_week") ?>
	</select>
</div>
<?php echo $oms_table_2->order_week->Lookup->getParamTag("p_x_order_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_order_date"><?php echo $oms_table_2->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->order_date->cellAttributes() ?>>
			<span id="el_oms_table_2_order_date">
<input type="text" data-table="oms_table_2" data-field="x_order_date" data-format="2" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($oms_table_2->order_date->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->order_date->EditValue ?>"<?php echo $oms_table_2->order_date->editAttributes() ?>>
<?php if (!$oms_table_2->order_date->ReadOnly && !$oms_table_2->order_date->Disabled && !isset($oms_table_2->order_date->EditAttrs["readonly"]) && !isset($oms_table_2->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("foms_table_2search", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->ex_factory->Visible) { // ex_factory ?>
	<div id="r_ex_factory" class="form-group row">
		<label for="x_ex_factory" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_ex_factory"><?php echo $oms_table_2->ex_factory->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ex_factory" id="z_ex_factory" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->ex_factory->cellAttributes() ?>>
			<span id="el_oms_table_2_ex_factory">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_ex_factory" data-value-separator="<?php echo $oms_table_2->ex_factory->displayValueSeparatorAttribute() ?>" id="x_ex_factory" name="x_ex_factory"<?php echo $oms_table_2->ex_factory->editAttributes() ?>>
		<?php echo $oms_table_2->ex_factory->selectOptionListHtml("x_ex_factory") ?>
	</select>
</div>
<?php echo $oms_table_2->ex_factory->Lookup->getParamTag("p_x_ex_factory") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->ex_factory_p->Visible) { // ex_factory_p ?>
	<div id="r_ex_factory_p" class="form-group row">
		<label for="x_ex_factory_p" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_ex_factory_p"><?php echo $oms_table_2->ex_factory_p->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->ex_factory_p->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_ex_factory_p" id="z_ex_factory_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->ex_factory_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_2_ex_factory_p">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table_2->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table_2->ex_factory_p->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table_2->ex_factory_p->checkBoxListHtml(TRUE, "x_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table_2" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table_2->ex_factory_p->displayValueSeparatorAttribute() ?>" name="x_ex_factory_p[]" id="x_ex_factory_p[]" value="{value}"<?php echo $oms_table_2->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table_2->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table_2->ex_factory_p->Lookup->getParamTag("p_x_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
			<span class="ew-search-cond btw1_ex_factory_p d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_2_ex_factory_p" class="btw1_ex_factory_p d-none">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table_2->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table_2->ex_factory_p->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table_2->ex_factory_p->checkBoxListHtml(TRUE, "y_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table_2" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table_2->ex_factory_p->displayValueSeparatorAttribute() ?>" name="y_ex_factory_p[]" id="y_ex_factory_p[]" value="{value}"<?php echo $oms_table_2->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table_2->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table_2->ex_factory_p->Lookup->getParamTag("p_y_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->shipping_mode->Visible) { // shipping_mode ?>
	<div id="r_shipping_mode" class="form-group row">
		<label for="x_shipping_mode" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_shipping_mode"><?php echo $oms_table_2->shipping_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_mode" id="z_shipping_mode" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->shipping_mode->cellAttributes() ?>>
			<span id="el_oms_table_2_shipping_mode">
<input type="text" data-table="oms_table_2" data-field="x_shipping_mode" name="x_shipping_mode" id="x_shipping_mode" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($oms_table_2->shipping_mode->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->shipping_mode->EditValue ?>"<?php echo $oms_table_2->shipping_mode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_category"><?php echo $oms_table_2->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->category->cellAttributes() ?>>
			<span id="el_oms_table_2_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_category" data-value-separator="<?php echo $oms_table_2->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $oms_table_2->category->editAttributes() ?>>
		<?php echo $oms_table_2->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $oms_table_2->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->cs->Visible) { // cs ?>
	<div id="r_cs" class="form-group row">
		<label for="x_cs" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_cs"><?php echo $oms_table_2->cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cs" id="z_cs" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->cs->cellAttributes() ?>>
			<span id="el_oms_table_2_cs">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_cs" data-value-separator="<?php echo $oms_table_2->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $oms_table_2->cs->editAttributes() ?>>
		<?php echo $oms_table_2->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_po"><?php echo $oms_table_2->po->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_2_po">
<input type="text" data-table="oms_table_2" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->po->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->po->EditValue ?>"<?php echo $oms_table_2->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_2_po" class="btw1_po d-none">
<input type="text" data-table="oms_table_2" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->po->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->po->EditValue2 ?>"<?php echo $oms_table_2->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_design"><?php echo $oms_table_2->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->design->cellAttributes() ?>>
			<span id="el_oms_table_2_design">
<input type="text" data-table="oms_table_2" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($oms_table_2->design->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->design->EditValue ?>"<?php echo $oms_table_2->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_size_buyer"><?php echo $oms_table_2->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->size_buyer->cellAttributes() ?>>
			<span id="el_oms_table_2_size_buyer">
<input type="text" data-table="oms_table_2" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table_2->size_buyer->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->size_buyer->EditValue ?>"<?php echo $oms_table_2->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->width->Visible) { // width ?>
	<div id="r_width" class="form-group row">
		<label for="x_width" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_width"><?php echo $oms_table_2->width->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_width" id="z_width" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->width->cellAttributes() ?>>
			<span id="el_oms_table_2_width">
<input type="text" data-table="oms_table_2" data-field="x_width" name="x_width" id="x_width" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->width->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->width->EditValue ?>"<?php echo $oms_table_2->width->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->length->Visible) { // length ?>
	<div id="r_length" class="form-group row">
		<label for="x_length" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_length"><?php echo $oms_table_2->length->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_length" id="z_length" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->length->cellAttributes() ?>>
			<span id="el_oms_table_2_length">
<input type="text" data-table="oms_table_2" data-field="x_length" name="x_length" id="x_length" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->length->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->length->EditValue ?>"<?php echo $oms_table_2->length->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_qty"><?php echo $oms_table_2->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->qty->cellAttributes() ?>>
			<span id="el_oms_table_2_qty">
<input type="text" data-table="oms_table_2" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->qty->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->qty->EditValue ?>"<?php echo $oms_table_2->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->revised_qty->Visible) { // revised_qty ?>
	<div id="r_revised_qty" class="form-group row">
		<label for="x_revised_qty" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_revised_qty"><?php echo $oms_table_2->revised_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_revised_qty" id="z_revised_qty" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->revised_qty->cellAttributes() ?>>
			<span id="el_oms_table_2_revised_qty">
<input type="text" data-table="oms_table_2" data-field="x_revised_qty" name="x_revised_qty" id="x_revised_qty" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->revised_qty->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->revised_qty->EditValue ?>"<?php echo $oms_table_2->revised_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_sqm"><?php echo $oms_table_2->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->sqm->cellAttributes() ?>>
			<span id="el_oms_table_2_sqm">
<input type="text" data-table="oms_table_2" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->sqm->EditValue ?>"<?php echo $oms_table_2->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->d_qty->Visible) { // d_qty ?>
	<div id="r_d_qty" class="form-group row">
		<label for="x_d_qty" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_d_qty"><?php echo $oms_table_2->d_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_qty" id="z_d_qty" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->d_qty->cellAttributes() ?>>
			<span id="el_oms_table_2_d_qty">
<input type="text" data-table="oms_table_2" data-field="x_d_qty" name="x_d_qty" id="x_d_qty" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->d_qty->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->d_qty->EditValue ?>"<?php echo $oms_table_2->d_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->pending->Visible) { // pending ?>
	<div id="r_pending" class="form-group row">
		<label for="x_pending" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_pending"><?php echo $oms_table_2->pending->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->pending->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pending" id="z_pending" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->pending->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_2_pending">
<input type="text" data-table="oms_table_2" data-field="x_pending" name="x_pending" id="x_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending->EditValue ?>"<?php echo $oms_table_2->pending->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pending d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_2_pending" class="btw1_pending d-none">
<input type="text" data-table="oms_table_2" data-field="x_pending" name="y_pending" id="y_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending->EditValue2 ?>"<?php echo $oms_table_2->pending->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->pending_sqm->Visible) { // pending_sqm ?>
	<div id="r_pending_sqm" class="form-group row">
		<label for="x_pending_sqm" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_pending_sqm"><?php echo $oms_table_2->pending_sqm->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->pending_sqm->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pending_sqm" id="z_pending_sqm" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table_2->pending_sqm->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_2_pending_sqm">
<input type="text" data-table="oms_table_2" data-field="x_pending_sqm" name="x_pending_sqm" id="x_pending_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending_sqm->EditValue ?>"<?php echo $oms_table_2->pending_sqm->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pending_sqm d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_2_pending_sqm" class="btw1_pending_sqm d-none">
<input type="text" data-table="oms_table_2" data-field="x_pending_sqm" name="y_pending_sqm" id="y_pending_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending_sqm->EditValue2 ?>"<?php echo $oms_table_2->pending_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->offloom->Visible) { // offloom ?>
	<div id="r_offloom" class="form-group row">
		<label for="x_offloom" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_offloom"><?php echo $oms_table_2->offloom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_offloom" id="z_offloom" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->offloom->cellAttributes() ?>>
			<span id="el_oms_table_2_offloom">
<input type="text" data-table="oms_table_2" data-field="x_offloom" name="x_offloom" id="x_offloom" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->offloom->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->offloom->EditValue ?>"<?php echo $oms_table_2->offloom->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->pending_offloom->Visible) { // pending_offloom ?>
	<div id="r_pending_offloom" class="form-group row">
		<label for="x_pending_offloom" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_pending_offloom"><?php echo $oms_table_2->pending_offloom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_offloom" id="z_pending_offloom" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->pending_offloom->cellAttributes() ?>>
			<span id="el_oms_table_2_pending_offloom">
<input type="text" data-table="oms_table_2" data-field="x_pending_offloom" name="x_pending_offloom" id="x_pending_offloom" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending_offloom->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending_offloom->EditValue ?>"<?php echo $oms_table_2->pending_offloom->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
	<div id="r_pending_offloom_sqm" class="form-group row">
		<label for="x_pending_offloom_sqm" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_pending_offloom_sqm"><?php echo $oms_table_2->pending_offloom_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_offloom_sqm" id="z_pending_offloom_sqm" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->pending_offloom_sqm->cellAttributes() ?>>
			<span id="el_oms_table_2_pending_offloom_sqm">
<input type="text" data-table="oms_table_2" data-field="x_pending_offloom_sqm" name="x_pending_offloom_sqm" id="x_pending_offloom_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->pending_offloom_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pending_offloom_sqm->EditValue ?>"<?php echo $oms_table_2->pending_offloom_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_cbm"><?php echo $oms_table_2->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cbm" id="z_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->cbm->cellAttributes() ?>>
			<span id="el_oms_table_2_cbm">
<input type="text" data-table="oms_table_2" data-field="x_cbm" name="x_cbm" id="x_cbm" size="35" placeholder="<?php echo HtmlEncode($oms_table_2->cbm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->cbm->EditValue ?>"<?php echo $oms_table_2->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->total_cbm->Visible) { // total_cbm ?>
	<div id="r_total_cbm" class="form-group row">
		<label for="x_total_cbm" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_total_cbm"><?php echo $oms_table_2->total_cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_total_cbm" id="z_total_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->total_cbm->cellAttributes() ?>>
			<span id="el_oms_table_2_total_cbm">
<input type="text" data-table="oms_table_2" data-field="x_total_cbm" name="x_total_cbm" id="x_total_cbm" size="35" placeholder="<?php echo HtmlEncode($oms_table_2->total_cbm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->total_cbm->EditValue ?>"<?php echo $oms_table_2->total_cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_weaving_works"><?php echo $oms_table_2->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->weaving_works->cellAttributes() ?>>
			<span id="el_oms_table_2_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_weaving_works" data-value-separator="<?php echo $oms_table_2->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $oms_table_2->weaving_works->editAttributes() ?>>
		<?php echo $oms_table_2->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $oms_table_2->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_current_works"><?php echo $oms_table_2->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->current_works->cellAttributes() ?>>
			<span id="el_oms_table_2_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_current_works" data-value-separator="<?php echo $oms_table_2->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $oms_table_2->current_works->editAttributes() ?>>
		<?php echo $oms_table_2->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $oms_table_2->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_remarks"><?php echo $oms_table_2->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->remarks->cellAttributes() ?>>
			<span id="el_oms_table_2_remarks">
<input type="text" data-table="oms_table_2" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($oms_table_2->remarks->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->remarks->EditValue ?>"<?php echo $oms_table_2->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_pl_no"><?php echo $oms_table_2->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->pl_no->cellAttributes() ?>>
			<span id="el_oms_table_2_pl_no">
<input type="text" data-table="oms_table_2" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" placeholder="<?php echo HtmlEncode($oms_table_2->pl_no->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->pl_no->EditValue ?>"<?php echo $oms_table_2->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_invoice_date"><?php echo $oms_table_2->invoice_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_date" id="z_invoice_date" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->invoice_date->cellAttributes() ?>>
			<span id="el_oms_table_2_invoice_date">
<input type="text" data-table="oms_table_2" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" size="35" placeholder="<?php echo HtmlEncode($oms_table_2->invoice_date->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->invoice_date->EditValue ?>"<?php echo $oms_table_2->invoice_date->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->sailing_week->Visible) { // sailing_week ?>
	<div id="r_sailing_week" class="form-group row">
		<label for="x_sailing_week" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_sailing_week"><?php echo $oms_table_2->sailing_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sailing_week" id="z_sailing_week" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->sailing_week->cellAttributes() ?>>
			<span id="el_oms_table_2_sailing_week">
<input type="text" data-table="oms_table_2" data-field="x_sailing_week" name="x_sailing_week" id="x_sailing_week" size="35" placeholder="<?php echo HtmlEncode($oms_table_2->sailing_week->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->sailing_week->EditValue ?>"<?php echo $oms_table_2->sailing_week->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_status"><?php echo $oms_table_2->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_status" id="z_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->status->cellAttributes() ?>>
			<span id="el_oms_table_2_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table_2" data-field="x_status" data-value-separator="<?php echo $oms_table_2->status->displayValueSeparatorAttribute() ?>" id="x_status[]" name="x_status[]" multiple="multiple"<?php echo $oms_table_2->status->editAttributes() ?>>
		<?php echo $oms_table_2->status->selectOptionListHtml("x_status[]") ?>
	</select>
</div>
<?php echo $oms_table_2->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_completed"><?php echo $oms_table_2->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_completed" id="z_completed" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->completed->cellAttributes() ?>>
			<span id="el_oms_table_2_completed">
<div id="tp_x_completed" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table_2" data-field="x_completed" data-value-separator="<?php echo $oms_table_2->completed->displayValueSeparatorAttribute() ?>" name="x_completed[]" id="x_completed[]" value="{value}"<?php echo $oms_table_2->completed->editAttributes() ?>></div>
<div id="dsl_x_completed" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $oms_table_2->completed->checkBoxListHtml(FALSE, "x_completed[]") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->label->Visible) { // label ?>
	<div id="r_label" class="form-group row">
		<label for="x_label" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_label"><?php echo $oms_table_2->label->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_label" id="z_label" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->label->cellAttributes() ?>>
			<span id="el_oms_table_2_label">
<input type="text" data-table="oms_table_2" data-field="x_label" name="x_label" id="x_label" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table_2->label->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->label->EditValue ?>"<?php echo $oms_table_2->label->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table_2->weight_sqm->Visible) { // weight_sqm ?>
	<div id="r_weight_sqm" class="form-group row">
		<label for="x_weight_sqm" class="<?php echo $oms_table_2_search->LeftColumnClass ?>"><span id="elh_oms_table_2_weight_sqm"><?php echo $oms_table_2->weight_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_sqm" id="z_weight_sqm" value="="></span>
		</label>
		<div class="<?php echo $oms_table_2_search->RightColumnClass ?>"><div<?php echo $oms_table_2->weight_sqm->cellAttributes() ?>>
			<span id="el_oms_table_2_weight_sqm">
<input type="text" data-table="oms_table_2" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table_2->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table_2->weight_sqm->EditValue ?>"<?php echo $oms_table_2->weight_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$oms_table_2_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $oms_table_2_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$oms_table_2_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$oms_table_2_search->terminate();
?>