<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$oms_table_edit = new oms_table_edit();

// Run the page
$oms_table_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$oms_table_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var foms_tableedit = currentForm = new ew.Form("foms_tableedit", "edit");

// Validate form
foms_tableedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($oms_table_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->id->caption(), $oms_table->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->buyers_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyers_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->buyers_id->caption(), $oms_table->buyers_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->reports_to->caption(), $oms_table->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->buyer_order->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->buyer_order->caption(), $oms_table->buyer_order->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->item->caption(), $oms_table->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->buyer_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->buyer_ref->caption(), $oms_table->buyer_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->order_week->Required) { ?>
			elm = this.getElements("x" + infix + "_order_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->order_week->caption(), $oms_table->order_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->order_date->caption(), $oms_table->order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->ex_factory->Required) { ?>
			elm = this.getElements("x" + infix + "_ex_factory");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->ex_factory->caption(), $oms_table->ex_factory->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->ex_factory_p->Required) { ?>
			elm = this.getElements("x" + infix + "_ex_factory_p[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->ex_factory_p->caption(), $oms_table->ex_factory_p->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->shipping_mode->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_mode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->shipping_mode->caption(), $oms_table->shipping_mode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->po->caption(), $oms_table->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->design->Required) { ?>
			elm = this.getElements("x" + infix + "_design");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->design->caption(), $oms_table->design->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->size_buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_size_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->size_buyer->caption(), $oms_table->size_buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->width->Required) { ?>
			elm = this.getElements("x" + infix + "_width");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->width->caption(), $oms_table->width->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->length->Required) { ?>
			elm = this.getElements("x" + infix + "_length");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->length->caption(), $oms_table->length->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->qty->Required) { ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->qty->caption(), $oms_table->qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->revised_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_revised_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->revised_qty->caption(), $oms_table->revised_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->sqm->caption(), $oms_table->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->d_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_d_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->d_qty->caption(), $oms_table->d_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->pending->Required) { ?>
			elm = this.getElements("x" + infix + "_pending");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->pending->caption(), $oms_table->pending->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->pending_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_pending_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->pending_sqm->caption(), $oms_table->pending_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->offloom->Required) { ?>
			elm = this.getElements("x" + infix + "_offloom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->offloom->caption(), $oms_table->offloom->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->pending_offloom->Required) { ?>
			elm = this.getElements("x" + infix + "_pending_offloom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->pending_offloom->caption(), $oms_table->pending_offloom->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->pending_offloom_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_pending_offloom_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->pending_offloom_sqm->caption(), $oms_table->pending_offloom_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->cbm->caption(), $oms_table->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->total_cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_total_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->total_cbm->caption(), $oms_table->total_cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->remarks->caption(), $oms_table->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->pl_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->pl_no->caption(), $oms_table->pl_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->invoice_date->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->invoice_date->caption(), $oms_table->invoice_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->sailing_week->Required) { ?>
			elm = this.getElements("x" + infix + "_sailing_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->sailing_week->caption(), $oms_table->sailing_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->seller_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_seller_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->seller_remarks->caption(), $oms_table->seller_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->status->caption(), $oms_table->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->rejection->Required) { ?>
			elm = this.getElements("x" + infix + "_rejection");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->rejection->caption(), $oms_table->rejection->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($oms_table_edit->weight_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_weight_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $oms_table->weight_sqm->caption(), $oms_table->weight_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weight_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($oms_table->weight_sqm->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
foms_tableedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_tableedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_tableedit.lists["x_buyers_id"] = <?php echo $oms_table_edit->buyers_id->Lookup->toClientList() ?>;
foms_tableedit.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_edit->buyers_id->lookupOptions()) ?>;
foms_tableedit.lists["x_reports_to"] = <?php echo $oms_table_edit->reports_to->Lookup->toClientList() ?>;
foms_tableedit.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_edit->reports_to->lookupOptions()) ?>;
foms_tableedit.lists["x_order_week"] = <?php echo $oms_table_edit->order_week->Lookup->toClientList() ?>;
foms_tableedit.lists["x_order_week"].options = <?php echo JsonEncode($oms_table_edit->order_week->lookupOptions()) ?>;
foms_tableedit.lists["x_ex_factory"] = <?php echo $oms_table_edit->ex_factory->Lookup->toClientList() ?>;
foms_tableedit.lists["x_ex_factory"].options = <?php echo JsonEncode($oms_table_edit->ex_factory->lookupOptions()) ?>;
foms_tableedit.lists["x_ex_factory_p[]"] = <?php echo $oms_table_edit->ex_factory_p->Lookup->toClientList() ?>;
foms_tableedit.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_edit->ex_factory_p->lookupOptions()) ?>;
foms_tableedit.lists["x_status[]"] = <?php echo $oms_table_edit->status->Lookup->toClientList() ?>;
foms_tableedit.lists["x_status[]"].options = <?php echo JsonEncode($oms_table_edit->status->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $oms_table_edit->showPageHeader(); ?>
<?php
$oms_table_edit->showMessage();
?>
<form name="foms_tableedit" id="foms_tableedit" class="<?php echo $oms_table_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($oms_table_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $oms_table_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="oms_table">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$oms_table_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($oms_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_oms_table_id" for="x_id" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->id->caption() ?><?php echo ($oms_table->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->id->cellAttributes() ?>>
<span id="el_oms_table_id">
<span<?php echo $oms_table->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($oms_table->id->CurrentValue) ?>">
<?php echo $oms_table->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label id="elh_oms_table_buyers_id" for="x_buyers_id" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->buyers_id->caption() ?><?php echo ($oms_table->buyers_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->buyers_id->cellAttributes() ?>>
<span id="el_oms_table_buyers_id">
<span<?php echo $oms_table->buyers_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->buyers_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_buyers_id" name="x_buyers_id" id="x_buyers_id" value="<?php echo HtmlEncode($oms_table->buyers_id->CurrentValue) ?>">
<?php echo $oms_table->buyers_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_oms_table_reports_to" for="x_reports_to" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->reports_to->caption() ?><?php echo ($oms_table->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->reports_to->cellAttributes() ?>>
<span id="el_oms_table_reports_to">
<span<?php echo $oms_table->reports_to->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->reports_to->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_reports_to" name="x_reports_to" id="x_reports_to" value="<?php echo HtmlEncode($oms_table->reports_to->CurrentValue) ?>">
<?php echo $oms_table->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
	<div id="r_buyer_order" class="form-group row">
		<label id="elh_oms_table_buyer_order" for="x_buyer_order" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->buyer_order->caption() ?><?php echo ($oms_table->buyer_order->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->buyer_order->cellAttributes() ?>>
<span id="el_oms_table_buyer_order">
<span<?php echo $oms_table->buyer_order->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->buyer_order->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" value="<?php echo HtmlEncode($oms_table->buyer_order->CurrentValue) ?>">
<?php echo $oms_table->buyer_order->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_oms_table_item" for="x_item" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->item->caption() ?><?php echo ($oms_table->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->item->cellAttributes() ?>>
<span id="el_oms_table_item">
<span<?php echo $oms_table->item->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->item->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_item" name="x_item" id="x_item" value="<?php echo HtmlEncode($oms_table->item->CurrentValue) ?>">
<?php echo $oms_table->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label id="elh_oms_table_buyer_ref" for="x_buyer_ref" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->buyer_ref->caption() ?><?php echo ($oms_table->buyer_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->buyer_ref->cellAttributes() ?>>
<span id="el_oms_table_buyer_ref">
<span<?php echo $oms_table->buyer_ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->buyer_ref->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($oms_table->buyer_ref->CurrentValue) ?>">
<?php echo $oms_table->buyer_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->order_week->Visible) { // order_week ?>
	<div id="r_order_week" class="form-group row">
		<label id="elh_oms_table_order_week" for="x_order_week" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->order_week->caption() ?><?php echo ($oms_table->order_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->order_week->cellAttributes() ?>>
<span id="el_oms_table_order_week">
<span<?php echo $oms_table->order_week->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->order_week->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_order_week" name="x_order_week" id="x_order_week" value="<?php echo HtmlEncode($oms_table->order_week->CurrentValue) ?>">
<?php echo $oms_table->order_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label id="elh_oms_table_order_date" for="x_order_date" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->order_date->caption() ?><?php echo ($oms_table->order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->order_date->cellAttributes() ?>>
<span id="el_oms_table_order_date">
<span<?php echo $oms_table->order_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->order_date->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_order_date" name="x_order_date" id="x_order_date" value="<?php echo HtmlEncode($oms_table->order_date->CurrentValue) ?>">
<?php echo $oms_table->order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->ex_factory->Visible) { // ex_factory ?>
	<div id="r_ex_factory" class="form-group row">
		<label id="elh_oms_table_ex_factory" for="x_ex_factory" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->ex_factory->caption() ?><?php echo ($oms_table->ex_factory->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->ex_factory->cellAttributes() ?>>
<span id="el_oms_table_ex_factory">
<span<?php echo $oms_table->ex_factory->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->ex_factory->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_ex_factory" name="x_ex_factory" id="x_ex_factory" value="<?php echo HtmlEncode($oms_table->ex_factory->CurrentValue) ?>">
<?php echo $oms_table->ex_factory->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
	<div id="r_ex_factory_p" class="form-group row">
		<label id="elh_oms_table_ex_factory_p" for="x_ex_factory_p" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->ex_factory_p->caption() ?><?php echo ($oms_table->ex_factory_p->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->ex_factory_p->cellAttributes() ?>>
<span id="el_oms_table_ex_factory_p">
<span<?php echo $oms_table->ex_factory_p->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->ex_factory_p->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_ex_factory_p" name="x_ex_factory_p" id="x_ex_factory_p" value="<?php echo HtmlEncode($oms_table->ex_factory_p->CurrentValue) ?>">
<?php echo $oms_table->ex_factory_p->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->shipping_mode->Visible) { // shipping_mode ?>
	<div id="r_shipping_mode" class="form-group row">
		<label id="elh_oms_table_shipping_mode" for="x_shipping_mode" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->shipping_mode->caption() ?><?php echo ($oms_table->shipping_mode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->shipping_mode->cellAttributes() ?>>
<span id="el_oms_table_shipping_mode">
<span<?php echo $oms_table->shipping_mode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->shipping_mode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_shipping_mode" name="x_shipping_mode" id="x_shipping_mode" value="<?php echo HtmlEncode($oms_table->shipping_mode->CurrentValue) ?>">
<?php echo $oms_table->shipping_mode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_oms_table_po" for="x_po" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->po->caption() ?><?php echo ($oms_table->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->po->cellAttributes() ?>>
<span id="el_oms_table_po">
<span<?php echo $oms_table->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($oms_table->po->CurrentValue) ?>">
<?php echo $oms_table->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label id="elh_oms_table_design" for="x_design" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->design->caption() ?><?php echo ($oms_table->design->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->design->cellAttributes() ?>>
<span id="el_oms_table_design">
<span<?php echo $oms_table->design->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->design->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_design" name="x_design" id="x_design" value="<?php echo HtmlEncode($oms_table->design->CurrentValue) ?>">
<?php echo $oms_table->design->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label id="elh_oms_table_size_buyer" for="x_size_buyer" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->size_buyer->caption() ?><?php echo ($oms_table->size_buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->size_buyer->cellAttributes() ?>>
<span id="el_oms_table_size_buyer">
<span<?php echo $oms_table->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->size_buyer->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" value="<?php echo HtmlEncode($oms_table->size_buyer->CurrentValue) ?>">
<?php echo $oms_table->size_buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->width->Visible) { // width ?>
	<div id="r_width" class="form-group row">
		<label id="elh_oms_table_width" for="x_width" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->width->caption() ?><?php echo ($oms_table->width->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->width->cellAttributes() ?>>
<span id="el_oms_table_width">
<span<?php echo $oms_table->width->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->width->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_width" name="x_width" id="x_width" value="<?php echo HtmlEncode($oms_table->width->CurrentValue) ?>">
<?php echo $oms_table->width->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->length->Visible) { // length ?>
	<div id="r_length" class="form-group row">
		<label id="elh_oms_table_length" for="x_length" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->length->caption() ?><?php echo ($oms_table->length->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->length->cellAttributes() ?>>
<span id="el_oms_table_length">
<span<?php echo $oms_table->length->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->length->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_length" name="x_length" id="x_length" value="<?php echo HtmlEncode($oms_table->length->CurrentValue) ?>">
<?php echo $oms_table->length->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label id="elh_oms_table_qty" for="x_qty" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->qty->caption() ?><?php echo ($oms_table->qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->qty->cellAttributes() ?>>
<span id="el_oms_table_qty">
<span<?php echo $oms_table->qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_qty" name="x_qty" id="x_qty" value="<?php echo HtmlEncode($oms_table->qty->CurrentValue) ?>">
<?php echo $oms_table->qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->revised_qty->Visible) { // revised_qty ?>
	<div id="r_revised_qty" class="form-group row">
		<label id="elh_oms_table_revised_qty" for="x_revised_qty" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->revised_qty->caption() ?><?php echo ($oms_table->revised_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->revised_qty->cellAttributes() ?>>
<span id="el_oms_table_revised_qty">
<span<?php echo $oms_table->revised_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->revised_qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_revised_qty" name="x_revised_qty" id="x_revised_qty" value="<?php echo HtmlEncode($oms_table->revised_qty->CurrentValue) ?>">
<?php echo $oms_table->revised_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_oms_table_sqm" for="x_sqm" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->sqm->caption() ?><?php echo ($oms_table->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->sqm->cellAttributes() ?>>
<span id="el_oms_table_sqm">
<span<?php echo $oms_table->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_sqm" name="x_sqm" id="x_sqm" value="<?php echo HtmlEncode($oms_table->sqm->CurrentValue) ?>">
<?php echo $oms_table->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->d_qty->Visible) { // d_qty ?>
	<div id="r_d_qty" class="form-group row">
		<label id="elh_oms_table_d_qty" for="x_d_qty" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->d_qty->caption() ?><?php echo ($oms_table->d_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->d_qty->cellAttributes() ?>>
<span id="el_oms_table_d_qty">
<span<?php echo $oms_table->d_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->d_qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_d_qty" name="x_d_qty" id="x_d_qty" value="<?php echo HtmlEncode($oms_table->d_qty->CurrentValue) ?>">
<?php echo $oms_table->d_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending->Visible) { // pending ?>
	<div id="r_pending" class="form-group row">
		<label id="elh_oms_table_pending" for="x_pending" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->pending->caption() ?><?php echo ($oms_table->pending->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->pending->cellAttributes() ?>>
<span id="el_oms_table_pending">
<span<?php echo $oms_table->pending->viewAttributes() ?>>
<?php if ((!EmptyString($oms_table->pending->EditValue)) && $oms_table->pending->linkAttributes() <> "") { ?>
<a<?php echo $oms_table->pending->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pending->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pending->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pending" name="x_pending" id="x_pending" value="<?php echo HtmlEncode($oms_table->pending->CurrentValue) ?>">
<?php echo $oms_table->pending->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending_sqm->Visible) { // pending_sqm ?>
	<div id="r_pending_sqm" class="form-group row">
		<label id="elh_oms_table_pending_sqm" for="x_pending_sqm" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->pending_sqm->caption() ?><?php echo ($oms_table->pending_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->pending_sqm->cellAttributes() ?>>
<span id="el_oms_table_pending_sqm">
<span<?php echo $oms_table->pending_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pending_sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pending_sqm" name="x_pending_sqm" id="x_pending_sqm" value="<?php echo HtmlEncode($oms_table->pending_sqm->CurrentValue) ?>">
<?php echo $oms_table->pending_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->offloom->Visible) { // offloom ?>
	<div id="r_offloom" class="form-group row">
		<label id="elh_oms_table_offloom" for="x_offloom" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->offloom->caption() ?><?php echo ($oms_table->offloom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->offloom->cellAttributes() ?>>
<span id="el_oms_table_offloom">
<span<?php echo $oms_table->offloom->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->offloom->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_offloom" name="x_offloom" id="x_offloom" value="<?php echo HtmlEncode($oms_table->offloom->CurrentValue) ?>">
<?php echo $oms_table->offloom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending_offloom->Visible) { // pending_offloom ?>
	<div id="r_pending_offloom" class="form-group row">
		<label id="elh_oms_table_pending_offloom" for="x_pending_offloom" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->pending_offloom->caption() ?><?php echo ($oms_table->pending_offloom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->pending_offloom->cellAttributes() ?>>
<span id="el_oms_table_pending_offloom">
<span<?php echo $oms_table->pending_offloom->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pending_offloom->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pending_offloom" name="x_pending_offloom" id="x_pending_offloom" value="<?php echo HtmlEncode($oms_table->pending_offloom->CurrentValue) ?>">
<?php echo $oms_table->pending_offloom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
	<div id="r_pending_offloom_sqm" class="form-group row">
		<label id="elh_oms_table_pending_offloom_sqm" for="x_pending_offloom_sqm" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->pending_offloom_sqm->caption() ?><?php echo ($oms_table->pending_offloom_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->pending_offloom_sqm->cellAttributes() ?>>
<span id="el_oms_table_pending_offloom_sqm">
<span<?php echo $oms_table->pending_offloom_sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pending_offloom_sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pending_offloom_sqm" name="x_pending_offloom_sqm" id="x_pending_offloom_sqm" value="<?php echo HtmlEncode($oms_table->pending_offloom_sqm->CurrentValue) ?>">
<?php echo $oms_table->pending_offloom_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_oms_table_cbm" for="x_cbm" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->cbm->caption() ?><?php echo ($oms_table->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->cbm->cellAttributes() ?>>
<span id="el_oms_table_cbm">
<span<?php echo $oms_table->cbm->viewAttributes() ?>>
<?php echo $oms_table->cbm->EditValue ?></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_cbm" name="x_cbm" id="x_cbm" value="<?php echo HtmlEncode($oms_table->cbm->CurrentValue) ?>">
<?php echo $oms_table->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->total_cbm->Visible) { // total_cbm ?>
	<div id="r_total_cbm" class="form-group row">
		<label id="elh_oms_table_total_cbm" for="x_total_cbm" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->total_cbm->caption() ?><?php echo ($oms_table->total_cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->total_cbm->cellAttributes() ?>>
<span id="el_oms_table_total_cbm">
<span<?php echo $oms_table->total_cbm->viewAttributes() ?>>
<?php echo $oms_table->total_cbm->EditValue ?></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_total_cbm" name="x_total_cbm" id="x_total_cbm" value="<?php echo HtmlEncode($oms_table->total_cbm->CurrentValue) ?>">
<?php echo $oms_table->total_cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_oms_table_remarks" for="x_remarks" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->remarks->caption() ?><?php echo ($oms_table->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->remarks->cellAttributes() ?>>
<span id="el_oms_table_remarks">
<span<?php echo $oms_table->remarks->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->remarks->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_remarks" name="x_remarks" id="x_remarks" value="<?php echo HtmlEncode($oms_table->remarks->CurrentValue) ?>">
<?php echo $oms_table->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label id="elh_oms_table_pl_no" for="x_pl_no" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->pl_no->caption() ?><?php echo ($oms_table->pl_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->pl_no->cellAttributes() ?>>
<span id="el_oms_table_pl_no">
<span<?php echo $oms_table->pl_no->viewAttributes() ?>>
<?php if ((!EmptyString($oms_table->pl_no->EditValue)) && $oms_table->pl_no->linkAttributes() <> "") { ?>
<a<?php echo $oms_table->pl_no->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pl_no->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->pl_no->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" value="<?php echo HtmlEncode($oms_table->pl_no->CurrentValue) ?>">
<?php echo $oms_table->pl_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label id="elh_oms_table_invoice_date" for="x_invoice_date" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->invoice_date->caption() ?><?php echo ($oms_table->invoice_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->invoice_date->cellAttributes() ?>>
<span id="el_oms_table_invoice_date">
<span<?php echo $oms_table->invoice_date->viewAttributes() ?>>
<?php echo $oms_table->invoice_date->EditValue ?></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" value="<?php echo HtmlEncode($oms_table->invoice_date->CurrentValue) ?>">
<?php echo $oms_table->invoice_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->sailing_week->Visible) { // sailing_week ?>
	<div id="r_sailing_week" class="form-group row">
		<label id="elh_oms_table_sailing_week" for="x_sailing_week" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->sailing_week->caption() ?><?php echo ($oms_table->sailing_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->sailing_week->cellAttributes() ?>>
<span id="el_oms_table_sailing_week">
<span<?php echo $oms_table->sailing_week->viewAttributes() ?>>
<?php echo $oms_table->sailing_week->EditValue ?></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_sailing_week" name="x_sailing_week" id="x_sailing_week" value="<?php echo HtmlEncode($oms_table->sailing_week->CurrentValue) ?>">
<?php echo $oms_table->sailing_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->seller_remarks->Visible) { // seller_remarks ?>
	<div id="r_seller_remarks" class="form-group row">
		<label id="elh_oms_table_seller_remarks" for="x_seller_remarks" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->seller_remarks->caption() ?><?php echo ($oms_table->seller_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->seller_remarks->cellAttributes() ?>>
<span id="el_oms_table_seller_remarks">
<textarea data-table="oms_table" data-field="x_seller_remarks" name="x_seller_remarks" id="x_seller_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($oms_table->seller_remarks->getPlaceHolder()) ?>"<?php echo $oms_table->seller_remarks->editAttributes() ?>><?php echo $oms_table->seller_remarks->EditValue ?></textarea>
</span>
<?php echo $oms_table->seller_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_oms_table_status" for="x_status" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->status->caption() ?><?php echo ($oms_table->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->status->cellAttributes() ?>>
<span id="el_oms_table_status">
<span<?php echo $oms_table->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->status->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($oms_table->status->CurrentValue) ?>">
<?php echo $oms_table->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->rejection->Visible) { // rejection ?>
	<div id="r_rejection" class="form-group row">
		<label id="elh_oms_table_rejection" for="x_rejection" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->rejection->caption() ?><?php echo ($oms_table->rejection->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->rejection->cellAttributes() ?>>
<span id="el_oms_table_rejection">
<span<?php echo $oms_table->rejection->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($oms_table->rejection->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="oms_table" data-field="x_rejection" name="x_rejection" id="x_rejection" value="<?php echo HtmlEncode($oms_table->rejection->CurrentValue) ?>">
<?php echo $oms_table->rejection->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($oms_table->weight_sqm->Visible) { // weight_sqm ?>
	<div id="r_weight_sqm" class="form-group row">
		<label id="elh_oms_table_weight_sqm" for="x_weight_sqm" class="<?php echo $oms_table_edit->LeftColumnClass ?>"><?php echo $oms_table->weight_sqm->caption() ?><?php echo ($oms_table->weight_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $oms_table_edit->RightColumnClass ?>"><div<?php echo $oms_table->weight_sqm->cellAttributes() ?>>
<span id="el_oms_table_weight_sqm">
<input type="text" data-table="oms_table" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table->weight_sqm->EditValue ?>"<?php echo $oms_table->weight_sqm->editAttributes() ?>>
</span>
<?php echo $oms_table->weight_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$oms_table_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $oms_table_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $oms_table_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$oms_table_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$oms_table_edit->terminate();
?>