<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$oms_table_list = new oms_table_list();

// Run the page
$oms_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$oms_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$oms_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var foms_tablelist = currentForm = new ew.Form("foms_tablelist", "list");
foms_tablelist.formKeyCountName = '<?php echo $oms_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
foms_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_tablelist.lists["x_buyers_id"] = <?php echo $oms_table_list->buyers_id->Lookup->toClientList() ?>;
foms_tablelist.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_list->buyers_id->lookupOptions()) ?>;
foms_tablelist.lists["x_reports_to"] = <?php echo $oms_table_list->reports_to->Lookup->toClientList() ?>;
foms_tablelist.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_list->reports_to->lookupOptions()) ?>;
foms_tablelist.lists["x_order_week"] = <?php echo $oms_table_list->order_week->Lookup->toClientList() ?>;
foms_tablelist.lists["x_order_week"].options = <?php echo JsonEncode($oms_table_list->order_week->lookupOptions()) ?>;
foms_tablelist.lists["x_ex_factory"] = <?php echo $oms_table_list->ex_factory->Lookup->toClientList() ?>;
foms_tablelist.lists["x_ex_factory"].options = <?php echo JsonEncode($oms_table_list->ex_factory->lookupOptions()) ?>;
foms_tablelist.lists["x_ex_factory_p[]"] = <?php echo $oms_table_list->ex_factory_p->Lookup->toClientList() ?>;
foms_tablelist.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_list->ex_factory_p->lookupOptions()) ?>;
foms_tablelist.lists["x_status[]"] = <?php echo $oms_table_list->status->Lookup->toClientList() ?>;
foms_tablelist.lists["x_status[]"].options = <?php echo JsonEncode($oms_table_list->status->lookupOptions()) ?>;
foms_tablelist.lists["x_completed[]"] = <?php echo $oms_table_list->completed->Lookup->toClientList() ?>;
foms_tablelist.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_list->completed->options(FALSE, TRUE)) ?>;

// Form object for search
var foms_tablelistsrch = currentSearchForm = new ew.Form("foms_tablelistsrch");

// Validate function for search
foms_tablelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->pending->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
foms_tablelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_tablelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_tablelistsrch.lists["x_buyers_id"] = <?php echo $oms_table_list->buyers_id->Lookup->toClientList() ?>;
foms_tablelistsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_list->buyers_id->lookupOptions()) ?>;
foms_tablelistsrch.lists["x_reports_to"] = <?php echo $oms_table_list->reports_to->Lookup->toClientList() ?>;
foms_tablelistsrch.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_list->reports_to->lookupOptions()) ?>;
foms_tablelistsrch.lists["x_ex_factory_p[]"] = <?php echo $oms_table_list->ex_factory_p->Lookup->toClientList() ?>;
foms_tablelistsrch.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_list->ex_factory_p->lookupOptions()) ?>;
foms_tablelistsrch.lists["x_completed[]"] = <?php echo $oms_table_list->completed->Lookup->toClientList() ?>;
foms_tablelistsrch.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_list->completed->options(FALSE, TRUE)) ?>;

// Filters
foms_tablelistsrch.filterList = <?php echo $oms_table_list->getFilterList() ?>;

// Init search panel as collapsed
foms_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$oms_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($oms_table_list->TotalRecs > 0 && $oms_table_list->ExportOptions->visible()) { ?>
<?php $oms_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($oms_table_list->ImportOptions->visible()) { ?>
<?php $oms_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($oms_table_list->SearchOptions->visible()) { ?>
<?php $oms_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($oms_table_list->FilterOptions->visible()) { ?>
<?php $oms_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$oms_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$oms_table->isExport() && !$oms_table->CurrentAction) { ?>
<form name="foms_tablelistsrch" id="foms_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($oms_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="foms_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="oms_table">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$oms_table_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$oms_table->RowType = ROWTYPE_SEARCH;

// Render row
$oms_table->resetAttributes();
$oms_table_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label for="x_buyers_id" class="ew-search-caption ew-label"><?php echo $oms_table->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_buyers_id" data-value-separator="<?php echo $oms_table->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $oms_table->buyers_id->editAttributes() ?>>
		<?php echo $oms_table->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $oms_table->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
	<div id="xsc_reports_to" class="ew-cell form-group">
		<label for="x_reports_to" class="ew-search-caption ew-label"><?php echo $oms_table->reports_to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_reports_to" data-value-separator="<?php echo $oms_table->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $oms_table->reports_to->editAttributes() ?>>
		<?php echo $oms_table->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $oms_table->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
	</div>
<?php } ?>
<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
	<div id="xsc_buyer_order" class="ew-cell form-group">
		<label for="x_buyer_order" class="ew-search-caption ew-label"><?php echo $oms_table->buyer_order->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table->buyer_order->getPlaceHolder()) ?>" value="<?php echo $oms_table->buyer_order->EditValue ?>"<?php echo $oms_table->buyer_order->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
	<div id="xsc_ex_factory_p" class="ew-cell form-group">
		<label for="x_ex_factory_p" class="ew-search-caption ew-label"><?php echo $oms_table->ex_factory_p->caption() ?></label>
		<span class="ew-search-operator"><select name="z_ex_factory_p" id="z_ex_factory_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table->ex_factory_p->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table->ex_factory_p->checkBoxListHtml(TRUE, "x_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table->ex_factory_p->displayValueSeparatorAttribute() ?>" name="x_ex_factory_p[]" id="x_ex_factory_p[]" value="{value}"<?php echo $oms_table->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table->ex_factory_p->Lookup->getParamTag("p_x_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		<span class="ew-search-cond btw1_ex_factory_p style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_ex_factory_p style="d-none"">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table->ex_factory_p->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table->ex_factory_p->checkBoxListHtml(TRUE, "y_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table->ex_factory_p->displayValueSeparatorAttribute() ?>" name="y_ex_factory_p[]" id="y_ex_factory_p[]" value="{value}"<?php echo $oms_table->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table->ex_factory_p->Lookup->getParamTag("p_y_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
<?php if ($oms_table->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $oms_table->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($oms_table->po->getPlaceHolder()) ?>" value="<?php echo $oms_table->po->EditValue ?>"<?php echo $oms_table->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="oms_table" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($oms_table->po->getPlaceHolder()) ?>" value="<?php echo $oms_table->po->EditValue2 ?>"<?php echo $oms_table->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($oms_table->design->Visible) { // design ?>
	<div id="xsc_design" class="ew-cell form-group">
		<label for="x_design" class="ew-search-caption ew-label"><?php echo $oms_table->design->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($oms_table->design->getPlaceHolder()) ?>" value="<?php echo $oms_table->design->EditValue ?>"<?php echo $oms_table->design->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($oms_table->pending->Visible) { // pending ?>
	<div id="xsc_pending" class="ew-cell form-group">
		<label for="x_pending" class="ew-search-caption ew-label"><?php echo $oms_table->pending->caption() ?></label>
		<span class="ew-search-operator"><select name="z_pending" id="z_pending" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table" data-field="x_pending" name="x_pending" id="x_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending->EditValue ?>"<?php echo $oms_table->pending->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_pending style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_pending style="d-none"">
<input type="text" data-table="oms_table" data-field="x_pending" name="y_pending" id="y_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending->EditValue2 ?>"<?php echo $oms_table->pending->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
	<div id="xsc_pl_no" class="ew-cell form-group">
		<label for="x_pl_no" class="ew-search-caption ew-label"><?php echo $oms_table->pl_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="oms_table" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" placeholder="<?php echo HtmlEncode($oms_table->pl_no->getPlaceHolder()) ?>" value="<?php echo $oms_table->pl_no->EditValue ?>"<?php echo $oms_table->pl_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($oms_table->completed->Visible) { // completed ?>
	<div id="xsc_completed" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $oms_table->completed->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_completed" id="z_completed" value="LIKE"></span>
		<span class="ew-search-field">
<div id="tp_x_completed" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table" data-field="x_completed" data-value-separator="<?php echo $oms_table->completed->displayValueSeparatorAttribute() ?>" name="x_completed[]" id="x_completed[]" value="{value}"<?php echo $oms_table->completed->editAttributes() ?>></div>
<div id="dsl_x_completed" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $oms_table->completed->checkBoxListHtml(FALSE, "x_completed[]") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($oms_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($oms_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $oms_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($oms_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($oms_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($oms_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($oms_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $oms_table_list->showPageHeader(); ?>
<?php
$oms_table_list->showMessage();
?>
<?php if ($oms_table_list->TotalRecs > 0 || $oms_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($oms_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> oms_table">
<?php if (!$oms_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$oms_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($oms_table_list->Pager)) $oms_table_list->Pager = new PrevNextPager($oms_table_list->StartRec, $oms_table_list->DisplayRecs, $oms_table_list->TotalRecs, $oms_table_list->AutoHidePager) ?>
<?php if ($oms_table_list->Pager->RecordCount > 0 && $oms_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($oms_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($oms_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $oms_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($oms_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($oms_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $oms_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($oms_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $oms_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $oms_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $oms_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($oms_table_list->TotalRecs > 0 && (!$oms_table_list->AutoHidePageSizeSelector || $oms_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="oms_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($oms_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($oms_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($oms_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($oms_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($oms_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($oms_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $oms_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="foms_tablelist" id="foms_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($oms_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $oms_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="oms_table">
<div id="gmp_oms_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($oms_table_list->TotalRecs > 0 || $oms_table->isGridEdit()) { ?>
<table id="tbl_oms_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$oms_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$oms_table_list->renderListOptions();

// Render list options (header, left)
$oms_table_list->ListOptions->render("header", "left");
?>
<?php if ($oms_table->id->Visible) { // id ?>
	<?php if ($oms_table->sortUrl($oms_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $oms_table->id->headerCellClass() ?>"><div id="elh_oms_table_id" class="oms_table_id"><div class="ew-table-header-caption"><?php echo $oms_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $oms_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->id) ?>',2);"><div id="elh_oms_table_id" class="oms_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
	<?php if ($oms_table->sortUrl($oms_table->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $oms_table->buyers_id->headerCellClass() ?>"><div id="elh_oms_table_buyers_id" class="oms_table_buyers_id"><div class="ew-table-header-caption"><?php echo $oms_table->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $oms_table->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->buyers_id) ?>',2);"><div id="elh_oms_table_buyers_id" class="oms_table_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
	<?php if ($oms_table->sortUrl($oms_table->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $oms_table->reports_to->headerCellClass() ?>"><div id="elh_oms_table_reports_to" class="oms_table_reports_to"><div class="ew-table-header-caption"><?php echo $oms_table->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $oms_table->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->reports_to) ?>',2);"><div id="elh_oms_table_reports_to" class="oms_table_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
	<?php if ($oms_table->sortUrl($oms_table->buyer_order) == "") { ?>
		<th data-name="buyer_order" class="<?php echo $oms_table->buyer_order->headerCellClass() ?>"><div id="elh_oms_table_buyer_order" class="oms_table_buyer_order"><div class="ew-table-header-caption"><?php echo $oms_table->buyer_order->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_order" class="<?php echo $oms_table->buyer_order->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->buyer_order) ?>',2);"><div id="elh_oms_table_buyer_order" class="oms_table_buyer_order">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->buyer_order->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->buyer_order->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->buyer_order->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->item->Visible) { // item ?>
	<?php if ($oms_table->sortUrl($oms_table->item) == "") { ?>
		<th data-name="item" class="<?php echo $oms_table->item->headerCellClass() ?>"><div id="elh_oms_table_item" class="oms_table_item"><div class="ew-table-header-caption"><?php echo $oms_table->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $oms_table->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->item) ?>',2);"><div id="elh_oms_table_item" class="oms_table_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($oms_table->sortUrl($oms_table->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $oms_table->buyer_ref->headerCellClass() ?>"><div id="elh_oms_table_buyer_ref" class="oms_table_buyer_ref"><div class="ew-table-header-caption"><?php echo $oms_table->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $oms_table->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->buyer_ref) ?>',2);"><div id="elh_oms_table_buyer_ref" class="oms_table_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->order_week->Visible) { // order_week ?>
	<?php if ($oms_table->sortUrl($oms_table->order_week) == "") { ?>
		<th data-name="order_week" class="<?php echo $oms_table->order_week->headerCellClass() ?>"><div id="elh_oms_table_order_week" class="oms_table_order_week"><div class="ew-table-header-caption"><?php echo $oms_table->order_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_week" class="<?php echo $oms_table->order_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->order_week) ?>',2);"><div id="elh_oms_table_order_week" class="oms_table_order_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->order_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->order_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->order_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->order_date->Visible) { // order_date ?>
	<?php if ($oms_table->sortUrl($oms_table->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $oms_table->order_date->headerCellClass() ?>"><div id="elh_oms_table_order_date" class="oms_table_order_date"><div class="ew-table-header-caption"><?php echo $oms_table->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $oms_table->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->order_date) ?>',2);"><div id="elh_oms_table_order_date" class="oms_table_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->ex_factory->Visible) { // ex_factory ?>
	<?php if ($oms_table->sortUrl($oms_table->ex_factory) == "") { ?>
		<th data-name="ex_factory" class="<?php echo $oms_table->ex_factory->headerCellClass() ?>"><div id="elh_oms_table_ex_factory" class="oms_table_ex_factory"><div class="ew-table-header-caption"><?php echo $oms_table->ex_factory->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory" class="<?php echo $oms_table->ex_factory->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->ex_factory) ?>',2);"><div id="elh_oms_table_ex_factory" class="oms_table_ex_factory">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->ex_factory->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->ex_factory->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->ex_factory->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
	<?php if ($oms_table->sortUrl($oms_table->ex_factory_p) == "") { ?>
		<th data-name="ex_factory_p" class="<?php echo $oms_table->ex_factory_p->headerCellClass() ?>"><div id="elh_oms_table_ex_factory_p" class="oms_table_ex_factory_p"><div class="ew-table-header-caption"><?php echo $oms_table->ex_factory_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory_p" class="<?php echo $oms_table->ex_factory_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->ex_factory_p) ?>',2);"><div id="elh_oms_table_ex_factory_p" class="oms_table_ex_factory_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->ex_factory_p->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->ex_factory_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->ex_factory_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->shipping_mode->Visible) { // shipping_mode ?>
	<?php if ($oms_table->sortUrl($oms_table->shipping_mode) == "") { ?>
		<th data-name="shipping_mode" class="<?php echo $oms_table->shipping_mode->headerCellClass() ?>"><div id="elh_oms_table_shipping_mode" class="oms_table_shipping_mode"><div class="ew-table-header-caption"><?php echo $oms_table->shipping_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_mode" class="<?php echo $oms_table->shipping_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->shipping_mode) ?>',2);"><div id="elh_oms_table_shipping_mode" class="oms_table_shipping_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->shipping_mode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->shipping_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->shipping_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->po->Visible) { // po ?>
	<?php if ($oms_table->sortUrl($oms_table->po) == "") { ?>
		<th data-name="po" class="<?php echo $oms_table->po->headerCellClass() ?>"><div id="elh_oms_table_po" class="oms_table_po"><div class="ew-table-header-caption"><?php echo $oms_table->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $oms_table->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->po) ?>',2);"><div id="elh_oms_table_po" class="oms_table_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->design->Visible) { // design ?>
	<?php if ($oms_table->sortUrl($oms_table->design) == "") { ?>
		<th data-name="design" class="<?php echo $oms_table->design->headerCellClass() ?>"><div id="elh_oms_table_design" class="oms_table_design"><div class="ew-table-header-caption"><?php echo $oms_table->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $oms_table->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->design) ?>',2);"><div id="elh_oms_table_design" class="oms_table_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->size_buyer->Visible) { // size_buyer ?>
	<?php if ($oms_table->sortUrl($oms_table->size_buyer) == "") { ?>
		<th data-name="size_buyer" class="<?php echo $oms_table->size_buyer->headerCellClass() ?>"><div id="elh_oms_table_size_buyer" class="oms_table_size_buyer"><div class="ew-table-header-caption"><?php echo $oms_table->size_buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_buyer" class="<?php echo $oms_table->size_buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->size_buyer) ?>',2);"><div id="elh_oms_table_size_buyer" class="oms_table_size_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->size_buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->size_buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->size_buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->width->Visible) { // width ?>
	<?php if ($oms_table->sortUrl($oms_table->width) == "") { ?>
		<th data-name="width" class="<?php echo $oms_table->width->headerCellClass() ?>"><div id="elh_oms_table_width" class="oms_table_width"><div class="ew-table-header-caption"><?php echo $oms_table->width->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="width" class="<?php echo $oms_table->width->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->width) ?>',2);"><div id="elh_oms_table_width" class="oms_table_width">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->width->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->width->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->width->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->length->Visible) { // length ?>
	<?php if ($oms_table->sortUrl($oms_table->length) == "") { ?>
		<th data-name="length" class="<?php echo $oms_table->length->headerCellClass() ?>"><div id="elh_oms_table_length" class="oms_table_length"><div class="ew-table-header-caption"><?php echo $oms_table->length->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="length" class="<?php echo $oms_table->length->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->length) ?>',2);"><div id="elh_oms_table_length" class="oms_table_length">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->length->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->length->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->length->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->qty->Visible) { // qty ?>
	<?php if ($oms_table->sortUrl($oms_table->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $oms_table->qty->headerCellClass() ?>"><div id="elh_oms_table_qty" class="oms_table_qty"><div class="ew-table-header-caption"><?php echo $oms_table->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $oms_table->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->qty) ?>',2);"><div id="elh_oms_table_qty" class="oms_table_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->revised_qty->Visible) { // revised_qty ?>
	<?php if ($oms_table->sortUrl($oms_table->revised_qty) == "") { ?>
		<th data-name="revised_qty" class="<?php echo $oms_table->revised_qty->headerCellClass() ?>"><div id="elh_oms_table_revised_qty" class="oms_table_revised_qty"><div class="ew-table-header-caption"><?php echo $oms_table->revised_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="revised_qty" class="<?php echo $oms_table->revised_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->revised_qty) ?>',2);"><div id="elh_oms_table_revised_qty" class="oms_table_revised_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->revised_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->revised_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->revised_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->sqm->Visible) { // sqm ?>
	<?php if ($oms_table->sortUrl($oms_table->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $oms_table->sqm->headerCellClass() ?>"><div id="elh_oms_table_sqm" class="oms_table_sqm"><div class="ew-table-header-caption"><?php echo $oms_table->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $oms_table->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->sqm) ?>',2);"><div id="elh_oms_table_sqm" class="oms_table_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->d_qty->Visible) { // d_qty ?>
	<?php if ($oms_table->sortUrl($oms_table->d_qty) == "") { ?>
		<th data-name="d_qty" class="<?php echo $oms_table->d_qty->headerCellClass() ?>"><div id="elh_oms_table_d_qty" class="oms_table_d_qty"><div class="ew-table-header-caption"><?php echo $oms_table->d_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_qty" class="<?php echo $oms_table->d_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->d_qty) ?>',2);"><div id="elh_oms_table_d_qty" class="oms_table_d_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->d_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->d_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->d_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->pending->Visible) { // pending ?>
	<?php if ($oms_table->sortUrl($oms_table->pending) == "") { ?>
		<th data-name="pending" class="<?php echo $oms_table->pending->headerCellClass() ?>"><div id="elh_oms_table_pending" class="oms_table_pending"><div class="ew-table-header-caption"><?php echo $oms_table->pending->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending" class="<?php echo $oms_table->pending->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->pending) ?>',2);"><div id="elh_oms_table_pending" class="oms_table_pending">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->pending->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->pending->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->pending->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->pending_sqm->Visible) { // pending_sqm ?>
	<?php if ($oms_table->sortUrl($oms_table->pending_sqm) == "") { ?>
		<th data-name="pending_sqm" class="<?php echo $oms_table->pending_sqm->headerCellClass() ?>"><div id="elh_oms_table_pending_sqm" class="oms_table_pending_sqm"><div class="ew-table-header-caption"><?php echo $oms_table->pending_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_sqm" class="<?php echo $oms_table->pending_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->pending_sqm) ?>',2);"><div id="elh_oms_table_pending_sqm" class="oms_table_pending_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->pending_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->pending_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->pending_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->offloom->Visible) { // offloom ?>
	<?php if ($oms_table->sortUrl($oms_table->offloom) == "") { ?>
		<th data-name="offloom" class="<?php echo $oms_table->offloom->headerCellClass() ?>"><div id="elh_oms_table_offloom" class="oms_table_offloom"><div class="ew-table-header-caption"><?php echo $oms_table->offloom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="offloom" class="<?php echo $oms_table->offloom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->offloom) ?>',2);"><div id="elh_oms_table_offloom" class="oms_table_offloom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->offloom->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->offloom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->offloom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->pending_offloom->Visible) { // pending_offloom ?>
	<?php if ($oms_table->sortUrl($oms_table->pending_offloom) == "") { ?>
		<th data-name="pending_offloom" class="<?php echo $oms_table->pending_offloom->headerCellClass() ?>"><div id="elh_oms_table_pending_offloom" class="oms_table_pending_offloom"><div class="ew-table-header-caption"><?php echo $oms_table->pending_offloom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_offloom" class="<?php echo $oms_table->pending_offloom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->pending_offloom) ?>',2);"><div id="elh_oms_table_pending_offloom" class="oms_table_pending_offloom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->pending_offloom->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->pending_offloom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->pending_offloom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
	<?php if ($oms_table->sortUrl($oms_table->pending_offloom_sqm) == "") { ?>
		<th data-name="pending_offloom_sqm" class="<?php echo $oms_table->pending_offloom_sqm->headerCellClass() ?>"><div id="elh_oms_table_pending_offloom_sqm" class="oms_table_pending_offloom_sqm"><div class="ew-table-header-caption"><?php echo $oms_table->pending_offloom_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_offloom_sqm" class="<?php echo $oms_table->pending_offloom_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->pending_offloom_sqm) ?>',2);"><div id="elh_oms_table_pending_offloom_sqm" class="oms_table_pending_offloom_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->pending_offloom_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->pending_offloom_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->pending_offloom_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->cbm->Visible) { // cbm ?>
	<?php if ($oms_table->sortUrl($oms_table->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $oms_table->cbm->headerCellClass() ?>"><div id="elh_oms_table_cbm" class="oms_table_cbm"><div class="ew-table-header-caption"><?php echo $oms_table->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $oms_table->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->cbm) ?>',2);"><div id="elh_oms_table_cbm" class="oms_table_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->total_cbm->Visible) { // total_cbm ?>
	<?php if ($oms_table->sortUrl($oms_table->total_cbm) == "") { ?>
		<th data-name="total_cbm" class="<?php echo $oms_table->total_cbm->headerCellClass() ?>"><div id="elh_oms_table_total_cbm" class="oms_table_total_cbm"><div class="ew-table-header-caption"><?php echo $oms_table->total_cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_cbm" class="<?php echo $oms_table->total_cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->total_cbm) ?>',2);"><div id="elh_oms_table_total_cbm" class="oms_table_total_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->total_cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->total_cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->total_cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->remarks->Visible) { // remarks ?>
	<?php if ($oms_table->sortUrl($oms_table->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $oms_table->remarks->headerCellClass() ?>"><div id="elh_oms_table_remarks" class="oms_table_remarks"><div class="ew-table-header-caption"><?php echo $oms_table->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $oms_table->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->remarks) ?>',2);"><div id="elh_oms_table_remarks" class="oms_table_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
	<?php if ($oms_table->sortUrl($oms_table->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $oms_table->pl_no->headerCellClass() ?>"><div id="elh_oms_table_pl_no" class="oms_table_pl_no"><div class="ew-table-header-caption"><?php echo $oms_table->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $oms_table->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->pl_no) ?>',2);"><div id="elh_oms_table_pl_no" class="oms_table_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->pl_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->invoice_date->Visible) { // invoice_date ?>
	<?php if ($oms_table->sortUrl($oms_table->invoice_date) == "") { ?>
		<th data-name="invoice_date" class="<?php echo $oms_table->invoice_date->headerCellClass() ?>"><div id="elh_oms_table_invoice_date" class="oms_table_invoice_date"><div class="ew-table-header-caption"><?php echo $oms_table->invoice_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_date" class="<?php echo $oms_table->invoice_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->invoice_date) ?>',2);"><div id="elh_oms_table_invoice_date" class="oms_table_invoice_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->invoice_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->invoice_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->invoice_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->sailing_week->Visible) { // sailing_week ?>
	<?php if ($oms_table->sortUrl($oms_table->sailing_week) == "") { ?>
		<th data-name="sailing_week" class="<?php echo $oms_table->sailing_week->headerCellClass() ?>"><div id="elh_oms_table_sailing_week" class="oms_table_sailing_week"><div class="ew-table-header-caption"><?php echo $oms_table->sailing_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sailing_week" class="<?php echo $oms_table->sailing_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->sailing_week) ?>',2);"><div id="elh_oms_table_sailing_week" class="oms_table_sailing_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->sailing_week->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->sailing_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->sailing_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->seller_remarks->Visible) { // seller_remarks ?>
	<?php if ($oms_table->sortUrl($oms_table->seller_remarks) == "") { ?>
		<th data-name="seller_remarks" class="<?php echo $oms_table->seller_remarks->headerCellClass() ?>"><div id="elh_oms_table_seller_remarks" class="oms_table_seller_remarks"><div class="ew-table-header-caption"><?php echo $oms_table->seller_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="seller_remarks" class="<?php echo $oms_table->seller_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->seller_remarks) ?>',2);"><div id="elh_oms_table_seller_remarks" class="oms_table_seller_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->seller_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($oms_table->seller_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->seller_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->status->Visible) { // status ?>
	<?php if ($oms_table->sortUrl($oms_table->status) == "") { ?>
		<th data-name="status" class="<?php echo $oms_table->status->headerCellClass() ?>"><div id="elh_oms_table_status" class="oms_table_status"><div class="ew-table-header-caption"><?php echo $oms_table->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $oms_table->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->status) ?>',2);"><div id="elh_oms_table_status" class="oms_table_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->rejection->Visible) { // rejection ?>
	<?php if ($oms_table->sortUrl($oms_table->rejection) == "") { ?>
		<th data-name="rejection" class="<?php echo $oms_table->rejection->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_oms_table_rejection" class="oms_table_rejection"><div class="ew-table-header-caption"><?php echo $oms_table->rejection->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rejection" class="<?php echo $oms_table->rejection->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->rejection) ?>',2);"><div id="elh_oms_table_rejection" class="oms_table_rejection">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->rejection->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->rejection->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->rejection->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->completed->Visible) { // completed ?>
	<?php if ($oms_table->sortUrl($oms_table->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $oms_table->completed->headerCellClass() ?>"><div id="elh_oms_table_completed" class="oms_table_completed"><div class="ew-table-header-caption"><?php echo $oms_table->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $oms_table->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->completed) ?>',2);"><div id="elh_oms_table_completed" class="oms_table_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($oms_table->weight_sqm->Visible) { // weight_sqm ?>
	<?php if ($oms_table->sortUrl($oms_table->weight_sqm) == "") { ?>
		<th data-name="weight_sqm" class="<?php echo $oms_table->weight_sqm->headerCellClass() ?>"><div id="elh_oms_table_weight_sqm" class="oms_table_weight_sqm"><div class="ew-table-header-caption"><?php echo $oms_table->weight_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_sqm" class="<?php echo $oms_table->weight_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $oms_table->SortUrl($oms_table->weight_sqm) ?>',2);"><div id="elh_oms_table_weight_sqm" class="oms_table_weight_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $oms_table->weight_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($oms_table->weight_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($oms_table->weight_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$oms_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($oms_table->ExportAll && $oms_table->isExport()) {
	$oms_table_list->StopRec = $oms_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($oms_table_list->TotalRecs > $oms_table_list->StartRec + $oms_table_list->DisplayRecs - 1)
		$oms_table_list->StopRec = $oms_table_list->StartRec + $oms_table_list->DisplayRecs - 1;
	else
		$oms_table_list->StopRec = $oms_table_list->TotalRecs;
}
$oms_table_list->RecCnt = $oms_table_list->StartRec - 1;
if ($oms_table_list->Recordset && !$oms_table_list->Recordset->EOF) {
	$oms_table_list->Recordset->moveFirst();
	$selectLimit = $oms_table_list->UseSelectLimit;
	if (!$selectLimit && $oms_table_list->StartRec > 1)
		$oms_table_list->Recordset->move($oms_table_list->StartRec - 1);
} elseif (!$oms_table->AllowAddDeleteRow && $oms_table_list->StopRec == 0) {
	$oms_table_list->StopRec = $oms_table->GridAddRowCount;
}

// Initialize aggregate
$oms_table->RowType = ROWTYPE_AGGREGATEINIT;
$oms_table->resetAttributes();
$oms_table_list->renderRow();
while ($oms_table_list->RecCnt < $oms_table_list->StopRec) {
	$oms_table_list->RecCnt++;
	if ($oms_table_list->RecCnt >= $oms_table_list->StartRec) {
		$oms_table_list->RowCnt++;

		// Set up key count
		$oms_table_list->KeyCount = $oms_table_list->RowIndex;

		// Init row class and style
		$oms_table->resetAttributes();
		$oms_table->CssClass = "";
		if ($oms_table->isGridAdd()) {
		} else {
			$oms_table_list->loadRowValues($oms_table_list->Recordset); // Load row values
		}
		$oms_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$oms_table->RowAttrs = array_merge($oms_table->RowAttrs, array('data-rowindex'=>$oms_table_list->RowCnt, 'id'=>'r' . $oms_table_list->RowCnt . '_oms_table', 'data-rowtype'=>$oms_table->RowType));

		// Render row
		$oms_table_list->renderRow();

		// Render list options
		$oms_table_list->renderListOptions();
?>
	<tr<?php echo $oms_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$oms_table_list->ListOptions->render("body", "left", $oms_table_list->RowCnt);
?>
	<?php if ($oms_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $oms_table->id->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_id" class="oms_table_id">
<span<?php echo $oms_table->id->viewAttributes() ?>>
<?php echo $oms_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $oms_table->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_buyers_id" class="oms_table_buyers_id">
<span<?php echo $oms_table->buyers_id->viewAttributes() ?>>
<?php echo $oms_table->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $oms_table->reports_to->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_reports_to" class="oms_table_reports_to">
<span<?php echo $oms_table->reports_to->viewAttributes() ?>>
<?php echo $oms_table->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
		<td data-name="buyer_order"<?php echo $oms_table->buyer_order->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_buyer_order" class="oms_table_buyer_order">
<span<?php echo $oms_table->buyer_order->viewAttributes() ?>>
<?php echo $oms_table->buyer_order->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->item->Visible) { // item ?>
		<td data-name="item"<?php echo $oms_table->item->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_item" class="oms_table_item">
<span<?php echo $oms_table->item->viewAttributes() ?>>
<?php echo $oms_table->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $oms_table->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_buyer_ref" class="oms_table_buyer_ref">
<span<?php echo $oms_table->buyer_ref->viewAttributes() ?>>
<?php echo $oms_table->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->order_week->Visible) { // order_week ?>
		<td data-name="order_week"<?php echo $oms_table->order_week->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_order_week" class="oms_table_order_week">
<span<?php echo $oms_table->order_week->viewAttributes() ?>>
<?php echo $oms_table->order_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $oms_table->order_date->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_order_date" class="oms_table_order_date">
<span<?php echo $oms_table->order_date->viewAttributes() ?>>
<?php echo $oms_table->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->ex_factory->Visible) { // ex_factory ?>
		<td data-name="ex_factory"<?php echo $oms_table->ex_factory->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_ex_factory" class="oms_table_ex_factory">
<span<?php echo $oms_table->ex_factory->viewAttributes() ?>>
<?php echo $oms_table->ex_factory->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
		<td data-name="ex_factory_p"<?php echo $oms_table->ex_factory_p->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_ex_factory_p" class="oms_table_ex_factory_p">
<span<?php echo $oms_table->ex_factory_p->viewAttributes() ?>>
<?php echo $oms_table->ex_factory_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->shipping_mode->Visible) { // shipping_mode ?>
		<td data-name="shipping_mode"<?php echo $oms_table->shipping_mode->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_shipping_mode" class="oms_table_shipping_mode">
<span<?php echo $oms_table->shipping_mode->viewAttributes() ?>>
<?php echo $oms_table->shipping_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->po->Visible) { // po ?>
		<td data-name="po"<?php echo $oms_table->po->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_po" class="oms_table_po">
<span<?php echo $oms_table->po->viewAttributes() ?>>
<?php echo $oms_table->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->design->Visible) { // design ?>
		<td data-name="design"<?php echo $oms_table->design->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_design" class="oms_table_design">
<span<?php echo $oms_table->design->viewAttributes() ?>>
<?php echo $oms_table->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer"<?php echo $oms_table->size_buyer->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_size_buyer" class="oms_table_size_buyer">
<span<?php echo $oms_table->size_buyer->viewAttributes() ?>>
<?php echo $oms_table->size_buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->width->Visible) { // width ?>
		<td data-name="width"<?php echo $oms_table->width->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_width" class="oms_table_width">
<span<?php echo $oms_table->width->viewAttributes() ?>>
<?php echo $oms_table->width->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->length->Visible) { // length ?>
		<td data-name="length"<?php echo $oms_table->length->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_length" class="oms_table_length">
<span<?php echo $oms_table->length->viewAttributes() ?>>
<?php echo $oms_table->length->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $oms_table->qty->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_qty" class="oms_table_qty">
<span<?php echo $oms_table->qty->viewAttributes() ?>>
<?php echo $oms_table->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->revised_qty->Visible) { // revised_qty ?>
		<td data-name="revised_qty"<?php echo $oms_table->revised_qty->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_revised_qty" class="oms_table_revised_qty">
<span<?php echo $oms_table->revised_qty->viewAttributes() ?>>
<?php echo $oms_table->revised_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $oms_table->sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_sqm" class="oms_table_sqm">
<span<?php echo $oms_table->sqm->viewAttributes() ?>>
<?php echo $oms_table->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->d_qty->Visible) { // d_qty ?>
		<td data-name="d_qty"<?php echo $oms_table->d_qty->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_d_qty" class="oms_table_d_qty">
<span<?php echo $oms_table->d_qty->viewAttributes() ?>>
<?php echo $oms_table->d_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->pending->Visible) { // pending ?>
		<td data-name="pending"<?php echo $oms_table->pending->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_pending" class="oms_table_pending">
<span<?php echo $oms_table->pending->viewAttributes() ?>>
<?php if ((!EmptyString($oms_table->pending->getViewValue())) && $oms_table->pending->linkAttributes() <> "") { ?>
<a<?php echo $oms_table->pending->linkAttributes() ?>><?php echo $oms_table->pending->getViewValue() ?></a>
<?php } else { ?>
<?php echo $oms_table->pending->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->pending_sqm->Visible) { // pending_sqm ?>
		<td data-name="pending_sqm"<?php echo $oms_table->pending_sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_pending_sqm" class="oms_table_pending_sqm">
<span<?php echo $oms_table->pending_sqm->viewAttributes() ?>>
<?php echo $oms_table->pending_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->offloom->Visible) { // offloom ?>
		<td data-name="offloom"<?php echo $oms_table->offloom->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_offloom" class="oms_table_offloom">
<span<?php echo $oms_table->offloom->viewAttributes() ?>>
<?php echo $oms_table->offloom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->pending_offloom->Visible) { // pending_offloom ?>
		<td data-name="pending_offloom"<?php echo $oms_table->pending_offloom->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_pending_offloom" class="oms_table_pending_offloom">
<span<?php echo $oms_table->pending_offloom->viewAttributes() ?>>
<?php echo $oms_table->pending_offloom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
		<td data-name="pending_offloom_sqm"<?php echo $oms_table->pending_offloom_sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_pending_offloom_sqm" class="oms_table_pending_offloom_sqm">
<span<?php echo $oms_table->pending_offloom_sqm->viewAttributes() ?>>
<?php echo $oms_table->pending_offloom_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $oms_table->cbm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_cbm" class="oms_table_cbm">
<span<?php echo $oms_table->cbm->viewAttributes() ?>>
<?php echo $oms_table->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->total_cbm->Visible) { // total_cbm ?>
		<td data-name="total_cbm"<?php echo $oms_table->total_cbm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_total_cbm" class="oms_table_total_cbm">
<span<?php echo $oms_table->total_cbm->viewAttributes() ?>>
<?php echo $oms_table->total_cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $oms_table->remarks->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_remarks" class="oms_table_remarks">
<span<?php echo $oms_table->remarks->viewAttributes() ?>>
<?php echo $oms_table->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $oms_table->pl_no->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_pl_no" class="oms_table_pl_no">
<span<?php echo $oms_table->pl_no->viewAttributes() ?>>
<?php if ((!EmptyString($oms_table->pl_no->getViewValue())) && $oms_table->pl_no->linkAttributes() <> "") { ?>
<a<?php echo $oms_table->pl_no->linkAttributes() ?>><?php echo $oms_table->pl_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $oms_table->pl_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date"<?php echo $oms_table->invoice_date->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_invoice_date" class="oms_table_invoice_date">
<span<?php echo $oms_table->invoice_date->viewAttributes() ?>>
<?php echo $oms_table->invoice_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->sailing_week->Visible) { // sailing_week ?>
		<td data-name="sailing_week"<?php echo $oms_table->sailing_week->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_sailing_week" class="oms_table_sailing_week">
<span<?php echo $oms_table->sailing_week->viewAttributes() ?>>
<?php echo $oms_table->sailing_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->seller_remarks->Visible) { // seller_remarks ?>
		<td data-name="seller_remarks"<?php echo $oms_table->seller_remarks->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_seller_remarks" class="oms_table_seller_remarks">
<span<?php echo $oms_table->seller_remarks->viewAttributes() ?>>
<?php echo $oms_table->seller_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->status->Visible) { // status ?>
		<td data-name="status"<?php echo $oms_table->status->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_status" class="oms_table_status">
<span<?php echo $oms_table->status->viewAttributes() ?>>
<?php echo $oms_table->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->rejection->Visible) { // rejection ?>
		<td data-name="rejection"<?php echo $oms_table->rejection->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_rejection" class="oms_table_rejection">
<span<?php echo $oms_table->rejection->viewAttributes() ?>>
<?php echo $oms_table->rejection->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $oms_table->completed->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_completed" class="oms_table_completed">
<span<?php echo $oms_table->completed->viewAttributes() ?>>
<?php echo $oms_table->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($oms_table->weight_sqm->Visible) { // weight_sqm ?>
		<td data-name="weight_sqm"<?php echo $oms_table->weight_sqm->cellAttributes() ?>>
<span id="el<?php echo $oms_table_list->RowCnt ?>_oms_table_weight_sqm" class="oms_table_weight_sqm">
<span<?php echo $oms_table->weight_sqm->viewAttributes() ?>>
<?php echo $oms_table->weight_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$oms_table_list->ListOptions->render("body", "right", $oms_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$oms_table->isGridAdd())
		$oms_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$oms_table->RowType = ROWTYPE_AGGREGATE;
$oms_table->resetAttributes();
$oms_table_list->renderRow();
?>
<?php if ($oms_table_list->TotalRecs > 0 && !$oms_table->isGridAdd() && !$oms_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$oms_table_list->renderListOptions();

// Render list options (footer, left)
$oms_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($oms_table->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $oms_table->id->footerCellClass() ?>"><span id="elf_oms_table_id" class="oms_table_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $oms_table->buyers_id->footerCellClass() ?>"><span id="elf_oms_table_buyers_id" class="oms_table_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to" class="<?php echo $oms_table->reports_to->footerCellClass() ?>"><span id="elf_oms_table_reports_to" class="oms_table_reports_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
		<td data-name="buyer_order" class="<?php echo $oms_table->buyer_order->footerCellClass() ?>"><span id="elf_oms_table_buyer_order" class="oms_table_buyer_order">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->item->Visible) { // item ?>
		<td data-name="item" class="<?php echo $oms_table->item->footerCellClass() ?>"><span id="elf_oms_table_item" class="oms_table_item">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $oms_table->buyer_ref->footerCellClass() ?>"><span id="elf_oms_table_buyer_ref" class="oms_table_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->order_week->Visible) { // order_week ?>
		<td data-name="order_week" class="<?php echo $oms_table->order_week->footerCellClass() ?>"><span id="elf_oms_table_order_week" class="oms_table_order_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->order_date->Visible) { // order_date ?>
		<td data-name="order_date" class="<?php echo $oms_table->order_date->footerCellClass() ?>"><span id="elf_oms_table_order_date" class="oms_table_order_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->ex_factory->Visible) { // ex_factory ?>
		<td data-name="ex_factory" class="<?php echo $oms_table->ex_factory->footerCellClass() ?>"><span id="elf_oms_table_ex_factory" class="oms_table_ex_factory">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
		<td data-name="ex_factory_p" class="<?php echo $oms_table->ex_factory_p->footerCellClass() ?>"><span id="elf_oms_table_ex_factory_p" class="oms_table_ex_factory_p">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->shipping_mode->Visible) { // shipping_mode ?>
		<td data-name="shipping_mode" class="<?php echo $oms_table->shipping_mode->footerCellClass() ?>"><span id="elf_oms_table_shipping_mode" class="oms_table_shipping_mode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $oms_table->po->footerCellClass() ?>"><span id="elf_oms_table_po" class="oms_table_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->design->Visible) { // design ?>
		<td data-name="design" class="<?php echo $oms_table->design->footerCellClass() ?>"><span id="elf_oms_table_design" class="oms_table_design">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer" class="<?php echo $oms_table->size_buyer->footerCellClass() ?>"><span id="elf_oms_table_size_buyer" class="oms_table_size_buyer">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->width->Visible) { // width ?>
		<td data-name="width" class="<?php echo $oms_table->width->footerCellClass() ?>"><span id="elf_oms_table_width" class="oms_table_width">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->length->Visible) { // length ?>
		<td data-name="length" class="<?php echo $oms_table->length->footerCellClass() ?>"><span id="elf_oms_table_length" class="oms_table_length">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->qty->Visible) { // qty ?>
		<td data-name="qty" class="<?php echo $oms_table->qty->footerCellClass() ?>"><span id="elf_oms_table_qty" class="oms_table_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->revised_qty->Visible) { // revised_qty ?>
		<td data-name="revised_qty" class="<?php echo $oms_table->revised_qty->footerCellClass() ?>"><span id="elf_oms_table_revised_qty" class="oms_table_revised_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $oms_table->sqm->footerCellClass() ?>"><span id="elf_oms_table_sqm" class="oms_table_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->d_qty->Visible) { // d_qty ?>
		<td data-name="d_qty" class="<?php echo $oms_table->d_qty->footerCellClass() ?>"><span id="elf_oms_table_d_qty" class="oms_table_d_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->d_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->pending->Visible) { // pending ?>
		<td data-name="pending" class="<?php echo $oms_table->pending->footerCellClass() ?>"><span id="elf_oms_table_pending" class="oms_table_pending">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->pending->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->pending_sqm->Visible) { // pending_sqm ?>
		<td data-name="pending_sqm" class="<?php echo $oms_table->pending_sqm->footerCellClass() ?>"><span id="elf_oms_table_pending_sqm" class="oms_table_pending_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->pending_sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->offloom->Visible) { // offloom ?>
		<td data-name="offloom" class="<?php echo $oms_table->offloom->footerCellClass() ?>"><span id="elf_oms_table_offloom" class="oms_table_offloom">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->offloom->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->pending_offloom->Visible) { // pending_offloom ?>
		<td data-name="pending_offloom" class="<?php echo $oms_table->pending_offloom->footerCellClass() ?>"><span id="elf_oms_table_pending_offloom" class="oms_table_pending_offloom">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->pending_offloom->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
		<td data-name="pending_offloom_sqm" class="<?php echo $oms_table->pending_offloom_sqm->footerCellClass() ?>"><span id="elf_oms_table_pending_offloom_sqm" class="oms_table_pending_offloom_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->pending_offloom_sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->cbm->Visible) { // cbm ?>
		<td data-name="cbm" class="<?php echo $oms_table->cbm->footerCellClass() ?>"><span id="elf_oms_table_cbm" class="oms_table_cbm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->cbm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->total_cbm->Visible) { // total_cbm ?>
		<td data-name="total_cbm" class="<?php echo $oms_table->total_cbm->footerCellClass() ?>"><span id="elf_oms_table_total_cbm" class="oms_table_total_cbm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $oms_table->total_cbm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($oms_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $oms_table->remarks->footerCellClass() ?>"><span id="elf_oms_table_remarks" class="oms_table_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $oms_table->pl_no->footerCellClass() ?>"><span id="elf_oms_table_pl_no" class="oms_table_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date" class="<?php echo $oms_table->invoice_date->footerCellClass() ?>"><span id="elf_oms_table_invoice_date" class="oms_table_invoice_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->sailing_week->Visible) { // sailing_week ?>
		<td data-name="sailing_week" class="<?php echo $oms_table->sailing_week->footerCellClass() ?>"><span id="elf_oms_table_sailing_week" class="oms_table_sailing_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->seller_remarks->Visible) { // seller_remarks ?>
		<td data-name="seller_remarks" class="<?php echo $oms_table->seller_remarks->footerCellClass() ?>"><span id="elf_oms_table_seller_remarks" class="oms_table_seller_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $oms_table->status->footerCellClass() ?>"><span id="elf_oms_table_status" class="oms_table_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->rejection->Visible) { // rejection ?>
		<td data-name="rejection" class="<?php echo $oms_table->rejection->footerCellClass() ?>"><span id="elf_oms_table_rejection" class="oms_table_rejection">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->completed->Visible) { // completed ?>
		<td data-name="completed" class="<?php echo $oms_table->completed->footerCellClass() ?>"><span id="elf_oms_table_completed" class="oms_table_completed">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($oms_table->weight_sqm->Visible) { // weight_sqm ?>
		<td data-name="weight_sqm" class="<?php echo $oms_table->weight_sqm->footerCellClass() ?>"><span id="elf_oms_table_weight_sqm" class="oms_table_weight_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$oms_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$oms_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($oms_table_list->Recordset)
	$oms_table_list->Recordset->Close();
?>
<?php if (!$oms_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$oms_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($oms_table_list->Pager)) $oms_table_list->Pager = new PrevNextPager($oms_table_list->StartRec, $oms_table_list->DisplayRecs, $oms_table_list->TotalRecs, $oms_table_list->AutoHidePager) ?>
<?php if ($oms_table_list->Pager->RecordCount > 0 && $oms_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($oms_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($oms_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $oms_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($oms_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($oms_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $oms_table_list->pageUrl() ?>start=<?php echo $oms_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $oms_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($oms_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $oms_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $oms_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $oms_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($oms_table_list->TotalRecs > 0 && (!$oms_table_list->AutoHidePageSizeSelector || $oms_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="oms_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($oms_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($oms_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($oms_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($oms_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($oms_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($oms_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $oms_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($oms_table_list->TotalRecs == 0 && !$oms_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $oms_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$oms_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$oms_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");
function pldetails(ID) 
	{
		const pld = ID.split(":")
		$.getJSON("apcajax.php?ID="+pld[0]+"&getpldetails="+pld[1],function(data){
		Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">Packing List Details</h1><button type="button" class="close" data-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><p>'+data+'</p></div><!-- Modal footer --><div class="modal-footer"><button type="button" class="btn btn-danger" data-dismiss="modal">Close</button></div></div></div></div></div>';
 		   		$("body").prepend(Obj);
 		   		$("#myModal").modal("show")
	});
	}
</script>
<?php if (!$oms_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_oms_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$oms_table_list->terminate();
?>