<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$oms_table_search = new oms_table_search();

// Run the page
$oms_table_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$oms_table_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($oms_table_search->IsModal) { ?>
var foms_tablesearch = currentAdvancedSearchForm = new ew.Form("foms_tablesearch", "search");
<?php } else { ?>
var foms_tablesearch = currentForm = new ew.Form("foms_tablesearch", "search");
<?php } ?>

// Form_CustomValidate event
foms_tablesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_tablesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_tablesearch.lists["x_buyers_id"] = <?php echo $oms_table_search->buyers_id->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_search->buyers_id->lookupOptions()) ?>;
foms_tablesearch.lists["x_reports_to"] = <?php echo $oms_table_search->reports_to->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_search->reports_to->lookupOptions()) ?>;
foms_tablesearch.lists["x_order_week"] = <?php echo $oms_table_search->order_week->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_order_week"].options = <?php echo JsonEncode($oms_table_search->order_week->lookupOptions()) ?>;
foms_tablesearch.lists["x_ex_factory"] = <?php echo $oms_table_search->ex_factory->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_ex_factory"].options = <?php echo JsonEncode($oms_table_search->ex_factory->lookupOptions()) ?>;
foms_tablesearch.lists["x_ex_factory_p[]"] = <?php echo $oms_table_search->ex_factory_p->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_search->ex_factory_p->lookupOptions()) ?>;
foms_tablesearch.lists["x_status[]"] = <?php echo $oms_table_search->status->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_status[]"].options = <?php echo JsonEncode($oms_table_search->status->lookupOptions()) ?>;
foms_tablesearch.lists["x_completed[]"] = <?php echo $oms_table_search->completed->Lookup->toClientList() ?>;
foms_tablesearch.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_search->completed->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

foms_tablesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_width");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->width->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_length");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->length->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_revised_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->revised_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->d_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->pending->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->pending_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_offloom");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->offloom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_offloom");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->pending_offloom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_offloom_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->pending_offloom_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($oms_table->weight_sqm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $oms_table_search->showPageHeader(); ?>
<?php
$oms_table_search->showMessage();
?>
<form name="foms_tablesearch" id="foms_tablesearch" class="<?php echo $oms_table_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($oms_table_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $oms_table_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="oms_table">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$oms_table_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($oms_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_id"><?php echo $oms_table->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->id->cellAttributes() ?>>
			<span id="el_oms_table_id">
<input type="text" data-table="oms_table" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($oms_table->id->getPlaceHolder()) ?>" value="<?php echo $oms_table->id->EditValue ?>"<?php echo $oms_table->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_buyers_id"><?php echo $oms_table->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->buyers_id->cellAttributes() ?>>
			<span id="el_oms_table_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_buyers_id" data-value-separator="<?php echo $oms_table->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $oms_table->buyers_id->editAttributes() ?>>
		<?php echo $oms_table->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $oms_table->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_reports_to"><?php echo $oms_table->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->reports_to->cellAttributes() ?>>
			<span id="el_oms_table_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_reports_to" data-value-separator="<?php echo $oms_table->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $oms_table->reports_to->editAttributes() ?>>
		<?php echo $oms_table->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $oms_table->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
	<div id="r_buyer_order" class="form-group row">
		<label for="x_buyer_order" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_buyer_order"><?php echo $oms_table->buyer_order->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->buyer_order->cellAttributes() ?>>
			<span id="el_oms_table_buyer_order">
<input type="text" data-table="oms_table" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table->buyer_order->getPlaceHolder()) ?>" value="<?php echo $oms_table->buyer_order->EditValue ?>"<?php echo $oms_table->buyer_order->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_item"><?php echo $oms_table->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->item->cellAttributes() ?>>
			<span id="el_oms_table_item">
<input type="text" data-table="oms_table" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table->item->getPlaceHolder()) ?>" value="<?php echo $oms_table->item->EditValue ?>"<?php echo $oms_table->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_buyer_ref"><?php echo $oms_table->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->buyer_ref->cellAttributes() ?>>
			<span id="el_oms_table_buyer_ref">
<input type="text" data-table="oms_table" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($oms_table->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $oms_table->buyer_ref->EditValue ?>"<?php echo $oms_table->buyer_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->order_week->Visible) { // order_week ?>
	<div id="r_order_week" class="form-group row">
		<label for="x_order_week" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_order_week"><?php echo $oms_table->order_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_week" id="z_order_week" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->order_week->cellAttributes() ?>>
			<span id="el_oms_table_order_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_order_week" data-value-separator="<?php echo $oms_table->order_week->displayValueSeparatorAttribute() ?>" id="x_order_week" name="x_order_week"<?php echo $oms_table->order_week->editAttributes() ?>>
		<?php echo $oms_table->order_week->selectOptionListHtml("x_order_week") ?>
	</select>
</div>
<?php echo $oms_table->order_week->Lookup->getParamTag("p_x_order_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_order_date"><?php echo $oms_table->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->order_date->cellAttributes() ?>>
			<span id="el_oms_table_order_date">
<input type="text" data-table="oms_table" data-field="x_order_date" data-format="2" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($oms_table->order_date->getPlaceHolder()) ?>" value="<?php echo $oms_table->order_date->EditValue ?>"<?php echo $oms_table->order_date->editAttributes() ?>>
<?php if (!$oms_table->order_date->ReadOnly && !$oms_table->order_date->Disabled && !isset($oms_table->order_date->EditAttrs["readonly"]) && !isset($oms_table->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("foms_tablesearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->ex_factory->Visible) { // ex_factory ?>
	<div id="r_ex_factory" class="form-group row">
		<label for="x_ex_factory" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_ex_factory"><?php echo $oms_table->ex_factory->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ex_factory" id="z_ex_factory" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->ex_factory->cellAttributes() ?>>
			<span id="el_oms_table_ex_factory">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_ex_factory" data-value-separator="<?php echo $oms_table->ex_factory->displayValueSeparatorAttribute() ?>" id="x_ex_factory" name="x_ex_factory"<?php echo $oms_table->ex_factory->editAttributes() ?>>
		<?php echo $oms_table->ex_factory->selectOptionListHtml("x_ex_factory") ?>
	</select>
</div>
<?php echo $oms_table->ex_factory->Lookup->getParamTag("p_x_ex_factory") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
	<div id="r_ex_factory_p" class="form-group row">
		<label for="x_ex_factory_p" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_ex_factory_p"><?php echo $oms_table->ex_factory_p->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->ex_factory_p->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_ex_factory_p" id="z_ex_factory_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($oms_table->ex_factory_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_ex_factory_p">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table->ex_factory_p->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table->ex_factory_p->checkBoxListHtml(TRUE, "x_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table->ex_factory_p->displayValueSeparatorAttribute() ?>" name="x_ex_factory_p[]" id="x_ex_factory_p[]" value="{value}"<?php echo $oms_table->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table->ex_factory_p->Lookup->getParamTag("p_x_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
			<span class="ew-search-cond btw1_ex_factory_p d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_ex_factory_p" class="btw1_ex_factory_p d-none">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($oms_table->ex_factory_p->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $oms_table->ex_factory_p->AdvancedSearch->ViewValue2 ?></button>
		<div id="dsl_y_ex_factory_p" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden; max-height: 300px; overflow-y: auto;">
<?php echo $oms_table->ex_factory_p->checkBoxListHtml(TRUE, "y_ex_factory_p[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_y_ex_factory_p" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table" data-field="x_ex_factory_p" data-value-separator="<?php echo $oms_table->ex_factory_p->displayValueSeparatorAttribute() ?>" name="y_ex_factory_p[]" id="y_ex_factory_p[]" value="{value}"<?php echo $oms_table->ex_factory_p->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$oms_table->ex_factory_p->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $oms_table->ex_factory_p->Lookup->getParamTag("p_y_ex_factory_p") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->shipping_mode->Visible) { // shipping_mode ?>
	<div id="r_shipping_mode" class="form-group row">
		<label for="x_shipping_mode" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_shipping_mode"><?php echo $oms_table->shipping_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_mode" id="z_shipping_mode" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->shipping_mode->cellAttributes() ?>>
			<span id="el_oms_table_shipping_mode">
<input type="text" data-table="oms_table" data-field="x_shipping_mode" name="x_shipping_mode" id="x_shipping_mode" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($oms_table->shipping_mode->getPlaceHolder()) ?>" value="<?php echo $oms_table->shipping_mode->EditValue ?>"<?php echo $oms_table->shipping_mode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_po"><?php echo $oms_table->po->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_po">
<input type="text" data-table="oms_table" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($oms_table->po->getPlaceHolder()) ?>" value="<?php echo $oms_table->po->EditValue ?>"<?php echo $oms_table->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_po" class="btw1_po d-none">
<input type="text" data-table="oms_table" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($oms_table->po->getPlaceHolder()) ?>" value="<?php echo $oms_table->po->EditValue2 ?>"<?php echo $oms_table->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_design"><?php echo $oms_table->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->design->cellAttributes() ?>>
			<span id="el_oms_table_design">
<input type="text" data-table="oms_table" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($oms_table->design->getPlaceHolder()) ?>" value="<?php echo $oms_table->design->EditValue ?>"<?php echo $oms_table->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_size_buyer"><?php echo $oms_table->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->size_buyer->cellAttributes() ?>>
			<span id="el_oms_table_size_buyer">
<input type="text" data-table="oms_table" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($oms_table->size_buyer->getPlaceHolder()) ?>" value="<?php echo $oms_table->size_buyer->EditValue ?>"<?php echo $oms_table->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->width->Visible) { // width ?>
	<div id="r_width" class="form-group row">
		<label for="x_width" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_width"><?php echo $oms_table->width->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_width" id="z_width" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->width->cellAttributes() ?>>
			<span id="el_oms_table_width">
<input type="text" data-table="oms_table" data-field="x_width" name="x_width" id="x_width" size="30" placeholder="<?php echo HtmlEncode($oms_table->width->getPlaceHolder()) ?>" value="<?php echo $oms_table->width->EditValue ?>"<?php echo $oms_table->width->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->length->Visible) { // length ?>
	<div id="r_length" class="form-group row">
		<label for="x_length" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_length"><?php echo $oms_table->length->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_length" id="z_length" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->length->cellAttributes() ?>>
			<span id="el_oms_table_length">
<input type="text" data-table="oms_table" data-field="x_length" name="x_length" id="x_length" size="30" placeholder="<?php echo HtmlEncode($oms_table->length->getPlaceHolder()) ?>" value="<?php echo $oms_table->length->EditValue ?>"<?php echo $oms_table->length->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_qty"><?php echo $oms_table->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->qty->cellAttributes() ?>>
			<span id="el_oms_table_qty">
<input type="text" data-table="oms_table" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($oms_table->qty->getPlaceHolder()) ?>" value="<?php echo $oms_table->qty->EditValue ?>"<?php echo $oms_table->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->revised_qty->Visible) { // revised_qty ?>
	<div id="r_revised_qty" class="form-group row">
		<label for="x_revised_qty" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_revised_qty"><?php echo $oms_table->revised_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_revised_qty" id="z_revised_qty" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->revised_qty->cellAttributes() ?>>
			<span id="el_oms_table_revised_qty">
<input type="text" data-table="oms_table" data-field="x_revised_qty" name="x_revised_qty" id="x_revised_qty" size="30" placeholder="<?php echo HtmlEncode($oms_table->revised_qty->getPlaceHolder()) ?>" value="<?php echo $oms_table->revised_qty->EditValue ?>"<?php echo $oms_table->revised_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_sqm"><?php echo $oms_table->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->sqm->cellAttributes() ?>>
			<span id="el_oms_table_sqm">
<input type="text" data-table="oms_table" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table->sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table->sqm->EditValue ?>"<?php echo $oms_table->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->d_qty->Visible) { // d_qty ?>
	<div id="r_d_qty" class="form-group row">
		<label for="x_d_qty" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_d_qty"><?php echo $oms_table->d_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_qty" id="z_d_qty" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->d_qty->cellAttributes() ?>>
			<span id="el_oms_table_d_qty">
<input type="text" data-table="oms_table" data-field="x_d_qty" name="x_d_qty" id="x_d_qty" size="30" placeholder="<?php echo HtmlEncode($oms_table->d_qty->getPlaceHolder()) ?>" value="<?php echo $oms_table->d_qty->EditValue ?>"<?php echo $oms_table->d_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending->Visible) { // pending ?>
	<div id="r_pending" class="form-group row">
		<label for="x_pending" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_pending"><?php echo $oms_table->pending->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->pending->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pending" id="z_pending" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table->pending->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_pending">
<input type="text" data-table="oms_table" data-field="x_pending" name="x_pending" id="x_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending->EditValue ?>"<?php echo $oms_table->pending->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pending d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_pending" class="btw1_pending d-none">
<input type="text" data-table="oms_table" data-field="x_pending" name="y_pending" id="y_pending" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending->EditValue2 ?>"<?php echo $oms_table->pending->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending_sqm->Visible) { // pending_sqm ?>
	<div id="r_pending_sqm" class="form-group row">
		<label for="x_pending_sqm" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_pending_sqm"><?php echo $oms_table->pending_sqm->caption() ?></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->pending_sqm->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pending_sqm" id="z_pending_sqm" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($oms_table->pending_sqm->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_oms_table_pending_sqm">
<input type="text" data-table="oms_table" data-field="x_pending_sqm" name="x_pending_sqm" id="x_pending_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending_sqm->EditValue ?>"<?php echo $oms_table->pending_sqm->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pending_sqm d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_oms_table_pending_sqm" class="btw1_pending_sqm d-none">
<input type="text" data-table="oms_table" data-field="x_pending_sqm" name="y_pending_sqm" id="y_pending_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending_sqm->EditValue2 ?>"<?php echo $oms_table->pending_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->offloom->Visible) { // offloom ?>
	<div id="r_offloom" class="form-group row">
		<label for="x_offloom" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_offloom"><?php echo $oms_table->offloom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_offloom" id="z_offloom" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->offloom->cellAttributes() ?>>
			<span id="el_oms_table_offloom">
<input type="text" data-table="oms_table" data-field="x_offloom" name="x_offloom" id="x_offloom" size="30" placeholder="<?php echo HtmlEncode($oms_table->offloom->getPlaceHolder()) ?>" value="<?php echo $oms_table->offloom->EditValue ?>"<?php echo $oms_table->offloom->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending_offloom->Visible) { // pending_offloom ?>
	<div id="r_pending_offloom" class="form-group row">
		<label for="x_pending_offloom" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_pending_offloom"><?php echo $oms_table->pending_offloom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_offloom" id="z_pending_offloom" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->pending_offloom->cellAttributes() ?>>
			<span id="el_oms_table_pending_offloom">
<input type="text" data-table="oms_table" data-field="x_pending_offloom" name="x_pending_offloom" id="x_pending_offloom" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending_offloom->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending_offloom->EditValue ?>"<?php echo $oms_table->pending_offloom->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
	<div id="r_pending_offloom_sqm" class="form-group row">
		<label for="x_pending_offloom_sqm" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_pending_offloom_sqm"><?php echo $oms_table->pending_offloom_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_offloom_sqm" id="z_pending_offloom_sqm" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->pending_offloom_sqm->cellAttributes() ?>>
			<span id="el_oms_table_pending_offloom_sqm">
<input type="text" data-table="oms_table" data-field="x_pending_offloom_sqm" name="x_pending_offloom_sqm" id="x_pending_offloom_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table->pending_offloom_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table->pending_offloom_sqm->EditValue ?>"<?php echo $oms_table->pending_offloom_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_cbm"><?php echo $oms_table->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cbm" id="z_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->cbm->cellAttributes() ?>>
			<span id="el_oms_table_cbm">
<input type="text" data-table="oms_table" data-field="x_cbm" name="x_cbm" id="x_cbm" size="35" placeholder="<?php echo HtmlEncode($oms_table->cbm->getPlaceHolder()) ?>" value="<?php echo $oms_table->cbm->EditValue ?>"<?php echo $oms_table->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->total_cbm->Visible) { // total_cbm ?>
	<div id="r_total_cbm" class="form-group row">
		<label for="x_total_cbm" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_total_cbm"><?php echo $oms_table->total_cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_total_cbm" id="z_total_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->total_cbm->cellAttributes() ?>>
			<span id="el_oms_table_total_cbm">
<input type="text" data-table="oms_table" data-field="x_total_cbm" name="x_total_cbm" id="x_total_cbm" size="35" placeholder="<?php echo HtmlEncode($oms_table->total_cbm->getPlaceHolder()) ?>" value="<?php echo $oms_table->total_cbm->EditValue ?>"<?php echo $oms_table->total_cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_remarks"><?php echo $oms_table->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->remarks->cellAttributes() ?>>
			<span id="el_oms_table_remarks">
<input type="text" data-table="oms_table" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($oms_table->remarks->getPlaceHolder()) ?>" value="<?php echo $oms_table->remarks->EditValue ?>"<?php echo $oms_table->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_pl_no"><?php echo $oms_table->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->pl_no->cellAttributes() ?>>
			<span id="el_oms_table_pl_no">
<input type="text" data-table="oms_table" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" placeholder="<?php echo HtmlEncode($oms_table->pl_no->getPlaceHolder()) ?>" value="<?php echo $oms_table->pl_no->EditValue ?>"<?php echo $oms_table->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_invoice_date"><?php echo $oms_table->invoice_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_date" id="z_invoice_date" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->invoice_date->cellAttributes() ?>>
			<span id="el_oms_table_invoice_date">
<input type="text" data-table="oms_table" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" size="35" placeholder="<?php echo HtmlEncode($oms_table->invoice_date->getPlaceHolder()) ?>" value="<?php echo $oms_table->invoice_date->EditValue ?>"<?php echo $oms_table->invoice_date->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->sailing_week->Visible) { // sailing_week ?>
	<div id="r_sailing_week" class="form-group row">
		<label for="x_sailing_week" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_sailing_week"><?php echo $oms_table->sailing_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sailing_week" id="z_sailing_week" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->sailing_week->cellAttributes() ?>>
			<span id="el_oms_table_sailing_week">
<input type="text" data-table="oms_table" data-field="x_sailing_week" name="x_sailing_week" id="x_sailing_week" size="35" placeholder="<?php echo HtmlEncode($oms_table->sailing_week->getPlaceHolder()) ?>" value="<?php echo $oms_table->sailing_week->EditValue ?>"<?php echo $oms_table->sailing_week->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->seller_remarks->Visible) { // seller_remarks ?>
	<div id="r_seller_remarks" class="form-group row">
		<label for="x_seller_remarks" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_seller_remarks"><?php echo $oms_table->seller_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_seller_remarks" id="z_seller_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->seller_remarks->cellAttributes() ?>>
			<span id="el_oms_table_seller_remarks">
<input type="text" data-table="oms_table" data-field="x_seller_remarks" name="x_seller_remarks" id="x_seller_remarks" size="35" placeholder="<?php echo HtmlEncode($oms_table->seller_remarks->getPlaceHolder()) ?>" value="<?php echo $oms_table->seller_remarks->EditValue ?>"<?php echo $oms_table->seller_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_status"><?php echo $oms_table->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_status" id="z_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->status->cellAttributes() ?>>
			<span id="el_oms_table_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="oms_table" data-field="x_status" data-value-separator="<?php echo $oms_table->status->displayValueSeparatorAttribute() ?>" id="x_status[]" name="x_status[]" multiple="multiple"<?php echo $oms_table->status->editAttributes() ?>>
		<?php echo $oms_table->status->selectOptionListHtml("x_status[]") ?>
	</select>
</div>
<?php echo $oms_table->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_completed"><?php echo $oms_table->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_completed" id="z_completed" value="LIKE"></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->completed->cellAttributes() ?>>
			<span id="el_oms_table_completed">
<div id="tp_x_completed" class="ew-template"><input type="checkbox" class="form-check-input" data-table="oms_table" data-field="x_completed" data-value-separator="<?php echo $oms_table->completed->displayValueSeparatorAttribute() ?>" name="x_completed[]" id="x_completed[]" value="{value}"<?php echo $oms_table->completed->editAttributes() ?>></div>
<div id="dsl_x_completed" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $oms_table->completed->checkBoxListHtml(FALSE, "x_completed[]") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($oms_table->weight_sqm->Visible) { // weight_sqm ?>
	<div id="r_weight_sqm" class="form-group row">
		<label for="x_weight_sqm" class="<?php echo $oms_table_search->LeftColumnClass ?>"><span id="elh_oms_table_weight_sqm"><?php echo $oms_table->weight_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_sqm" id="z_weight_sqm" value="="></span>
		</label>
		<div class="<?php echo $oms_table_search->RightColumnClass ?>"><div<?php echo $oms_table->weight_sqm->cellAttributes() ?>>
			<span id="el_oms_table_weight_sqm">
<input type="text" data-table="oms_table" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($oms_table->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $oms_table->weight_sqm->EditValue ?>"<?php echo $oms_table->weight_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$oms_table_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $oms_table_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$oms_table_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$oms_table_search->terminate();
?>