<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$oms_table_view = new oms_table_view();

// Run the page
$oms_table_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$oms_table_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$oms_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var foms_tableview = currentForm = new ew.Form("foms_tableview", "view");

// Form_CustomValidate event
foms_tableview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
foms_tableview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
foms_tableview.lists["x_buyers_id"] = <?php echo $oms_table_view->buyers_id->Lookup->toClientList() ?>;
foms_tableview.lists["x_buyers_id"].options = <?php echo JsonEncode($oms_table_view->buyers_id->lookupOptions()) ?>;
foms_tableview.lists["x_reports_to"] = <?php echo $oms_table_view->reports_to->Lookup->toClientList() ?>;
foms_tableview.lists["x_reports_to"].options = <?php echo JsonEncode($oms_table_view->reports_to->lookupOptions()) ?>;
foms_tableview.lists["x_order_week"] = <?php echo $oms_table_view->order_week->Lookup->toClientList() ?>;
foms_tableview.lists["x_order_week"].options = <?php echo JsonEncode($oms_table_view->order_week->lookupOptions()) ?>;
foms_tableview.lists["x_ex_factory"] = <?php echo $oms_table_view->ex_factory->Lookup->toClientList() ?>;
foms_tableview.lists["x_ex_factory"].options = <?php echo JsonEncode($oms_table_view->ex_factory->lookupOptions()) ?>;
foms_tableview.lists["x_ex_factory_p[]"] = <?php echo $oms_table_view->ex_factory_p->Lookup->toClientList() ?>;
foms_tableview.lists["x_ex_factory_p[]"].options = <?php echo JsonEncode($oms_table_view->ex_factory_p->lookupOptions()) ?>;
foms_tableview.lists["x_status[]"] = <?php echo $oms_table_view->status->Lookup->toClientList() ?>;
foms_tableview.lists["x_status[]"].options = <?php echo JsonEncode($oms_table_view->status->lookupOptions()) ?>;
foms_tableview.lists["x_completed[]"] = <?php echo $oms_table_view->completed->Lookup->toClientList() ?>;
foms_tableview.lists["x_completed[]"].options = <?php echo JsonEncode($oms_table_view->completed->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$oms_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $oms_table_view->ExportOptions->render("body") ?>
<?php $oms_table_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $oms_table_view->showPageHeader(); ?>
<?php
$oms_table_view->showMessage();
?>
<form name="foms_tableview" id="foms_tableview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($oms_table_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $oms_table_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="oms_table">
<input type="hidden" name="modal" value="<?php echo (int)$oms_table_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($oms_table->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_id"><?php echo $oms_table->id->caption() ?></span></td>
		<td data-name="id"<?php echo $oms_table->id->cellAttributes() ?>>
<span id="el_oms_table_id">
<span<?php echo $oms_table->id->viewAttributes() ?>>
<?php echo $oms_table->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->buyers_id->Visible) { // buyers_id ?>
	<tr id="r_buyers_id">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_buyers_id"><?php echo $oms_table->buyers_id->caption() ?></span></td>
		<td data-name="buyers_id"<?php echo $oms_table->buyers_id->cellAttributes() ?>>
<span id="el_oms_table_buyers_id">
<span<?php echo $oms_table->buyers_id->viewAttributes() ?>>
<?php echo $oms_table->buyers_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->reports_to->Visible) { // reports_to ?>
	<tr id="r_reports_to">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_reports_to"><?php echo $oms_table->reports_to->caption() ?></span></td>
		<td data-name="reports_to"<?php echo $oms_table->reports_to->cellAttributes() ?>>
<span id="el_oms_table_reports_to">
<span<?php echo $oms_table->reports_to->viewAttributes() ?>>
<?php echo $oms_table->reports_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->buyer_order->Visible) { // buyer_order ?>
	<tr id="r_buyer_order">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_buyer_order"><?php echo $oms_table->buyer_order->caption() ?></span></td>
		<td data-name="buyer_order"<?php echo $oms_table->buyer_order->cellAttributes() ?>>
<span id="el_oms_table_buyer_order">
<span<?php echo $oms_table->buyer_order->viewAttributes() ?>>
<?php echo $oms_table->buyer_order->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_item"><?php echo $oms_table->item->caption() ?></span></td>
		<td data-name="item"<?php echo $oms_table->item->cellAttributes() ?>>
<span id="el_oms_table_item">
<span<?php echo $oms_table->item->viewAttributes() ?>>
<?php echo $oms_table->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_buyer_ref"><?php echo $oms_table->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $oms_table->buyer_ref->cellAttributes() ?>>
<span id="el_oms_table_buyer_ref">
<span<?php echo $oms_table->buyer_ref->viewAttributes() ?>>
<?php echo $oms_table->buyer_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->order_week->Visible) { // order_week ?>
	<tr id="r_order_week">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_order_week"><?php echo $oms_table->order_week->caption() ?></span></td>
		<td data-name="order_week"<?php echo $oms_table->order_week->cellAttributes() ?>>
<span id="el_oms_table_order_week">
<span<?php echo $oms_table->order_week->viewAttributes() ?>>
<?php echo $oms_table->order_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->order_date->Visible) { // order_date ?>
	<tr id="r_order_date">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_order_date"><?php echo $oms_table->order_date->caption() ?></span></td>
		<td data-name="order_date"<?php echo $oms_table->order_date->cellAttributes() ?>>
<span id="el_oms_table_order_date">
<span<?php echo $oms_table->order_date->viewAttributes() ?>>
<?php echo $oms_table->order_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->ex_factory->Visible) { // ex_factory ?>
	<tr id="r_ex_factory">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_ex_factory"><?php echo $oms_table->ex_factory->caption() ?></span></td>
		<td data-name="ex_factory"<?php echo $oms_table->ex_factory->cellAttributes() ?>>
<span id="el_oms_table_ex_factory">
<span<?php echo $oms_table->ex_factory->viewAttributes() ?>>
<?php echo $oms_table->ex_factory->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->ex_factory_p->Visible) { // ex_factory_p ?>
	<tr id="r_ex_factory_p">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_ex_factory_p"><?php echo $oms_table->ex_factory_p->caption() ?></span></td>
		<td data-name="ex_factory_p"<?php echo $oms_table->ex_factory_p->cellAttributes() ?>>
<span id="el_oms_table_ex_factory_p">
<span<?php echo $oms_table->ex_factory_p->viewAttributes() ?>>
<?php echo $oms_table->ex_factory_p->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->shipping_mode->Visible) { // shipping_mode ?>
	<tr id="r_shipping_mode">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_shipping_mode"><?php echo $oms_table->shipping_mode->caption() ?></span></td>
		<td data-name="shipping_mode"<?php echo $oms_table->shipping_mode->cellAttributes() ?>>
<span id="el_oms_table_shipping_mode">
<span<?php echo $oms_table->shipping_mode->viewAttributes() ?>>
<?php echo $oms_table->shipping_mode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_po"><?php echo $oms_table->po->caption() ?></span></td>
		<td data-name="po"<?php echo $oms_table->po->cellAttributes() ?>>
<span id="el_oms_table_po">
<span<?php echo $oms_table->po->viewAttributes() ?>>
<?php echo $oms_table->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->design->Visible) { // design ?>
	<tr id="r_design">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_design"><?php echo $oms_table->design->caption() ?></span></td>
		<td data-name="design"<?php echo $oms_table->design->cellAttributes() ?>>
<span id="el_oms_table_design">
<span<?php echo $oms_table->design->viewAttributes() ?>>
<?php echo $oms_table->design->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->size_buyer->Visible) { // size_buyer ?>
	<tr id="r_size_buyer">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_size_buyer"><?php echo $oms_table->size_buyer->caption() ?></span></td>
		<td data-name="size_buyer"<?php echo $oms_table->size_buyer->cellAttributes() ?>>
<span id="el_oms_table_size_buyer">
<span<?php echo $oms_table->size_buyer->viewAttributes() ?>>
<?php echo $oms_table->size_buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->width->Visible) { // width ?>
	<tr id="r_width">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_width"><?php echo $oms_table->width->caption() ?></span></td>
		<td data-name="width"<?php echo $oms_table->width->cellAttributes() ?>>
<span id="el_oms_table_width">
<span<?php echo $oms_table->width->viewAttributes() ?>>
<?php echo $oms_table->width->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->length->Visible) { // length ?>
	<tr id="r_length">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_length"><?php echo $oms_table->length->caption() ?></span></td>
		<td data-name="length"<?php echo $oms_table->length->cellAttributes() ?>>
<span id="el_oms_table_length">
<span<?php echo $oms_table->length->viewAttributes() ?>>
<?php echo $oms_table->length->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->qty->Visible) { // qty ?>
	<tr id="r_qty">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_qty"><?php echo $oms_table->qty->caption() ?></span></td>
		<td data-name="qty"<?php echo $oms_table->qty->cellAttributes() ?>>
<span id="el_oms_table_qty">
<span<?php echo $oms_table->qty->viewAttributes() ?>>
<?php echo $oms_table->qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->revised_qty->Visible) { // revised_qty ?>
	<tr id="r_revised_qty">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_revised_qty"><?php echo $oms_table->revised_qty->caption() ?></span></td>
		<td data-name="revised_qty"<?php echo $oms_table->revised_qty->cellAttributes() ?>>
<span id="el_oms_table_revised_qty">
<span<?php echo $oms_table->revised_qty->viewAttributes() ?>>
<?php echo $oms_table->revised_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_sqm"><?php echo $oms_table->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $oms_table->sqm->cellAttributes() ?>>
<span id="el_oms_table_sqm">
<span<?php echo $oms_table->sqm->viewAttributes() ?>>
<?php echo $oms_table->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->d_qty->Visible) { // d_qty ?>
	<tr id="r_d_qty">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_d_qty"><?php echo $oms_table->d_qty->caption() ?></span></td>
		<td data-name="d_qty"<?php echo $oms_table->d_qty->cellAttributes() ?>>
<span id="el_oms_table_d_qty">
<span<?php echo $oms_table->d_qty->viewAttributes() ?>>
<?php echo $oms_table->d_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->pending->Visible) { // pending ?>
	<tr id="r_pending">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_pending"><?php echo $oms_table->pending->caption() ?></span></td>
		<td data-name="pending"<?php echo $oms_table->pending->cellAttributes() ?>>
<span id="el_oms_table_pending">
<span<?php echo $oms_table->pending->viewAttributes() ?>>
<?php if ((!EmptyString($oms_table->pending->getViewValue())) && $oms_table->pending->linkAttributes() <> "") { ?>
<a<?php echo $oms_table->pending->linkAttributes() ?>><?php echo $oms_table->pending->getViewValue() ?></a>
<?php } else { ?>
<?php echo $oms_table->pending->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->pending_sqm->Visible) { // pending_sqm ?>
	<tr id="r_pending_sqm">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_pending_sqm"><?php echo $oms_table->pending_sqm->caption() ?></span></td>
		<td data-name="pending_sqm"<?php echo $oms_table->pending_sqm->cellAttributes() ?>>
<span id="el_oms_table_pending_sqm">
<span<?php echo $oms_table->pending_sqm->viewAttributes() ?>>
<?php echo $oms_table->pending_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->offloom->Visible) { // offloom ?>
	<tr id="r_offloom">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_offloom"><?php echo $oms_table->offloom->caption() ?></span></td>
		<td data-name="offloom"<?php echo $oms_table->offloom->cellAttributes() ?>>
<span id="el_oms_table_offloom">
<span<?php echo $oms_table->offloom->viewAttributes() ?>>
<?php echo $oms_table->offloom->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->pending_offloom->Visible) { // pending_offloom ?>
	<tr id="r_pending_offloom">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_pending_offloom"><?php echo $oms_table->pending_offloom->caption() ?></span></td>
		<td data-name="pending_offloom"<?php echo $oms_table->pending_offloom->cellAttributes() ?>>
<span id="el_oms_table_pending_offloom">
<span<?php echo $oms_table->pending_offloom->viewAttributes() ?>>
<?php echo $oms_table->pending_offloom->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->pending_offloom_sqm->Visible) { // pending_offloom_sqm ?>
	<tr id="r_pending_offloom_sqm">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_pending_offloom_sqm"><?php echo $oms_table->pending_offloom_sqm->caption() ?></span></td>
		<td data-name="pending_offloom_sqm"<?php echo $oms_table->pending_offloom_sqm->cellAttributes() ?>>
<span id="el_oms_table_pending_offloom_sqm">
<span<?php echo $oms_table->pending_offloom_sqm->viewAttributes() ?>>
<?php echo $oms_table->pending_offloom_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->cbm->Visible) { // cbm ?>
	<tr id="r_cbm">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_cbm"><?php echo $oms_table->cbm->caption() ?></span></td>
		<td data-name="cbm"<?php echo $oms_table->cbm->cellAttributes() ?>>
<span id="el_oms_table_cbm">
<span<?php echo $oms_table->cbm->viewAttributes() ?>>
<?php echo $oms_table->cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->total_cbm->Visible) { // total_cbm ?>
	<tr id="r_total_cbm">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_total_cbm"><?php echo $oms_table->total_cbm->caption() ?></span></td>
		<td data-name="total_cbm"<?php echo $oms_table->total_cbm->cellAttributes() ?>>
<span id="el_oms_table_total_cbm">
<span<?php echo $oms_table->total_cbm->viewAttributes() ?>>
<?php echo $oms_table->total_cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_remarks"><?php echo $oms_table->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $oms_table->remarks->cellAttributes() ?>>
<span id="el_oms_table_remarks">
<span<?php echo $oms_table->remarks->viewAttributes() ?>>
<?php echo $oms_table->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->pl_no->Visible) { // pl_no ?>
	<tr id="r_pl_no">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_pl_no"><?php echo $oms_table->pl_no->caption() ?></span></td>
		<td data-name="pl_no"<?php echo $oms_table->pl_no->cellAttributes() ?>>
<span id="el_oms_table_pl_no">
<span<?php echo $oms_table->pl_no->viewAttributes() ?>>
<?php if ((!EmptyString($oms_table->pl_no->getViewValue())) && $oms_table->pl_no->linkAttributes() <> "") { ?>
<a<?php echo $oms_table->pl_no->linkAttributes() ?>><?php echo $oms_table->pl_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $oms_table->pl_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->invoice_date->Visible) { // invoice_date ?>
	<tr id="r_invoice_date">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_invoice_date"><?php echo $oms_table->invoice_date->caption() ?></span></td>
		<td data-name="invoice_date"<?php echo $oms_table->invoice_date->cellAttributes() ?>>
<span id="el_oms_table_invoice_date">
<span<?php echo $oms_table->invoice_date->viewAttributes() ?>>
<?php echo $oms_table->invoice_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->sailing_week->Visible) { // sailing_week ?>
	<tr id="r_sailing_week">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_sailing_week"><?php echo $oms_table->sailing_week->caption() ?></span></td>
		<td data-name="sailing_week"<?php echo $oms_table->sailing_week->cellAttributes() ?>>
<span id="el_oms_table_sailing_week">
<span<?php echo $oms_table->sailing_week->viewAttributes() ?>>
<?php echo $oms_table->sailing_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->seller_remarks->Visible) { // seller_remarks ?>
	<tr id="r_seller_remarks">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_seller_remarks"><?php echo $oms_table->seller_remarks->caption() ?></span></td>
		<td data-name="seller_remarks"<?php echo $oms_table->seller_remarks->cellAttributes() ?>>
<span id="el_oms_table_seller_remarks">
<span<?php echo $oms_table->seller_remarks->viewAttributes() ?>>
<?php echo $oms_table->seller_remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_status"><?php echo $oms_table->status->caption() ?></span></td>
		<td data-name="status"<?php echo $oms_table->status->cellAttributes() ?>>
<span id="el_oms_table_status">
<span<?php echo $oms_table->status->viewAttributes() ?>>
<?php echo $oms_table->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->completed->Visible) { // completed ?>
	<tr id="r_completed">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_completed"><?php echo $oms_table->completed->caption() ?></span></td>
		<td data-name="completed"<?php echo $oms_table->completed->cellAttributes() ?>>
<span id="el_oms_table_completed">
<span<?php echo $oms_table->completed->viewAttributes() ?>>
<?php echo $oms_table->completed->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($oms_table->weight_sqm->Visible) { // weight_sqm ?>
	<tr id="r_weight_sqm">
		<td class="<?php echo $oms_table_view->TableLeftColumnClass ?>"><span id="elh_oms_table_weight_sqm"><?php echo $oms_table->weight_sqm->caption() ?></span></td>
		<td data-name="weight_sqm"<?php echo $oms_table->weight_sqm->cellAttributes() ?>>
<span id="el_oms_table_weight_sqm">
<span<?php echo $oms_table->weight_sqm->viewAttributes() ?>>
<?php echo $oms_table->weight_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$oms_table_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$oms_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$oms_table_view->terminate();
?>