<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$other_all_edit = new other_all_edit();

// Run the page
$other_all_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$other_all_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fother_alledit = currentForm = new ew.Form("fother_alledit", "edit");

// Validate form
fother_alledit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($other_all_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->id->caption(), $other_all->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->location->caption(), $other_all->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->emp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_emp_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->emp_id->caption(), $other_all->emp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->item->caption(), $other_all->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->quantity->caption(), $other_all->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($other_all->quantity->errorMessage()) ?>");
		<?php if ($other_all_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->amount->caption(), $other_all->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($other_all->amount->errorMessage()) ?>");
		<?php if ($other_all_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->description->caption(), $other_all->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->upload->Required) { ?>
			felm = this.getElements("x" + infix + "_upload");
			elm = this.getElements("fn_x" + infix + "_upload");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $other_all->upload->caption(), $other_all->upload->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->e_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_e_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->e_operator->caption(), $other_all->e_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($other_all_edit->e_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_e_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $other_all->e_datetime->caption(), $other_all->e_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fother_alledit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fother_alledit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fother_alledit.lists["x_location"] = <?php echo $other_all_edit->location->Lookup->toClientList() ?>;
fother_alledit.lists["x_location"].options = <?php echo JsonEncode($other_all_edit->location->lookupOptions()) ?>;
fother_alledit.lists["x_emp_id[]"] = <?php echo $other_all_edit->emp_id->Lookup->toClientList() ?>;
fother_alledit.lists["x_emp_id[]"].options = <?php echo JsonEncode($other_all_edit->emp_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $other_all_edit->showPageHeader(); ?>
<?php
$other_all_edit->showMessage();
?>
<form name="fother_alledit" id="fother_alledit" class="<?php echo $other_all_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($other_all_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $other_all_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="other_all">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$other_all_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($other_all->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_other_all_id" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->id->caption() ?><?php echo ($other_all->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->id->cellAttributes() ?>>
<span id="el_other_all_id">
<span<?php echo $other_all->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($other_all->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="other_all" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($other_all->id->CurrentValue) ?>">
<?php echo $other_all->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_other_all_location" for="x_location" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->location->caption() ?><?php echo ($other_all->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->location->cellAttributes() ?>>
<span id="el_other_all_location">
<?php $other_all->location->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$other_all->location->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="other_all" data-field="x_location" data-value-separator="<?php echo $other_all->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $other_all->location->editAttributes() ?>>
		<?php echo $other_all->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $other_all->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $other_all->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label id="elh_other_all_emp_id" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->emp_id->caption() ?><?php echo ($other_all->emp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->emp_id->cellAttributes() ?>>
<span id="el_other_all_emp_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_emp_id"><?php echo strval($other_all->emp_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($other_all->emp_id->ViewValue) : $other_all->emp_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($other_all->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($other_all->emp_id->ReadOnly || $other_all->emp_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_emp_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $other_all->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
<input type="hidden" data-table="other_all" data-field="x_emp_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $other_all->emp_id->displayValueSeparatorAttribute() ?>" name="x_emp_id[]" id="x_emp_id[]" value="<?php echo $other_all->emp_id->CurrentValue ?>"<?php echo $other_all->emp_id->editAttributes() ?>>
</span>
<?php echo $other_all->emp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_other_all_item" for="x_item" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->item->caption() ?><?php echo ($other_all->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->item->cellAttributes() ?>>
<span id="el_other_all_item">
<input type="text" data-table="other_all" data-field="x_item" name="x_item" id="x_item" size="30" placeholder="<?php echo HtmlEncode($other_all->item->getPlaceHolder()) ?>" value="<?php echo $other_all->item->EditValue ?>"<?php echo $other_all->item->editAttributes() ?>>
</span>
<?php echo $other_all->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_other_all_quantity" for="x_quantity" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->quantity->caption() ?><?php echo ($other_all->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->quantity->cellAttributes() ?>>
<span id="el_other_all_quantity">
<input type="text" data-table="other_all" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($other_all->quantity->getPlaceHolder()) ?>" value="<?php echo $other_all->quantity->EditValue ?>"<?php echo $other_all->quantity->editAttributes() ?>>
</span>
<?php echo $other_all->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_other_all_amount" for="x_amount" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->amount->caption() ?><?php echo ($other_all->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->amount->cellAttributes() ?>>
<span id="el_other_all_amount">
<input type="text" data-table="other_all" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($other_all->amount->getPlaceHolder()) ?>" value="<?php echo $other_all->amount->EditValue ?>"<?php echo $other_all->amount->editAttributes() ?>>
</span>
<?php echo $other_all->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_other_all_description" for="x_description" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->description->caption() ?><?php echo ($other_all->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->description->cellAttributes() ?>>
<span id="el_other_all_description">
<textarea data-table="other_all" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($other_all->description->getPlaceHolder()) ?>"<?php echo $other_all->description->editAttributes() ?>><?php echo $other_all->description->EditValue ?></textarea>
</span>
<?php echo $other_all->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($other_all->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label id="elh_other_all_upload" class="<?php echo $other_all_edit->LeftColumnClass ?>"><?php echo $other_all->upload->caption() ?><?php echo ($other_all->upload->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $other_all_edit->RightColumnClass ?>"><div<?php echo $other_all->upload->cellAttributes() ?>>
<span id="el_other_all_upload">
<div id="fd_x_upload">
<span title="<?php echo $other_all->upload->title() ? $other_all->upload->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($other_all->upload->ReadOnly || $other_all->upload->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="other_all" data-field="x_upload" name="x_upload" id="x_upload" multiple="multiple"<?php echo $other_all->upload->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_upload" id= "fn_x_upload" value="<?php echo $other_all->upload->Upload->FileName ?>">
<?php if (Post("fa_x_upload") == "0") { ?>
<input type="hidden" name="fa_x_upload" id= "fa_x_upload" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_upload" id= "fa_x_upload" value="1">
<?php } ?>
<input type="hidden" name="fs_x_upload" id= "fs_x_upload" value="200">
<input type="hidden" name="fx_x_upload" id= "fx_x_upload" value="<?php echo $other_all->upload->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_upload" id= "fm_x_upload" value="<?php echo $other_all->upload->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_upload" id= "fc_x_upload" value="<?php echo $other_all->upload->UploadMaxFileCount ?>">
</div>
<table id="ft_x_upload" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $other_all->upload->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$other_all_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $other_all_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $other_all_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$other_all_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$other_all_edit->terminate();
?>