<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$other_all_list = new other_all_list();

// Run the page
$other_all_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$other_all_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$other_all->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fother_alllist = currentForm = new ew.Form("fother_alllist", "list");
fother_alllist.formKeyCountName = '<?php echo $other_all_list->FormKeyCountName ?>';

// Form_CustomValidate event
fother_alllist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fother_alllist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fother_alllist.lists["x_location"] = <?php echo $other_all_list->location->Lookup->toClientList() ?>;
fother_alllist.lists["x_location"].options = <?php echo JsonEncode($other_all_list->location->lookupOptions()) ?>;
fother_alllist.lists["x_emp_id[]"] = <?php echo $other_all_list->emp_id->Lookup->toClientList() ?>;
fother_alllist.lists["x_emp_id[]"].options = <?php echo JsonEncode($other_all_list->emp_id->lookupOptions()) ?>;
fother_alllist.lists["x_payment"] = <?php echo $other_all_list->payment->Lookup->toClientList() ?>;
fother_alllist.lists["x_payment"].options = <?php echo JsonEncode($other_all_list->payment->lookupOptions()) ?>;

// Form object for search
var fother_alllistsrch = currentSearchForm = new ew.Form("fother_alllistsrch");

// Validate function for search
fother_alllistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fother_alllistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fother_alllistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fother_alllistsrch.lists["x_location"] = <?php echo $other_all_list->location->Lookup->toClientList() ?>;
fother_alllistsrch.lists["x_location"].options = <?php echo JsonEncode($other_all_list->location->lookupOptions()) ?>;
fother_alllistsrch.lists["x_payment"] = <?php echo $other_all_list->payment->Lookup->toClientList() ?>;
fother_alllistsrch.lists["x_payment"].options = <?php echo JsonEncode($other_all_list->payment->lookupOptions()) ?>;

// Filters
fother_alllistsrch.filterList = <?php echo $other_all_list->getFilterList() ?>;

// Init search panel as collapsed
fother_alllistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$other_all->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($other_all_list->TotalRecs > 0 && $other_all_list->ExportOptions->visible()) { ?>
<?php $other_all_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($other_all_list->ImportOptions->visible()) { ?>
<?php $other_all_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($other_all_list->SearchOptions->visible()) { ?>
<?php $other_all_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($other_all_list->FilterOptions->visible()) { ?>
<?php $other_all_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$other_all_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$other_all->isExport() && !$other_all->CurrentAction) { ?>
<form name="fother_alllistsrch" id="fother_alllistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($other_all_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fother_alllistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="other_all">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$other_all_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$other_all->RowType = ROWTYPE_SEARCH;

// Render row
$other_all->resetAttributes();
$other_all_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($other_all->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $other_all->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="other_all" data-field="x_location" data-value-separator="<?php echo $other_all->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $other_all->location->editAttributes() ?>>
		<?php echo $other_all->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $other_all->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($other_all->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label for="x_payment" class="ew-search-caption ew-label"><?php echo $other_all->payment->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="other_all" data-field="x_payment" data-value-separator="<?php echo $other_all->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $other_all->payment->editAttributes() ?>>
		<?php echo $other_all->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $other_all->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($other_all_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($other_all_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $other_all_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($other_all_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($other_all_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($other_all_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($other_all_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $other_all_list->showPageHeader(); ?>
<?php
$other_all_list->showMessage();
?>
<?php if ($other_all_list->TotalRecs > 0 || $other_all->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($other_all_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> other_all">
<?php if (!$other_all->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$other_all->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($other_all_list->Pager)) $other_all_list->Pager = new PrevNextPager($other_all_list->StartRec, $other_all_list->DisplayRecs, $other_all_list->TotalRecs, $other_all_list->AutoHidePager) ?>
<?php if ($other_all_list->Pager->RecordCount > 0 && $other_all_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($other_all_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($other_all_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $other_all_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($other_all_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($other_all_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $other_all_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($other_all_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $other_all_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $other_all_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $other_all_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($other_all_list->TotalRecs > 0 && (!$other_all_list->AutoHidePageSizeSelector || $other_all_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="other_all">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($other_all_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($other_all_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($other_all_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($other_all_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($other_all_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($other_all->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $other_all_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fother_alllist" id="fother_alllist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($other_all_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $other_all_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="other_all">
<div id="gmp_other_all" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($other_all_list->TotalRecs > 0 || $other_all->isGridEdit()) { ?>
<table id="tbl_other_alllist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$other_all_list->RowType = ROWTYPE_HEADER;

// Render list options
$other_all_list->renderListOptions();

// Render list options (header, left)
$other_all_list->ListOptions->render("header", "left");
?>
<?php if ($other_all->id->Visible) { // id ?>
	<?php if ($other_all->sortUrl($other_all->id) == "") { ?>
		<th data-name="id" class="<?php echo $other_all->id->headerCellClass() ?>"><div id="elh_other_all_id" class="other_all_id"><div class="ew-table-header-caption"><?php echo $other_all->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $other_all->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->id) ?>',2);"><div id="elh_other_all_id" class="other_all_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($other_all->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->location->Visible) { // location ?>
	<?php if ($other_all->sortUrl($other_all->location) == "") { ?>
		<th data-name="location" class="<?php echo $other_all->location->headerCellClass() ?>"><div id="elh_other_all_location" class="other_all_location"><div class="ew-table-header-caption"><?php echo $other_all->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $other_all->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->location) ?>',2);"><div id="elh_other_all_location" class="other_all_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->emp_id->Visible) { // emp_id ?>
	<?php if ($other_all->sortUrl($other_all->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $other_all->emp_id->headerCellClass() ?>"><div id="elh_other_all_emp_id" class="other_all_emp_id"><div class="ew-table-header-caption"><?php echo $other_all->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $other_all->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->emp_id) ?>',2);"><div id="elh_other_all_emp_id" class="other_all_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->item->Visible) { // item ?>
	<?php if ($other_all->sortUrl($other_all->item) == "") { ?>
		<th data-name="item" class="<?php echo $other_all->item->headerCellClass() ?>"><div id="elh_other_all_item" class="other_all_item"><div class="ew-table-header-caption"><?php echo $other_all->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $other_all->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->item) ?>',2);"><div id="elh_other_all_item" class="other_all_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->item->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->quantity->Visible) { // quantity ?>
	<?php if ($other_all->sortUrl($other_all->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $other_all->quantity->headerCellClass() ?>"><div id="elh_other_all_quantity" class="other_all_quantity"><div class="ew-table-header-caption"><?php echo $other_all->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $other_all->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->quantity) ?>',2);"><div id="elh_other_all_quantity" class="other_all_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->amount->Visible) { // amount ?>
	<?php if ($other_all->sortUrl($other_all->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $other_all->amount->headerCellClass() ?>"><div id="elh_other_all_amount" class="other_all_amount"><div class="ew-table-header-caption"><?php echo $other_all->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $other_all->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->amount) ?>',2);"><div id="elh_other_all_amount" class="other_all_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->description->Visible) { // description ?>
	<?php if ($other_all->sortUrl($other_all->description) == "") { ?>
		<th data-name="description" class="<?php echo $other_all->description->headerCellClass() ?>"><div id="elh_other_all_description" class="other_all_description"><div class="ew-table-header-caption"><?php echo $other_all->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $other_all->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->description) ?>',2);"><div id="elh_other_all_description" class="other_all_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($other_all->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->upload->Visible) { // upload ?>
	<?php if ($other_all->sortUrl($other_all->upload) == "") { ?>
		<th data-name="upload" class="<?php echo $other_all->upload->headerCellClass() ?>"><div id="elh_other_all_upload" class="other_all_upload"><div class="ew-table-header-caption"><?php echo $other_all->upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upload" class="<?php echo $other_all->upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->upload) ?>',2);"><div id="elh_other_all_upload" class="other_all_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($other_all->upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->payment->Visible) { // payment ?>
	<?php if ($other_all->sortUrl($other_all->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $other_all->payment->headerCellClass() ?>"><div id="elh_other_all_payment" class="other_all_payment"><div class="ew-table-header-caption"><?php echo $other_all->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $other_all->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->payment) ?>',2);"><div id="elh_other_all_payment" class="other_all_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->operator->Visible) { // operator ?>
	<?php if ($other_all->sortUrl($other_all->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $other_all->operator->headerCellClass() ?>"><div id="elh_other_all_operator" class="other_all_operator"><div class="ew-table-header-caption"><?php echo $other_all->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $other_all->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->operator) ?>',2);"><div id="elh_other_all_operator" class="other_all_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->datetime->Visible) { // datetime ?>
	<?php if ($other_all->sortUrl($other_all->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $other_all->datetime->headerCellClass() ?>"><div id="elh_other_all_datetime" class="other_all_datetime"><div class="ew-table-header-caption"><?php echo $other_all->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $other_all->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->datetime) ?>',2);"><div id="elh_other_all_datetime" class="other_all_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($other_all->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->e_operator->Visible) { // e_operator ?>
	<?php if ($other_all->sortUrl($other_all->e_operator) == "") { ?>
		<th data-name="e_operator" class="<?php echo $other_all->e_operator->headerCellClass() ?>"><div id="elh_other_all_e_operator" class="other_all_e_operator"><div class="ew-table-header-caption"><?php echo $other_all->e_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_operator" class="<?php echo $other_all->e_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->e_operator) ?>',2);"><div id="elh_other_all_e_operator" class="other_all_e_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->e_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->e_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->e_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($other_all->e_datetime->Visible) { // e_datetime ?>
	<?php if ($other_all->sortUrl($other_all->e_datetime) == "") { ?>
		<th data-name="e_datetime" class="<?php echo $other_all->e_datetime->headerCellClass() ?>"><div id="elh_other_all_e_datetime" class="other_all_e_datetime"><div class="ew-table-header-caption"><?php echo $other_all->e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_datetime" class="<?php echo $other_all->e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $other_all->SortUrl($other_all->e_datetime) ?>',2);"><div id="elh_other_all_e_datetime" class="other_all_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $other_all->e_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($other_all->e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($other_all->e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$other_all_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($other_all->ExportAll && $other_all->isExport()) {
	$other_all_list->StopRec = $other_all_list->TotalRecs;
} else {

	// Set the last record to display
	if ($other_all_list->TotalRecs > $other_all_list->StartRec + $other_all_list->DisplayRecs - 1)
		$other_all_list->StopRec = $other_all_list->StartRec + $other_all_list->DisplayRecs - 1;
	else
		$other_all_list->StopRec = $other_all_list->TotalRecs;
}
$other_all_list->RecCnt = $other_all_list->StartRec - 1;
if ($other_all_list->Recordset && !$other_all_list->Recordset->EOF) {
	$other_all_list->Recordset->moveFirst();
	$selectLimit = $other_all_list->UseSelectLimit;
	if (!$selectLimit && $other_all_list->StartRec > 1)
		$other_all_list->Recordset->move($other_all_list->StartRec - 1);
} elseif (!$other_all->AllowAddDeleteRow && $other_all_list->StopRec == 0) {
	$other_all_list->StopRec = $other_all->GridAddRowCount;
}

// Initialize aggregate
$other_all->RowType = ROWTYPE_AGGREGATEINIT;
$other_all->resetAttributes();
$other_all_list->renderRow();
while ($other_all_list->RecCnt < $other_all_list->StopRec) {
	$other_all_list->RecCnt++;
	if ($other_all_list->RecCnt >= $other_all_list->StartRec) {
		$other_all_list->RowCnt++;

		// Set up key count
		$other_all_list->KeyCount = $other_all_list->RowIndex;

		// Init row class and style
		$other_all->resetAttributes();
		$other_all->CssClass = "";
		if ($other_all->isGridAdd()) {
		} else {
			$other_all_list->loadRowValues($other_all_list->Recordset); // Load row values
		}
		$other_all->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$other_all->RowAttrs = array_merge($other_all->RowAttrs, array('data-rowindex'=>$other_all_list->RowCnt, 'id'=>'r' . $other_all_list->RowCnt . '_other_all', 'data-rowtype'=>$other_all->RowType));

		// Render row
		$other_all_list->renderRow();

		// Render list options
		$other_all_list->renderListOptions();
?>
	<tr<?php echo $other_all->rowAttributes() ?>>
<?php

// Render list options (body, left)
$other_all_list->ListOptions->render("body", "left", $other_all_list->RowCnt);
?>
	<?php if ($other_all->id->Visible) { // id ?>
		<td data-name="id"<?php echo $other_all->id->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_id" class="other_all_id">
<span<?php echo $other_all->id->viewAttributes() ?>>
<?php echo $other_all->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->location->Visible) { // location ?>
		<td data-name="location"<?php echo $other_all->location->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_location" class="other_all_location">
<span<?php echo $other_all->location->viewAttributes() ?>>
<?php echo $other_all->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $other_all->emp_id->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_emp_id" class="other_all_emp_id">
<span<?php echo $other_all->emp_id->viewAttributes() ?>>
<?php echo $other_all->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->item->Visible) { // item ?>
		<td data-name="item"<?php echo $other_all->item->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_item" class="other_all_item">
<span<?php echo $other_all->item->viewAttributes() ?>>
<?php echo $other_all->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $other_all->quantity->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_quantity" class="other_all_quantity">
<span<?php echo $other_all->quantity->viewAttributes() ?>>
<?php echo $other_all->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $other_all->amount->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_amount" class="other_all_amount">
<span<?php echo $other_all->amount->viewAttributes() ?>>
<?php echo $other_all->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->description->Visible) { // description ?>
		<td data-name="description"<?php echo $other_all->description->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_description" class="other_all_description">
<span<?php echo $other_all->description->viewAttributes() ?>>
<?php echo $other_all->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->upload->Visible) { // upload ?>
		<td data-name="upload"<?php echo $other_all->upload->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_upload" class="other_all_upload">
<span>
<?php echo GetFileViewTag($other_all->upload, $other_all->upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $other_all->payment->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_payment" class="other_all_payment">
<span<?php echo $other_all->payment->viewAttributes() ?>>
<?php echo $other_all->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $other_all->operator->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_operator" class="other_all_operator">
<span<?php echo $other_all->operator->viewAttributes() ?>>
<?php echo $other_all->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $other_all->datetime->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_datetime" class="other_all_datetime">
<span<?php echo $other_all->datetime->viewAttributes() ?>>
<?php echo $other_all->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->e_operator->Visible) { // e_operator ?>
		<td data-name="e_operator"<?php echo $other_all->e_operator->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_e_operator" class="other_all_e_operator">
<span<?php echo $other_all->e_operator->viewAttributes() ?>>
<?php echo $other_all->e_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($other_all->e_datetime->Visible) { // e_datetime ?>
		<td data-name="e_datetime"<?php echo $other_all->e_datetime->cellAttributes() ?>>
<span id="el<?php echo $other_all_list->RowCnt ?>_other_all_e_datetime" class="other_all_e_datetime">
<span<?php echo $other_all->e_datetime->viewAttributes() ?>>
<?php echo $other_all->e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$other_all_list->ListOptions->render("body", "right", $other_all_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$other_all->isGridAdd())
		$other_all_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$other_all->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($other_all_list->Recordset)
	$other_all_list->Recordset->Close();
?>
<?php if (!$other_all->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$other_all->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($other_all_list->Pager)) $other_all_list->Pager = new PrevNextPager($other_all_list->StartRec, $other_all_list->DisplayRecs, $other_all_list->TotalRecs, $other_all_list->AutoHidePager) ?>
<?php if ($other_all_list->Pager->RecordCount > 0 && $other_all_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($other_all_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($other_all_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $other_all_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($other_all_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($other_all_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $other_all_list->pageUrl() ?>start=<?php echo $other_all_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $other_all_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($other_all_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $other_all_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $other_all_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $other_all_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($other_all_list->TotalRecs > 0 && (!$other_all_list->AutoHidePageSizeSelector || $other_all_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="other_all">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($other_all_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($other_all_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($other_all_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($other_all_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($other_all_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($other_all->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $other_all_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($other_all_list->TotalRecs == 0 && !$other_all->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $other_all_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$other_all_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$other_all->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$other_all->isExport()) { ?>
<script>
ew.scrollableTable("gmp_other_all", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$other_all_list->terminate();
?>