<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$other_all_search = new other_all_search();

// Run the page
$other_all_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$other_all_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($other_all_search->IsModal) { ?>
var fother_allsearch = currentAdvancedSearchForm = new ew.Form("fother_allsearch", "search");
<?php } else { ?>
var fother_allsearch = currentForm = new ew.Form("fother_allsearch", "search");
<?php } ?>

// Form_CustomValidate event
fother_allsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fother_allsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fother_allsearch.lists["x_location"] = <?php echo $other_all_search->location->Lookup->toClientList() ?>;
fother_allsearch.lists["x_location"].options = <?php echo JsonEncode($other_all_search->location->lookupOptions()) ?>;
fother_allsearch.lists["x_emp_id[]"] = <?php echo $other_all_search->emp_id->Lookup->toClientList() ?>;
fother_allsearch.lists["x_emp_id[]"].options = <?php echo JsonEncode($other_all_search->emp_id->lookupOptions()) ?>;
fother_allsearch.lists["x_payment"] = <?php echo $other_all_search->payment->Lookup->toClientList() ?>;
fother_allsearch.lists["x_payment"].options = <?php echo JsonEncode($other_all_search->payment->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fother_allsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->e_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($other_all->e_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $other_all_search->showPageHeader(); ?>
<?php
$other_all_search->showMessage();
?>
<form name="fother_allsearch" id="fother_allsearch" class="<?php echo $other_all_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($other_all_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $other_all_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="other_all">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$other_all_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($other_all->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_id"><?php echo $other_all->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->id->cellAttributes() ?>>
			<span id="el_other_all_id">
<input type="text" data-table="other_all" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($other_all->id->getPlaceHolder()) ?>" value="<?php echo $other_all->id->EditValue ?>"<?php echo $other_all->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_location"><?php echo $other_all->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->location->cellAttributes() ?>>
			<span id="el_other_all_location">
<?php $other_all->location->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$other_all->location->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="other_all" data-field="x_location" data-value-separator="<?php echo $other_all->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $other_all->location->editAttributes() ?>>
		<?php echo $other_all->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $other_all->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_emp_id"><?php echo $other_all->emp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->emp_id->cellAttributes() ?>>
			<span id="el_other_all_emp_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_emp_id"><?php echo strval($other_all->emp_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($other_all->emp_id->AdvancedSearch->ViewValue) : $other_all->emp_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($other_all->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($other_all->emp_id->ReadOnly || $other_all->emp_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_emp_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $other_all->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
<input type="hidden" data-table="other_all" data-field="x_emp_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $other_all->emp_id->displayValueSeparatorAttribute() ?>" name="x_emp_id[]" id="x_emp_id[]" value="<?php echo $other_all->emp_id->AdvancedSearch->SearchValue ?>"<?php echo $other_all->emp_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_item"><?php echo $other_all->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_item" id="z_item" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->item->cellAttributes() ?>>
			<span id="el_other_all_item">
<input type="text" data-table="other_all" data-field="x_item" name="x_item" id="x_item" size="30" placeholder="<?php echo HtmlEncode($other_all->item->getPlaceHolder()) ?>" value="<?php echo $other_all->item->EditValue ?>"<?php echo $other_all->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_quantity"><?php echo $other_all->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->quantity->cellAttributes() ?>>
			<span id="el_other_all_quantity">
<input type="text" data-table="other_all" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($other_all->quantity->getPlaceHolder()) ?>" value="<?php echo $other_all->quantity->EditValue ?>"<?php echo $other_all->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_amount"><?php echo $other_all->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->amount->cellAttributes() ?>>
			<span id="el_other_all_amount">
<input type="text" data-table="other_all" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($other_all->amount->getPlaceHolder()) ?>" value="<?php echo $other_all->amount->EditValue ?>"<?php echo $other_all->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_description"><?php echo $other_all->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->description->cellAttributes() ?>>
			<span id="el_other_all_description">
<input type="text" data-table="other_all" data-field="x_description" name="x_description" id="x_description" maxlength="255" placeholder="<?php echo HtmlEncode($other_all->description->getPlaceHolder()) ?>" value="<?php echo $other_all->description->EditValue ?>"<?php echo $other_all->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_upload"><?php echo $other_all->upload->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_upload" id="z_upload" value="LIKE"></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->upload->cellAttributes() ?>>
			<span id="el_other_all_upload">
<input type="text" data-table="other_all" data-field="x_upload" name="x_upload" id="x_upload" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($other_all->upload->getPlaceHolder()) ?>" value="<?php echo $other_all->upload->EditValue ?>"<?php echo $other_all->upload->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label for="x_payment" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_payment"><?php echo $other_all->payment->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->payment->cellAttributes() ?>>
			<span id="el_other_all_payment">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="other_all" data-field="x_payment" data-value-separator="<?php echo $other_all->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $other_all->payment->editAttributes() ?>>
		<?php echo $other_all->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $other_all->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_operator"><?php echo $other_all->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->operator->cellAttributes() ?>>
			<span id="el_other_all_operator">
<input type="text" data-table="other_all" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($other_all->operator->getPlaceHolder()) ?>" value="<?php echo $other_all->operator->EditValue ?>"<?php echo $other_all->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_datetime"><?php echo $other_all->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($other_all->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_other_all_datetime">
<input type="text" data-table="other_all" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($other_all->datetime->getPlaceHolder()) ?>" value="<?php echo $other_all->datetime->EditValue ?>"<?php echo $other_all->datetime->editAttributes() ?>>
<?php if (!$other_all->datetime->ReadOnly && !$other_all->datetime->Disabled && !isset($other_all->datetime->EditAttrs["readonly"]) && !isset($other_all->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fother_allsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_other_all_datetime" class="btw1_datetime d-none">
<input type="text" data-table="other_all" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($other_all->datetime->getPlaceHolder()) ?>" value="<?php echo $other_all->datetime->EditValue2 ?>"<?php echo $other_all->datetime->editAttributes() ?>>
<?php if (!$other_all->datetime->ReadOnly && !$other_all->datetime->Disabled && !isset($other_all->datetime->EditAttrs["readonly"]) && !isset($other_all->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fother_allsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->e_operator->Visible) { // e_operator ?>
	<div id="r_e_operator" class="form-group row">
		<label for="x_e_operator" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_e_operator"><?php echo $other_all->e_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_operator" id="z_e_operator" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->e_operator->cellAttributes() ?>>
			<span id="el_other_all_e_operator">
<input type="text" data-table="other_all" data-field="x_e_operator" name="x_e_operator" id="x_e_operator" size="30" placeholder="<?php echo HtmlEncode($other_all->e_operator->getPlaceHolder()) ?>" value="<?php echo $other_all->e_operator->EditValue ?>"<?php echo $other_all->e_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($other_all->e_datetime->Visible) { // e_datetime ?>
	<div id="r_e_datetime" class="form-group row">
		<label for="x_e_datetime" class="<?php echo $other_all_search->LeftColumnClass ?>"><span id="elh_other_all_e_datetime"><?php echo $other_all->e_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_datetime" id="z_e_datetime" value="="></span>
		</label>
		<div class="<?php echo $other_all_search->RightColumnClass ?>"><div<?php echo $other_all->e_datetime->cellAttributes() ?>>
			<span id="el_other_all_e_datetime">
<input type="text" data-table="other_all" data-field="x_e_datetime" name="x_e_datetime" id="x_e_datetime" placeholder="<?php echo HtmlEncode($other_all->e_datetime->getPlaceHolder()) ?>" value="<?php echo $other_all->e_datetime->EditValue ?>"<?php echo $other_all->e_datetime->editAttributes() ?>>
<?php if (!$other_all->e_datetime->ReadOnly && !$other_all->e_datetime->Disabled && !isset($other_all->e_datetime->EditAttrs["readonly"]) && !isset($other_all->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fother_allsearch", "x_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$other_all_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $other_all_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$other_all_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$other_all_search->terminate();
?>