<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_cart_list = new p_cart_list();

// Run the page
$p_cart_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_cart_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$p_cart->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fp_cartlist = currentForm = new ew.Form("fp_cartlist", "list");
fp_cartlist.formKeyCountName = '<?php echo $p_cart_list->FormKeyCountName ?>';

// Form_CustomValidate event
fp_cartlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_cartlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_cartlist.lists["x_company_id"] = <?php echo $p_cart_list->company_id->Lookup->toClientList() ?>;
fp_cartlist.lists["x_company_id"].options = <?php echo JsonEncode($p_cart_list->company_id->lookupOptions()) ?>;
fp_cartlist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_cartlist.lists["x_s_grp"] = <?php echo $p_cart_list->s_grp->Lookup->toClientList() ?>;
fp_cartlist.lists["x_s_grp"].options = <?php echo JsonEncode($p_cart_list->s_grp->lookupOptions()) ?>;
fp_cartlist.lists["x_product"] = <?php echo $p_cart_list->product->Lookup->toClientList() ?>;
fp_cartlist.lists["x_product"].options = <?php echo JsonEncode($p_cart_list->product->lookupOptions()) ?>;
fp_cartlist.lists["x_rid_tmp"] = <?php echo $p_cart_list->rid_tmp->Lookup->toClientList() ?>;
fp_cartlist.lists["x_rid_tmp"].options = <?php echo JsonEncode($p_cart_list->rid_tmp->lookupOptions()) ?>;
fp_cartlist.autoSuggests["x_rid_tmp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_cartlist.lists["x_rid"] = <?php echo $p_cart_list->rid->Lookup->toClientList() ?>;
fp_cartlist.lists["x_rid"].options = <?php echo JsonEncode($p_cart_list->rid->lookupOptions()) ?>;
fp_cartlist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_cartlist.lists["x_packing_type"] = <?php echo $p_cart_list->packing_type->Lookup->toClientList() ?>;
fp_cartlist.lists["x_packing_type"].options = <?php echo JsonEncode($p_cart_list->packing_type->lookupOptions()) ?>;
fp_cartlist.lists["x_c_operator"] = <?php echo $p_cart_list->c_operator->Lookup->toClientList() ?>;
fp_cartlist.lists["x_c_operator"].options = <?php echo JsonEncode($p_cart_list->c_operator->lookupOptions()) ?>;

// Form object for search
var fp_cartlistsrch = currentSearchForm = new ew.Form("fp_cartlistsrch");

// Filters
fp_cartlistsrch.filterList = <?php echo $p_cart_list->getFilterList() ?>;

// Init search panel as collapsed
fp_cartlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$p_cart->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($p_cart_list->TotalRecs > 0 && $p_cart_list->ExportOptions->visible()) { ?>
<?php $p_cart_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($p_cart_list->ImportOptions->visible()) { ?>
<?php $p_cart_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($p_cart_list->SearchOptions->visible()) { ?>
<?php $p_cart_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($p_cart_list->FilterOptions->visible()) { ?>
<?php $p_cart_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$p_cart_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$p_cart->isExport() && !$p_cart->CurrentAction) { ?>
<form name="fp_cartlistsrch" id="fp_cartlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($p_cart_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fp_cartlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="p_cart">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($p_cart_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($p_cart_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $p_cart_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($p_cart_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($p_cart_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($p_cart_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($p_cart_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $p_cart_list->showPageHeader(); ?>
<?php
$p_cart_list->showMessage();
?>
<?php if ($p_cart_list->TotalRecs > 0 || $p_cart->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($p_cart_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> p_cart">
<?php if (!$p_cart->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$p_cart->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_cart_list->Pager)) $p_cart_list->Pager = new PrevNextPager($p_cart_list->StartRec, $p_cart_list->DisplayRecs, $p_cart_list->TotalRecs, $p_cart_list->AutoHidePager) ?>
<?php if ($p_cart_list->Pager->RecordCount > 0 && $p_cart_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_cart_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_cart_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_cart_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_cart_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_cart_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_cart_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_cart_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_cart_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_cart_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_cart_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_cart_list->TotalRecs > 0 && (!$p_cart_list->AutoHidePageSizeSelector || $p_cart_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_cart">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_cart_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_cart_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_cart_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_cart_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_cart_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_cart->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_cart_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fp_cartlist" id="fp_cartlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_cart_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_cart_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_cart">
<div id="gmp_p_cart" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($p_cart_list->TotalRecs > 0 || $p_cart->isGridEdit()) { ?>
<table id="tbl_p_cartlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$p_cart_list->RowType = ROWTYPE_HEADER;

// Render list options
$p_cart_list->renderListOptions();

// Render list options (header, left)
$p_cart_list->ListOptions->render("header", "left");
?>
<?php if ($p_cart->id->Visible) { // id ?>
	<?php if ($p_cart->sortUrl($p_cart->id) == "") { ?>
		<th data-name="id" class="<?php echo $p_cart->id->headerCellClass() ?>"><div id="elh_p_cart_id" class="p_cart_id"><div class="ew-table-header-caption"><?php echo $p_cart->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $p_cart->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->id) ?>',2);"><div id="elh_p_cart_id" class="p_cart_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->company_id->Visible) { // company_id ?>
	<?php if ($p_cart->sortUrl($p_cart->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $p_cart->company_id->headerCellClass() ?>"><div id="elh_p_cart_company_id" class="p_cart_company_id"><div class="ew-table-header-caption"><?php echo $p_cart->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $p_cart->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->company_id) ?>',2);"><div id="elh_p_cart_company_id" class="p_cart_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->company_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->s_grp->Visible) { // s_grp ?>
	<?php if ($p_cart->sortUrl($p_cart->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $p_cart->s_grp->headerCellClass() ?>"><div id="elh_p_cart_s_grp" class="p_cart_s_grp"><div class="ew-table-header-caption"><?php echo $p_cart->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $p_cart->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->s_grp) ?>',2);"><div id="elh_p_cart_s_grp" class="p_cart_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->product->Visible) { // product ?>
	<?php if ($p_cart->sortUrl($p_cart->product) == "") { ?>
		<th data-name="product" class="<?php echo $p_cart->product->headerCellClass() ?>"><div id="elh_p_cart_product" class="p_cart_product"><div class="ew-table-header-caption"><?php echo $p_cart->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $p_cart->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->product) ?>',2);"><div id="elh_p_cart_product" class="p_cart_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->rid_tmp->Visible) { // rid_tmp ?>
	<?php if ($p_cart->sortUrl($p_cart->rid_tmp) == "") { ?>
		<th data-name="rid_tmp" class="<?php echo $p_cart->rid_tmp->headerCellClass() ?>"><div id="elh_p_cart_rid_tmp" class="p_cart_rid_tmp"><div class="ew-table-header-caption"><?php echo $p_cart->rid_tmp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid_tmp" class="<?php echo $p_cart->rid_tmp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->rid_tmp) ?>',2);"><div id="elh_p_cart_rid_tmp" class="p_cart_rid_tmp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->rid_tmp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->rid_tmp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->rid_tmp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->rid->Visible) { // rid ?>
	<?php if ($p_cart->sortUrl($p_cart->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $p_cart->rid->headerCellClass() ?>"><div id="elh_p_cart_rid" class="p_cart_rid"><div class="ew-table-header-caption"><?php echo $p_cart->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $p_cart->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->rid) ?>',2);"><div id="elh_p_cart_rid" class="p_cart_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->packing_type->Visible) { // packing_type ?>
	<?php if ($p_cart->sortUrl($p_cart->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $p_cart->packing_type->headerCellClass() ?>"><div id="elh_p_cart_packing_type" class="p_cart_packing_type"><div class="ew-table-header-caption"><?php echo $p_cart->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $p_cart->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->packing_type) ?>',2);"><div id="elh_p_cart_packing_type" class="p_cart_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->color->Visible) { // color ?>
	<?php if ($p_cart->sortUrl($p_cart->color) == "") { ?>
		<th data-name="color" class="<?php echo $p_cart->color->headerCellClass() ?>"><div id="elh_p_cart_color" class="p_cart_color"><div class="ew-table-header-caption"><?php echo $p_cart->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $p_cart->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->color) ?>',2);"><div id="elh_p_cart_color" class="p_cart_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->color->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->quantity_sub->Visible) { // quantity_sub ?>
	<?php if ($p_cart->sortUrl($p_cart->quantity_sub) == "") { ?>
		<th data-name="quantity_sub" class="<?php echo $p_cart->quantity_sub->headerCellClass() ?>"><div id="elh_p_cart_quantity_sub" class="p_cart_quantity_sub"><div class="ew-table-header-caption"><?php echo $p_cart->quantity_sub->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_sub" class="<?php echo $p_cart->quantity_sub->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->quantity_sub) ?>',2);"><div id="elh_p_cart_quantity_sub" class="p_cart_quantity_sub">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->quantity_sub->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->quantity_sub->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->quantity_sub->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->qty->Visible) { // qty ?>
	<?php if ($p_cart->sortUrl($p_cart->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $p_cart->qty->headerCellClass() ?>"><div id="elh_p_cart_qty" class="p_cart_qty"><div class="ew-table-header-caption"><?php echo $p_cart->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $p_cart->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->qty) ?>',2);"><div id="elh_p_cart_qty" class="p_cart_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->price->Visible) { // price ?>
	<?php if ($p_cart->sortUrl($p_cart->price) == "") { ?>
		<th data-name="price" class="<?php echo $p_cart->price->headerCellClass() ?>"><div id="elh_p_cart_price" class="p_cart_price"><div class="ew-table-header-caption"><?php echo $p_cart->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $p_cart->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->price) ?>',2);"><div id="elh_p_cart_price" class="p_cart_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->amount->Visible) { // amount ?>
	<?php if ($p_cart->sortUrl($p_cart->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $p_cart->amount->headerCellClass() ?>"><div id="elh_p_cart_amount" class="p_cart_amount"><div class="ew-table-header-caption"><?php echo $p_cart->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $p_cart->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->amount) ?>',2);"><div id="elh_p_cart_amount" class="p_cart_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->operator->Visible) { // operator ?>
	<?php if ($p_cart->sortUrl($p_cart->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $p_cart->operator->headerCellClass() ?>"><div id="elh_p_cart_operator" class="p_cart_operator"><div class="ew-table-header-caption"><?php echo $p_cart->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $p_cart->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->operator) ?>',2);"><div id="elh_p_cart_operator" class="p_cart_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->datetime->Visible) { // datetime ?>
	<?php if ($p_cart->sortUrl($p_cart->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $p_cart->datetime->headerCellClass() ?>"><div id="elh_p_cart_datetime" class="p_cart_datetime"><div class="ew-table-header-caption"><?php echo $p_cart->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $p_cart->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->datetime) ?>',2);"><div id="elh_p_cart_datetime" class="p_cart_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->po_id->Visible) { // po_id ?>
	<?php if ($p_cart->sortUrl($p_cart->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $p_cart->po_id->headerCellClass() ?>"><div id="elh_p_cart_po_id" class="p_cart_po_id"><div class="ew-table-header-caption"><?php echo $p_cart->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $p_cart->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->po_id) ?>',2);"><div id="elh_p_cart_po_id" class="p_cart_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->po_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->c_operator->Visible) { // c_operator ?>
	<?php if ($p_cart->sortUrl($p_cart->c_operator) == "") { ?>
		<th data-name="c_operator" class="<?php echo $p_cart->c_operator->headerCellClass() ?>"><div id="elh_p_cart_c_operator" class="p_cart_c_operator"><div class="ew-table-header-caption"><?php echo $p_cart->c_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_operator" class="<?php echo $p_cart->c_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->c_operator) ?>',2);"><div id="elh_p_cart_c_operator" class="p_cart_c_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->c_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->c_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->c_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->c_datetime->Visible) { // c_datetime ?>
	<?php if ($p_cart->sortUrl($p_cart->c_datetime) == "") { ?>
		<th data-name="c_datetime" class="<?php echo $p_cart->c_datetime->headerCellClass() ?>"><div id="elh_p_cart_c_datetime" class="p_cart_c_datetime"><div class="ew-table-header-caption"><?php echo $p_cart->c_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_datetime" class="<?php echo $p_cart->c_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->c_datetime) ?>',2);"><div id="elh_p_cart_c_datetime" class="p_cart_c_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->c_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_cart->c_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->c_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->d_operator->Visible) { // d_operator ?>
	<?php if ($p_cart->sortUrl($p_cart->d_operator) == "") { ?>
		<th data-name="d_operator" class="<?php echo $p_cart->d_operator->headerCellClass() ?>"><div id="elh_p_cart_d_operator" class="p_cart_d_operator"><div class="ew-table-header-caption"><?php echo $p_cart->d_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_operator" class="<?php echo $p_cart->d_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->d_operator) ?>',2);"><div id="elh_p_cart_d_operator" class="p_cart_d_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->d_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->d_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->d_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_cart->d_datetime->Visible) { // d_datetime ?>
	<?php if ($p_cart->sortUrl($p_cart->d_datetime) == "") { ?>
		<th data-name="d_datetime" class="<?php echo $p_cart->d_datetime->headerCellClass() ?>"><div id="elh_p_cart_d_datetime" class="p_cart_d_datetime"><div class="ew-table-header-caption"><?php echo $p_cart->d_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_datetime" class="<?php echo $p_cart->d_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_cart->SortUrl($p_cart->d_datetime) ?>',2);"><div id="elh_p_cart_d_datetime" class="p_cart_d_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_cart->d_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_cart->d_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_cart->d_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$p_cart_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($p_cart->ExportAll && $p_cart->isExport()) {
	$p_cart_list->StopRec = $p_cart_list->TotalRecs;
} else {

	// Set the last record to display
	if ($p_cart_list->TotalRecs > $p_cart_list->StartRec + $p_cart_list->DisplayRecs - 1)
		$p_cart_list->StopRec = $p_cart_list->StartRec + $p_cart_list->DisplayRecs - 1;
	else
		$p_cart_list->StopRec = $p_cart_list->TotalRecs;
}
$p_cart_list->RecCnt = $p_cart_list->StartRec - 1;
if ($p_cart_list->Recordset && !$p_cart_list->Recordset->EOF) {
	$p_cart_list->Recordset->moveFirst();
	$selectLimit = $p_cart_list->UseSelectLimit;
	if (!$selectLimit && $p_cart_list->StartRec > 1)
		$p_cart_list->Recordset->move($p_cart_list->StartRec - 1);
} elseif (!$p_cart->AllowAddDeleteRow && $p_cart_list->StopRec == 0) {
	$p_cart_list->StopRec = $p_cart->GridAddRowCount;
}

// Initialize aggregate
$p_cart->RowType = ROWTYPE_AGGREGATEINIT;
$p_cart->resetAttributes();
$p_cart_list->renderRow();
while ($p_cart_list->RecCnt < $p_cart_list->StopRec) {
	$p_cart_list->RecCnt++;
	if ($p_cart_list->RecCnt >= $p_cart_list->StartRec) {
		$p_cart_list->RowCnt++;

		// Set up key count
		$p_cart_list->KeyCount = $p_cart_list->RowIndex;

		// Init row class and style
		$p_cart->resetAttributes();
		$p_cart->CssClass = "";
		if ($p_cart->isGridAdd()) {
		} else {
			$p_cart_list->loadRowValues($p_cart_list->Recordset); // Load row values
		}
		$p_cart->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$p_cart->RowAttrs = array_merge($p_cart->RowAttrs, array('data-rowindex'=>$p_cart_list->RowCnt, 'id'=>'r' . $p_cart_list->RowCnt . '_p_cart', 'data-rowtype'=>$p_cart->RowType));

		// Render row
		$p_cart_list->renderRow();

		// Render list options
		$p_cart_list->renderListOptions();
?>
	<tr<?php echo $p_cart->rowAttributes() ?>>
<?php

// Render list options (body, left)
$p_cart_list->ListOptions->render("body", "left", $p_cart_list->RowCnt);
?>
	<?php if ($p_cart->id->Visible) { // id ?>
		<td data-name="id"<?php echo $p_cart->id->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_id" class="p_cart_id">
<span<?php echo $p_cart->id->viewAttributes() ?>>
<?php echo $p_cart->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $p_cart->company_id->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_company_id" class="p_cart_company_id">
<span<?php echo $p_cart->company_id->viewAttributes() ?>>
<?php echo $p_cart->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $p_cart->s_grp->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_s_grp" class="p_cart_s_grp">
<span<?php echo $p_cart->s_grp->viewAttributes() ?>>
<?php echo $p_cart->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->product->Visible) { // product ?>
		<td data-name="product"<?php echo $p_cart->product->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_product" class="p_cart_product">
<span<?php echo $p_cart->product->viewAttributes() ?>>
<?php echo $p_cart->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->rid_tmp->Visible) { // rid_tmp ?>
		<td data-name="rid_tmp"<?php echo $p_cart->rid_tmp->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_rid_tmp" class="p_cart_rid_tmp">
<span<?php echo $p_cart->rid_tmp->viewAttributes() ?>>
<?php echo $p_cart->rid_tmp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $p_cart->rid->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_rid" class="p_cart_rid">
<span<?php echo $p_cart->rid->viewAttributes() ?>>
<?php echo $p_cart->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $p_cart->packing_type->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_packing_type" class="p_cart_packing_type">
<span<?php echo $p_cart->packing_type->viewAttributes() ?>>
<?php echo $p_cart->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->color->Visible) { // color ?>
		<td data-name="color"<?php echo $p_cart->color->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_color" class="p_cart_color">
<span<?php echo $p_cart->color->viewAttributes() ?>>
<?php echo $p_cart->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->quantity_sub->Visible) { // quantity_sub ?>
		<td data-name="quantity_sub"<?php echo $p_cart->quantity_sub->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_quantity_sub" class="p_cart_quantity_sub">
<span<?php echo $p_cart->quantity_sub->viewAttributes() ?>>
<?php echo $p_cart->quantity_sub->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $p_cart->qty->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_qty" class="p_cart_qty">
<span<?php echo $p_cart->qty->viewAttributes() ?>>
<?php echo $p_cart->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->price->Visible) { // price ?>
		<td data-name="price"<?php echo $p_cart->price->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_price" class="p_cart_price">
<span<?php echo $p_cart->price->viewAttributes() ?>>
<?php echo $p_cart->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $p_cart->amount->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_amount" class="p_cart_amount">
<span<?php echo $p_cart->amount->viewAttributes() ?>>
<?php echo $p_cart->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $p_cart->operator->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_operator" class="p_cart_operator">
<span<?php echo $p_cart->operator->viewAttributes() ?>>
<?php echo $p_cart->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $p_cart->datetime->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_datetime" class="p_cart_datetime">
<span<?php echo $p_cart->datetime->viewAttributes() ?>>
<?php echo $p_cart->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $p_cart->po_id->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_po_id" class="p_cart_po_id">
<span<?php echo $p_cart->po_id->viewAttributes() ?>>
<?php echo $p_cart->po_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->c_operator->Visible) { // c_operator ?>
		<td data-name="c_operator"<?php echo $p_cart->c_operator->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_c_operator" class="p_cart_c_operator">
<span<?php echo $p_cart->c_operator->viewAttributes() ?>>
<?php echo $p_cart->c_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->c_datetime->Visible) { // c_datetime ?>
		<td data-name="c_datetime"<?php echo $p_cart->c_datetime->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_c_datetime" class="p_cart_c_datetime">
<span<?php echo $p_cart->c_datetime->viewAttributes() ?>>
<?php echo $p_cart->c_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->d_operator->Visible) { // d_operator ?>
		<td data-name="d_operator"<?php echo $p_cart->d_operator->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_d_operator" class="p_cart_d_operator">
<span<?php echo $p_cart->d_operator->viewAttributes() ?>>
<?php echo $p_cart->d_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_cart->d_datetime->Visible) { // d_datetime ?>
		<td data-name="d_datetime"<?php echo $p_cart->d_datetime->cellAttributes() ?>>
<span id="el<?php echo $p_cart_list->RowCnt ?>_p_cart_d_datetime" class="p_cart_d_datetime">
<span<?php echo $p_cart->d_datetime->viewAttributes() ?>>
<?php echo $p_cart->d_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$p_cart_list->ListOptions->render("body", "right", $p_cart_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$p_cart->isGridAdd())
		$p_cart_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$p_cart->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($p_cart_list->Recordset)
	$p_cart_list->Recordset->Close();
?>
<?php if (!$p_cart->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$p_cart->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_cart_list->Pager)) $p_cart_list->Pager = new PrevNextPager($p_cart_list->StartRec, $p_cart_list->DisplayRecs, $p_cart_list->TotalRecs, $p_cart_list->AutoHidePager) ?>
<?php if ($p_cart_list->Pager->RecordCount > 0 && $p_cart_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_cart_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_cart_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_cart_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_cart_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_cart_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_cart_list->pageUrl() ?>start=<?php echo $p_cart_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_cart_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_cart_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_cart_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_cart_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_cart_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_cart_list->TotalRecs > 0 && (!$p_cart_list->AutoHidePageSizeSelector || $p_cart_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_cart">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_cart_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_cart_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_cart_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_cart_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_cart_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_cart->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_cart_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($p_cart_list->TotalRecs == 0 && !$p_cart->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $p_cart_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$p_cart_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$p_cart->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$p_cart->isExport()) { ?>
<script>
ew.scrollableTable("gmp_p_cart", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$p_cart_list->terminate();
?>