<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_cart_search = new p_cart_search();

// Run the page
$p_cart_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_cart_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($p_cart_search->IsModal) { ?>
var fp_cartsearch = currentAdvancedSearchForm = new ew.Form("fp_cartsearch", "search");
<?php } else { ?>
var fp_cartsearch = currentForm = new ew.Form("fp_cartsearch", "search");
<?php } ?>

// Form_CustomValidate event
fp_cartsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_cartsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_cartsearch.lists["x_company_id"] = <?php echo $p_cart_search->company_id->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_company_id"].options = <?php echo JsonEncode($p_cart_search->company_id->lookupOptions()) ?>;
fp_cartsearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_cartsearch.lists["x_s_grp"] = <?php echo $p_cart_search->s_grp->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_s_grp"].options = <?php echo JsonEncode($p_cart_search->s_grp->lookupOptions()) ?>;
fp_cartsearch.lists["x_rid_tmp"] = <?php echo $p_cart_search->rid_tmp->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_rid_tmp"].options = <?php echo JsonEncode($p_cart_search->rid_tmp->lookupOptions()) ?>;
fp_cartsearch.autoSuggests["x_rid_tmp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_cartsearch.lists["x_rid"] = <?php echo $p_cart_search->rid->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_rid"].options = <?php echo JsonEncode($p_cart_search->rid->lookupOptions()) ?>;
fp_cartsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_cartsearch.lists["x_packing_type"] = <?php echo $p_cart_search->packing_type->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_packing_type"].options = <?php echo JsonEncode($p_cart_search->packing_type->lookupOptions()) ?>;
fp_cartsearch.lists["x_color_2[]"] = <?php echo $p_cart_search->color_2->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_color_2[]"].options = <?php echo JsonEncode($p_cart_search->color_2->options(FALSE, TRUE)) ?>;
fp_cartsearch.lists["x_c_operator"] = <?php echo $p_cart_search->c_operator->Lookup->toClientList() ?>;
fp_cartsearch.lists["x_c_operator"].options = <?php echo JsonEncode($p_cart_search->c_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fp_cartsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity_sub");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->quantity_sub->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->po_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_c_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->c_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->d_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_cart->d_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_cart_search->showPageHeader(); ?>
<?php
$p_cart_search->showMessage();
?>
<form name="fp_cartsearch" id="fp_cartsearch" class="<?php echo $p_cart_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_cart_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_cart_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_cart">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$p_cart_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($p_cart->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_id"><?php echo $p_cart->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->id->cellAttributes() ?>>
			<span id="el_p_cart_id">
<input type="text" data-table="p_cart" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($p_cart->id->getPlaceHolder()) ?>" value="<?php echo $p_cart->id->EditValue ?>"<?php echo $p_cart->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_company_id"><?php echo $p_cart->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->company_id->cellAttributes() ?>>
			<span id="el_p_cart_company_id">
<?php
$wrkonchange = "" . trim(@$p_cart->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_cart->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($p_cart->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_cart->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_cart->company_id->getPlaceHolder()) ?>"<?php echo $p_cart->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_cart->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_cart->company_id->ReadOnly || $p_cart->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_cart" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_cart->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($p_cart->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_cartsearch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $p_cart->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_s_grp"><?php echo $p_cart->s_grp->caption() ?></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->s_grp->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_s_grp" id="z_s_grp" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($p_cart->s_grp->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_p_cart_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_cart" data-field="x_s_grp" data-value-separator="<?php echo $p_cart->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $p_cart->s_grp->editAttributes() ?>>
		<?php echo $p_cart->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $p_cart->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
			<span class="ew-search-cond btw1_s_grp d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_p_cart_s_grp" class="btw1_s_grp d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_cart" data-field="x_s_grp" data-value-separator="<?php echo $p_cart->s_grp->displayValueSeparatorAttribute() ?>" id="y_s_grp" name="y_s_grp"<?php echo $p_cart->s_grp->editAttributes() ?>>
		<?php echo $p_cart->s_grp->selectOptionListHtml("y_s_grp") ?>
	</select>
</div>
<?php echo $p_cart->s_grp->Lookup->getParamTag("p_y_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->rid_tmp->Visible) { // rid_tmp ?>
	<div id="r_rid_tmp" class="form-group row">
		<label class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_rid_tmp"><?php echo $p_cart->rid_tmp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_tmp" id="z_rid_tmp" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->rid_tmp->cellAttributes() ?>>
			<span id="el_p_cart_rid_tmp">
<?php
$wrkonchange = "" . trim(@$p_cart->rid_tmp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_cart->rid_tmp->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid_tmp" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid_tmp" id="sv_x_rid_tmp" value="<?php echo RemoveHtml($p_cart->rid_tmp->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($p_cart->rid_tmp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_cart->rid_tmp->getPlaceHolder()) ?>"<?php echo $p_cart->rid_tmp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_cart->rid_tmp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid_tmp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_cart->rid_tmp->ReadOnly || $p_cart->rid_tmp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_cart" data-field="x_rid_tmp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_cart->rid_tmp->displayValueSeparatorAttribute() ?>" name="x_rid_tmp" id="x_rid_tmp" value="<?php echo HtmlEncode($p_cart->rid_tmp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_cartsearch.createAutoSuggest({"id":"x_rid_tmp","forceSelect":true});
</script>
<?php echo $p_cart->rid_tmp->Lookup->getParamTag("p_x_rid_tmp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_rid"><?php echo $p_cart->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->rid->cellAttributes() ?>>
			<span id="el_p_cart_rid">
<?php
$wrkonchange = "" . trim(@$p_cart->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_cart->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($p_cart->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_cart->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_cart->rid->getPlaceHolder()) ?>"<?php echo $p_cart->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="p_cart" data-field="x_rid" data-value-separator="<?php echo $p_cart->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($p_cart->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_cartsearch.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $p_cart->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_packing_type"><?php echo $p_cart->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->packing_type->cellAttributes() ?>>
			<span id="el_p_cart_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_cart" data-field="x_packing_type" data-value-separator="<?php echo $p_cart->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $p_cart->packing_type->editAttributes() ?>>
		<?php echo $p_cart->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $p_cart->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->color_2->Visible) { // color_2 ?>
	<div id="r_color_2" class="form-group row">
		<label class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_color_2"><?php echo $p_cart->color_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color_2" id="z_color_2" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->color_2->cellAttributes() ?>>
			<span id="el_p_cart_color_2">
<div id="tp_x_color_2" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_cart" data-field="x_color_2" data-value-separator="<?php echo $p_cart->color_2->displayValueSeparatorAttribute() ?>" name="x_color_2[]" id="x_color_2[]" value="{value}"<?php echo $p_cart->color_2->editAttributes() ?>></div>
<div id="dsl_x_color_2" data-repeatcolumn="4" class="ew-item-list d-none"><div>
<?php echo $p_cart->color_2->checkBoxListHtml(FALSE, "x_color_2[]") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label for="x_color" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_color"><?php echo $p_cart->color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_color" id="z_color" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->color->cellAttributes() ?>>
			<span id="el_p_cart_color">
<input type="text" data-table="p_cart" data-field="x_color" name="x_color" id="x_color" size="30" placeholder="<?php echo HtmlEncode($p_cart->color->getPlaceHolder()) ?>" value="<?php echo $p_cart->color->EditValue ?>"<?php echo $p_cart->color->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->quantity_sub->Visible) { // quantity_sub ?>
	<div id="r_quantity_sub" class="form-group row">
		<label for="x_quantity_sub" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_quantity_sub"><?php echo $p_cart->quantity_sub->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_sub" id="z_quantity_sub" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->quantity_sub->cellAttributes() ?>>
			<span id="el_p_cart_quantity_sub">
<input type="text" data-table="p_cart" data-field="x_quantity_sub" name="x_quantity_sub" id="x_quantity_sub" size="30" placeholder="<?php echo HtmlEncode($p_cart->quantity_sub->getPlaceHolder()) ?>" value="<?php echo $p_cart->quantity_sub->EditValue ?>"<?php echo $p_cart->quantity_sub->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_qty"><?php echo $p_cart->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->qty->cellAttributes() ?>>
			<span id="el_p_cart_qty">
<input type="text" data-table="p_cart" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($p_cart->qty->getPlaceHolder()) ?>" value="<?php echo $p_cart->qty->EditValue ?>"<?php echo $p_cart->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_price"><?php echo $p_cart->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->price->cellAttributes() ?>>
			<span id="el_p_cart_price">
<input type="text" data-table="p_cart" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($p_cart->price->getPlaceHolder()) ?>" value="<?php echo $p_cart->price->EditValue ?>"<?php echo $p_cart->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_amount"><?php echo $p_cart->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->amount->cellAttributes() ?>>
			<span id="el_p_cart_amount">
<input type="text" data-table="p_cart" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($p_cart->amount->getPlaceHolder()) ?>" value="<?php echo $p_cart->amount->EditValue ?>"<?php echo $p_cart->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_remarks"><?php echo $p_cart->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->remarks->cellAttributes() ?>>
			<span id="el_p_cart_remarks">
<input type="text" data-table="p_cart" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($p_cart->remarks->getPlaceHolder()) ?>" value="<?php echo $p_cart->remarks->EditValue ?>"<?php echo $p_cart->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_operator"><?php echo $p_cart->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->operator->cellAttributes() ?>>
			<span id="el_p_cart_operator">
<input type="text" data-table="p_cart" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($p_cart->operator->getPlaceHolder()) ?>" value="<?php echo $p_cart->operator->EditValue ?>"<?php echo $p_cart->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_datetime"><?php echo $p_cart->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->datetime->cellAttributes() ?>>
			<span id="el_p_cart_datetime">
<input type="text" data-table="p_cart" data-field="x_datetime" name="x_datetime" id="x_datetime" size="30" placeholder="<?php echo HtmlEncode($p_cart->datetime->getPlaceHolder()) ?>" value="<?php echo $p_cart->datetime->EditValue ?>"<?php echo $p_cart->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group row">
		<label for="x_po_id" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_po_id"><?php echo $p_cart->po_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_id" id="z_po_id" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->po_id->cellAttributes() ?>>
			<span id="el_p_cart_po_id">
<input type="text" data-table="p_cart" data-field="x_po_id" name="x_po_id" id="x_po_id" size="30" placeholder="<?php echo HtmlEncode($p_cart->po_id->getPlaceHolder()) ?>" value="<?php echo $p_cart->po_id->EditValue ?>"<?php echo $p_cart->po_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->c_operator->Visible) { // c_operator ?>
	<div id="r_c_operator" class="form-group row">
		<label for="x_c_operator" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_c_operator"><?php echo $p_cart->c_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_operator" id="z_c_operator" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->c_operator->cellAttributes() ?>>
			<span id="el_p_cart_c_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_cart" data-field="x_c_operator" data-value-separator="<?php echo $p_cart->c_operator->displayValueSeparatorAttribute() ?>" id="x_c_operator" name="x_c_operator"<?php echo $p_cart->c_operator->editAttributes() ?>>
		<?php echo $p_cart->c_operator->selectOptionListHtml("x_c_operator") ?>
	</select>
</div>
<?php echo $p_cart->c_operator->Lookup->getParamTag("p_x_c_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->c_datetime->Visible) { // c_datetime ?>
	<div id="r_c_datetime" class="form-group row">
		<label for="x_c_datetime" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_c_datetime"><?php echo $p_cart->c_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_c_datetime" id="z_c_datetime" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->c_datetime->cellAttributes() ?>>
			<span id="el_p_cart_c_datetime">
<input type="text" data-table="p_cart" data-field="x_c_datetime" name="x_c_datetime" id="x_c_datetime" placeholder="<?php echo HtmlEncode($p_cart->c_datetime->getPlaceHolder()) ?>" value="<?php echo $p_cart->c_datetime->EditValue ?>"<?php echo $p_cart->c_datetime->editAttributes() ?>>
<?php if (!$p_cart->c_datetime->ReadOnly && !$p_cart->c_datetime->Disabled && !isset($p_cart->c_datetime->EditAttrs["readonly"]) && !isset($p_cart->c_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_cartsearch", "x_c_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->d_operator->Visible) { // d_operator ?>
	<div id="r_d_operator" class="form-group row">
		<label for="x_d_operator" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_d_operator"><?php echo $p_cart->d_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_operator" id="z_d_operator" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->d_operator->cellAttributes() ?>>
			<span id="el_p_cart_d_operator">
<input type="text" data-table="p_cart" data-field="x_d_operator" name="x_d_operator" id="x_d_operator" size="30" placeholder="<?php echo HtmlEncode($p_cart->d_operator->getPlaceHolder()) ?>" value="<?php echo $p_cart->d_operator->EditValue ?>"<?php echo $p_cart->d_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->d_datetime->Visible) { // d_datetime ?>
	<div id="r_d_datetime" class="form-group row">
		<label for="x_d_datetime" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_d_datetime"><?php echo $p_cart->d_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_datetime" id="z_d_datetime" value="="></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->d_datetime->cellAttributes() ?>>
			<span id="el_p_cart_d_datetime">
<input type="text" data-table="p_cart" data-field="x_d_datetime" name="x_d_datetime" id="x_d_datetime" placeholder="<?php echo HtmlEncode($p_cart->d_datetime->getPlaceHolder()) ?>" value="<?php echo $p_cart->d_datetime->EditValue ?>"<?php echo $p_cart->d_datetime->editAttributes() ?>>
<?php if (!$p_cart->d_datetime->ReadOnly && !$p_cart->d_datetime->Disabled && !isset($p_cart->d_datetime->EditAttrs["readonly"]) && !isset($p_cart->d_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_cartsearch", "x_d_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_cart->day_p->Visible) { // day_p ?>
	<div id="r_day_p" class="form-group row">
		<label for="x_day_p" class="<?php echo $p_cart_search->LeftColumnClass ?>"><span id="elh_p_cart_day_p"><?php echo $p_cart->day_p->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_day_p" id="z_day_p" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_cart_search->RightColumnClass ?>"><div<?php echo $p_cart->day_p->cellAttributes() ?>>
			<span id="el_p_cart_day_p">
<input type="text" data-table="p_cart" data-field="x_day_p" name="x_day_p" id="x_day_p" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($p_cart->day_p->getPlaceHolder()) ?>" value="<?php echo $p_cart->day_p->EditValue ?>"<?php echo $p_cart->day_p->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$p_cart_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_cart_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_cart_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_cart_search->terminate();
?>