<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_eastimate_add = new p_eastimate_add();

// Run the page
$p_eastimate_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_eastimate_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fp_eastimateadd = currentForm = new ew.Form("fp_eastimateadd", "add");

// Validate form
fp_eastimateadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($p_eastimate_add->job_type->Required) { ?>
			elm = this.getElements("x" + infix + "_job_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->job_type->caption(), $p_eastimate->job_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->job_category->Required) { ?>
			elm = this.getElements("x" + infix + "_job_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->job_category->caption(), $p_eastimate->job_category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->company_id->caption(), $p_eastimate->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->company_id->errorMessage()) ?>");
		<?php if ($p_eastimate_add->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->description->caption(), $p_eastimate->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->size->Required) { ?>
			elm = this.getElements("x" + infix + "_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->size->caption(), $p_eastimate->size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->quantity->caption(), $p_eastimate->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->quantity->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pages->Required) { ?>
			elm = this.getElements("x" + infix + "_pages");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pages->caption(), $p_eastimate->pages->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->paper->Required) { ?>
			elm = this.getElements("x" + infix + "_paper");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->paper->caption(), $p_eastimate->paper->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_paper");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->paper->errorMessage()) ?>");
		<?php if ($p_eastimate_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->remarks->caption(), $p_eastimate->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->pr_01->Required) { ?>
			elm = this.getElements("x" + infix + "_pr_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pr_01->caption(), $p_eastimate->pr_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pr_01->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pr_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pr_01->caption(), $p_eastimate->qty_pr_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pr_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pr_01->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pl_01->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pl_01->caption(), $p_eastimate->pl_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pl_01->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pl_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pl_01->caption(), $p_eastimate->qty_pl_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pl_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pl_01->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pr_02->Required) { ?>
			elm = this.getElements("x" + infix + "_pr_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pr_02->caption(), $p_eastimate->pr_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pr_02->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pr_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pr_02->caption(), $p_eastimate->qty_pr_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pr_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pr_02->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pl_02->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pl_02->caption(), $p_eastimate->pl_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pl_02->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pl_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pl_02->caption(), $p_eastimate->qty_pl_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pl_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pl_02->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pr_03->Required) { ?>
			elm = this.getElements("x" + infix + "_pr_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pr_03->caption(), $p_eastimate->pr_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pr_03->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pr_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pr_03->caption(), $p_eastimate->qty_pr_03->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pr_03");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pr_03->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pl_03->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pl_03->caption(), $p_eastimate->pl_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pl_03->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pl_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pl_03->caption(), $p_eastimate->qty_pl_03->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pl_03");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pl_03->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pr_04->Required) { ?>
			elm = this.getElements("x" + infix + "_pr_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pr_04->caption(), $p_eastimate->pr_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pr_04->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pr_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pr_04->caption(), $p_eastimate->qty_pr_04->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pr_04");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pr_04->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pl_04->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pl_04->caption(), $p_eastimate->pl_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pl_04->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pl_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pl_04->caption(), $p_eastimate->qty_pl_04->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pl_04");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pl_04->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pa_01->Required) { ?>
			elm = this.getElements("x" + infix + "_pa_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pa_01->caption(), $p_eastimate->pa_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pa_01->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pa_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pa_01->caption(), $p_eastimate->qty_pa_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pa_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pa_01->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pa_02->Required) { ?>
			elm = this.getElements("x" + infix + "_pa_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pa_02->caption(), $p_eastimate->pa_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pa_02->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pa_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pa_02->caption(), $p_eastimate->qty_pa_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pa_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pa_02->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pa_03->Required) { ?>
			elm = this.getElements("x" + infix + "_pa_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pa_03->caption(), $p_eastimate->pa_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pa_03->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pa_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pa_03->caption(), $p_eastimate->qty_pa_03->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pa_03");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pa_03->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pa_04->Required) { ?>
			elm = this.getElements("x" + infix + "_pa_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pa_04->caption(), $p_eastimate->pa_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pa_04->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pa_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pa_04->caption(), $p_eastimate->qty_pa_04->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pa_04");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pa_04->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pa_05->Required) { ?>
			elm = this.getElements("x" + infix + "_pa_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pa_05->caption(), $p_eastimate->pa_05->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pa_05");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->pa_05->errorMessage()) ?>");
		<?php if ($p_eastimate_add->qty_pa_05->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pa_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pa_05->caption(), $p_eastimate->qty_pa_05->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pa_05");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pa_05->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pc_01->Required) { ?>
			elm = this.getElements("x" + infix + "_pc_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pc_01->caption(), $p_eastimate->pc_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pc_01->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pc_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pc_01->caption(), $p_eastimate->qty_pc_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pc_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pc_01->errorMessage()) ?>");
		<?php if ($p_eastimate_add->pc_02->Required) { ?>
			elm = this.getElements("x" + infix + "_pc_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->pc_02->caption(), $p_eastimate->pc_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_pc_02->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_pc_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_pc_02->caption(), $p_eastimate->qty_pc_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_pc_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_pc_02->errorMessage()) ?>");
		<?php if ($p_eastimate_add->o_01->Required) { ?>
			elm = this.getElements("x" + infix + "_o_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->o_01->caption(), $p_eastimate->o_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_o_01->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_o_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_o_01->caption(), $p_eastimate->qty_o_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_o_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_o_01->errorMessage()) ?>");
		<?php if ($p_eastimate_add->lamination_type->Required) { ?>
			elm = this.getElements("x" + infix + "_lamination_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->lamination_type->caption(), $p_eastimate->lamination_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->lamination_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_lamination_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->lamination_qty->caption(), $p_eastimate->lamination_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lamination_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->lamination_qty->errorMessage()) ?>");
		<?php if ($p_eastimate_add->die_type->Required) { ?>
			elm = this.getElements("x" + infix + "_die_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->die_type->caption(), $p_eastimate->die_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->die_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_die_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->die_qty->caption(), $p_eastimate->die_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_die_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->die_qty->errorMessage()) ?>");
		<?php if ($p_eastimate_add->binding_type->Required) { ?>
			elm = this.getElements("x" + infix + "_binding_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->binding_type->caption(), $p_eastimate->binding_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->binding_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_binding_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->binding_qty->caption(), $p_eastimate->binding_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_binding_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->binding_qty->errorMessage()) ?>");
		<?php if ($p_eastimate_add->number_type->Required) { ?>
			elm = this.getElements("x" + infix + "_number_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->number_type->caption(), $p_eastimate->number_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->number_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_number_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->number_qty->caption(), $p_eastimate->number_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_number_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->number_qty->errorMessage()) ?>");
		<?php if ($p_eastimate_add->de_01->Required) { ?>
			elm = this.getElements("x" + infix + "_de_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->de_01->caption(), $p_eastimate->de_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_de_01->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_de_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_de_01->caption(), $p_eastimate->qty_de_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_de_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_de_01->errorMessage()) ?>");
		<?php if ($p_eastimate_add->de_02->Required) { ?>
			elm = this.getElements("x" + infix + "_de_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->de_02->caption(), $p_eastimate->de_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_de_02->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_de_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_de_02->caption(), $p_eastimate->qty_de_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_de_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_de_02->errorMessage()) ?>");
		<?php if ($p_eastimate_add->de_03->Required) { ?>
			elm = this.getElements("x" + infix + "_de_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->de_03->caption(), $p_eastimate->de_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->qty_de_03->Required) { ?>
			elm = this.getElements("x" + infix + "_qty_de_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->qty_de_03->caption(), $p_eastimate->qty_de_03->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty_de_03");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_eastimate->qty_de_03->errorMessage()) ?>");
		<?php if ($p_eastimate_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->operator->caption(), $p_eastimate->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_eastimate_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_eastimate->datetime->caption(), $p_eastimate->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fp_eastimateadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_eastimateadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fp_eastimateadd.multiPage = new ew.MultiPage("fp_eastimateadd");

// Dynamic selection lists
fp_eastimateadd.lists["x_job_type"] = <?php echo $p_eastimate_add->job_type->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_job_type"].options = <?php echo JsonEncode($p_eastimate_add->job_type->options(FALSE, TRUE)) ?>;
fp_eastimateadd.lists["x_job_category"] = <?php echo $p_eastimate_add->job_category->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_job_category"].options = <?php echo JsonEncode($p_eastimate_add->job_category->options(FALSE, TRUE)) ?>;
fp_eastimateadd.lists["x_company_id"] = <?php echo $p_eastimate_add->company_id->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_company_id"].options = <?php echo JsonEncode($p_eastimate_add->company_id->lookupOptions()) ?>;
fp_eastimateadd.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateadd.lists["x_size"] = <?php echo $p_eastimate_add->size->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_size"].options = <?php echo JsonEncode($p_eastimate_add->size->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pr_01"] = <?php echo $p_eastimate_add->pr_01->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pr_01"].options = <?php echo JsonEncode($p_eastimate_add->pr_01->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pl_01"] = <?php echo $p_eastimate_add->pl_01->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pl_01"].options = <?php echo JsonEncode($p_eastimate_add->pl_01->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pr_02"] = <?php echo $p_eastimate_add->pr_02->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pr_02"].options = <?php echo JsonEncode($p_eastimate_add->pr_02->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pl_02"] = <?php echo $p_eastimate_add->pl_02->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pl_02"].options = <?php echo JsonEncode($p_eastimate_add->pl_02->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pr_03"] = <?php echo $p_eastimate_add->pr_03->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pr_03"].options = <?php echo JsonEncode($p_eastimate_add->pr_03->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pl_03"] = <?php echo $p_eastimate_add->pl_03->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pl_03"].options = <?php echo JsonEncode($p_eastimate_add->pl_03->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pr_04"] = <?php echo $p_eastimate_add->pr_04->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pr_04"].options = <?php echo JsonEncode($p_eastimate_add->pr_04->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pl_04"] = <?php echo $p_eastimate_add->pl_04->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pl_04"].options = <?php echo JsonEncode($p_eastimate_add->pl_04->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pa_01"] = <?php echo $p_eastimate_add->pa_01->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pa_01"].options = <?php echo JsonEncode($p_eastimate_add->pa_01->lookupOptions()) ?>;
fp_eastimateadd.autoSuggests["x_pa_01"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateadd.lists["x_pa_02"] = <?php echo $p_eastimate_add->pa_02->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pa_02"].options = <?php echo JsonEncode($p_eastimate_add->pa_02->lookupOptions()) ?>;
fp_eastimateadd.autoSuggests["x_pa_02"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateadd.lists["x_pa_03"] = <?php echo $p_eastimate_add->pa_03->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pa_03"].options = <?php echo JsonEncode($p_eastimate_add->pa_03->lookupOptions()) ?>;
fp_eastimateadd.autoSuggests["x_pa_03"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateadd.lists["x_pa_04"] = <?php echo $p_eastimate_add->pa_04->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pa_04"].options = <?php echo JsonEncode($p_eastimate_add->pa_04->lookupOptions()) ?>;
fp_eastimateadd.autoSuggests["x_pa_04"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateadd.lists["x_pa_05"] = <?php echo $p_eastimate_add->pa_05->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pa_05"].options = <?php echo JsonEncode($p_eastimate_add->pa_05->lookupOptions()) ?>;
fp_eastimateadd.autoSuggests["x_pa_05"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateadd.lists["x_pc_01"] = <?php echo $p_eastimate_add->pc_01->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pc_01"].options = <?php echo JsonEncode($p_eastimate_add->pc_01->lookupOptions()) ?>;
fp_eastimateadd.lists["x_pc_02"] = <?php echo $p_eastimate_add->pc_02->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_pc_02"].options = <?php echo JsonEncode($p_eastimate_add->pc_02->lookupOptions()) ?>;
fp_eastimateadd.lists["x_o_01"] = <?php echo $p_eastimate_add->o_01->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_o_01"].options = <?php echo JsonEncode($p_eastimate_add->o_01->lookupOptions()) ?>;
fp_eastimateadd.lists["x_lamination_type"] = <?php echo $p_eastimate_add->lamination_type->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_lamination_type"].options = <?php echo JsonEncode($p_eastimate_add->lamination_type->lookupOptions()) ?>;
fp_eastimateadd.lists["x_die_type"] = <?php echo $p_eastimate_add->die_type->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_die_type"].options = <?php echo JsonEncode($p_eastimate_add->die_type->lookupOptions()) ?>;
fp_eastimateadd.lists["x_binding_type"] = <?php echo $p_eastimate_add->binding_type->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_binding_type"].options = <?php echo JsonEncode($p_eastimate_add->binding_type->lookupOptions()) ?>;
fp_eastimateadd.lists["x_number_type"] = <?php echo $p_eastimate_add->number_type->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_number_type"].options = <?php echo JsonEncode($p_eastimate_add->number_type->lookupOptions()) ?>;
fp_eastimateadd.lists["x_de_01"] = <?php echo $p_eastimate_add->de_01->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_de_01"].options = <?php echo JsonEncode($p_eastimate_add->de_01->lookupOptions()) ?>;
fp_eastimateadd.lists["x_de_02"] = <?php echo $p_eastimate_add->de_02->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_de_02"].options = <?php echo JsonEncode($p_eastimate_add->de_02->lookupOptions()) ?>;
fp_eastimateadd.lists["x_de_03"] = <?php echo $p_eastimate_add->de_03->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_de_03"].options = <?php echo JsonEncode($p_eastimate_add->de_03->lookupOptions()) ?>;
fp_eastimateadd.lists["x_operator"] = <?php echo $p_eastimate_add->operator->Lookup->toClientList() ?>;
fp_eastimateadd.lists["x_operator"].options = <?php echo JsonEncode($p_eastimate_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_eastimate_add->showPageHeader(); ?>
<?php
$p_eastimate_add->showMessage();
?>
<form name="fp_eastimateadd" id="fp_eastimateadd" class="<?php echo $p_eastimate_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_eastimate_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_eastimate_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_eastimate">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$p_eastimate_add->IsModal ?>">
<?php if ($p_eastimate_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($p_eastimate->job_type->Visible) { // job_type ?>
	<div id="r_job_type" class="form-group row">
		<label id="elh_p_eastimate_job_type" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->job_type->caption() ?><?php echo ($p_eastimate->job_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->job_type->cellAttributes() ?>>
<span id="el_p_eastimate_job_type">
<div id="tp_x_job_type" class="ew-template"><input type="radio" class="form-check-input" data-table="p_eastimate" data-field="x_job_type" data-page="0" data-value-separator="<?php echo $p_eastimate->job_type->displayValueSeparatorAttribute() ?>" name="x_job_type" id="x_job_type" value="{value}"<?php echo $p_eastimate->job_type->editAttributes() ?>></div>
<div id="dsl_x_job_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_eastimate->job_type->radioButtonListHtml(FALSE, "x_job_type", 0) ?>
</div></div>
</span>
<?php echo $p_eastimate->job_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->job_category->Visible) { // job_category ?>
	<div id="r_job_category" class="form-group row">
		<label id="elh_p_eastimate_job_category" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->job_category->caption() ?><?php echo ($p_eastimate->job_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->job_category->cellAttributes() ?>>
<span id="el_p_eastimate_job_category">
<div id="tp_x_job_category" class="ew-template"><input type="radio" class="form-check-input" data-table="p_eastimate" data-field="x_job_category" data-page="0" data-value-separator="<?php echo $p_eastimate->job_category->displayValueSeparatorAttribute() ?>" name="x_job_category" id="x_job_category" value="{value}"<?php echo $p_eastimate->job_category->editAttributes() ?>></div>
<div id="dsl_x_job_category" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_eastimate->job_category->radioButtonListHtml(FALSE, "x_job_category", 0) ?>
</div></div>
</span>
<?php echo $p_eastimate->job_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_p_eastimate_company_id" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->company_id->caption() ?><?php echo ($p_eastimate->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->company_id->cellAttributes() ?>>
<span id="el_p_eastimate_company_id">
<?php
$wrkonchange = "" . trim(@$p_eastimate->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_eastimate->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($p_eastimate->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_eastimate->company_id->getPlaceHolder()) ?>"<?php echo $p_eastimate->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_eastimate->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_eastimate->company_id->ReadOnly || $p_eastimate->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_eastimate" data-field="x_company_id" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_eastimate->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($p_eastimate->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_eastimateadd.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $p_eastimate->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $p_eastimate->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_p_eastimate_description" for="x_description" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->description->caption() ?><?php echo ($p_eastimate->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->description->cellAttributes() ?>>
<span id="el_p_eastimate_description">
<input type="text" data-table="p_eastimate" data-field="x_description" data-page="0" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($p_eastimate->description->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->description->EditValue ?>"<?php echo $p_eastimate->description->editAttributes() ?>>
</span>
<?php echo $p_eastimate->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label id="elh_p_eastimate_size" for="x_size" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->size->caption() ?><?php echo ($p_eastimate->size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->size->cellAttributes() ?>>
<span id="el_p_eastimate_size">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_size" data-page="0" data-value-separator="<?php echo $p_eastimate->size->displayValueSeparatorAttribute() ?>" id="x_size" name="x_size"<?php echo $p_eastimate->size->editAttributes() ?>>
		<?php echo $p_eastimate->size->selectOptionListHtml("x_size") ?>
	</select>
</div>
<?php echo $p_eastimate->size->Lookup->getParamTag("p_x_size") ?>
</span>
<?php echo $p_eastimate->size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_p_eastimate_quantity" for="x_quantity" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->quantity->caption() ?><?php echo ($p_eastimate->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->quantity->cellAttributes() ?>>
<span id="el_p_eastimate_quantity">
<input type="text" data-table="p_eastimate" data-field="x_quantity" data-page="0" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->quantity->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->quantity->EditValue ?>"<?php echo $p_eastimate->quantity->editAttributes() ?>>
</span>
<?php echo $p_eastimate->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pages->Visible) { // pages ?>
	<div id="r_pages" class="form-group row">
		<label id="elh_p_eastimate_pages" for="x_pages" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pages->caption() ?><?php echo ($p_eastimate->pages->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pages->cellAttributes() ?>>
<span id="el_p_eastimate_pages">
<input type="text" data-table="p_eastimate" data-field="x_pages" data-page="0" name="x_pages" id="x_pages" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->pages->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->pages->EditValue ?>"<?php echo $p_eastimate->pages->editAttributes() ?>>
</span>
<?php echo $p_eastimate->pages->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->paper->Visible) { // paper ?>
	<div id="r_paper" class="form-group row">
		<label id="elh_p_eastimate_paper" for="x_paper" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->paper->caption() ?><?php echo ($p_eastimate->paper->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->paper->cellAttributes() ?>>
<span id="el_p_eastimate_paper">
<input type="text" data-table="p_eastimate" data-field="x_paper" data-page="0" name="x_paper" id="x_paper" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->paper->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->paper->EditValue ?>"<?php echo $p_eastimate->paper->editAttributes() ?>>
</span>
<?php echo $p_eastimate->paper->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_p_eastimate_remarks" for="x_remarks" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->remarks->caption() ?><?php echo ($p_eastimate->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->remarks->cellAttributes() ?>>
<span id="el_p_eastimate_remarks">
<textarea data-table="p_eastimate" data-field="x_remarks" data-page="0" name="x_remarks" id="x_remarks" cols="35" rows="2" placeholder="<?php echo HtmlEncode($p_eastimate->remarks->getPlaceHolder()) ?>"<?php echo $p_eastimate->remarks->editAttributes() ?>><?php echo $p_eastimate->remarks->EditValue ?></textarea>
</span>
<?php echo $p_eastimate->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="p_eastimate_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("1")) ?>" href="#tab_p_eastimate1"><?php echo $p_eastimate->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->pr_01->Visible) { // pr_01 ?>
	<div id="r_pr_01" class="form-group row">
		<label id="elh_p_eastimate_pr_01" for="x_pr_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pr_01->caption() ?><?php echo ($p_eastimate->pr_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pr_01->cellAttributes() ?>>
<span id="el_p_eastimate_pr_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pr_01" data-page="1" data-value-separator="<?php echo $p_eastimate->pr_01->displayValueSeparatorAttribute() ?>" id="x_pr_01" name="x_pr_01"<?php echo $p_eastimate->pr_01->editAttributes() ?>>
		<?php echo $p_eastimate->pr_01->selectOptionListHtml("x_pr_01") ?>
	</select>
</div>
<?php echo $p_eastimate->pr_01->Lookup->getParamTag("p_x_pr_01") ?>
</span>
<?php echo $p_eastimate->pr_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pr_01->Visible) { // qty_pr_01 ?>
	<div id="r_qty_pr_01" class="form-group row">
		<label id="elh_p_eastimate_qty_pr_01" for="x_qty_pr_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pr_01->caption() ?><?php echo ($p_eastimate->qty_pr_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pr_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_01">
<input type="text" data-table="p_eastimate" data-field="x_qty_pr_01" data-page="1" name="x_qty_pr_01" id="x_qty_pr_01" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pr_01->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pr_01->EditValue ?>"<?php echo $p_eastimate->qty_pr_01->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pr_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pl_01->Visible) { // pl_01 ?>
	<div id="r_pl_01" class="form-group row">
		<label id="elh_p_eastimate_pl_01" for="x_pl_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pl_01->caption() ?><?php echo ($p_eastimate->pl_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pl_01->cellAttributes() ?>>
<span id="el_p_eastimate_pl_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pl_01" data-page="1" data-value-separator="<?php echo $p_eastimate->pl_01->displayValueSeparatorAttribute() ?>" id="x_pl_01" name="x_pl_01"<?php echo $p_eastimate->pl_01->editAttributes() ?>>
		<?php echo $p_eastimate->pl_01->selectOptionListHtml("x_pl_01") ?>
	</select>
</div>
<?php echo $p_eastimate->pl_01->Lookup->getParamTag("p_x_pl_01") ?>
</span>
<?php echo $p_eastimate->pl_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pl_01->Visible) { // qty_pl_01 ?>
	<div id="r_qty_pl_01" class="form-group row">
		<label id="elh_p_eastimate_qty_pl_01" for="x_qty_pl_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pl_01->caption() ?><?php echo ($p_eastimate->qty_pl_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pl_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_01">
<input type="text" data-table="p_eastimate" data-field="x_qty_pl_01" data-page="1" name="x_qty_pl_01" id="x_qty_pl_01" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pl_01->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pl_01->EditValue ?>"<?php echo $p_eastimate->qty_pl_01->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pl_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("2")) ?>" href="#tab_p_eastimate2"><?php echo $p_eastimate->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->pr_02->Visible) { // pr_02 ?>
	<div id="r_pr_02" class="form-group row">
		<label id="elh_p_eastimate_pr_02" for="x_pr_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pr_02->caption() ?><?php echo ($p_eastimate->pr_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pr_02->cellAttributes() ?>>
<span id="el_p_eastimate_pr_02">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pr_02" data-page="2" data-value-separator="<?php echo $p_eastimate->pr_02->displayValueSeparatorAttribute() ?>" id="x_pr_02" name="x_pr_02"<?php echo $p_eastimate->pr_02->editAttributes() ?>>
		<?php echo $p_eastimate->pr_02->selectOptionListHtml("x_pr_02") ?>
	</select>
</div>
<?php echo $p_eastimate->pr_02->Lookup->getParamTag("p_x_pr_02") ?>
</span>
<?php echo $p_eastimate->pr_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pr_02->Visible) { // qty_pr_02 ?>
	<div id="r_qty_pr_02" class="form-group row">
		<label id="elh_p_eastimate_qty_pr_02" for="x_qty_pr_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pr_02->caption() ?><?php echo ($p_eastimate->qty_pr_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pr_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_02">
<input type="text" data-table="p_eastimate" data-field="x_qty_pr_02" data-page="2" name="x_qty_pr_02" id="x_qty_pr_02" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pr_02->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pr_02->EditValue ?>"<?php echo $p_eastimate->qty_pr_02->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pr_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pl_02->Visible) { // pl_02 ?>
	<div id="r_pl_02" class="form-group row">
		<label id="elh_p_eastimate_pl_02" for="x_pl_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pl_02->caption() ?><?php echo ($p_eastimate->pl_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pl_02->cellAttributes() ?>>
<span id="el_p_eastimate_pl_02">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pl_02" data-page="2" data-value-separator="<?php echo $p_eastimate->pl_02->displayValueSeparatorAttribute() ?>" id="x_pl_02" name="x_pl_02"<?php echo $p_eastimate->pl_02->editAttributes() ?>>
		<?php echo $p_eastimate->pl_02->selectOptionListHtml("x_pl_02") ?>
	</select>
</div>
<?php echo $p_eastimate->pl_02->Lookup->getParamTag("p_x_pl_02") ?>
</span>
<?php echo $p_eastimate->pl_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pl_02->Visible) { // qty_pl_02 ?>
	<div id="r_qty_pl_02" class="form-group row">
		<label id="elh_p_eastimate_qty_pl_02" for="x_qty_pl_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pl_02->caption() ?><?php echo ($p_eastimate->qty_pl_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pl_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_02">
<input type="text" data-table="p_eastimate" data-field="x_qty_pl_02" data-page="2" name="x_qty_pl_02" id="x_qty_pl_02" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pl_02->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pl_02->EditValue ?>"<?php echo $p_eastimate->qty_pl_02->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pl_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("3")) ?>" href="#tab_p_eastimate3"><?php echo $p_eastimate->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->pr_03->Visible) { // pr_03 ?>
	<div id="r_pr_03" class="form-group row">
		<label id="elh_p_eastimate_pr_03" for="x_pr_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pr_03->caption() ?><?php echo ($p_eastimate->pr_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pr_03->cellAttributes() ?>>
<span id="el_p_eastimate_pr_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pr_03" data-page="3" data-value-separator="<?php echo $p_eastimate->pr_03->displayValueSeparatorAttribute() ?>" id="x_pr_03" name="x_pr_03"<?php echo $p_eastimate->pr_03->editAttributes() ?>>
		<?php echo $p_eastimate->pr_03->selectOptionListHtml("x_pr_03") ?>
	</select>
</div>
<?php echo $p_eastimate->pr_03->Lookup->getParamTag("p_x_pr_03") ?>
</span>
<?php echo $p_eastimate->pr_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pr_03->Visible) { // qty_pr_03 ?>
	<div id="r_qty_pr_03" class="form-group row">
		<label id="elh_p_eastimate_qty_pr_03" for="x_qty_pr_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pr_03->caption() ?><?php echo ($p_eastimate->qty_pr_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pr_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_03">
<input type="text" data-table="p_eastimate" data-field="x_qty_pr_03" data-page="3" name="x_qty_pr_03" id="x_qty_pr_03" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pr_03->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pr_03->EditValue ?>"<?php echo $p_eastimate->qty_pr_03->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pr_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pl_03->Visible) { // pl_03 ?>
	<div id="r_pl_03" class="form-group row">
		<label id="elh_p_eastimate_pl_03" for="x_pl_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pl_03->caption() ?><?php echo ($p_eastimate->pl_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pl_03->cellAttributes() ?>>
<span id="el_p_eastimate_pl_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pl_03" data-page="3" data-value-separator="<?php echo $p_eastimate->pl_03->displayValueSeparatorAttribute() ?>" id="x_pl_03" name="x_pl_03"<?php echo $p_eastimate->pl_03->editAttributes() ?>>
		<?php echo $p_eastimate->pl_03->selectOptionListHtml("x_pl_03") ?>
	</select>
</div>
<?php echo $p_eastimate->pl_03->Lookup->getParamTag("p_x_pl_03") ?>
</span>
<?php echo $p_eastimate->pl_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pl_03->Visible) { // qty_pl_03 ?>
	<div id="r_qty_pl_03" class="form-group row">
		<label id="elh_p_eastimate_qty_pl_03" for="x_qty_pl_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pl_03->caption() ?><?php echo ($p_eastimate->qty_pl_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pl_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_03">
<input type="text" data-table="p_eastimate" data-field="x_qty_pl_03" data-page="3" name="x_qty_pl_03" id="x_qty_pl_03" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pl_03->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pl_03->EditValue ?>"<?php echo $p_eastimate->qty_pl_03->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pl_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("4") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("4")) ?>" href="#tab_p_eastimate4"><?php echo $p_eastimate->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->pr_04->Visible) { // pr_04 ?>
	<div id="r_pr_04" class="form-group row">
		<label id="elh_p_eastimate_pr_04" for="x_pr_04" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pr_04->caption() ?><?php echo ($p_eastimate->pr_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pr_04->cellAttributes() ?>>
<span id="el_p_eastimate_pr_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pr_04" data-page="4" data-value-separator="<?php echo $p_eastimate->pr_04->displayValueSeparatorAttribute() ?>" id="x_pr_04" name="x_pr_04"<?php echo $p_eastimate->pr_04->editAttributes() ?>>
		<?php echo $p_eastimate->pr_04->selectOptionListHtml("x_pr_04") ?>
	</select>
</div>
<?php echo $p_eastimate->pr_04->Lookup->getParamTag("p_x_pr_04") ?>
</span>
<?php echo $p_eastimate->pr_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pr_04->Visible) { // qty_pr_04 ?>
	<div id="r_qty_pr_04" class="form-group row">
		<label id="elh_p_eastimate_qty_pr_04" for="x_qty_pr_04" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pr_04->caption() ?><?php echo ($p_eastimate->qty_pr_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pr_04->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_04">
<input type="text" data-table="p_eastimate" data-field="x_qty_pr_04" data-page="4" name="x_qty_pr_04" id="x_qty_pr_04" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pr_04->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pr_04->EditValue ?>"<?php echo $p_eastimate->qty_pr_04->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pr_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pl_04->Visible) { // pl_04 ?>
	<div id="r_pl_04" class="form-group row">
		<label id="elh_p_eastimate_pl_04" for="x_pl_04" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pl_04->caption() ?><?php echo ($p_eastimate->pl_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pl_04->cellAttributes() ?>>
<span id="el_p_eastimate_pl_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pl_04" data-page="4" data-value-separator="<?php echo $p_eastimate->pl_04->displayValueSeparatorAttribute() ?>" id="x_pl_04" name="x_pl_04"<?php echo $p_eastimate->pl_04->editAttributes() ?>>
		<?php echo $p_eastimate->pl_04->selectOptionListHtml("x_pl_04") ?>
	</select>
</div>
<?php echo $p_eastimate->pl_04->Lookup->getParamTag("p_x_pl_04") ?>
</span>
<?php echo $p_eastimate->pl_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pl_04->Visible) { // qty_pl_04 ?>
	<div id="r_qty_pl_04" class="form-group row">
		<label id="elh_p_eastimate_qty_pl_04" for="x_qty_pl_04" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pl_04->caption() ?><?php echo ($p_eastimate->qty_pl_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pl_04->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_04">
<input type="text" data-table="p_eastimate" data-field="x_qty_pl_04" data-page="4" name="x_qty_pl_04" id="x_qty_pl_04" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pl_04->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pl_04->EditValue ?>"<?php echo $p_eastimate->qty_pl_04->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pl_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("5") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("5")) ?>" href="#tab_p_eastimate5"><?php echo $p_eastimate->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->pa_01->Visible) { // pa_01 ?>
	<div id="r_pa_01" class="form-group row">
		<label id="elh_p_eastimate_pa_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pa_01->caption() ?><?php echo ($p_eastimate->pa_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pa_01->cellAttributes() ?>>
<span id="el_p_eastimate_pa_01">
<?php
$wrkonchange = "" . trim(@$p_eastimate->pa_01->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_eastimate->pa_01->EditAttrs["onchange"] = "";
?>
<span id="as_x_pa_01" class="text-nowrap" style="z-index: 8730">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_pa_01" id="sv_x_pa_01" value="<?php echo RemoveHtml($p_eastimate->pa_01->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->pa_01->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_eastimate->pa_01->getPlaceHolder()) ?>"<?php echo $p_eastimate->pa_01->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_eastimate->pa_01->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_pa_01',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_eastimate->pa_01->ReadOnly || $p_eastimate->pa_01->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_eastimate" data-field="x_pa_01" data-page="5" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_eastimate->pa_01->displayValueSeparatorAttribute() ?>" name="x_pa_01" id="x_pa_01" value="<?php echo HtmlEncode($p_eastimate->pa_01->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_eastimateadd.createAutoSuggest({"id":"x_pa_01","forceSelect":true});
</script>
<?php echo $p_eastimate->pa_01->Lookup->getParamTag("p_x_pa_01") ?>
</span>
<?php echo $p_eastimate->pa_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pa_01->Visible) { // qty_pa_01 ?>
	<div id="r_qty_pa_01" class="form-group row">
		<label id="elh_p_eastimate_qty_pa_01" for="x_qty_pa_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pa_01->caption() ?><?php echo ($p_eastimate->qty_pa_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pa_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_01">
<input type="text" data-table="p_eastimate" data-field="x_qty_pa_01" data-page="5" name="x_qty_pa_01" id="x_qty_pa_01" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pa_01->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pa_01->EditValue ?>"<?php echo $p_eastimate->qty_pa_01->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pa_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pa_02->Visible) { // pa_02 ?>
	<div id="r_pa_02" class="form-group row">
		<label id="elh_p_eastimate_pa_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pa_02->caption() ?><?php echo ($p_eastimate->pa_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pa_02->cellAttributes() ?>>
<span id="el_p_eastimate_pa_02">
<?php
$wrkonchange = "" . trim(@$p_eastimate->pa_02->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_eastimate->pa_02->EditAttrs["onchange"] = "";
?>
<span id="as_x_pa_02" class="text-nowrap" style="z-index: 8710">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_pa_02" id="sv_x_pa_02" value="<?php echo RemoveHtml($p_eastimate->pa_02->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->pa_02->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_eastimate->pa_02->getPlaceHolder()) ?>"<?php echo $p_eastimate->pa_02->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_eastimate->pa_02->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_pa_02',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_eastimate->pa_02->ReadOnly || $p_eastimate->pa_02->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_eastimate" data-field="x_pa_02" data-page="5" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_eastimate->pa_02->displayValueSeparatorAttribute() ?>" name="x_pa_02" id="x_pa_02" value="<?php echo HtmlEncode($p_eastimate->pa_02->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_eastimateadd.createAutoSuggest({"id":"x_pa_02","forceSelect":true});
</script>
<?php echo $p_eastimate->pa_02->Lookup->getParamTag("p_x_pa_02") ?>
</span>
<?php echo $p_eastimate->pa_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pa_02->Visible) { // qty_pa_02 ?>
	<div id="r_qty_pa_02" class="form-group row">
		<label id="elh_p_eastimate_qty_pa_02" for="x_qty_pa_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pa_02->caption() ?><?php echo ($p_eastimate->qty_pa_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pa_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_02">
<input type="text" data-table="p_eastimate" data-field="x_qty_pa_02" data-page="5" name="x_qty_pa_02" id="x_qty_pa_02" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pa_02->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pa_02->EditValue ?>"<?php echo $p_eastimate->qty_pa_02->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pa_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pa_03->Visible) { // pa_03 ?>
	<div id="r_pa_03" class="form-group row">
		<label id="elh_p_eastimate_pa_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pa_03->caption() ?><?php echo ($p_eastimate->pa_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pa_03->cellAttributes() ?>>
<span id="el_p_eastimate_pa_03">
<?php
$wrkonchange = "" . trim(@$p_eastimate->pa_03->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_eastimate->pa_03->EditAttrs["onchange"] = "";
?>
<span id="as_x_pa_03" class="text-nowrap" style="z-index: 8690">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_pa_03" id="sv_x_pa_03" value="<?php echo RemoveHtml($p_eastimate->pa_03->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->pa_03->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_eastimate->pa_03->getPlaceHolder()) ?>"<?php echo $p_eastimate->pa_03->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_eastimate->pa_03->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_pa_03',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_eastimate->pa_03->ReadOnly || $p_eastimate->pa_03->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_eastimate" data-field="x_pa_03" data-page="5" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_eastimate->pa_03->displayValueSeparatorAttribute() ?>" name="x_pa_03" id="x_pa_03" value="<?php echo HtmlEncode($p_eastimate->pa_03->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_eastimateadd.createAutoSuggest({"id":"x_pa_03","forceSelect":true});
</script>
<?php echo $p_eastimate->pa_03->Lookup->getParamTag("p_x_pa_03") ?>
</span>
<?php echo $p_eastimate->pa_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pa_03->Visible) { // qty_pa_03 ?>
	<div id="r_qty_pa_03" class="form-group row">
		<label id="elh_p_eastimate_qty_pa_03" for="x_qty_pa_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pa_03->caption() ?><?php echo ($p_eastimate->qty_pa_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pa_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_03">
<input type="text" data-table="p_eastimate" data-field="x_qty_pa_03" data-page="5" name="x_qty_pa_03" id="x_qty_pa_03" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pa_03->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pa_03->EditValue ?>"<?php echo $p_eastimate->qty_pa_03->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pa_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pa_04->Visible) { // pa_04 ?>
	<div id="r_pa_04" class="form-group row">
		<label id="elh_p_eastimate_pa_04" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pa_04->caption() ?><?php echo ($p_eastimate->pa_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pa_04->cellAttributes() ?>>
<span id="el_p_eastimate_pa_04">
<?php
$wrkonchange = "" . trim(@$p_eastimate->pa_04->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_eastimate->pa_04->EditAttrs["onchange"] = "";
?>
<span id="as_x_pa_04" class="text-nowrap" style="z-index: 8670">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_pa_04" id="sv_x_pa_04" value="<?php echo RemoveHtml($p_eastimate->pa_04->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->pa_04->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_eastimate->pa_04->getPlaceHolder()) ?>"<?php echo $p_eastimate->pa_04->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_eastimate->pa_04->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_pa_04',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_eastimate->pa_04->ReadOnly || $p_eastimate->pa_04->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_eastimate" data-field="x_pa_04" data-page="5" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_eastimate->pa_04->displayValueSeparatorAttribute() ?>" name="x_pa_04" id="x_pa_04" value="<?php echo HtmlEncode($p_eastimate->pa_04->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_eastimateadd.createAutoSuggest({"id":"x_pa_04","forceSelect":true});
</script>
<?php echo $p_eastimate->pa_04->Lookup->getParamTag("p_x_pa_04") ?>
</span>
<?php echo $p_eastimate->pa_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pa_04->Visible) { // qty_pa_04 ?>
	<div id="r_qty_pa_04" class="form-group row">
		<label id="elh_p_eastimate_qty_pa_04" for="x_qty_pa_04" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pa_04->caption() ?><?php echo ($p_eastimate->qty_pa_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pa_04->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_04">
<input type="text" data-table="p_eastimate" data-field="x_qty_pa_04" data-page="5" name="x_qty_pa_04" id="x_qty_pa_04" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pa_04->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pa_04->EditValue ?>"<?php echo $p_eastimate->qty_pa_04->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pa_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pa_05->Visible) { // pa_05 ?>
	<div id="r_pa_05" class="form-group row">
		<label id="elh_p_eastimate_pa_05" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pa_05->caption() ?><?php echo ($p_eastimate->pa_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pa_05->cellAttributes() ?>>
<span id="el_p_eastimate_pa_05">
<?php
$wrkonchange = "" . trim(@$p_eastimate->pa_05->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_eastimate->pa_05->EditAttrs["onchange"] = "";
?>
<span id="as_x_pa_05" class="text-nowrap" style="z-index: 8650">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_pa_05" id="sv_x_pa_05" value="<?php echo RemoveHtml($p_eastimate->pa_05->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->pa_05->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_eastimate->pa_05->getPlaceHolder()) ?>"<?php echo $p_eastimate->pa_05->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_eastimate->pa_05->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_pa_05',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_eastimate->pa_05->ReadOnly || $p_eastimate->pa_05->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_eastimate" data-field="x_pa_05" data-page="5" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_eastimate->pa_05->displayValueSeparatorAttribute() ?>" name="x_pa_05" id="x_pa_05" value="<?php echo HtmlEncode($p_eastimate->pa_05->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_eastimateadd.createAutoSuggest({"id":"x_pa_05","forceSelect":true});
</script>
<?php echo $p_eastimate->pa_05->Lookup->getParamTag("p_x_pa_05") ?>
</span>
<?php echo $p_eastimate->pa_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pa_05->Visible) { // qty_pa_05 ?>
	<div id="r_qty_pa_05" class="form-group row">
		<label id="elh_p_eastimate_qty_pa_05" for="x_qty_pa_05" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pa_05->caption() ?><?php echo ($p_eastimate->qty_pa_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pa_05->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_05">
<input type="text" data-table="p_eastimate" data-field="x_qty_pa_05" data-page="5" name="x_qty_pa_05" id="x_qty_pa_05" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pa_05->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pa_05->EditValue ?>"<?php echo $p_eastimate->qty_pa_05->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pa_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("6") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("6")) ?>" href="#tab_p_eastimate6"><?php echo $p_eastimate->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->pc_01->Visible) { // pc_01 ?>
	<div id="r_pc_01" class="form-group row">
		<label id="elh_p_eastimate_pc_01" for="x_pc_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pc_01->caption() ?><?php echo ($p_eastimate->pc_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pc_01->cellAttributes() ?>>
<span id="el_p_eastimate_pc_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pc_01" data-page="6" data-value-separator="<?php echo $p_eastimate->pc_01->displayValueSeparatorAttribute() ?>" id="x_pc_01" name="x_pc_01"<?php echo $p_eastimate->pc_01->editAttributes() ?>>
		<?php echo $p_eastimate->pc_01->selectOptionListHtml("x_pc_01") ?>
	</select>
</div>
<?php echo $p_eastimate->pc_01->Lookup->getParamTag("p_x_pc_01") ?>
</span>
<?php echo $p_eastimate->pc_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pc_01->Visible) { // qty_pc_01 ?>
	<div id="r_qty_pc_01" class="form-group row">
		<label id="elh_p_eastimate_qty_pc_01" for="x_qty_pc_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pc_01->caption() ?><?php echo ($p_eastimate->qty_pc_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pc_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pc_01">
<input type="text" data-table="p_eastimate" data-field="x_qty_pc_01" data-page="6" name="x_qty_pc_01" id="x_qty_pc_01" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pc_01->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pc_01->EditValue ?>"<?php echo $p_eastimate->qty_pc_01->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pc_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->pc_02->Visible) { // pc_02 ?>
	<div id="r_pc_02" class="form-group row">
		<label id="elh_p_eastimate_pc_02" for="x_pc_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->pc_02->caption() ?><?php echo ($p_eastimate->pc_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->pc_02->cellAttributes() ?>>
<span id="el_p_eastimate_pc_02">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_pc_02" data-page="6" data-value-separator="<?php echo $p_eastimate->pc_02->displayValueSeparatorAttribute() ?>" id="x_pc_02" name="x_pc_02"<?php echo $p_eastimate->pc_02->editAttributes() ?>>
		<?php echo $p_eastimate->pc_02->selectOptionListHtml("x_pc_02") ?>
	</select>
</div>
<?php echo $p_eastimate->pc_02->Lookup->getParamTag("p_x_pc_02") ?>
</span>
<?php echo $p_eastimate->pc_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_pc_02->Visible) { // qty_pc_02 ?>
	<div id="r_qty_pc_02" class="form-group row">
		<label id="elh_p_eastimate_qty_pc_02" for="x_qty_pc_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_pc_02->caption() ?><?php echo ($p_eastimate->qty_pc_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_pc_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pc_02">
<input type="text" data-table="p_eastimate" data-field="x_qty_pc_02" data-page="6" name="x_qty_pc_02" id="x_qty_pc_02" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_pc_02->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_pc_02->EditValue ?>"<?php echo $p_eastimate->qty_pc_02->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_pc_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->o_01->Visible) { // o_01 ?>
	<div id="r_o_01" class="form-group row">
		<label id="elh_p_eastimate_o_01" for="x_o_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->o_01->caption() ?><?php echo ($p_eastimate->o_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->o_01->cellAttributes() ?>>
<span id="el_p_eastimate_o_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_o_01" data-page="6" data-value-separator="<?php echo $p_eastimate->o_01->displayValueSeparatorAttribute() ?>" id="x_o_01" name="x_o_01"<?php echo $p_eastimate->o_01->editAttributes() ?>>
		<?php echo $p_eastimate->o_01->selectOptionListHtml("x_o_01") ?>
	</select>
</div>
<?php echo $p_eastimate->o_01->Lookup->getParamTag("p_x_o_01") ?>
</span>
<?php echo $p_eastimate->o_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_o_01->Visible) { // qty_o_01 ?>
	<div id="r_qty_o_01" class="form-group row">
		<label id="elh_p_eastimate_qty_o_01" for="x_qty_o_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_o_01->caption() ?><?php echo ($p_eastimate->qty_o_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_o_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_o_01">
<input type="text" data-table="p_eastimate" data-field="x_qty_o_01" data-page="6" name="x_qty_o_01" id="x_qty_o_01" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_o_01->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_o_01->EditValue ?>"<?php echo $p_eastimate->qty_o_01->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_o_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("7") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("7")) ?>" href="#tab_p_eastimate7"><?php echo $p_eastimate->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate7"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->lamination_type->Visible) { // lamination_type ?>
	<div id="r_lamination_type" class="form-group row">
		<label id="elh_p_eastimate_lamination_type" for="x_lamination_type" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->lamination_type->caption() ?><?php echo ($p_eastimate->lamination_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->lamination_type->cellAttributes() ?>>
<span id="el_p_eastimate_lamination_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_lamination_type" data-page="7" data-value-separator="<?php echo $p_eastimate->lamination_type->displayValueSeparatorAttribute() ?>" id="x_lamination_type" name="x_lamination_type"<?php echo $p_eastimate->lamination_type->editAttributes() ?>>
		<?php echo $p_eastimate->lamination_type->selectOptionListHtml("x_lamination_type") ?>
	</select>
</div>
<?php echo $p_eastimate->lamination_type->Lookup->getParamTag("p_x_lamination_type") ?>
</span>
<?php echo $p_eastimate->lamination_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->lamination_qty->Visible) { // lamination_qty ?>
	<div id="r_lamination_qty" class="form-group row">
		<label id="elh_p_eastimate_lamination_qty" for="x_lamination_qty" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->lamination_qty->caption() ?><?php echo ($p_eastimate->lamination_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->lamination_qty->cellAttributes() ?>>
<span id="el_p_eastimate_lamination_qty">
<input type="text" data-table="p_eastimate" data-field="x_lamination_qty" data-page="7" name="x_lamination_qty" id="x_lamination_qty" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->lamination_qty->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->lamination_qty->EditValue ?>"<?php echo $p_eastimate->lamination_qty->editAttributes() ?>>
</span>
<?php echo $p_eastimate->lamination_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->die_type->Visible) { // die_type ?>
	<div id="r_die_type" class="form-group row">
		<label id="elh_p_eastimate_die_type" for="x_die_type" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->die_type->caption() ?><?php echo ($p_eastimate->die_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->die_type->cellAttributes() ?>>
<span id="el_p_eastimate_die_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_die_type" data-page="7" data-value-separator="<?php echo $p_eastimate->die_type->displayValueSeparatorAttribute() ?>" id="x_die_type" name="x_die_type"<?php echo $p_eastimate->die_type->editAttributes() ?>>
		<?php echo $p_eastimate->die_type->selectOptionListHtml("x_die_type") ?>
	</select>
</div>
<?php echo $p_eastimate->die_type->Lookup->getParamTag("p_x_die_type") ?>
</span>
<?php echo $p_eastimate->die_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->die_qty->Visible) { // die_qty ?>
	<div id="r_die_qty" class="form-group row">
		<label id="elh_p_eastimate_die_qty" for="x_die_qty" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->die_qty->caption() ?><?php echo ($p_eastimate->die_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->die_qty->cellAttributes() ?>>
<span id="el_p_eastimate_die_qty">
<input type="text" data-table="p_eastimate" data-field="x_die_qty" data-page="7" name="x_die_qty" id="x_die_qty" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->die_qty->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->die_qty->EditValue ?>"<?php echo $p_eastimate->die_qty->editAttributes() ?>>
</span>
<?php echo $p_eastimate->die_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("8") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("8")) ?>" href="#tab_p_eastimate8"><?php echo $p_eastimate->pageCaption(8) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("8") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate8"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->binding_type->Visible) { // binding_type ?>
	<div id="r_binding_type" class="form-group row">
		<label id="elh_p_eastimate_binding_type" for="x_binding_type" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->binding_type->caption() ?><?php echo ($p_eastimate->binding_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->binding_type->cellAttributes() ?>>
<span id="el_p_eastimate_binding_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_binding_type" data-page="8" data-value-separator="<?php echo $p_eastimate->binding_type->displayValueSeparatorAttribute() ?>" id="x_binding_type" name="x_binding_type"<?php echo $p_eastimate->binding_type->editAttributes() ?>>
		<?php echo $p_eastimate->binding_type->selectOptionListHtml("x_binding_type") ?>
	</select>
</div>
<?php echo $p_eastimate->binding_type->Lookup->getParamTag("p_x_binding_type") ?>
</span>
<?php echo $p_eastimate->binding_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->binding_qty->Visible) { // binding_qty ?>
	<div id="r_binding_qty" class="form-group row">
		<label id="elh_p_eastimate_binding_qty" for="x_binding_qty" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->binding_qty->caption() ?><?php echo ($p_eastimate->binding_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->binding_qty->cellAttributes() ?>>
<span id="el_p_eastimate_binding_qty">
<input type="text" data-table="p_eastimate" data-field="x_binding_qty" data-page="8" name="x_binding_qty" id="x_binding_qty" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->binding_qty->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->binding_qty->EditValue ?>"<?php echo $p_eastimate->binding_qty->editAttributes() ?>>
</span>
<?php echo $p_eastimate->binding_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->number_type->Visible) { // number_type ?>
	<div id="r_number_type" class="form-group row">
		<label id="elh_p_eastimate_number_type" for="x_number_type" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->number_type->caption() ?><?php echo ($p_eastimate->number_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->number_type->cellAttributes() ?>>
<span id="el_p_eastimate_number_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_number_type" data-page="8" data-value-separator="<?php echo $p_eastimate->number_type->displayValueSeparatorAttribute() ?>" id="x_number_type" name="x_number_type"<?php echo $p_eastimate->number_type->editAttributes() ?>>
		<?php echo $p_eastimate->number_type->selectOptionListHtml("x_number_type") ?>
	</select>
</div>
<?php echo $p_eastimate->number_type->Lookup->getParamTag("p_x_number_type") ?>
</span>
<?php echo $p_eastimate->number_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->number_qty->Visible) { // number_qty ?>
	<div id="r_number_qty" class="form-group row">
		<label id="elh_p_eastimate_number_qty" for="x_number_qty" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->number_qty->caption() ?><?php echo ($p_eastimate->number_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->number_qty->cellAttributes() ?>>
<span id="el_p_eastimate_number_qty">
<input type="text" data-table="p_eastimate" data-field="x_number_qty" data-page="8" name="x_number_qty" id="x_number_qty" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->number_qty->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->number_qty->EditValue ?>"<?php echo $p_eastimate->number_qty->editAttributes() ?>>
</span>
<?php echo $p_eastimate->number_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $p_eastimate_add->MultiPages->pageStyle("9") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_add->MultiPages->isActive("9")) ?>" href="#tab_p_eastimate9"><?php echo $p_eastimate->pageCaption(9) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_add->MultiPages->pageStyle("9") ?>" data-parent="<?php echo $p_eastimate_add->MultiPages->Parent ?>" id="tab_p_eastimate9"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_eastimate->de_01->Visible) { // de_01 ?>
	<div id="r_de_01" class="form-group row">
		<label id="elh_p_eastimate_de_01" for="x_de_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->de_01->caption() ?><?php echo ($p_eastimate->de_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->de_01->cellAttributes() ?>>
<span id="el_p_eastimate_de_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_de_01" data-page="9" data-value-separator="<?php echo $p_eastimate->de_01->displayValueSeparatorAttribute() ?>" id="x_de_01" name="x_de_01"<?php echo $p_eastimate->de_01->editAttributes() ?>>
		<?php echo $p_eastimate->de_01->selectOptionListHtml("x_de_01") ?>
	</select>
</div>
<?php echo $p_eastimate->de_01->Lookup->getParamTag("p_x_de_01") ?>
</span>
<?php echo $p_eastimate->de_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_de_01->Visible) { // qty_de_01 ?>
	<div id="r_qty_de_01" class="form-group row">
		<label id="elh_p_eastimate_qty_de_01" for="x_qty_de_01" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_de_01->caption() ?><?php echo ($p_eastimate->qty_de_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_de_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_de_01">
<input type="text" data-table="p_eastimate" data-field="x_qty_de_01" data-page="9" name="x_qty_de_01" id="x_qty_de_01" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_de_01->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_de_01->EditValue ?>"<?php echo $p_eastimate->qty_de_01->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_de_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->de_02->Visible) { // de_02 ?>
	<div id="r_de_02" class="form-group row">
		<label id="elh_p_eastimate_de_02" for="x_de_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->de_02->caption() ?><?php echo ($p_eastimate->de_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->de_02->cellAttributes() ?>>
<span id="el_p_eastimate_de_02">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_de_02" data-page="9" data-value-separator="<?php echo $p_eastimate->de_02->displayValueSeparatorAttribute() ?>" id="x_de_02" name="x_de_02"<?php echo $p_eastimate->de_02->editAttributes() ?>>
		<?php echo $p_eastimate->de_02->selectOptionListHtml("x_de_02") ?>
	</select>
</div>
<?php echo $p_eastimate->de_02->Lookup->getParamTag("p_x_de_02") ?>
</span>
<?php echo $p_eastimate->de_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_de_02->Visible) { // qty_de_02 ?>
	<div id="r_qty_de_02" class="form-group row">
		<label id="elh_p_eastimate_qty_de_02" for="x_qty_de_02" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_de_02->caption() ?><?php echo ($p_eastimate->qty_de_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_de_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_de_02">
<input type="text" data-table="p_eastimate" data-field="x_qty_de_02" data-page="9" name="x_qty_de_02" id="x_qty_de_02" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_de_02->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_de_02->EditValue ?>"<?php echo $p_eastimate->qty_de_02->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_de_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->de_03->Visible) { // de_03 ?>
	<div id="r_de_03" class="form-group row">
		<label id="elh_p_eastimate_de_03" for="x_de_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->de_03->caption() ?><?php echo ($p_eastimate->de_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->de_03->cellAttributes() ?>>
<span id="el_p_eastimate_de_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_eastimate" data-field="x_de_03" data-page="9" data-value-separator="<?php echo $p_eastimate->de_03->displayValueSeparatorAttribute() ?>" id="x_de_03" name="x_de_03"<?php echo $p_eastimate->de_03->editAttributes() ?>>
		<?php echo $p_eastimate->de_03->selectOptionListHtml("x_de_03") ?>
	</select>
</div>
<?php echo $p_eastimate->de_03->Lookup->getParamTag("p_x_de_03") ?>
</span>
<?php echo $p_eastimate->de_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_eastimate->qty_de_03->Visible) { // qty_de_03 ?>
	<div id="r_qty_de_03" class="form-group row">
		<label id="elh_p_eastimate_qty_de_03" for="x_qty_de_03" class="<?php echo $p_eastimate_add->LeftColumnClass ?>"><?php echo $p_eastimate->qty_de_03->caption() ?><?php echo ($p_eastimate->qty_de_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_eastimate_add->RightColumnClass ?>"><div<?php echo $p_eastimate->qty_de_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_de_03">
<input type="text" data-table="p_eastimate" data-field="x_qty_de_03" data-page="9" name="x_qty_de_03" id="x_qty_de_03" size="30" placeholder="<?php echo HtmlEncode($p_eastimate->qty_de_03->getPlaceHolder()) ?>" value="<?php echo $p_eastimate->qty_de_03->EditValue ?>"<?php echo $p_eastimate->qty_de_03->editAttributes() ?>>
</span>
<?php echo $p_eastimate->qty_de_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$p_eastimate_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_eastimate_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $p_eastimate_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_eastimate_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var paper = $("#x_paper").val();
		$("#r_pa_01").show();
		$("#r_qty_pa_01").show();		
		$("#r_pa_02").hide();
		$("#r_qty_pa_02").hide();		
		$("#r_pa_03").hide();
		$("#r_qty_pa_03").hide();		
		$("#r_pa_04").hide();
		$("#r_qty_pa_04").hide();		
		$("#r_pa_05").hide();
		$("#r_qty_pa_05").hide();
			if (paper == 4)
			{
				$("#r_pa_05").hide();
				$("#r_qty_pa_05").hide();		
			}
			else if (paper == 3)
			{
				$("#r_pa_04").hide();
				$("#r_qty_pa_04").hide();		
				$("#r_pa_05").hide();
				$("#r_qty_pa_05").hide();		
			}		
			else if (paper == 2)
			{
				$("#r_pa_03").hide();
				$("#r_qty_pa_03").hide();		
				$("#r_pa_04").hide();
				$("#r_qty_pa_04").hide();		
				$("#r_pa_05").hide();
				$("#r_qty_pa_05").hide();		
			}		
			else if (paper == 1)
			{
				$("#r_pa_02").hide();
				$("#r_qty_pa_02").hide();		
				$("#r_pa_03").hide();
				$("#r_qty_pa_03").hide();		
				$("#r_pa_04").hide();
				$("#r_qty_pa_04").hide();		
				$("#r_pa_05").hide();
				$("#r_qty_pa_05").hide();		
			}		
			else if (paper == 0)
			{
				$("#r_pa_01").hide();
				$("#r_qty_pa_01").hide();		
				$("#r_pa_02").hide();
				$("#r_qty_pa_02").hide();		
				$("#r_pa_03").hide();
				$("#r_qty_pa_03").hide();		
				$("#r_pa_04").hide();
				$("#r_qty_pa_04").hide();		
				$("#r_pa_05").hide();
				$("#r_qty_pa_05").hide();		
			}
</script>
<?php include_once "footer.php" ?>
<?php
$p_eastimate_add->terminate();
?>