<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_eastimate_view = new p_eastimate_view();

// Run the page
$p_eastimate_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_eastimate_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$p_eastimate->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fp_eastimateview = currentForm = new ew.Form("fp_eastimateview", "view");

// Form_CustomValidate event
fp_eastimateview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_eastimateview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fp_eastimateview.multiPage = new ew.MultiPage("fp_eastimateview");

// Dynamic selection lists
fp_eastimateview.lists["x_job_type"] = <?php echo $p_eastimate_view->job_type->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_job_type"].options = <?php echo JsonEncode($p_eastimate_view->job_type->options(FALSE, TRUE)) ?>;
fp_eastimateview.lists["x_job_category"] = <?php echo $p_eastimate_view->job_category->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_job_category"].options = <?php echo JsonEncode($p_eastimate_view->job_category->options(FALSE, TRUE)) ?>;
fp_eastimateview.lists["x_company_id"] = <?php echo $p_eastimate_view->company_id->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_company_id"].options = <?php echo JsonEncode($p_eastimate_view->company_id->lookupOptions()) ?>;
fp_eastimateview.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateview.lists["x_size"] = <?php echo $p_eastimate_view->size->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_size"].options = <?php echo JsonEncode($p_eastimate_view->size->lookupOptions()) ?>;
fp_eastimateview.lists["x_pr_01"] = <?php echo $p_eastimate_view->pr_01->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pr_01"].options = <?php echo JsonEncode($p_eastimate_view->pr_01->lookupOptions()) ?>;
fp_eastimateview.lists["x_pl_01"] = <?php echo $p_eastimate_view->pl_01->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pl_01"].options = <?php echo JsonEncode($p_eastimate_view->pl_01->lookupOptions()) ?>;
fp_eastimateview.lists["x_pr_02"] = <?php echo $p_eastimate_view->pr_02->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pr_02"].options = <?php echo JsonEncode($p_eastimate_view->pr_02->lookupOptions()) ?>;
fp_eastimateview.lists["x_pl_02"] = <?php echo $p_eastimate_view->pl_02->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pl_02"].options = <?php echo JsonEncode($p_eastimate_view->pl_02->lookupOptions()) ?>;
fp_eastimateview.lists["x_pr_03"] = <?php echo $p_eastimate_view->pr_03->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pr_03"].options = <?php echo JsonEncode($p_eastimate_view->pr_03->lookupOptions()) ?>;
fp_eastimateview.lists["x_pl_03"] = <?php echo $p_eastimate_view->pl_03->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pl_03"].options = <?php echo JsonEncode($p_eastimate_view->pl_03->lookupOptions()) ?>;
fp_eastimateview.lists["x_pr_04"] = <?php echo $p_eastimate_view->pr_04->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pr_04"].options = <?php echo JsonEncode($p_eastimate_view->pr_04->lookupOptions()) ?>;
fp_eastimateview.lists["x_pl_04"] = <?php echo $p_eastimate_view->pl_04->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pl_04"].options = <?php echo JsonEncode($p_eastimate_view->pl_04->lookupOptions()) ?>;
fp_eastimateview.lists["x_pa_01"] = <?php echo $p_eastimate_view->pa_01->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pa_01"].options = <?php echo JsonEncode($p_eastimate_view->pa_01->lookupOptions()) ?>;
fp_eastimateview.autoSuggests["x_pa_01"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateview.lists["x_pa_02"] = <?php echo $p_eastimate_view->pa_02->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pa_02"].options = <?php echo JsonEncode($p_eastimate_view->pa_02->lookupOptions()) ?>;
fp_eastimateview.autoSuggests["x_pa_02"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateview.lists["x_pa_03"] = <?php echo $p_eastimate_view->pa_03->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pa_03"].options = <?php echo JsonEncode($p_eastimate_view->pa_03->lookupOptions()) ?>;
fp_eastimateview.autoSuggests["x_pa_03"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateview.lists["x_pa_04"] = <?php echo $p_eastimate_view->pa_04->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pa_04"].options = <?php echo JsonEncode($p_eastimate_view->pa_04->lookupOptions()) ?>;
fp_eastimateview.autoSuggests["x_pa_04"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateview.lists["x_pa_05"] = <?php echo $p_eastimate_view->pa_05->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pa_05"].options = <?php echo JsonEncode($p_eastimate_view->pa_05->lookupOptions()) ?>;
fp_eastimateview.autoSuggests["x_pa_05"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_eastimateview.lists["x_pc_01"] = <?php echo $p_eastimate_view->pc_01->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pc_01"].options = <?php echo JsonEncode($p_eastimate_view->pc_01->lookupOptions()) ?>;
fp_eastimateview.lists["x_pc_02"] = <?php echo $p_eastimate_view->pc_02->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_pc_02"].options = <?php echo JsonEncode($p_eastimate_view->pc_02->lookupOptions()) ?>;
fp_eastimateview.lists["x_o_01"] = <?php echo $p_eastimate_view->o_01->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_o_01"].options = <?php echo JsonEncode($p_eastimate_view->o_01->lookupOptions()) ?>;
fp_eastimateview.lists["x_lamination_type"] = <?php echo $p_eastimate_view->lamination_type->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_lamination_type"].options = <?php echo JsonEncode($p_eastimate_view->lamination_type->lookupOptions()) ?>;
fp_eastimateview.lists["x_die_type"] = <?php echo $p_eastimate_view->die_type->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_die_type"].options = <?php echo JsonEncode($p_eastimate_view->die_type->lookupOptions()) ?>;
fp_eastimateview.lists["x_binding_type"] = <?php echo $p_eastimate_view->binding_type->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_binding_type"].options = <?php echo JsonEncode($p_eastimate_view->binding_type->lookupOptions()) ?>;
fp_eastimateview.lists["x_number_type"] = <?php echo $p_eastimate_view->number_type->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_number_type"].options = <?php echo JsonEncode($p_eastimate_view->number_type->lookupOptions()) ?>;
fp_eastimateview.lists["x_de_01"] = <?php echo $p_eastimate_view->de_01->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_de_01"].options = <?php echo JsonEncode($p_eastimate_view->de_01->lookupOptions()) ?>;
fp_eastimateview.lists["x_de_02"] = <?php echo $p_eastimate_view->de_02->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_de_02"].options = <?php echo JsonEncode($p_eastimate_view->de_02->lookupOptions()) ?>;
fp_eastimateview.lists["x_de_03"] = <?php echo $p_eastimate_view->de_03->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_de_03"].options = <?php echo JsonEncode($p_eastimate_view->de_03->lookupOptions()) ?>;
fp_eastimateview.lists["x_operator"] = <?php echo $p_eastimate_view->operator->Lookup->toClientList() ?>;
fp_eastimateview.lists["x_operator"].options = <?php echo JsonEncode($p_eastimate_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $p_eastimate_view->ExportOptions->render("body") ?>
<?php $p_eastimate_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $p_eastimate_view->showPageHeader(); ?>
<?php
$p_eastimate_view->showMessage();
?>
<form name="fp_eastimateview" id="fp_eastimateview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_eastimate_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_eastimate_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_eastimate">
<input type="hidden" name="modal" value="<?php echo (int)$p_eastimate_view->IsModal ?>">
<?php if ($p_eastimate_view->MultiPages->Items[0]->Visible) { ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_id"><?php echo $p_eastimate->id->caption() ?></span></td>
		<td data-name="id"<?php echo $p_eastimate->id->cellAttributes() ?>>
<span id="el_p_eastimate_id" data-page="0">
<span<?php echo $p_eastimate->id->viewAttributes() ?>>
<?php echo $p_eastimate->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->job_type->Visible) { // job_type ?>
	<tr id="r_job_type">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_job_type"><?php echo $p_eastimate->job_type->caption() ?></span></td>
		<td data-name="job_type"<?php echo $p_eastimate->job_type->cellAttributes() ?>>
<span id="el_p_eastimate_job_type" data-page="0">
<span<?php echo $p_eastimate->job_type->viewAttributes() ?>>
<?php echo $p_eastimate->job_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->job_category->Visible) { // job_category ?>
	<tr id="r_job_category">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_job_category"><?php echo $p_eastimate->job_category->caption() ?></span></td>
		<td data-name="job_category"<?php echo $p_eastimate->job_category->cellAttributes() ?>>
<span id="el_p_eastimate_job_category" data-page="0">
<span<?php echo $p_eastimate->job_category->viewAttributes() ?>>
<?php echo $p_eastimate->job_category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_company_id"><?php echo $p_eastimate->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $p_eastimate->company_id->cellAttributes() ?>>
<span id="el_p_eastimate_company_id" data-page="0">
<span<?php echo $p_eastimate->company_id->viewAttributes() ?>>
<?php echo $p_eastimate->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_description"><?php echo $p_eastimate->description->caption() ?></span></td>
		<td data-name="description"<?php echo $p_eastimate->description->cellAttributes() ?>>
<span id="el_p_eastimate_description" data-page="0">
<span<?php echo $p_eastimate->description->viewAttributes() ?>>
<?php echo $p_eastimate->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_size"><?php echo $p_eastimate->size->caption() ?></span></td>
		<td data-name="size"<?php echo $p_eastimate->size->cellAttributes() ?>>
<span id="el_p_eastimate_size" data-page="0">
<span<?php echo $p_eastimate->size->viewAttributes() ?>>
<?php echo $p_eastimate->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_quantity"><?php echo $p_eastimate->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $p_eastimate->quantity->cellAttributes() ?>>
<span id="el_p_eastimate_quantity" data-page="0">
<span<?php echo $p_eastimate->quantity->viewAttributes() ?>>
<?php echo $p_eastimate->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pages->Visible) { // pages ?>
	<tr id="r_pages">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pages"><?php echo $p_eastimate->pages->caption() ?></span></td>
		<td data-name="pages"<?php echo $p_eastimate->pages->cellAttributes() ?>>
<span id="el_p_eastimate_pages" data-page="0">
<span<?php echo $p_eastimate->pages->viewAttributes() ?>>
<?php echo $p_eastimate->pages->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->paper->Visible) { // paper ?>
	<tr id="r_paper">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_paper"><?php echo $p_eastimate->paper->caption() ?></span></td>
		<td data-name="paper"<?php echo $p_eastimate->paper->cellAttributes() ?>>
<span id="el_p_eastimate_paper" data-page="0">
<span<?php echo $p_eastimate->paper->viewAttributes() ?>>
<?php echo $p_eastimate->paper->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_remarks"><?php echo $p_eastimate->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $p_eastimate->remarks->cellAttributes() ?>>
<span id="el_p_eastimate_remarks" data-page="0">
<span<?php echo $p_eastimate->remarks->viewAttributes() ?>>
<?php echo $p_eastimate->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
<div class="ew-multi-page">
<div class="accordion ew-accordion" id="p_eastimate_view"><!-- multi-page accordion -->
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("1")) ?>" href="#tab_p_eastimate1"><?php echo $p_eastimate->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate1">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->pr_01->Visible) { // pr_01 ?>
	<tr id="r_pr_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pr_01"><?php echo $p_eastimate->pr_01->caption() ?></span></td>
		<td data-name="pr_01"<?php echo $p_eastimate->pr_01->cellAttributes() ?>>
<span id="el_p_eastimate_pr_01" data-page="1">
<span<?php echo $p_eastimate->pr_01->viewAttributes() ?>>
<?php echo $p_eastimate->pr_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pr_01->Visible) { // qty_pr_01 ?>
	<tr id="r_qty_pr_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_01"><?php echo $p_eastimate->qty_pr_01->caption() ?></span></td>
		<td data-name="qty_pr_01"<?php echo $p_eastimate->qty_pr_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_01" data-page="1">
<span<?php echo $p_eastimate->qty_pr_01->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pr_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pl_01->Visible) { // pl_01 ?>
	<tr id="r_pl_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pl_01"><?php echo $p_eastimate->pl_01->caption() ?></span></td>
		<td data-name="pl_01"<?php echo $p_eastimate->pl_01->cellAttributes() ?>>
<span id="el_p_eastimate_pl_01" data-page="1">
<span<?php echo $p_eastimate->pl_01->viewAttributes() ?>>
<?php echo $p_eastimate->pl_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pl_01->Visible) { // qty_pl_01 ?>
	<tr id="r_qty_pl_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_01"><?php echo $p_eastimate->qty_pl_01->caption() ?></span></td>
		<td data-name="qty_pl_01"<?php echo $p_eastimate->qty_pl_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_01" data-page="1">
<span<?php echo $p_eastimate->qty_pl_01->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pl_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("2")) ?>" href="#tab_p_eastimate2"><?php echo $p_eastimate->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate2">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->pr_02->Visible) { // pr_02 ?>
	<tr id="r_pr_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pr_02"><?php echo $p_eastimate->pr_02->caption() ?></span></td>
		<td data-name="pr_02"<?php echo $p_eastimate->pr_02->cellAttributes() ?>>
<span id="el_p_eastimate_pr_02" data-page="2">
<span<?php echo $p_eastimate->pr_02->viewAttributes() ?>>
<?php echo $p_eastimate->pr_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pr_02->Visible) { // qty_pr_02 ?>
	<tr id="r_qty_pr_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_02"><?php echo $p_eastimate->qty_pr_02->caption() ?></span></td>
		<td data-name="qty_pr_02"<?php echo $p_eastimate->qty_pr_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_02" data-page="2">
<span<?php echo $p_eastimate->qty_pr_02->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pr_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pl_02->Visible) { // pl_02 ?>
	<tr id="r_pl_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pl_02"><?php echo $p_eastimate->pl_02->caption() ?></span></td>
		<td data-name="pl_02"<?php echo $p_eastimate->pl_02->cellAttributes() ?>>
<span id="el_p_eastimate_pl_02" data-page="2">
<span<?php echo $p_eastimate->pl_02->viewAttributes() ?>>
<?php echo $p_eastimate->pl_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pl_02->Visible) { // qty_pl_02 ?>
	<tr id="r_qty_pl_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_02"><?php echo $p_eastimate->qty_pl_02->caption() ?></span></td>
		<td data-name="qty_pl_02"<?php echo $p_eastimate->qty_pl_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_02" data-page="2">
<span<?php echo $p_eastimate->qty_pl_02->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pl_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("3")) ?>" href="#tab_p_eastimate3"><?php echo $p_eastimate->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate3">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->pr_03->Visible) { // pr_03 ?>
	<tr id="r_pr_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pr_03"><?php echo $p_eastimate->pr_03->caption() ?></span></td>
		<td data-name="pr_03"<?php echo $p_eastimate->pr_03->cellAttributes() ?>>
<span id="el_p_eastimate_pr_03" data-page="3">
<span<?php echo $p_eastimate->pr_03->viewAttributes() ?>>
<?php echo $p_eastimate->pr_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pr_03->Visible) { // qty_pr_03 ?>
	<tr id="r_qty_pr_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_03"><?php echo $p_eastimate->qty_pr_03->caption() ?></span></td>
		<td data-name="qty_pr_03"<?php echo $p_eastimate->qty_pr_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_03" data-page="3">
<span<?php echo $p_eastimate->qty_pr_03->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pr_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pl_03->Visible) { // pl_03 ?>
	<tr id="r_pl_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pl_03"><?php echo $p_eastimate->pl_03->caption() ?></span></td>
		<td data-name="pl_03"<?php echo $p_eastimate->pl_03->cellAttributes() ?>>
<span id="el_p_eastimate_pl_03" data-page="3">
<span<?php echo $p_eastimate->pl_03->viewAttributes() ?>>
<?php echo $p_eastimate->pl_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pl_03->Visible) { // qty_pl_03 ?>
	<tr id="r_qty_pl_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_03"><?php echo $p_eastimate->qty_pl_03->caption() ?></span></td>
		<td data-name="qty_pl_03"<?php echo $p_eastimate->qty_pl_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_03" data-page="3">
<span<?php echo $p_eastimate->qty_pl_03->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pl_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("4")) ?>" href="#tab_p_eastimate4"><?php echo $p_eastimate->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate4">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->pr_04->Visible) { // pr_04 ?>
	<tr id="r_pr_04">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pr_04"><?php echo $p_eastimate->pr_04->caption() ?></span></td>
		<td data-name="pr_04"<?php echo $p_eastimate->pr_04->cellAttributes() ?>>
<span id="el_p_eastimate_pr_04" data-page="4">
<span<?php echo $p_eastimate->pr_04->viewAttributes() ?>>
<?php echo $p_eastimate->pr_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pr_04->Visible) { // qty_pr_04 ?>
	<tr id="r_qty_pr_04">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pr_04"><?php echo $p_eastimate->qty_pr_04->caption() ?></span></td>
		<td data-name="qty_pr_04"<?php echo $p_eastimate->qty_pr_04->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pr_04" data-page="4">
<span<?php echo $p_eastimate->qty_pr_04->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pr_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pl_04->Visible) { // pl_04 ?>
	<tr id="r_pl_04">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pl_04"><?php echo $p_eastimate->pl_04->caption() ?></span></td>
		<td data-name="pl_04"<?php echo $p_eastimate->pl_04->cellAttributes() ?>>
<span id="el_p_eastimate_pl_04" data-page="4">
<span<?php echo $p_eastimate->pl_04->viewAttributes() ?>>
<?php echo $p_eastimate->pl_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pl_04->Visible) { // qty_pl_04 ?>
	<tr id="r_qty_pl_04">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pl_04"><?php echo $p_eastimate->qty_pl_04->caption() ?></span></td>
		<td data-name="qty_pl_04"<?php echo $p_eastimate->qty_pl_04->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pl_04" data-page="4">
<span<?php echo $p_eastimate->qty_pl_04->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pl_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("5")) ?>" href="#tab_p_eastimate5"><?php echo $p_eastimate->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate5">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->pa_01->Visible) { // pa_01 ?>
	<tr id="r_pa_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pa_01"><?php echo $p_eastimate->pa_01->caption() ?></span></td>
		<td data-name="pa_01"<?php echo $p_eastimate->pa_01->cellAttributes() ?>>
<span id="el_p_eastimate_pa_01" data-page="5">
<span<?php echo $p_eastimate->pa_01->viewAttributes() ?>>
<?php echo $p_eastimate->pa_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pa_01->Visible) { // qty_pa_01 ?>
	<tr id="r_qty_pa_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_01"><?php echo $p_eastimate->qty_pa_01->caption() ?></span></td>
		<td data-name="qty_pa_01"<?php echo $p_eastimate->qty_pa_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_01" data-page="5">
<span<?php echo $p_eastimate->qty_pa_01->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pa_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pa_02->Visible) { // pa_02 ?>
	<tr id="r_pa_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pa_02"><?php echo $p_eastimate->pa_02->caption() ?></span></td>
		<td data-name="pa_02"<?php echo $p_eastimate->pa_02->cellAttributes() ?>>
<span id="el_p_eastimate_pa_02" data-page="5">
<span<?php echo $p_eastimate->pa_02->viewAttributes() ?>>
<?php echo $p_eastimate->pa_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pa_02->Visible) { // qty_pa_02 ?>
	<tr id="r_qty_pa_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_02"><?php echo $p_eastimate->qty_pa_02->caption() ?></span></td>
		<td data-name="qty_pa_02"<?php echo $p_eastimate->qty_pa_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_02" data-page="5">
<span<?php echo $p_eastimate->qty_pa_02->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pa_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pa_03->Visible) { // pa_03 ?>
	<tr id="r_pa_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pa_03"><?php echo $p_eastimate->pa_03->caption() ?></span></td>
		<td data-name="pa_03"<?php echo $p_eastimate->pa_03->cellAttributes() ?>>
<span id="el_p_eastimate_pa_03" data-page="5">
<span<?php echo $p_eastimate->pa_03->viewAttributes() ?>>
<?php echo $p_eastimate->pa_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pa_03->Visible) { // qty_pa_03 ?>
	<tr id="r_qty_pa_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_03"><?php echo $p_eastimate->qty_pa_03->caption() ?></span></td>
		<td data-name="qty_pa_03"<?php echo $p_eastimate->qty_pa_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_03" data-page="5">
<span<?php echo $p_eastimate->qty_pa_03->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pa_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pa_04->Visible) { // pa_04 ?>
	<tr id="r_pa_04">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pa_04"><?php echo $p_eastimate->pa_04->caption() ?></span></td>
		<td data-name="pa_04"<?php echo $p_eastimate->pa_04->cellAttributes() ?>>
<span id="el_p_eastimate_pa_04" data-page="5">
<span<?php echo $p_eastimate->pa_04->viewAttributes() ?>>
<?php echo $p_eastimate->pa_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pa_04->Visible) { // qty_pa_04 ?>
	<tr id="r_qty_pa_04">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_04"><?php echo $p_eastimate->qty_pa_04->caption() ?></span></td>
		<td data-name="qty_pa_04"<?php echo $p_eastimate->qty_pa_04->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_04" data-page="5">
<span<?php echo $p_eastimate->qty_pa_04->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pa_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pa_05->Visible) { // pa_05 ?>
	<tr id="r_pa_05">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pa_05"><?php echo $p_eastimate->pa_05->caption() ?></span></td>
		<td data-name="pa_05"<?php echo $p_eastimate->pa_05->cellAttributes() ?>>
<span id="el_p_eastimate_pa_05" data-page="5">
<span<?php echo $p_eastimate->pa_05->viewAttributes() ?>>
<?php echo $p_eastimate->pa_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pa_05->Visible) { // qty_pa_05 ?>
	<tr id="r_qty_pa_05">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pa_05"><?php echo $p_eastimate->qty_pa_05->caption() ?></span></td>
		<td data-name="qty_pa_05"<?php echo $p_eastimate->qty_pa_05->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pa_05" data-page="5">
<span<?php echo $p_eastimate->qty_pa_05->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pa_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("6")) ?>" href="#tab_p_eastimate6"><?php echo $p_eastimate->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate6">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->pc_01->Visible) { // pc_01 ?>
	<tr id="r_pc_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pc_01"><?php echo $p_eastimate->pc_01->caption() ?></span></td>
		<td data-name="pc_01"<?php echo $p_eastimate->pc_01->cellAttributes() ?>>
<span id="el_p_eastimate_pc_01" data-page="6">
<span<?php echo $p_eastimate->pc_01->viewAttributes() ?>>
<?php echo $p_eastimate->pc_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pc_01->Visible) { // qty_pc_01 ?>
	<tr id="r_qty_pc_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pc_01"><?php echo $p_eastimate->qty_pc_01->caption() ?></span></td>
		<td data-name="qty_pc_01"<?php echo $p_eastimate->qty_pc_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pc_01" data-page="6">
<span<?php echo $p_eastimate->qty_pc_01->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pc_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->pc_02->Visible) { // pc_02 ?>
	<tr id="r_pc_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_pc_02"><?php echo $p_eastimate->pc_02->caption() ?></span></td>
		<td data-name="pc_02"<?php echo $p_eastimate->pc_02->cellAttributes() ?>>
<span id="el_p_eastimate_pc_02" data-page="6">
<span<?php echo $p_eastimate->pc_02->viewAttributes() ?>>
<?php echo $p_eastimate->pc_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_pc_02->Visible) { // qty_pc_02 ?>
	<tr id="r_qty_pc_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_pc_02"><?php echo $p_eastimate->qty_pc_02->caption() ?></span></td>
		<td data-name="qty_pc_02"<?php echo $p_eastimate->qty_pc_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_pc_02" data-page="6">
<span<?php echo $p_eastimate->qty_pc_02->viewAttributes() ?>>
<?php echo $p_eastimate->qty_pc_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->o_01->Visible) { // o_01 ?>
	<tr id="r_o_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_o_01"><?php echo $p_eastimate->o_01->caption() ?></span></td>
		<td data-name="o_01"<?php echo $p_eastimate->o_01->cellAttributes() ?>>
<span id="el_p_eastimate_o_01" data-page="6">
<span<?php echo $p_eastimate->o_01->viewAttributes() ?>>
<?php echo $p_eastimate->o_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_o_01->Visible) { // qty_o_01 ?>
	<tr id="r_qty_o_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_o_01"><?php echo $p_eastimate->qty_o_01->caption() ?></span></td>
		<td data-name="qty_o_01"<?php echo $p_eastimate->qty_o_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_o_01" data-page="6">
<span<?php echo $p_eastimate->qty_o_01->viewAttributes() ?>>
<?php echo $p_eastimate->qty_o_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("7") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("7")) ?>" href="#tab_p_eastimate7"><?php echo $p_eastimate->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate7">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->lamination_type->Visible) { // lamination_type ?>
	<tr id="r_lamination_type">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_lamination_type"><?php echo $p_eastimate->lamination_type->caption() ?></span></td>
		<td data-name="lamination_type"<?php echo $p_eastimate->lamination_type->cellAttributes() ?>>
<span id="el_p_eastimate_lamination_type" data-page="7">
<span<?php echo $p_eastimate->lamination_type->viewAttributes() ?>>
<?php echo $p_eastimate->lamination_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->lamination_qty->Visible) { // lamination_qty ?>
	<tr id="r_lamination_qty">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_lamination_qty"><?php echo $p_eastimate->lamination_qty->caption() ?></span></td>
		<td data-name="lamination_qty"<?php echo $p_eastimate->lamination_qty->cellAttributes() ?>>
<span id="el_p_eastimate_lamination_qty" data-page="7">
<span<?php echo $p_eastimate->lamination_qty->viewAttributes() ?>>
<?php echo $p_eastimate->lamination_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->die_type->Visible) { // die_type ?>
	<tr id="r_die_type">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_die_type"><?php echo $p_eastimate->die_type->caption() ?></span></td>
		<td data-name="die_type"<?php echo $p_eastimate->die_type->cellAttributes() ?>>
<span id="el_p_eastimate_die_type" data-page="7">
<span<?php echo $p_eastimate->die_type->viewAttributes() ?>>
<?php echo $p_eastimate->die_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->die_qty->Visible) { // die_qty ?>
	<tr id="r_die_qty">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_die_qty"><?php echo $p_eastimate->die_qty->caption() ?></span></td>
		<td data-name="die_qty"<?php echo $p_eastimate->die_qty->cellAttributes() ?>>
<span id="el_p_eastimate_die_qty" data-page="7">
<span<?php echo $p_eastimate->die_qty->viewAttributes() ?>>
<?php echo $p_eastimate->die_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("8") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("8")) ?>" href="#tab_p_eastimate8"><?php echo $p_eastimate->pageCaption(8) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("8") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate8">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->binding_type->Visible) { // binding_type ?>
	<tr id="r_binding_type">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_binding_type"><?php echo $p_eastimate->binding_type->caption() ?></span></td>
		<td data-name="binding_type"<?php echo $p_eastimate->binding_type->cellAttributes() ?>>
<span id="el_p_eastimate_binding_type" data-page="8">
<span<?php echo $p_eastimate->binding_type->viewAttributes() ?>>
<?php echo $p_eastimate->binding_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->binding_qty->Visible) { // binding_qty ?>
	<tr id="r_binding_qty">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_binding_qty"><?php echo $p_eastimate->binding_qty->caption() ?></span></td>
		<td data-name="binding_qty"<?php echo $p_eastimate->binding_qty->cellAttributes() ?>>
<span id="el_p_eastimate_binding_qty" data-page="8">
<span<?php echo $p_eastimate->binding_qty->viewAttributes() ?>>
<?php echo $p_eastimate->binding_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->number_type->Visible) { // number_type ?>
	<tr id="r_number_type">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_number_type"><?php echo $p_eastimate->number_type->caption() ?></span></td>
		<td data-name="number_type"<?php echo $p_eastimate->number_type->cellAttributes() ?>>
<span id="el_p_eastimate_number_type" data-page="8">
<span<?php echo $p_eastimate->number_type->viewAttributes() ?>>
<?php echo $p_eastimate->number_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->number_qty->Visible) { // number_qty ?>
	<tr id="r_number_qty">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_number_qty"><?php echo $p_eastimate->number_qty->caption() ?></span></td>
		<td data-name="number_qty"<?php echo $p_eastimate->number_qty->cellAttributes() ?>>
<span id="el_p_eastimate_number_qty" data-page="8">
<span<?php echo $p_eastimate->number_qty->viewAttributes() ?>>
<?php echo $p_eastimate->number_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $p_eastimate_view->MultiPages->pageStyle("9") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_eastimate_view->MultiPages->isActive("9")) ?>" href="#tab_p_eastimate9"><?php echo $p_eastimate->pageCaption(9) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_eastimate_view->MultiPages->pageStyle("9") ?>" data-parent="<?php echo $p_eastimate_view->MultiPages->Parent ?>" id="tab_p_eastimate9">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_eastimate->de_01->Visible) { // de_01 ?>
	<tr id="r_de_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_de_01"><?php echo $p_eastimate->de_01->caption() ?></span></td>
		<td data-name="de_01"<?php echo $p_eastimate->de_01->cellAttributes() ?>>
<span id="el_p_eastimate_de_01" data-page="9">
<span<?php echo $p_eastimate->de_01->viewAttributes() ?>>
<?php echo $p_eastimate->de_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_de_01->Visible) { // qty_de_01 ?>
	<tr id="r_qty_de_01">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_de_01"><?php echo $p_eastimate->qty_de_01->caption() ?></span></td>
		<td data-name="qty_de_01"<?php echo $p_eastimate->qty_de_01->cellAttributes() ?>>
<span id="el_p_eastimate_qty_de_01" data-page="9">
<span<?php echo $p_eastimate->qty_de_01->viewAttributes() ?>>
<?php echo $p_eastimate->qty_de_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->de_02->Visible) { // de_02 ?>
	<tr id="r_de_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_de_02"><?php echo $p_eastimate->de_02->caption() ?></span></td>
		<td data-name="de_02"<?php echo $p_eastimate->de_02->cellAttributes() ?>>
<span id="el_p_eastimate_de_02" data-page="9">
<span<?php echo $p_eastimate->de_02->viewAttributes() ?>>
<?php echo $p_eastimate->de_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_de_02->Visible) { // qty_de_02 ?>
	<tr id="r_qty_de_02">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_de_02"><?php echo $p_eastimate->qty_de_02->caption() ?></span></td>
		<td data-name="qty_de_02"<?php echo $p_eastimate->qty_de_02->cellAttributes() ?>>
<span id="el_p_eastimate_qty_de_02" data-page="9">
<span<?php echo $p_eastimate->qty_de_02->viewAttributes() ?>>
<?php echo $p_eastimate->qty_de_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->de_03->Visible) { // de_03 ?>
	<tr id="r_de_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_de_03"><?php echo $p_eastimate->de_03->caption() ?></span></td>
		<td data-name="de_03"<?php echo $p_eastimate->de_03->cellAttributes() ?>>
<span id="el_p_eastimate_de_03" data-page="9">
<span<?php echo $p_eastimate->de_03->viewAttributes() ?>>
<?php echo $p_eastimate->de_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->qty_de_03->Visible) { // qty_de_03 ?>
	<tr id="r_qty_de_03">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_qty_de_03"><?php echo $p_eastimate->qty_de_03->caption() ?></span></td>
		<td data-name="qty_de_03"<?php echo $p_eastimate->qty_de_03->cellAttributes() ?>>
<span id="el_p_eastimate_qty_de_03" data-page="9">
<span<?php echo $p_eastimate->qty_de_03->viewAttributes() ?>>
<?php echo $p_eastimate->qty_de_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_operator"><?php echo $p_eastimate->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $p_eastimate->operator->cellAttributes() ?>>
<span id="el_p_eastimate_operator" data-page="9">
<span<?php echo $p_eastimate->operator->viewAttributes() ?>>
<?php echo $p_eastimate->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_eastimate->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $p_eastimate_view->TableLeftColumnClass ?>"><span id="elh_p_eastimate_datetime"><?php echo $p_eastimate->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $p_eastimate->datetime->cellAttributes() ?>>
<span id="el_p_eastimate_datetime" data-page="9">
<span<?php echo $p_eastimate->datetime->viewAttributes() ?>>
<?php echo $p_eastimate->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$p_eastimate->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$p_eastimate->isExport()) { ?>
</div>
</div>
<?php } ?>
</form>
<?php
$p_eastimate_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$p_eastimate->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$p_eastimate_view->terminate();
?>