<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_po_add = new p_po_add();

// Run the page
$p_po_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_po_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fp_poadd = currentForm = new ew.Form("fp_poadd", "add");

// Validate form
fp_poadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($p_po_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->type->caption(), $p_po->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->job_category->Required) { ?>
			elm = this.getElements("x" + infix + "_job_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->job_category->caption(), $p_po->job_category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->company_id->caption(), $p_po->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_po->company_id->errorMessage()) ?>");
		<?php if ($p_po_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->item->caption(), $p_po->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->quantity->caption(), $p_po->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->item_size->Required) { ?>
			elm = this.getElements("x" + infix + "_item_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->item_size->caption(), $p_po->item_size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_03->Required) { ?>
			elm = this.getElements("x" + infix + "_description_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_03->caption(), $p_po->description_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_description_02[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_02->caption(), $p_po->description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_09->Required) { ?>
			elm = this.getElements("x" + infix + "_description_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_09->caption(), $p_po->description_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_description_01[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_01->caption(), $p_po->description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_08->Required) { ?>
			elm = this.getElements("x" + infix + "_description_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_08->caption(), $p_po->description_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_07->Required) { ?>
			elm = this.getElements("x" + infix + "_description_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_07->caption(), $p_po->description_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_10->Required) { ?>
			elm = this.getElements("x" + infix + "_description_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_10->caption(), $p_po->description_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_04->Required) { ?>
			elm = this.getElements("x" + infix + "_description_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_04->caption(), $p_po->description_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_06->Required) { ?>
			elm = this.getElements("x" + infix + "_description_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_06->caption(), $p_po->description_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->description_05->Required) { ?>
			elm = this.getElements("x" + infix + "_description_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->description_05->caption(), $p_po->description_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->amount->caption(), $p_po->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->gst->caption(), $p_po->gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->buyer_instruction->caption(), $p_po->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->remarks->caption(), $p_po->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->despatch_date->caption(), $p_po->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_po->despatch_date->errorMessage()) ?>");
		<?php if ($p_po_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->operator->caption(), $p_po->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_po_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_po->datetime->caption(), $p_po->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fp_poadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_poadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fp_poadd.multiPage = new ew.MultiPage("fp_poadd");

// Dynamic selection lists
fp_poadd.lists["x_type"] = <?php echo $p_po_add->type->Lookup->toClientList() ?>;
fp_poadd.lists["x_type"].options = <?php echo JsonEncode($p_po_add->type->options(FALSE, TRUE)) ?>;
fp_poadd.lists["x_job_category"] = <?php echo $p_po_add->job_category->Lookup->toClientList() ?>;
fp_poadd.lists["x_job_category"].options = <?php echo JsonEncode($p_po_add->job_category->options(FALSE, TRUE)) ?>;
fp_poadd.lists["x_company_id"] = <?php echo $p_po_add->company_id->Lookup->toClientList() ?>;
fp_poadd.lists["x_company_id"].options = <?php echo JsonEncode($p_po_add->company_id->lookupOptions()) ?>;
fp_poadd.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_poadd.lists["x_description_03[]"] = <?php echo $p_po_add->description_03->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_03[]"].options = <?php echo JsonEncode($p_po_add->description_03->lookupOptions()) ?>;
fp_poadd.lists["x_description_02[]"] = <?php echo $p_po_add->description_02->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_02[]"].options = <?php echo JsonEncode($p_po_add->description_02->lookupOptions()) ?>;
fp_poadd.lists["x_description_09[]"] = <?php echo $p_po_add->description_09->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_09[]"].options = <?php echo JsonEncode($p_po_add->description_09->lookupOptions()) ?>;
fp_poadd.lists["x_description_01[]"] = <?php echo $p_po_add->description_01->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_01[]"].options = <?php echo JsonEncode($p_po_add->description_01->lookupOptions()) ?>;
fp_poadd.lists["x_description_08[]"] = <?php echo $p_po_add->description_08->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_08[]"].options = <?php echo JsonEncode($p_po_add->description_08->lookupOptions()) ?>;
fp_poadd.lists["x_description_07[]"] = <?php echo $p_po_add->description_07->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_07[]"].options = <?php echo JsonEncode($p_po_add->description_07->lookupOptions()) ?>;
fp_poadd.lists["x_description_10[]"] = <?php echo $p_po_add->description_10->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_10[]"].options = <?php echo JsonEncode($p_po_add->description_10->lookupOptions()) ?>;
fp_poadd.lists["x_description_04[]"] = <?php echo $p_po_add->description_04->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_04[]"].options = <?php echo JsonEncode($p_po_add->description_04->lookupOptions()) ?>;
fp_poadd.lists["x_description_06[]"] = <?php echo $p_po_add->description_06->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_06[]"].options = <?php echo JsonEncode($p_po_add->description_06->lookupOptions()) ?>;
fp_poadd.lists["x_description_05[]"] = <?php echo $p_po_add->description_05->Lookup->toClientList() ?>;
fp_poadd.lists["x_description_05[]"].options = <?php echo JsonEncode($p_po_add->description_05->lookupOptions()) ?>;
fp_poadd.lists["x_gst"] = <?php echo $p_po_add->gst->Lookup->toClientList() ?>;
fp_poadd.lists["x_gst"].options = <?php echo JsonEncode($p_po_add->gst->lookupOptions()) ?>;
fp_poadd.lists["x_operator"] = <?php echo $p_po_add->operator->Lookup->toClientList() ?>;
fp_poadd.lists["x_operator"].options = <?php echo JsonEncode($p_po_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_po_add->showPageHeader(); ?>
<?php
$p_po_add->showMessage();
?>
<form name="fp_poadd" id="fp_poadd" class="<?php echo $p_po_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_po_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_po_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_po">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$p_po_add->IsModal ?>">
<?php if ($p_po_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($p_po->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_p_po_type" for="x_type" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->type->caption() ?><?php echo ($p_po->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->type->cellAttributes() ?>>
<span id="el_p_po_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_po" data-field="x_type" data-page="0" data-value-separator="<?php echo $p_po->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $p_po->type->editAttributes() ?>>
		<?php echo $p_po->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $p_po->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->job_category->Visible) { // job_category ?>
	<div id="r_job_category" class="form-group row">
		<label id="elh_p_po_job_category" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->job_category->caption() ?><?php echo ($p_po->job_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->job_category->cellAttributes() ?>>
<span id="el_p_po_job_category">
<div id="tp_x_job_category" class="ew-template"><input type="radio" class="form-check-input" data-table="p_po" data-field="x_job_category" data-page="0" data-value-separator="<?php echo $p_po->job_category->displayValueSeparatorAttribute() ?>" name="x_job_category" id="x_job_category" value="{value}"<?php echo $p_po->job_category->editAttributes() ?>></div>
<div id="dsl_x_job_category" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->job_category->radioButtonListHtml(FALSE, "x_job_category", 0) ?>
</div></div>
</span>
<?php echo $p_po->job_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_p_po_company_id" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->company_id->caption() ?><?php echo ($p_po->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->company_id->cellAttributes() ?>>
<span id="el_p_po_company_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$p_po->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_po->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($p_po->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_po->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_po->company_id->getPlaceHolder()) ?>"<?php echo $p_po->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_po->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_po->company_id->ReadOnly || $p_po->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_po" data-field="x_company_id" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_po->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($p_po->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_poadd.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $p_po->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $p_po->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_p_po_item" for="x_item" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->item->caption() ?><?php echo ($p_po->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->item->cellAttributes() ?>>
<span id="el_p_po_item">
<input type="text" data-table="p_po" data-field="x_item" data-page="0" name="x_item" id="x_item" size="30" placeholder="<?php echo HtmlEncode($p_po->item->getPlaceHolder()) ?>" value="<?php echo $p_po->item->EditValue ?>"<?php echo $p_po->item->editAttributes() ?>>
</span>
<?php echo $p_po->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_p_po_quantity" for="x_quantity" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->quantity->caption() ?><?php echo ($p_po->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->quantity->cellAttributes() ?>>
<span id="el_p_po_quantity">
<input type="text" data-table="p_po" data-field="x_quantity" data-page="0" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($p_po->quantity->getPlaceHolder()) ?>" value="<?php echo $p_po->quantity->EditValue ?>"<?php echo $p_po->quantity->editAttributes() ?>>
</span>
<?php echo $p_po->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->item_size->Visible) { // item_size ?>
	<div id="r_item_size" class="form-group row">
		<label id="elh_p_po_item_size" for="x_item_size" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->item_size->caption() ?><?php echo ($p_po->item_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->item_size->cellAttributes() ?>>
<span id="el_p_po_item_size">
<input type="text" data-table="p_po" data-field="x_item_size" data-page="0" name="x_item_size" id="x_item_size" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($p_po->item_size->getPlaceHolder()) ?>" value="<?php echo $p_po->item_size->EditValue ?>"<?php echo $p_po->item_size->editAttributes() ?>>
</span>
<?php echo $p_po->item_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="p_po_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $p_po_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_po_add->MultiPages->isActive("1")) ?>" href="#tab_p_po1"><?php echo $p_po->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_po_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $p_po_add->MultiPages->Parent ?>" id="tab_p_po1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($p_po->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label id="elh_p_po_description_03" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_03->caption() ?><?php echo ($p_po->description_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_03->cellAttributes() ?>>
<span id="el_p_po_description_03">
<div id="tp_x_description_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_03" data-page="1" data-value-separator="<?php echo $p_po->description_03->displayValueSeparatorAttribute() ?>" name="x_description_03[]" id="x_description_03[]" value="{value}"<?php echo $p_po->description_03->editAttributes() ?>></div>
<div id="dsl_x_description_03" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_03->checkBoxListHtml(FALSE, "x_description_03[]", 1) ?>
</div></div>
<?php echo $p_po->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
<?php echo $p_po->description_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label id="elh_p_po_description_02" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_02->caption() ?><?php echo ($p_po->description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_02->cellAttributes() ?>>
<span id="el_p_po_description_02">
<div id="tp_x_description_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_02" data-page="1" data-value-separator="<?php echo $p_po->description_02->displayValueSeparatorAttribute() ?>" name="x_description_02[]" id="x_description_02[]" value="{value}"<?php echo $p_po->description_02->editAttributes() ?>></div>
<div id="dsl_x_description_02" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_02->checkBoxListHtml(FALSE, "x_description_02[]", 1) ?>
</div></div>
<?php echo $p_po->description_02->Lookup->getParamTag("p_x_description_02") ?>
</span>
<?php echo $p_po->description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label id="elh_p_po_description_09" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_09->caption() ?><?php echo ($p_po->description_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_09->cellAttributes() ?>>
<span id="el_p_po_description_09">
<div id="tp_x_description_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_09" data-page="1" data-value-separator="<?php echo $p_po->description_09->displayValueSeparatorAttribute() ?>" name="x_description_09[]" id="x_description_09[]" value="{value}"<?php echo $p_po->description_09->editAttributes() ?>></div>
<div id="dsl_x_description_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_09->checkBoxListHtml(FALSE, "x_description_09[]", 1) ?>
</div></div>
<?php echo $p_po->description_09->Lookup->getParamTag("p_x_description_09") ?>
</span>
<?php echo $p_po->description_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label id="elh_p_po_description_01" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_01->caption() ?><?php echo ($p_po->description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_01->cellAttributes() ?>>
<span id="el_p_po_description_01">
<div id="tp_x_description_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_01" data-page="1" data-value-separator="<?php echo $p_po->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01[]" id="x_description_01[]" value="{value}"<?php echo $p_po->description_01->editAttributes() ?>></div>
<div id="dsl_x_description_01" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_01->checkBoxListHtml(FALSE, "x_description_01[]", 1) ?>
</div></div>
<?php echo $p_po->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
<?php echo $p_po->description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label id="elh_p_po_description_08" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_08->caption() ?><?php echo ($p_po->description_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_08->cellAttributes() ?>>
<span id="el_p_po_description_08">
<div id="tp_x_description_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_08" data-page="1" data-value-separator="<?php echo $p_po->description_08->displayValueSeparatorAttribute() ?>" name="x_description_08[]" id="x_description_08[]" value="{value}"<?php echo $p_po->description_08->editAttributes() ?>></div>
<div id="dsl_x_description_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_08->checkBoxListHtml(FALSE, "x_description_08[]", 1) ?>
</div></div>
<?php echo $p_po->description_08->Lookup->getParamTag("p_x_description_08") ?>
</span>
<?php echo $p_po->description_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label id="elh_p_po_description_07" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_07->caption() ?><?php echo ($p_po->description_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_07->cellAttributes() ?>>
<span id="el_p_po_description_07">
<div id="tp_x_description_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_07" data-page="1" data-value-separator="<?php echo $p_po->description_07->displayValueSeparatorAttribute() ?>" name="x_description_07[]" id="x_description_07[]" value="{value}"<?php echo $p_po->description_07->editAttributes() ?>></div>
<div id="dsl_x_description_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_07->checkBoxListHtml(FALSE, "x_description_07[]", 1) ?>
</div></div>
<?php echo $p_po->description_07->Lookup->getParamTag("p_x_description_07") ?>
</span>
<?php echo $p_po->description_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label id="elh_p_po_description_10" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_10->caption() ?><?php echo ($p_po->description_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_10->cellAttributes() ?>>
<span id="el_p_po_description_10">
<div id="tp_x_description_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_10" data-page="1" data-value-separator="<?php echo $p_po->description_10->displayValueSeparatorAttribute() ?>" name="x_description_10[]" id="x_description_10[]" value="{value}"<?php echo $p_po->description_10->editAttributes() ?>></div>
<div id="dsl_x_description_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_10->checkBoxListHtml(FALSE, "x_description_10[]", 1) ?>
</div></div>
<?php echo $p_po->description_10->Lookup->getParamTag("p_x_description_10") ?>
</span>
<?php echo $p_po->description_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label id="elh_p_po_description_04" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_04->caption() ?><?php echo ($p_po->description_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_04->cellAttributes() ?>>
<span id="el_p_po_description_04">
<div id="tp_x_description_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_04" data-page="1" data-value-separator="<?php echo $p_po->description_04->displayValueSeparatorAttribute() ?>" name="x_description_04[]" id="x_description_04[]" value="{value}"<?php echo $p_po->description_04->editAttributes() ?>></div>
<div id="dsl_x_description_04" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_04->checkBoxListHtml(FALSE, "x_description_04[]", 1) ?>
</div></div>
<?php echo $p_po->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
<?php echo $p_po->description_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label id="elh_p_po_description_06" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_06->caption() ?><?php echo ($p_po->description_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_06->cellAttributes() ?>>
<span id="el_p_po_description_06">
<div id="tp_x_description_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_06" data-page="1" data-value-separator="<?php echo $p_po->description_06->displayValueSeparatorAttribute() ?>" name="x_description_06[]" id="x_description_06[]" value="{value}"<?php echo $p_po->description_06->editAttributes() ?>></div>
<div id="dsl_x_description_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_06->checkBoxListHtml(FALSE, "x_description_06[]", 1) ?>
</div></div>
<?php echo $p_po->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
<?php echo $p_po->description_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label id="elh_p_po_description_05" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->description_05->caption() ?><?php echo ($p_po->description_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->description_05->cellAttributes() ?>>
<span id="el_p_po_description_05">
<div id="tp_x_description_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_05" data-page="1" data-value-separator="<?php echo $p_po->description_05->displayValueSeparatorAttribute() ?>" name="x_description_05[]" id="x_description_05[]" value="{value}"<?php echo $p_po->description_05->editAttributes() ?>></div>
<div id="dsl_x_description_05" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_05->checkBoxListHtml(FALSE, "x_description_05[]", 1) ?>
</div></div>
<?php echo $p_po->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
<?php echo $p_po->description_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_p_po_amount" for="x_amount" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->amount->caption() ?><?php echo ($p_po->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->amount->cellAttributes() ?>>
<span id="el_p_po_amount">
<input type="text" data-table="p_po" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($p_po->amount->getPlaceHolder()) ?>" value="<?php echo $p_po->amount->EditValue ?>"<?php echo $p_po->amount->editAttributes() ?>>
</span>
<?php echo $p_po->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label id="elh_p_po_gst" for="x_gst" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->gst->caption() ?><?php echo ($p_po->gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->gst->cellAttributes() ?>>
<span id="el_p_po_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_po" data-field="x_gst" data-page="1" data-value-separator="<?php echo $p_po->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $p_po->gst->editAttributes() ?>>
		<?php echo $p_po->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $p_po->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
<?php echo $p_po->gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_p_po_buyer_instruction" for="x_buyer_instruction" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->buyer_instruction->caption() ?><?php echo ($p_po->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->buyer_instruction->cellAttributes() ?>>
<span id="el_p_po_buyer_instruction">
<textarea data-table="p_po" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($p_po->buyer_instruction->getPlaceHolder()) ?>"<?php echo $p_po->buyer_instruction->editAttributes() ?>><?php echo $p_po->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $p_po->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_p_po_remarks" for="x_remarks" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->remarks->caption() ?><?php echo ($p_po->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->remarks->cellAttributes() ?>>
<span id="el_p_po_remarks">
<textarea data-table="p_po" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($p_po->remarks->getPlaceHolder()) ?>"<?php echo $p_po->remarks->editAttributes() ?>><?php echo $p_po->remarks->EditValue ?></textarea>
</span>
<?php echo $p_po->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_po->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_p_po_despatch_date" for="x_despatch_date" class="<?php echo $p_po_add->LeftColumnClass ?>"><?php echo $p_po->despatch_date->caption() ?><?php echo ($p_po->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_po_add->RightColumnClass ?>"><div<?php echo $p_po->despatch_date->cellAttributes() ?>>
<span id="el_p_po_despatch_date">
<input type="text" data-table="p_po" data-field="x_despatch_date" data-page="1" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($p_po->despatch_date->getPlaceHolder()) ?>" value="<?php echo $p_po->despatch_date->EditValue ?>"<?php echo $p_po->despatch_date->editAttributes() ?>>
<?php if (!$p_po->despatch_date->ReadOnly && !$p_po->despatch_date->Disabled && !isset($p_po->despatch_date->EditAttrs["readonly"]) && !isset($p_po->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_poadd", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $p_po->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$p_po_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_po_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $p_po_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_po_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#dsl_x_description_01").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_01" title="" data-title="Paper" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=101,102,112&O=\'});" data-original-title="Add Paper"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_02").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_02" title="" data-title="Plate/Master" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=115&O=\'});" data-original-title="Add Plate/Master"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_03").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_03" title="" data-title="Printing" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=116&O=\'});" data-original-title="Add Printing"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_04").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_04" title="" data-title="Binding" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=114&O=\'});" data-original-title="Add Binding"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_05").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_05" title="" data-title="Other" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=101,102,112,114,115,116&O=NOT\'});" data-original-title="Add Other Work"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_06").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_06" title="" data-title="Design Work" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=100&O=\'});" data-original-title="Add Design Work"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_07").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_07" title="" data-title="Lamination Work" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=123&O=\'});" data-original-title="Add Lamination Work / Die Cutting / Creasing"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_08").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_08" title="" data-title="Paper Cutting" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=125&O=\'});" data-original-title="Add Paper Cutting"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_09").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_09" title="" data-title="Plate Cleaning" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=126&O=\'});" data-original-title="Add Plate Cleaning"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_description_10").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_10" title="" data-title=" Die Cutting / Crease" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'p_cartadd.php?P=124&O=\'});" data-original-title="Add Die Cutting / Crease"><i class="fa fa-plus ew-icon"></i></button></div>');
</script>
<?php include_once "footer.php" ?>
<?php
$p_po_add->terminate();
?>