<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_po_list = new p_po_list();

// Run the page
$p_po_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_po_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$p_po->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fp_polist = currentForm = new ew.Form("fp_polist", "list");
fp_polist.formKeyCountName = '<?php echo $p_po_list->FormKeyCountName ?>';

// Form_CustomValidate event
fp_polist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_polist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_polist.lists["x_type"] = <?php echo $p_po_list->type->Lookup->toClientList() ?>;
fp_polist.lists["x_type"].options = <?php echo JsonEncode($p_po_list->type->options(FALSE, TRUE)) ?>;
fp_polist.lists["x_job_category"] = <?php echo $p_po_list->job_category->Lookup->toClientList() ?>;
fp_polist.lists["x_job_category"].options = <?php echo JsonEncode($p_po_list->job_category->options(FALSE, TRUE)) ?>;
fp_polist.lists["x_company_id"] = <?php echo $p_po_list->company_id->Lookup->toClientList() ?>;
fp_polist.lists["x_company_id"].options = <?php echo JsonEncode($p_po_list->company_id->lookupOptions()) ?>;
fp_polist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_polist.lists["x_gst"] = <?php echo $p_po_list->gst->Lookup->toClientList() ?>;
fp_polist.lists["x_gst"].options = <?php echo JsonEncode($p_po_list->gst->lookupOptions()) ?>;
fp_polist.lists["x_operator"] = <?php echo $p_po_list->operator->Lookup->toClientList() ?>;
fp_polist.lists["x_operator"].options = <?php echo JsonEncode($p_po_list->operator->lookupOptions()) ?>;
fp_polist.lists["x_c_operator"] = <?php echo $p_po_list->c_operator->Lookup->toClientList() ?>;
fp_polist.lists["x_c_operator"].options = <?php echo JsonEncode($p_po_list->c_operator->lookupOptions()) ?>;

// Form object for search
var fp_polistsrch = currentSearchForm = new ew.Form("fp_polistsrch");

// Validate function for search
fp_polistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_po->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_po->company_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fp_polistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_polistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_polistsrch.lists["x_type"] = <?php echo $p_po_list->type->Lookup->toClientList() ?>;
fp_polistsrch.lists["x_type"].options = <?php echo JsonEncode($p_po_list->type->options(FALSE, TRUE)) ?>;
fp_polistsrch.lists["x_company_id"] = <?php echo $p_po_list->company_id->Lookup->toClientList() ?>;
fp_polistsrch.lists["x_company_id"].options = <?php echo JsonEncode($p_po_list->company_id->lookupOptions()) ?>;
fp_polistsrch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fp_polistsrch.filterList = <?php echo $p_po_list->getFilterList() ?>;

// Init search panel as collapsed
fp_polistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var PrintOrder = function(CID, PID){
	  var CAID =[];
	  $("#tbl_p_polist tbody input[type='checkbox']:checked").each(function(){
	  		 CAID.push($(this).val());	  		 
	  });
	  if(CAID.length>0)
	  {
	  	location.href='autoprogramme.php?apcid=053126ddfffc6ab775ef39662e12cf52&action=UHJpbnQ&id='+ CAID.toString();
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
</script>
<?php } ?>
<?php if (!$p_po->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($p_po_list->TotalRecs > 0 && $p_po_list->ExportOptions->visible()) { ?>
<?php $p_po_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($p_po_list->ImportOptions->visible()) { ?>
<?php $p_po_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($p_po_list->SearchOptions->visible()) { ?>
<?php $p_po_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($p_po_list->FilterOptions->visible()) { ?>
<?php $p_po_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$p_po_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$p_po->isExport() && !$p_po->CurrentAction) { ?>
<form name="fp_polistsrch" id="fp_polistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($p_po_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fp_polistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="p_po">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$p_po_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$p_po->RowType = ROWTYPE_SEARCH;

// Render row
$p_po->resetAttributes();
$p_po_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($p_po->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $p_po->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="p_po" data-field="x_po" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($p_po->po->getPlaceHolder()) ?>" value="<?php echo $p_po->po->EditValue ?>"<?php echo $p_po->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($p_po->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $p_po->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_po" data-field="x_type" data-value-separator="<?php echo $p_po->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $p_po->type->editAttributes() ?>>
		<?php echo $p_po->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($p_po->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $p_po->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$p_po->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_po->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($p_po->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_po->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_po->company_id->getPlaceHolder()) ?>"<?php echo $p_po->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_po->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_po->company_id->ReadOnly || $p_po->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_po" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_po->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($p_po->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_polistsrch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $p_po->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($p_po_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($p_po_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $p_po_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($p_po_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($p_po_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($p_po_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($p_po_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $p_po_list->showPageHeader(); ?>
<?php
$p_po_list->showMessage();
?>
<?php if ($p_po_list->TotalRecs > 0 || $p_po->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($p_po_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> p_po">
<?php if (!$p_po->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$p_po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_po_list->Pager)) $p_po_list->Pager = new PrevNextPager($p_po_list->StartRec, $p_po_list->DisplayRecs, $p_po_list->TotalRecs, $p_po_list->AutoHidePager) ?>
<?php if ($p_po_list->Pager->RecordCount > 0 && $p_po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_po_list->TotalRecs > 0 && (!$p_po_list->AutoHidePageSizeSelector || $p_po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fp_polist" id="fp_polist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_po_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_po_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_po">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_p_po" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($p_po_list->TotalRecs > 0 || $p_po->isGridEdit()) { ?>
<table id="tbl_p_polist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$p_po_list->RowType = ROWTYPE_HEADER;

// Render list options
$p_po_list->renderListOptions();

// Render list options (header, left)
$p_po_list->ListOptions->render("header", "left");
?>
<?php if ($p_po->id->Visible) { // id ?>
	<?php if ($p_po->sortUrl($p_po->id) == "") { ?>
		<th data-name="id" class="<?php echo $p_po->id->headerCellClass() ?>"><div id="elh_p_po_id" class="p_po_id"><div class="ew-table-header-caption"><?php echo $p_po->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $p_po->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->id) ?>',2);"><div id="elh_p_po_id" class="p_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->po->Visible) { // po ?>
	<?php if ($p_po->sortUrl($p_po->po) == "") { ?>
		<th data-name="po" class="<?php echo $p_po->po->headerCellClass() ?>"><div id="elh_p_po_po" class="p_po_po"><div class="ew-table-header-caption"><?php echo $p_po->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $p_po->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->po) ?>',2);"><div id="elh_p_po_po" class="p_po_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->type->Visible) { // type ?>
	<?php if ($p_po->sortUrl($p_po->type) == "") { ?>
		<th data-name="type" class="<?php echo $p_po->type->headerCellClass() ?>"><div id="elh_p_po_type" class="p_po_type"><div class="ew-table-header-caption"><?php echo $p_po->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $p_po->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->type) ?>',2);"><div id="elh_p_po_type" class="p_po_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_po->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->job_category->Visible) { // job_category ?>
	<?php if ($p_po->sortUrl($p_po->job_category) == "") { ?>
		<th data-name="job_category" class="<?php echo $p_po->job_category->headerCellClass() ?>"><div id="elh_p_po_job_category" class="p_po_job_category"><div class="ew-table-header-caption"><?php echo $p_po->job_category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="job_category" class="<?php echo $p_po->job_category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->job_category) ?>',2);"><div id="elh_p_po_job_category" class="p_po_job_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->job_category->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_po->job_category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->job_category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->company_id->Visible) { // company_id ?>
	<?php if ($p_po->sortUrl($p_po->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $p_po->company_id->headerCellClass() ?>"><div id="elh_p_po_company_id" class="p_po_company_id"><div class="ew-table-header-caption"><?php echo $p_po->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $p_po->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->company_id) ?>',2);"><div id="elh_p_po_company_id" class="p_po_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->company_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->item->Visible) { // item ?>
	<?php if ($p_po->sortUrl($p_po->item) == "") { ?>
		<th data-name="item" class="<?php echo $p_po->item->headerCellClass() ?>"><div id="elh_p_po_item" class="p_po_item"><div class="ew-table-header-caption"><?php echo $p_po->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $p_po->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->item) ?>',2);"><div id="elh_p_po_item" class="p_po_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->quantity->Visible) { // quantity ?>
	<?php if ($p_po->sortUrl($p_po->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $p_po->quantity->headerCellClass() ?>"><div id="elh_p_po_quantity" class="p_po_quantity"><div class="ew-table-header-caption"><?php echo $p_po->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $p_po->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->quantity) ?>',2);"><div id="elh_p_po_quantity" class="p_po_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->item_size->Visible) { // item_size ?>
	<?php if ($p_po->sortUrl($p_po->item_size) == "") { ?>
		<th data-name="item_size" class="<?php echo $p_po->item_size->headerCellClass() ?>"><div id="elh_p_po_item_size" class="p_po_item_size"><div class="ew-table-header-caption"><?php echo $p_po->item_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item_size" class="<?php echo $p_po->item_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->item_size) ?>',2);"><div id="elh_p_po_item_size" class="p_po_item_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->item_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->item_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->item_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->amount->Visible) { // amount ?>
	<?php if ($p_po->sortUrl($p_po->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $p_po->amount->headerCellClass() ?>"><div id="elh_p_po_amount" class="p_po_amount"><div class="ew-table-header-caption"><?php echo $p_po->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $p_po->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->amount) ?>',2);"><div id="elh_p_po_amount" class="p_po_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->gst->Visible) { // gst ?>
	<?php if ($p_po->sortUrl($p_po->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $p_po->gst->headerCellClass() ?>"><div id="elh_p_po_gst" class="p_po_gst"><div class="ew-table-header-caption"><?php echo $p_po->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $p_po->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->gst) ?>',2);"><div id="elh_p_po_gst" class="p_po_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_po->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->despatch_date->Visible) { // despatch_date ?>
	<?php if ($p_po->sortUrl($p_po->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $p_po->despatch_date->headerCellClass() ?>"><div id="elh_p_po_despatch_date" class="p_po_despatch_date"><div class="ew-table-header-caption"><?php echo $p_po->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $p_po->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->despatch_date) ?>',2);"><div id="elh_p_po_despatch_date" class="p_po_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->operator->Visible) { // operator ?>
	<?php if ($p_po->sortUrl($p_po->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $p_po->operator->headerCellClass() ?>"><div id="elh_p_po_operator" class="p_po_operator"><div class="ew-table-header-caption"><?php echo $p_po->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $p_po->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->operator) ?>',2);"><div id="elh_p_po_operator" class="p_po_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_po->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->datetime->Visible) { // datetime ?>
	<?php if ($p_po->sortUrl($p_po->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $p_po->datetime->headerCellClass() ?>"><div id="elh_p_po_datetime" class="p_po_datetime"><div class="ew-table-header-caption"><?php echo $p_po->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $p_po->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->datetime) ?>',2);"><div id="elh_p_po_datetime" class="p_po_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_po->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->c_operator->Visible) { // c_operator ?>
	<?php if ($p_po->sortUrl($p_po->c_operator) == "") { ?>
		<th data-name="c_operator" class="<?php echo $p_po->c_operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_p_po_c_operator" class="p_po_c_operator"><div class="ew-table-header-caption"><?php echo $p_po->c_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_operator" class="<?php echo $p_po->c_operator->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->c_operator) ?>',2);"><div id="elh_p_po_c_operator" class="p_po_c_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->c_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_po->c_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->c_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_po->c_datetime->Visible) { // c_datetime ?>
	<?php if ($p_po->sortUrl($p_po->c_datetime) == "") { ?>
		<th data-name="c_datetime" class="<?php echo $p_po->c_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_p_po_c_datetime" class="p_po_c_datetime"><div class="ew-table-header-caption"><?php echo $p_po->c_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_datetime" class="<?php echo $p_po->c_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_po->SortUrl($p_po->c_datetime) ?>',2);"><div id="elh_p_po_c_datetime" class="p_po_c_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_po->c_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_po->c_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_po->c_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$p_po_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($p_po->ExportAll && $p_po->isExport()) {
	$p_po_list->StopRec = $p_po_list->TotalRecs;
} else {

	// Set the last record to display
	if ($p_po_list->TotalRecs > $p_po_list->StartRec + $p_po_list->DisplayRecs - 1)
		$p_po_list->StopRec = $p_po_list->StartRec + $p_po_list->DisplayRecs - 1;
	else
		$p_po_list->StopRec = $p_po_list->TotalRecs;
}
$p_po_list->RecCnt = $p_po_list->StartRec - 1;
if ($p_po_list->Recordset && !$p_po_list->Recordset->EOF) {
	$p_po_list->Recordset->moveFirst();
	$selectLimit = $p_po_list->UseSelectLimit;
	if (!$selectLimit && $p_po_list->StartRec > 1)
		$p_po_list->Recordset->move($p_po_list->StartRec - 1);
} elseif (!$p_po->AllowAddDeleteRow && $p_po_list->StopRec == 0) {
	$p_po_list->StopRec = $p_po->GridAddRowCount;
}

// Initialize aggregate
$p_po->RowType = ROWTYPE_AGGREGATEINIT;
$p_po->resetAttributes();
$p_po_list->renderRow();
while ($p_po_list->RecCnt < $p_po_list->StopRec) {
	$p_po_list->RecCnt++;
	if ($p_po_list->RecCnt >= $p_po_list->StartRec) {
		$p_po_list->RowCnt++;

		// Set up key count
		$p_po_list->KeyCount = $p_po_list->RowIndex;

		// Init row class and style
		$p_po->resetAttributes();
		$p_po->CssClass = "";
		if ($p_po->isGridAdd()) {
		} else {
			$p_po_list->loadRowValues($p_po_list->Recordset); // Load row values
		}
		$p_po->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$p_po->RowAttrs = array_merge($p_po->RowAttrs, array('data-rowindex'=>$p_po_list->RowCnt, 'id'=>'r' . $p_po_list->RowCnt . '_p_po', 'data-rowtype'=>$p_po->RowType));

		// Render row
		$p_po_list->renderRow();

		// Render list options
		$p_po_list->renderListOptions();
?>
	<tr<?php echo $p_po->rowAttributes() ?>>
<?php

// Render list options (body, left)
$p_po_list->ListOptions->render("body", "left", $p_po_list->RowCnt);
?>
	<?php if ($p_po->id->Visible) { // id ?>
		<td data-name="id"<?php echo $p_po->id->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_id" class="p_po_id">
<span<?php echo $p_po->id->viewAttributes() ?>>
<?php echo $p_po->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->po->Visible) { // po ?>
		<td data-name="po"<?php echo $p_po->po->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_po" class="p_po_po">
<span<?php echo $p_po->po->viewAttributes() ?>>
<?php if ((!EmptyString($p_po->po->getViewValue())) && $p_po->po->linkAttributes() <> "") { ?>
<a<?php echo $p_po->po->linkAttributes() ?>><?php echo $p_po->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $p_po->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->type->Visible) { // type ?>
		<td data-name="type"<?php echo $p_po->type->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_type" class="p_po_type">
<span<?php echo $p_po->type->viewAttributes() ?>>
<?php echo $p_po->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->job_category->Visible) { // job_category ?>
		<td data-name="job_category"<?php echo $p_po->job_category->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_job_category" class="p_po_job_category">
<span<?php echo $p_po->job_category->viewAttributes() ?>>
<?php echo $p_po->job_category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $p_po->company_id->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_company_id" class="p_po_company_id">
<span<?php echo $p_po->company_id->viewAttributes() ?>>
<?php echo $p_po->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->item->Visible) { // item ?>
		<td data-name="item"<?php echo $p_po->item->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_item" class="p_po_item">
<span<?php echo $p_po->item->viewAttributes() ?>>
<?php echo $p_po->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $p_po->quantity->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_quantity" class="p_po_quantity">
<span<?php echo $p_po->quantity->viewAttributes() ?>>
<?php echo $p_po->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->item_size->Visible) { // item_size ?>
		<td data-name="item_size"<?php echo $p_po->item_size->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_item_size" class="p_po_item_size">
<span<?php echo $p_po->item_size->viewAttributes() ?>>
<?php echo $p_po->item_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $p_po->amount->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_amount" class="p_po_amount">
<span<?php echo $p_po->amount->viewAttributes() ?>>
<?php echo $p_po->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $p_po->gst->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_gst" class="p_po_gst">
<span<?php echo $p_po->gst->viewAttributes() ?>>
<?php echo $p_po->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $p_po->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_despatch_date" class="p_po_despatch_date">
<span<?php echo $p_po->despatch_date->viewAttributes() ?>>
<?php echo $p_po->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $p_po->operator->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_operator" class="p_po_operator">
<span<?php echo $p_po->operator->viewAttributes() ?>>
<?php echo $p_po->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $p_po->datetime->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_datetime" class="p_po_datetime">
<span<?php echo $p_po->datetime->viewAttributes() ?>>
<?php echo $p_po->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->c_operator->Visible) { // c_operator ?>
		<td data-name="c_operator"<?php echo $p_po->c_operator->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_c_operator" class="p_po_c_operator">
<span<?php echo $p_po->c_operator->viewAttributes() ?>>
<?php echo $p_po->c_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_po->c_datetime->Visible) { // c_datetime ?>
		<td data-name="c_datetime"<?php echo $p_po->c_datetime->cellAttributes() ?>>
<span id="el<?php echo $p_po_list->RowCnt ?>_p_po_c_datetime" class="p_po_c_datetime">
<span<?php echo $p_po->c_datetime->viewAttributes() ?>>
<?php echo $p_po->c_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$p_po_list->ListOptions->render("body", "right", $p_po_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$p_po->isGridAdd())
		$p_po_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$p_po->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($p_po_list->Recordset)
	$p_po_list->Recordset->Close();
?>
<?php if (!$p_po->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$p_po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_po_list->Pager)) $p_po_list->Pager = new PrevNextPager($p_po_list->StartRec, $p_po_list->DisplayRecs, $p_po_list->TotalRecs, $p_po_list->AutoHidePager) ?>
<?php if ($p_po_list->Pager->RecordCount > 0 && $p_po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_po_list->pageUrl() ?>start=<?php echo $p_po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_po_list->TotalRecs > 0 && (!$p_po_list->AutoHidePageSizeSelector || $p_po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_po_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($p_po_list->TotalRecs == 0 && !$p_po->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $p_po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$p_po_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$p_po->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$p_po->isExport()) { ?>
<script>
ew.scrollableTable("gmp_p_po", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$p_po_list->terminate();
?>