<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_po_search = new p_po_search();

// Run the page
$p_po_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_po_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($p_po_search->IsModal) { ?>
var fp_posearch = currentAdvancedSearchForm = new ew.Form("fp_posearch", "search");
<?php } else { ?>
var fp_posearch = currentForm = new ew.Form("fp_posearch", "search");
<?php } ?>

// Form_CustomValidate event
fp_posearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_posearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fp_posearch.multiPage = new ew.MultiPage("fp_posearch");

// Dynamic selection lists
fp_posearch.lists["x_type"] = <?php echo $p_po_search->type->Lookup->toClientList() ?>;
fp_posearch.lists["x_type"].options = <?php echo JsonEncode($p_po_search->type->options(FALSE, TRUE)) ?>;
fp_posearch.lists["x_job_category"] = <?php echo $p_po_search->job_category->Lookup->toClientList() ?>;
fp_posearch.lists["x_job_category"].options = <?php echo JsonEncode($p_po_search->job_category->options(FALSE, TRUE)) ?>;
fp_posearch.lists["x_company_id"] = <?php echo $p_po_search->company_id->Lookup->toClientList() ?>;
fp_posearch.lists["x_company_id"].options = <?php echo JsonEncode($p_po_search->company_id->lookupOptions()) ?>;
fp_posearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fp_posearch.lists["x_description_03[]"] = <?php echo $p_po_search->description_03->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_03[]"].options = <?php echo JsonEncode($p_po_search->description_03->lookupOptions()) ?>;
fp_posearch.lists["x_description_02[]"] = <?php echo $p_po_search->description_02->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_02[]"].options = <?php echo JsonEncode($p_po_search->description_02->lookupOptions()) ?>;
fp_posearch.lists["x_description_09[]"] = <?php echo $p_po_search->description_09->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_09[]"].options = <?php echo JsonEncode($p_po_search->description_09->lookupOptions()) ?>;
fp_posearch.lists["x_description_01[]"] = <?php echo $p_po_search->description_01->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_01[]"].options = <?php echo JsonEncode($p_po_search->description_01->lookupOptions()) ?>;
fp_posearch.lists["x_description_08[]"] = <?php echo $p_po_search->description_08->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_08[]"].options = <?php echo JsonEncode($p_po_search->description_08->lookupOptions()) ?>;
fp_posearch.lists["x_description_07[]"] = <?php echo $p_po_search->description_07->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_07[]"].options = <?php echo JsonEncode($p_po_search->description_07->lookupOptions()) ?>;
fp_posearch.lists["x_description_10[]"] = <?php echo $p_po_search->description_10->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_10[]"].options = <?php echo JsonEncode($p_po_search->description_10->lookupOptions()) ?>;
fp_posearch.lists["x_description_04[]"] = <?php echo $p_po_search->description_04->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_04[]"].options = <?php echo JsonEncode($p_po_search->description_04->lookupOptions()) ?>;
fp_posearch.lists["x_description_06[]"] = <?php echo $p_po_search->description_06->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_06[]"].options = <?php echo JsonEncode($p_po_search->description_06->lookupOptions()) ?>;
fp_posearch.lists["x_description_05[]"] = <?php echo $p_po_search->description_05->Lookup->toClientList() ?>;
fp_posearch.lists["x_description_05[]"].options = <?php echo JsonEncode($p_po_search->description_05->lookupOptions()) ?>;
fp_posearch.lists["x_gst"] = <?php echo $p_po_search->gst->Lookup->toClientList() ?>;
fp_posearch.lists["x_gst"].options = <?php echo JsonEncode($p_po_search->gst->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fp_posearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_po->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_po->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_po->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_po->despatch_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_po_search->showPageHeader(); ?>
<?php
$p_po_search->showMessage();
?>
<form name="fp_posearch" id="fp_posearch" class="<?php echo $p_po_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_po_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_po_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_po">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$p_po_search->IsModal ?>">
<?php if ($p_po_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($p_po->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_id"><?php echo $p_po->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->id->cellAttributes() ?>>
			<span id="el_p_po_id">
<input type="text" data-table="p_po" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($p_po->id->getPlaceHolder()) ?>" value="<?php echo $p_po->id->EditValue ?>"<?php echo $p_po->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_po"><?php echo $p_po->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->po->cellAttributes() ?>>
			<span id="el_p_po_po">
<input type="text" data-table="p_po" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($p_po->po->getPlaceHolder()) ?>" value="<?php echo $p_po->po->EditValue ?>"<?php echo $p_po->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_type"><?php echo $p_po->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->type->cellAttributes() ?>>
			<span id="el_p_po_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_po" data-field="x_type" data-page="0" data-value-separator="<?php echo $p_po->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $p_po->type->editAttributes() ?>>
		<?php echo $p_po->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->job_category->Visible) { // job_category ?>
	<div id="r_job_category" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_job_category"><?php echo $p_po->job_category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_job_category" id="z_job_category" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->job_category->cellAttributes() ?>>
			<span id="el_p_po_job_category">
<div id="tp_x_job_category" class="ew-template"><input type="radio" class="form-check-input" data-table="p_po" data-field="x_job_category" data-page="0" data-value-separator="<?php echo $p_po->job_category->displayValueSeparatorAttribute() ?>" name="x_job_category" id="x_job_category" value="{value}"<?php echo $p_po->job_category->editAttributes() ?>></div>
<div id="dsl_x_job_category" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->job_category->radioButtonListHtml(FALSE, "x_job_category", 0) ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_company_id"><?php echo $p_po->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->company_id->cellAttributes() ?>>
			<span id="el_p_po_company_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$p_po->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$p_po->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($p_po->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($p_po->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($p_po->company_id->getPlaceHolder()) ?>"<?php echo $p_po->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($p_po->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($p_po->company_id->ReadOnly || $p_po->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="p_po" data-field="x_company_id" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $p_po->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($p_po->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fp_posearch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $p_po->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_quantity"><?php echo $p_po->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->quantity->cellAttributes() ?>>
			<span id="el_p_po_quantity">
<input type="text" data-table="p_po" data-field="x_quantity" data-page="0" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($p_po->quantity->getPlaceHolder()) ?>" value="<?php echo $p_po->quantity->EditValue ?>"<?php echo $p_po->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->item_size->Visible) { // item_size ?>
	<div id="r_item_size" class="form-group row">
		<label for="x_item_size" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_item_size"><?php echo $p_po->item_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item_size" id="z_item_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->item_size->cellAttributes() ?>>
			<span id="el_p_po_item_size">
<input type="text" data-table="p_po" data-field="x_item_size" data-page="0" name="x_item_size" id="x_item_size" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($p_po->item_size->getPlaceHolder()) ?>" value="<?php echo $p_po->item_size->EditValue ?>"<?php echo $p_po->item_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="p_po_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $p_po_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($p_po_search->MultiPages->isActive("1")) ?>" href="#tab_p_po1"><?php echo $p_po->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $p_po_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $p_po_search->MultiPages->Parent ?>" id="tab_p_po1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($p_po->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_03"><?php echo $p_po->description_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_03" id="z_description_03" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_03->cellAttributes() ?>>
			<span id="el_p_po_description_03">
<div id="tp_x_description_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_03" data-page="1" data-value-separator="<?php echo $p_po->description_03->displayValueSeparatorAttribute() ?>" name="x_description_03[]" id="x_description_03[]" value="{value}"<?php echo $p_po->description_03->editAttributes() ?>></div>
<div id="dsl_x_description_03" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_03->checkBoxListHtml(FALSE, "x_description_03[]", 1) ?>
</div></div>
<?php echo $p_po->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_02"><?php echo $p_po->description_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_02" id="z_description_02" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_02->cellAttributes() ?>>
			<span id="el_p_po_description_02">
<div id="tp_x_description_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_02" data-page="1" data-value-separator="<?php echo $p_po->description_02->displayValueSeparatorAttribute() ?>" name="x_description_02[]" id="x_description_02[]" value="{value}"<?php echo $p_po->description_02->editAttributes() ?>></div>
<div id="dsl_x_description_02" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_02->checkBoxListHtml(FALSE, "x_description_02[]", 1) ?>
</div></div>
<?php echo $p_po->description_02->Lookup->getParamTag("p_x_description_02") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_09"><?php echo $p_po->description_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_09" id="z_description_09" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_09->cellAttributes() ?>>
			<span id="el_p_po_description_09">
<div id="tp_x_description_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_09" data-page="1" data-value-separator="<?php echo $p_po->description_09->displayValueSeparatorAttribute() ?>" name="x_description_09[]" id="x_description_09[]" value="{value}"<?php echo $p_po->description_09->editAttributes() ?>></div>
<div id="dsl_x_description_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_09->checkBoxListHtml(FALSE, "x_description_09[]", 1) ?>
</div></div>
<?php echo $p_po->description_09->Lookup->getParamTag("p_x_description_09") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_01"><?php echo $p_po->description_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_01" id="z_description_01" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_01->cellAttributes() ?>>
			<span id="el_p_po_description_01">
<div id="tp_x_description_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_01" data-page="1" data-value-separator="<?php echo $p_po->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01[]" id="x_description_01[]" value="{value}"<?php echo $p_po->description_01->editAttributes() ?>></div>
<div id="dsl_x_description_01" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_01->checkBoxListHtml(FALSE, "x_description_01[]", 1) ?>
</div></div>
<?php echo $p_po->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_08"><?php echo $p_po->description_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_08" id="z_description_08" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_08->cellAttributes() ?>>
			<span id="el_p_po_description_08">
<div id="tp_x_description_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_08" data-page="1" data-value-separator="<?php echo $p_po->description_08->displayValueSeparatorAttribute() ?>" name="x_description_08[]" id="x_description_08[]" value="{value}"<?php echo $p_po->description_08->editAttributes() ?>></div>
<div id="dsl_x_description_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_08->checkBoxListHtml(FALSE, "x_description_08[]", 1) ?>
</div></div>
<?php echo $p_po->description_08->Lookup->getParamTag("p_x_description_08") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_07"><?php echo $p_po->description_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_07" id="z_description_07" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_07->cellAttributes() ?>>
			<span id="el_p_po_description_07">
<div id="tp_x_description_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_07" data-page="1" data-value-separator="<?php echo $p_po->description_07->displayValueSeparatorAttribute() ?>" name="x_description_07[]" id="x_description_07[]" value="{value}"<?php echo $p_po->description_07->editAttributes() ?>></div>
<div id="dsl_x_description_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_07->checkBoxListHtml(FALSE, "x_description_07[]", 1) ?>
</div></div>
<?php echo $p_po->description_07->Lookup->getParamTag("p_x_description_07") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_10"><?php echo $p_po->description_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_10" id="z_description_10" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_10->cellAttributes() ?>>
			<span id="el_p_po_description_10">
<div id="tp_x_description_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_10" data-page="1" data-value-separator="<?php echo $p_po->description_10->displayValueSeparatorAttribute() ?>" name="x_description_10[]" id="x_description_10[]" value="{value}"<?php echo $p_po->description_10->editAttributes() ?>></div>
<div id="dsl_x_description_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_10->checkBoxListHtml(FALSE, "x_description_10[]", 1) ?>
</div></div>
<?php echo $p_po->description_10->Lookup->getParamTag("p_x_description_10") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_04"><?php echo $p_po->description_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_04" id="z_description_04" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_04->cellAttributes() ?>>
			<span id="el_p_po_description_04">
<div id="tp_x_description_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_04" data-page="1" data-value-separator="<?php echo $p_po->description_04->displayValueSeparatorAttribute() ?>" name="x_description_04[]" id="x_description_04[]" value="{value}"<?php echo $p_po->description_04->editAttributes() ?>></div>
<div id="dsl_x_description_04" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_04->checkBoxListHtml(FALSE, "x_description_04[]", 1) ?>
</div></div>
<?php echo $p_po->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_06"><?php echo $p_po->description_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_06" id="z_description_06" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_06->cellAttributes() ?>>
			<span id="el_p_po_description_06">
<div id="tp_x_description_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_06" data-page="1" data-value-separator="<?php echo $p_po->description_06->displayValueSeparatorAttribute() ?>" name="x_description_06[]" id="x_description_06[]" value="{value}"<?php echo $p_po->description_06->editAttributes() ?>></div>
<div id="dsl_x_description_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $p_po->description_06->checkBoxListHtml(FALSE, "x_description_06[]", 1) ?>
</div></div>
<?php echo $p_po->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_description_05"><?php echo $p_po->description_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_05" id="z_description_05" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->description_05->cellAttributes() ?>>
			<span id="el_p_po_description_05">
<div id="tp_x_description_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_po" data-field="x_description_05" data-page="1" data-value-separator="<?php echo $p_po->description_05->displayValueSeparatorAttribute() ?>" name="x_description_05[]" id="x_description_05[]" value="{value}"<?php echo $p_po->description_05->editAttributes() ?>></div>
<div id="dsl_x_description_05" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_po->description_05->checkBoxListHtml(FALSE, "x_description_05[]", 1) ?>
</div></div>
<?php echo $p_po->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_amount"><?php echo $p_po->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->amount->cellAttributes() ?>>
			<span id="el_p_po_amount">
<input type="text" data-table="p_po" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($p_po->amount->getPlaceHolder()) ?>" value="<?php echo $p_po->amount->EditValue ?>"<?php echo $p_po->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_gst"><?php echo $p_po->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst" id="z_gst" value="="></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->gst->cellAttributes() ?>>
			<span id="el_p_po_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_po" data-field="x_gst" data-page="1" data-value-separator="<?php echo $p_po->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $p_po->gst->editAttributes() ?>>
		<?php echo $p_po->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $p_po->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_buyer_instruction"><?php echo $p_po->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->buyer_instruction->cellAttributes() ?>>
			<span id="el_p_po_buyer_instruction">
<input type="text" data-table="p_po" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($p_po->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $p_po->buyer_instruction->EditValue ?>"<?php echo $p_po->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_remarks"><?php echo $p_po->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->remarks->cellAttributes() ?>>
			<span id="el_p_po_remarks">
<input type="text" data-table="p_po" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($p_po->remarks->getPlaceHolder()) ?>" value="<?php echo $p_po->remarks->EditValue ?>"<?php echo $p_po->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_po->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $p_po_search->LeftColumnClass ?>"><span id="elh_p_po_despatch_date"><?php echo $p_po->despatch_date->caption() ?></span>
		</label>
		<div class="<?php echo $p_po_search->RightColumnClass ?>"><div<?php echo $p_po->despatch_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_despatch_date" id="z_despatch_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($p_po->despatch_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_p_po_despatch_date">
<input type="text" data-table="p_po" data-field="x_despatch_date" data-page="1" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($p_po->despatch_date->getPlaceHolder()) ?>" value="<?php echo $p_po->despatch_date->EditValue ?>"<?php echo $p_po->despatch_date->editAttributes() ?>>
<?php if (!$p_po->despatch_date->ReadOnly && !$p_po->despatch_date->Disabled && !isset($p_po->despatch_date->EditAttrs["readonly"]) && !isset($p_po->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_posearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_despatch_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_p_po_despatch_date" class="btw1_despatch_date d-none">
<input type="text" data-table="p_po" data-field="x_despatch_date" data-page="1" name="y_despatch_date" id="y_despatch_date" placeholder="<?php echo HtmlEncode($p_po->despatch_date->getPlaceHolder()) ?>" value="<?php echo $p_po->despatch_date->EditValue2 ?>"<?php echo $p_po->despatch_date->editAttributes() ?>>
<?php if (!$p_po->despatch_date->ReadOnly && !$p_po->despatch_date->Disabled && !isset($p_po->despatch_date->EditAttrs["readonly"]) && !isset($p_po->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_posearch", "y_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$p_po_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_po_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_po_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_po_search->terminate();
?>