<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_size_list = new p_size_list();

// Run the page
$p_size_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_size_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$p_size->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fp_sizelist = currentForm = new ew.Form("fp_sizelist", "list");
fp_sizelist.formKeyCountName = '<?php echo $p_size_list->FormKeyCountName ?>';

// Form_CustomValidate event
fp_sizelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_sizelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_sizelist.lists["x_type"] = <?php echo $p_size_list->type->Lookup->toClientList() ?>;
fp_sizelist.lists["x_type"].options = <?php echo JsonEncode($p_size_list->type->options(FALSE, TRUE)) ?>;
fp_sizelist.lists["x_size"] = <?php echo $p_size_list->size->Lookup->toClientList() ?>;
fp_sizelist.lists["x_size"].options = <?php echo JsonEncode($p_size_list->size->lookupOptions()) ?>;
fp_sizelist.lists["x_rid[]"] = <?php echo $p_size_list->rid->Lookup->toClientList() ?>;
fp_sizelist.lists["x_rid[]"].options = <?php echo JsonEncode($p_size_list->rid->lookupOptions()) ?>;
fp_sizelist.lists["x_status"] = <?php echo $p_size_list->status->Lookup->toClientList() ?>;
fp_sizelist.lists["x_status"].options = <?php echo JsonEncode($p_size_list->status->options(FALSE, TRUE)) ?>;
fp_sizelist.lists["x_operator"] = <?php echo $p_size_list->operator->Lookup->toClientList() ?>;
fp_sizelist.lists["x_operator"].options = <?php echo JsonEncode($p_size_list->operator->lookupOptions()) ?>;

// Form object for search
var fp_sizelistsrch = currentSearchForm = new ew.Form("fp_sizelistsrch");

// Validate function for search
fp_sizelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fp_sizelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_sizelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_sizelistsrch.lists["x_type"] = <?php echo $p_size_list->type->Lookup->toClientList() ?>;
fp_sizelistsrch.lists["x_type"].options = <?php echo JsonEncode($p_size_list->type->options(FALSE, TRUE)) ?>;
fp_sizelistsrch.lists["x_status"] = <?php echo $p_size_list->status->Lookup->toClientList() ?>;
fp_sizelistsrch.lists["x_status"].options = <?php echo JsonEncode($p_size_list->status->options(FALSE, TRUE)) ?>;

// Filters
fp_sizelistsrch.filterList = <?php echo $p_size_list->getFilterList() ?>;

// Init search panel as collapsed
fp_sizelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$p_size->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($p_size_list->TotalRecs > 0 && $p_size_list->ExportOptions->visible()) { ?>
<?php $p_size_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($p_size_list->ImportOptions->visible()) { ?>
<?php $p_size_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($p_size_list->SearchOptions->visible()) { ?>
<?php $p_size_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($p_size_list->FilterOptions->visible()) { ?>
<?php $p_size_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$p_size_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$p_size->isExport() && !$p_size->CurrentAction) { ?>
<form name="fp_sizelistsrch" id="fp_sizelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($p_size_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fp_sizelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="p_size">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$p_size_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$p_size->RowType = ROWTYPE_SEARCH;

// Render row
$p_size->resetAttributes();
$p_size_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($p_size->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $p_size->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_size" data-field="x_type" data-value-separator="<?php echo $p_size->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $p_size->type->editAttributes() ?>>
		<?php echo $p_size->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($p_size->description->Visible) { // description ?>
	<div id="xsc_description" class="ew-cell form-group">
		<label for="x_description" class="ew-search-caption ew-label"><?php echo $p_size->description->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="p_size" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($p_size->description->getPlaceHolder()) ?>" value="<?php echo $p_size->description->EditValue ?>"<?php echo $p_size->description->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($p_size->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $p_size->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_size" data-field="x_status" data-value-separator="<?php echo $p_size->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $p_size->status->editAttributes() ?>>
		<?php echo $p_size->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($p_size_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($p_size_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $p_size_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($p_size_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($p_size_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($p_size_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($p_size_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $p_size_list->showPageHeader(); ?>
<?php
$p_size_list->showMessage();
?>
<?php if ($p_size_list->TotalRecs > 0 || $p_size->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($p_size_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> p_size">
<?php if (!$p_size->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$p_size->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_size_list->Pager)) $p_size_list->Pager = new PrevNextPager($p_size_list->StartRec, $p_size_list->DisplayRecs, $p_size_list->TotalRecs, $p_size_list->AutoHidePager) ?>
<?php if ($p_size_list->Pager->RecordCount > 0 && $p_size_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_size_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_size_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_size_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_size_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_size_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_size_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_size_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_size_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_size_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_size_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_size_list->TotalRecs > 0 && (!$p_size_list->AutoHidePageSizeSelector || $p_size_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_size">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_size_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_size_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_size_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_size_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_size_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_size->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_size_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fp_sizelist" id="fp_sizelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_size_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_size_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_size">
<div id="gmp_p_size" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($p_size_list->TotalRecs > 0 || $p_size->isGridEdit()) { ?>
<table id="tbl_p_sizelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$p_size_list->RowType = ROWTYPE_HEADER;

// Render list options
$p_size_list->renderListOptions();

// Render list options (header, left)
$p_size_list->ListOptions->render("header", "left");
?>
<?php if ($p_size->id->Visible) { // id ?>
	<?php if ($p_size->sortUrl($p_size->id) == "") { ?>
		<th data-name="id" class="<?php echo $p_size->id->headerCellClass() ?>"><div id="elh_p_size_id" class="p_size_id"><div class="ew-table-header-caption"><?php echo $p_size->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $p_size->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->id) ?>',2);"><div id="elh_p_size_id" class="p_size_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->type->Visible) { // type ?>
	<?php if ($p_size->sortUrl($p_size->type) == "") { ?>
		<th data-name="type" class="<?php echo $p_size->type->headerCellClass() ?>"><div id="elh_p_size_type" class="p_size_type"><div class="ew-table-header-caption"><?php echo $p_size->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $p_size->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->type) ?>',2);"><div id="elh_p_size_type" class="p_size_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->description->Visible) { // description ?>
	<?php if ($p_size->sortUrl($p_size->description) == "") { ?>
		<th data-name="description" class="<?php echo $p_size->description->headerCellClass() ?>"><div id="elh_p_size_description" class="p_size_description"><div class="ew-table-header-caption"><?php echo $p_size->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $p_size->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->description) ?>',2);"><div id="elh_p_size_description" class="p_size_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_size->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->size->Visible) { // size ?>
	<?php if ($p_size->sortUrl($p_size->size) == "") { ?>
		<th data-name="size" class="<?php echo $p_size->size->headerCellClass() ?>"><div id="elh_p_size_size" class="p_size_size"><div class="ew-table-header-caption"><?php echo $p_size->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $p_size->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->size) ?>',2);"><div id="elh_p_size_size" class="p_size_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->size->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->rid->Visible) { // rid ?>
	<?php if ($p_size->sortUrl($p_size->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $p_size->rid->headerCellClass() ?>"><div id="elh_p_size_rid" class="p_size_rid"><div class="ew-table-header-caption"><?php echo $p_size->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $p_size->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->rid) ?>',2);"><div id="elh_p_size_rid" class="p_size_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->qty_in_sheet->Visible) { // qty_in_sheet ?>
	<?php if ($p_size->sortUrl($p_size->qty_in_sheet) == "") { ?>
		<th data-name="qty_in_sheet" class="<?php echo $p_size->qty_in_sheet->headerCellClass() ?>"><div id="elh_p_size_qty_in_sheet" class="p_size_qty_in_sheet"><div class="ew-table-header-caption"><?php echo $p_size->qty_in_sheet->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty_in_sheet" class="<?php echo $p_size->qty_in_sheet->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->qty_in_sheet) ?>',2);"><div id="elh_p_size_qty_in_sheet" class="p_size_qty_in_sheet">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->qty_in_sheet->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->qty_in_sheet->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->qty_in_sheet->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->status->Visible) { // status ?>
	<?php if ($p_size->sortUrl($p_size->status) == "") { ?>
		<th data-name="status" class="<?php echo $p_size->status->headerCellClass() ?>"><div id="elh_p_size_status" class="p_size_status"><div class="ew-table-header-caption"><?php echo $p_size->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $p_size->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->status) ?>',2);"><div id="elh_p_size_status" class="p_size_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->operator->Visible) { // operator ?>
	<?php if ($p_size->sortUrl($p_size->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $p_size->operator->headerCellClass() ?>"><div id="elh_p_size_operator" class="p_size_operator"><div class="ew-table-header-caption"><?php echo $p_size->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $p_size->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->operator) ?>',2);"><div id="elh_p_size_operator" class="p_size_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_size->datetime->Visible) { // datetime ?>
	<?php if ($p_size->sortUrl($p_size->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $p_size->datetime->headerCellClass() ?>"><div id="elh_p_size_datetime" class="p_size_datetime"><div class="ew-table-header-caption"><?php echo $p_size->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $p_size->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_size->SortUrl($p_size->datetime) ?>',2);"><div id="elh_p_size_datetime" class="p_size_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_size->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_size->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_size->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$p_size_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($p_size->ExportAll && $p_size->isExport()) {
	$p_size_list->StopRec = $p_size_list->TotalRecs;
} else {

	// Set the last record to display
	if ($p_size_list->TotalRecs > $p_size_list->StartRec + $p_size_list->DisplayRecs - 1)
		$p_size_list->StopRec = $p_size_list->StartRec + $p_size_list->DisplayRecs - 1;
	else
		$p_size_list->StopRec = $p_size_list->TotalRecs;
}
$p_size_list->RecCnt = $p_size_list->StartRec - 1;
if ($p_size_list->Recordset && !$p_size_list->Recordset->EOF) {
	$p_size_list->Recordset->moveFirst();
	$selectLimit = $p_size_list->UseSelectLimit;
	if (!$selectLimit && $p_size_list->StartRec > 1)
		$p_size_list->Recordset->move($p_size_list->StartRec - 1);
} elseif (!$p_size->AllowAddDeleteRow && $p_size_list->StopRec == 0) {
	$p_size_list->StopRec = $p_size->GridAddRowCount;
}

// Initialize aggregate
$p_size->RowType = ROWTYPE_AGGREGATEINIT;
$p_size->resetAttributes();
$p_size_list->renderRow();
while ($p_size_list->RecCnt < $p_size_list->StopRec) {
	$p_size_list->RecCnt++;
	if ($p_size_list->RecCnt >= $p_size_list->StartRec) {
		$p_size_list->RowCnt++;

		// Set up key count
		$p_size_list->KeyCount = $p_size_list->RowIndex;

		// Init row class and style
		$p_size->resetAttributes();
		$p_size->CssClass = "";
		if ($p_size->isGridAdd()) {
		} else {
			$p_size_list->loadRowValues($p_size_list->Recordset); // Load row values
		}
		$p_size->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$p_size->RowAttrs = array_merge($p_size->RowAttrs, array('data-rowindex'=>$p_size_list->RowCnt, 'id'=>'r' . $p_size_list->RowCnt . '_p_size', 'data-rowtype'=>$p_size->RowType));

		// Render row
		$p_size_list->renderRow();

		// Render list options
		$p_size_list->renderListOptions();
?>
	<tr<?php echo $p_size->rowAttributes() ?>>
<?php

// Render list options (body, left)
$p_size_list->ListOptions->render("body", "left", $p_size_list->RowCnt);
?>
	<?php if ($p_size->id->Visible) { // id ?>
		<td data-name="id"<?php echo $p_size->id->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_id" class="p_size_id">
<span<?php echo $p_size->id->viewAttributes() ?>>
<?php echo $p_size->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->type->Visible) { // type ?>
		<td data-name="type"<?php echo $p_size->type->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_type" class="p_size_type">
<span<?php echo $p_size->type->viewAttributes() ?>>
<?php echo $p_size->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->description->Visible) { // description ?>
		<td data-name="description"<?php echo $p_size->description->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_description" class="p_size_description">
<span<?php echo $p_size->description->viewAttributes() ?>>
<?php echo $p_size->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->size->Visible) { // size ?>
		<td data-name="size"<?php echo $p_size->size->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_size" class="p_size_size">
<span<?php echo $p_size->size->viewAttributes() ?>>
<?php echo $p_size->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $p_size->rid->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_rid" class="p_size_rid">
<span<?php echo $p_size->rid->viewAttributes() ?>>
<?php echo $p_size->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->qty_in_sheet->Visible) { // qty_in_sheet ?>
		<td data-name="qty_in_sheet"<?php echo $p_size->qty_in_sheet->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_qty_in_sheet" class="p_size_qty_in_sheet">
<span<?php echo $p_size->qty_in_sheet->viewAttributes() ?>>
<?php echo $p_size->qty_in_sheet->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->status->Visible) { // status ?>
		<td data-name="status"<?php echo $p_size->status->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_status" class="p_size_status">
<span<?php echo $p_size->status->viewAttributes() ?>>
<?php echo $p_size->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $p_size->operator->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_operator" class="p_size_operator">
<span<?php echo $p_size->operator->viewAttributes() ?>>
<?php echo $p_size->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_size->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $p_size->datetime->cellAttributes() ?>>
<span id="el<?php echo $p_size_list->RowCnt ?>_p_size_datetime" class="p_size_datetime">
<span<?php echo $p_size->datetime->viewAttributes() ?>>
<?php echo $p_size->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$p_size_list->ListOptions->render("body", "right", $p_size_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$p_size->isGridAdd())
		$p_size_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$p_size->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($p_size_list->Recordset)
	$p_size_list->Recordset->Close();
?>
<?php if (!$p_size->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$p_size->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_size_list->Pager)) $p_size_list->Pager = new PrevNextPager($p_size_list->StartRec, $p_size_list->DisplayRecs, $p_size_list->TotalRecs, $p_size_list->AutoHidePager) ?>
<?php if ($p_size_list->Pager->RecordCount > 0 && $p_size_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_size_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_size_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_size_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_size_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_size_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_size_list->pageUrl() ?>start=<?php echo $p_size_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_size_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_size_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_size_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_size_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_size_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_size_list->TotalRecs > 0 && (!$p_size_list->AutoHidePageSizeSelector || $p_size_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_size">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_size_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_size_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_size_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_size_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_size_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_size->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_size_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($p_size_list->TotalRecs == 0 && !$p_size->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $p_size_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$p_size_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$p_size->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$p_size->isExport()) { ?>
<script>
ew.scrollableTable("gmp_p_size", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$p_size_list->terminate();
?>