<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_size_search = new p_size_search();

// Run the page
$p_size_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_size_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($p_size_search->IsModal) { ?>
var fp_sizesearch = currentAdvancedSearchForm = new ew.Form("fp_sizesearch", "search");
<?php } else { ?>
var fp_sizesearch = currentForm = new ew.Form("fp_sizesearch", "search");
<?php } ?>

// Form_CustomValidate event
fp_sizesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_sizesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_sizesearch.lists["x_type"] = <?php echo $p_size_search->type->Lookup->toClientList() ?>;
fp_sizesearch.lists["x_type"].options = <?php echo JsonEncode($p_size_search->type->options(FALSE, TRUE)) ?>;
fp_sizesearch.lists["x_size"] = <?php echo $p_size_search->size->Lookup->toClientList() ?>;
fp_sizesearch.lists["x_size"].options = <?php echo JsonEncode($p_size_search->size->lookupOptions()) ?>;
fp_sizesearch.lists["x_rid[]"] = <?php echo $p_size_search->rid->Lookup->toClientList() ?>;
fp_sizesearch.lists["x_rid[]"].options = <?php echo JsonEncode($p_size_search->rid->lookupOptions()) ?>;
fp_sizesearch.lists["x_status"] = <?php echo $p_size_search->status->Lookup->toClientList() ?>;
fp_sizesearch.lists["x_status"].options = <?php echo JsonEncode($p_size_search->status->options(FALSE, TRUE)) ?>;
fp_sizesearch.lists["x_operator"] = <?php echo $p_size_search->operator->Lookup->toClientList() ?>;
fp_sizesearch.lists["x_operator"].options = <?php echo JsonEncode($p_size_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fp_sizesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_size->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty_in_sheet");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_size->qty_in_sheet->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_size->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_size_search->showPageHeader(); ?>
<?php
$p_size_search->showMessage();
?>
<form name="fp_sizesearch" id="fp_sizesearch" class="<?php echo $p_size_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_size_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_size_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_size">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$p_size_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($p_size->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_id"><?php echo $p_size->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->id->cellAttributes() ?>>
			<span id="el_p_size_id">
<input type="text" data-table="p_size" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($p_size->id->getPlaceHolder()) ?>" value="<?php echo $p_size->id->EditValue ?>"<?php echo $p_size->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_type"><?php echo $p_size->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->type->cellAttributes() ?>>
			<span id="el_p_size_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_size" data-field="x_type" data-value-separator="<?php echo $p_size->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $p_size->type->editAttributes() ?>>
		<?php echo $p_size->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_description"><?php echo $p_size->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->description->cellAttributes() ?>>
			<span id="el_p_size_description">
<input type="text" data-table="p_size" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($p_size->description->getPlaceHolder()) ?>" value="<?php echo $p_size->description->EditValue ?>"<?php echo $p_size->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_size"><?php echo $p_size->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->size->cellAttributes() ?>>
			<span id="el_p_size_size">
<div id="tp_x_size" class="ew-template"><input type="radio" class="form-check-input" data-table="p_size" data-field="x_size" data-value-separator="<?php echo $p_size->size->displayValueSeparatorAttribute() ?>" name="x_size" id="x_size" value="{value}"<?php echo $p_size->size->editAttributes() ?>></div>
<div id="dsl_x_size" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $p_size->size->radioButtonListHtml(FALSE, "x_size") ?>
</div></div>
<?php echo $p_size->size->Lookup->getParamTag("p_x_size") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_rid"><?php echo $p_size->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->rid->cellAttributes() ?>>
			<span id="el_p_size_rid">
<div id="tp_x_rid" class="ew-template"><input type="checkbox" class="form-check-input" data-table="p_size" data-field="x_rid" data-value-separator="<?php echo $p_size->rid->displayValueSeparatorAttribute() ?>" name="x_rid[]" id="x_rid[]" value="{value}"<?php echo $p_size->rid->editAttributes() ?>></div>
<div id="dsl_x_rid" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $p_size->rid->checkBoxListHtml(FALSE, "x_rid[]") ?>
</div></div>
<?php echo $p_size->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->qty_in_sheet->Visible) { // qty_in_sheet ?>
	<div id="r_qty_in_sheet" class="form-group row">
		<label for="x_qty_in_sheet" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_qty_in_sheet"><?php echo $p_size->qty_in_sheet->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty_in_sheet" id="z_qty_in_sheet" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->qty_in_sheet->cellAttributes() ?>>
			<span id="el_p_size_qty_in_sheet">
<input type="text" data-table="p_size" data-field="x_qty_in_sheet" name="x_qty_in_sheet" id="x_qty_in_sheet" size="30" placeholder="<?php echo HtmlEncode($p_size->qty_in_sheet->getPlaceHolder()) ?>" value="<?php echo $p_size->qty_in_sheet->EditValue ?>"<?php echo $p_size->qty_in_sheet->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_status"><?php echo $p_size->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->status->cellAttributes() ?>>
			<span id="el_p_size_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_size" data-field="x_status" data-value-separator="<?php echo $p_size->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $p_size->status->editAttributes() ?>>
		<?php echo $p_size->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_operator"><?php echo $p_size->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->operator->cellAttributes() ?>>
			<span id="el_p_size_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_size" data-field="x_operator" data-value-separator="<?php echo $p_size->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $p_size->operator->editAttributes() ?>>
		<?php echo $p_size->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $p_size->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_size->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $p_size_search->LeftColumnClass ?>"><span id="elh_p_size_datetime"><?php echo $p_size->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $p_size_search->RightColumnClass ?>"><div<?php echo $p_size->datetime->cellAttributes() ?>>
			<span id="el_p_size_datetime">
<input type="text" data-table="p_size" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($p_size->datetime->getPlaceHolder()) ?>" value="<?php echo $p_size->datetime->EditValue ?>"<?php echo $p_size->datetime->editAttributes() ?>>
<?php if (!$p_size->datetime->ReadOnly && !$p_size->datetime->Disabled && !isset($p_size->datetime->EditAttrs["readonly"]) && !isset($p_size->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_sizesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$p_size_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_size_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_size_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_size_search->terminate();
?>