<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_size_view = new p_size_view();

// Run the page
$p_size_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_size_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$p_size->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fp_sizeview = currentForm = new ew.Form("fp_sizeview", "view");

// Form_CustomValidate event
fp_sizeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_sizeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_sizeview.lists["x_type"] = <?php echo $p_size_view->type->Lookup->toClientList() ?>;
fp_sizeview.lists["x_type"].options = <?php echo JsonEncode($p_size_view->type->options(FALSE, TRUE)) ?>;
fp_sizeview.lists["x_size"] = <?php echo $p_size_view->size->Lookup->toClientList() ?>;
fp_sizeview.lists["x_size"].options = <?php echo JsonEncode($p_size_view->size->lookupOptions()) ?>;
fp_sizeview.lists["x_rid[]"] = <?php echo $p_size_view->rid->Lookup->toClientList() ?>;
fp_sizeview.lists["x_rid[]"].options = <?php echo JsonEncode($p_size_view->rid->lookupOptions()) ?>;
fp_sizeview.lists["x_status"] = <?php echo $p_size_view->status->Lookup->toClientList() ?>;
fp_sizeview.lists["x_status"].options = <?php echo JsonEncode($p_size_view->status->options(FALSE, TRUE)) ?>;
fp_sizeview.lists["x_operator"] = <?php echo $p_size_view->operator->Lookup->toClientList() ?>;
fp_sizeview.lists["x_operator"].options = <?php echo JsonEncode($p_size_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$p_size->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $p_size_view->ExportOptions->render("body") ?>
<?php $p_size_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $p_size_view->showPageHeader(); ?>
<?php
$p_size_view->showMessage();
?>
<form name="fp_sizeview" id="fp_sizeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_size_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_size_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_size">
<input type="hidden" name="modal" value="<?php echo (int)$p_size_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($p_size->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_id"><?php echo $p_size->id->caption() ?></span></td>
		<td data-name="id"<?php echo $p_size->id->cellAttributes() ?>>
<span id="el_p_size_id">
<span<?php echo $p_size->id->viewAttributes() ?>>
<?php echo $p_size->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_type"><?php echo $p_size->type->caption() ?></span></td>
		<td data-name="type"<?php echo $p_size->type->cellAttributes() ?>>
<span id="el_p_size_type">
<span<?php echo $p_size->type->viewAttributes() ?>>
<?php echo $p_size->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_description"><?php echo $p_size->description->caption() ?></span></td>
		<td data-name="description"<?php echo $p_size->description->cellAttributes() ?>>
<span id="el_p_size_description">
<span<?php echo $p_size->description->viewAttributes() ?>>
<?php echo $p_size->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_size"><?php echo $p_size->size->caption() ?></span></td>
		<td data-name="size"<?php echo $p_size->size->cellAttributes() ?>>
<span id="el_p_size_size">
<span<?php echo $p_size->size->viewAttributes() ?>>
<?php echo $p_size->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_rid"><?php echo $p_size->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $p_size->rid->cellAttributes() ?>>
<span id="el_p_size_rid">
<span<?php echo $p_size->rid->viewAttributes() ?>>
<?php echo $p_size->rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->qty_in_sheet->Visible) { // qty_in_sheet ?>
	<tr id="r_qty_in_sheet">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_qty_in_sheet"><?php echo $p_size->qty_in_sheet->caption() ?></span></td>
		<td data-name="qty_in_sheet"<?php echo $p_size->qty_in_sheet->cellAttributes() ?>>
<span id="el_p_size_qty_in_sheet">
<span<?php echo $p_size->qty_in_sheet->viewAttributes() ?>>
<?php echo $p_size->qty_in_sheet->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_status"><?php echo $p_size->status->caption() ?></span></td>
		<td data-name="status"<?php echo $p_size->status->cellAttributes() ?>>
<span id="el_p_size_status">
<span<?php echo $p_size->status->viewAttributes() ?>>
<?php echo $p_size->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_operator"><?php echo $p_size->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $p_size->operator->cellAttributes() ?>>
<span id="el_p_size_operator">
<span<?php echo $p_size->operator->viewAttributes() ?>>
<?php echo $p_size->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($p_size->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $p_size_view->TableLeftColumnClass ?>"><span id="elh_p_size_datetime"><?php echo $p_size->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $p_size->datetime->cellAttributes() ?>>
<span id="el_p_size_datetime">
<span<?php echo $p_size->datetime->viewAttributes() ?>>
<?php echo $p_size->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$p_size_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$p_size->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$p_size_view->terminate();
?>