<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_stock_add = new p_stock_add();

// Run the page
$p_stock_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_stock_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fp_stockadd = currentForm = new ew.Form("fp_stockadd", "add");

// Validate form
fp_stockadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($p_stock_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->location->caption(), $p_stock->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_stock_add->s_date->Required) { ?>
			elm = this.getElements("x" + infix + "_s_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->s_date->caption(), $p_stock->s_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_s_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->s_date->errorMessage()) ?>");
		<?php if ($p_stock_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->rid->caption(), $p_stock->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_stock_add->b_stock->Required) { ?>
			elm = this.getElements("x" + infix + "_b_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->b_stock->caption(), $p_stock->b_stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_b_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->b_stock->errorMessage()) ?>");
		<?php if ($p_stock_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->packing_type->caption(), $p_stock->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->packing_type->errorMessage()) ?>");
		<?php if ($p_stock_add->shortage->Required) { ?>
			elm = this.getElements("x" + infix + "_shortage");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->shortage->caption(), $p_stock->shortage->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shortage");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->shortage->errorMessage()) ?>");
		<?php if ($p_stock_add->stock_id->Required) { ?>
			elm = this.getElements("x" + infix + "_stock_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->stock_id->caption(), $p_stock->stock_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_stock_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->lot_no->caption(), $p_stock->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($p_stock_add->b_stock_packets->Required) { ?>
			elm = this.getElements("x" + infix + "_b_stock_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->b_stock_packets->caption(), $p_stock->b_stock_packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_b_stock_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->b_stock_packets->errorMessage()) ?>");
		<?php if ($p_stock_add->p_stock_packets->Required) { ?>
			elm = this.getElements("x" + infix + "_p_stock_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->p_stock_packets->caption(), $p_stock->p_stock_packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_p_stock_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->p_stock_packets->errorMessage()) ?>");
		<?php if ($p_stock_add->shortage_packets->Required) { ?>
			elm = this.getElements("x" + infix + "_shortage_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $p_stock->shortage_packets->caption(), $p_stock->shortage_packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_shortage_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($p_stock->shortage_packets->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fp_stockadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_stockadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_stockadd.lists["x_location"] = <?php echo $p_stock_add->location->Lookup->toClientList() ?>;
fp_stockadd.lists["x_location"].options = <?php echo JsonEncode($p_stock_add->location->lookupOptions()) ?>;
fp_stockadd.lists["x_rid"] = <?php echo $p_stock_add->rid->Lookup->toClientList() ?>;
fp_stockadd.lists["x_rid"].options = <?php echo JsonEncode($p_stock_add->rid->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_stock_add->showPageHeader(); ?>
<?php
$p_stock_add->showMessage();
?>
<form name="fp_stockadd" id="fp_stockadd" class="<?php echo $p_stock_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_stock_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_stock_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_stock">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$p_stock_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($p_stock->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_p_stock_location" for="x_location" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->location->caption() ?><?php echo ($p_stock->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->location->cellAttributes() ?>>
<span id="el_p_stock_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_stock" data-field="x_location" data-value-separator="<?php echo $p_stock->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $p_stock->location->editAttributes() ?>>
		<?php echo $p_stock->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $p_stock->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $p_stock->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->s_date->Visible) { // s_date ?>
	<div id="r_s_date" class="form-group row">
		<label id="elh_p_stock_s_date" for="x_s_date" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->s_date->caption() ?><?php echo ($p_stock->s_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->s_date->cellAttributes() ?>>
<span id="el_p_stock_s_date">
<input type="text" data-table="p_stock" data-field="x_s_date" name="x_s_date" id="x_s_date" placeholder="<?php echo HtmlEncode($p_stock->s_date->getPlaceHolder()) ?>" value="<?php echo $p_stock->s_date->EditValue ?>"<?php echo $p_stock->s_date->editAttributes() ?>>
<?php if (!$p_stock->s_date->ReadOnly && !$p_stock->s_date->Disabled && !isset($p_stock->s_date->EditAttrs["readonly"]) && !isset($p_stock->s_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_stockadd", "x_s_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $p_stock->s_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_p_stock_rid" for="x_rid" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->rid->caption() ?><?php echo ($p_stock->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->rid->cellAttributes() ?>>
<span id="el_p_stock_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_stock" data-field="x_rid" data-value-separator="<?php echo $p_stock->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $p_stock->rid->editAttributes() ?>>
		<?php echo $p_stock->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $p_stock->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $p_stock->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->b_stock->Visible) { // b_stock ?>
	<div id="r_b_stock" class="form-group row">
		<label id="elh_p_stock_b_stock" for="x_b_stock" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->b_stock->caption() ?><?php echo ($p_stock->b_stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->b_stock->cellAttributes() ?>>
<span id="el_p_stock_b_stock">
<input type="text" data-table="p_stock" data-field="x_b_stock" name="x_b_stock" id="x_b_stock" size="30" placeholder="<?php echo HtmlEncode($p_stock->b_stock->getPlaceHolder()) ?>" value="<?php echo $p_stock->b_stock->EditValue ?>"<?php echo $p_stock->b_stock->editAttributes() ?>>
</span>
<?php echo $p_stock->b_stock->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_p_stock_packing_type" for="x_packing_type" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->packing_type->caption() ?><?php echo ($p_stock->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->packing_type->cellAttributes() ?>>
<span id="el_p_stock_packing_type">
<input type="text" data-table="p_stock" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($p_stock->packing_type->getPlaceHolder()) ?>" value="<?php echo $p_stock->packing_type->EditValue ?>"<?php echo $p_stock->packing_type->editAttributes() ?>>
</span>
<?php echo $p_stock->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->shortage->Visible) { // shortage ?>
	<div id="r_shortage" class="form-group row">
		<label id="elh_p_stock_shortage" for="x_shortage" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->shortage->caption() ?><?php echo ($p_stock->shortage->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->shortage->cellAttributes() ?>>
<span id="el_p_stock_shortage">
<input type="text" data-table="p_stock" data-field="x_shortage" name="x_shortage" id="x_shortage" size="30" placeholder="<?php echo HtmlEncode($p_stock->shortage->getPlaceHolder()) ?>" value="<?php echo $p_stock->shortage->EditValue ?>"<?php echo $p_stock->shortage->editAttributes() ?>>
</span>
<?php echo $p_stock->shortage->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->stock_id->Visible) { // stock_id ?>
	<div id="r_stock_id" class="form-group row">
		<label id="elh_p_stock_stock_id" for="x_stock_id" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->stock_id->caption() ?><?php echo ($p_stock->stock_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->stock_id->cellAttributes() ?>>
<span id="el_p_stock_stock_id">
<input type="text" data-table="p_stock" data-field="x_stock_id" name="x_stock_id" id="x_stock_id" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($p_stock->stock_id->getPlaceHolder()) ?>" value="<?php echo $p_stock->stock_id->EditValue ?>"<?php echo $p_stock->stock_id->editAttributes() ?>>
</span>
<?php echo $p_stock->stock_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_p_stock_lot_no" for="x_lot_no" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->lot_no->caption() ?><?php echo ($p_stock->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->lot_no->cellAttributes() ?>>
<span id="el_p_stock_lot_no">
<input type="text" data-table="p_stock" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($p_stock->lot_no->getPlaceHolder()) ?>" value="<?php echo $p_stock->lot_no->EditValue ?>"<?php echo $p_stock->lot_no->editAttributes() ?>>
</span>
<?php echo $p_stock->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->b_stock_packets->Visible) { // b_stock_packets ?>
	<div id="r_b_stock_packets" class="form-group row">
		<label id="elh_p_stock_b_stock_packets" for="x_b_stock_packets" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->b_stock_packets->caption() ?><?php echo ($p_stock->b_stock_packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->b_stock_packets->cellAttributes() ?>>
<span id="el_p_stock_b_stock_packets">
<input type="text" data-table="p_stock" data-field="x_b_stock_packets" name="x_b_stock_packets" id="x_b_stock_packets" size="30" placeholder="<?php echo HtmlEncode($p_stock->b_stock_packets->getPlaceHolder()) ?>" value="<?php echo $p_stock->b_stock_packets->EditValue ?>"<?php echo $p_stock->b_stock_packets->editAttributes() ?>>
</span>
<?php echo $p_stock->b_stock_packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->p_stock_packets->Visible) { // p_stock_packets ?>
	<div id="r_p_stock_packets" class="form-group row">
		<label id="elh_p_stock_p_stock_packets" for="x_p_stock_packets" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->p_stock_packets->caption() ?><?php echo ($p_stock->p_stock_packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->p_stock_packets->cellAttributes() ?>>
<span id="el_p_stock_p_stock_packets">
<input type="text" data-table="p_stock" data-field="x_p_stock_packets" name="x_p_stock_packets" id="x_p_stock_packets" size="30" placeholder="<?php echo HtmlEncode($p_stock->p_stock_packets->getPlaceHolder()) ?>" value="<?php echo $p_stock->p_stock_packets->EditValue ?>"<?php echo $p_stock->p_stock_packets->editAttributes() ?>>
</span>
<?php echo $p_stock->p_stock_packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($p_stock->shortage_packets->Visible) { // shortage_packets ?>
	<div id="r_shortage_packets" class="form-group row">
		<label id="elh_p_stock_shortage_packets" for="x_shortage_packets" class="<?php echo $p_stock_add->LeftColumnClass ?>"><?php echo $p_stock->shortage_packets->caption() ?><?php echo ($p_stock->shortage_packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $p_stock_add->RightColumnClass ?>"><div<?php echo $p_stock->shortage_packets->cellAttributes() ?>>
<span id="el_p_stock_shortage_packets">
<input type="text" data-table="p_stock" data-field="x_shortage_packets" name="x_shortage_packets" id="x_shortage_packets" size="30" placeholder="<?php echo HtmlEncode($p_stock->shortage_packets->getPlaceHolder()) ?>" value="<?php echo $p_stock->shortage_packets->EditValue ?>"<?php echo $p_stock->shortage_packets->editAttributes() ?>>
</span>
<?php echo $p_stock->shortage_packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$p_stock_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_stock_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $p_stock_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_stock_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_stock_add->terminate();
?>