<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_stock_list = new p_stock_list();

// Run the page
$p_stock_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_stock_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$p_stock->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fp_stocklist = currentForm = new ew.Form("fp_stocklist", "list");
fp_stocklist.formKeyCountName = '<?php echo $p_stock_list->FormKeyCountName ?>';

// Form_CustomValidate event
fp_stocklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_stocklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_stocklist.lists["x_location"] = <?php echo $p_stock_list->location->Lookup->toClientList() ?>;
fp_stocklist.lists["x_location"].options = <?php echo JsonEncode($p_stock_list->location->lookupOptions()) ?>;
fp_stocklist.lists["x_rid"] = <?php echo $p_stock_list->rid->Lookup->toClientList() ?>;
fp_stocklist.lists["x_rid"].options = <?php echo JsonEncode($p_stock_list->rid->lookupOptions()) ?>;
fp_stocklist.lists["x_operator"] = <?php echo $p_stock_list->operator->Lookup->toClientList() ?>;
fp_stocklist.lists["x_operator"].options = <?php echo JsonEncode($p_stock_list->operator->lookupOptions()) ?>;

// Form object for search
var fp_stocklistsrch = currentSearchForm = new ew.Form("fp_stocklistsrch");

// Validate function for search
fp_stocklistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fp_stocklistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_stocklistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_stocklistsrch.lists["x_rid"] = <?php echo $p_stock_list->rid->Lookup->toClientList() ?>;
fp_stocklistsrch.lists["x_rid"].options = <?php echo JsonEncode($p_stock_list->rid->lookupOptions()) ?>;

// Filters
fp_stocklistsrch.filterList = <?php echo $p_stock_list->getFilterList() ?>;

// Init search panel as collapsed
fp_stocklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$p_stock->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($p_stock_list->TotalRecs > 0 && $p_stock_list->ExportOptions->visible()) { ?>
<?php $p_stock_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($p_stock_list->ImportOptions->visible()) { ?>
<?php $p_stock_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($p_stock_list->SearchOptions->visible()) { ?>
<?php $p_stock_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($p_stock_list->FilterOptions->visible()) { ?>
<?php $p_stock_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$p_stock_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$p_stock->isExport() && !$p_stock->CurrentAction) { ?>
<form name="fp_stocklistsrch" id="fp_stocklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($p_stock_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fp_stocklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="p_stock">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$p_stock_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$p_stock->RowType = ROWTYPE_SEARCH;

// Render row
$p_stock->resetAttributes();
$p_stock_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($p_stock->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $p_stock->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="p_stock" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($p_stock->rid->getPlaceHolder()) ?>" value="<?php echo $p_stock->rid->EditValue ?>"<?php echo $p_stock->rid->editAttributes() ?>>
<?php echo $p_stock->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($p_stock_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($p_stock_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $p_stock_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($p_stock_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($p_stock_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($p_stock_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($p_stock_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $p_stock_list->showPageHeader(); ?>
<?php
$p_stock_list->showMessage();
?>
<?php if ($p_stock_list->TotalRecs > 0 || $p_stock->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($p_stock_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> p_stock">
<?php if (!$p_stock->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$p_stock->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_stock_list->Pager)) $p_stock_list->Pager = new PrevNextPager($p_stock_list->StartRec, $p_stock_list->DisplayRecs, $p_stock_list->TotalRecs, $p_stock_list->AutoHidePager) ?>
<?php if ($p_stock_list->Pager->RecordCount > 0 && $p_stock_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_stock_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_stock_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_stock_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_stock_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_stock_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_stock_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_stock_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_stock_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_stock_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_stock_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_stock_list->TotalRecs > 0 && (!$p_stock_list->AutoHidePageSizeSelector || $p_stock_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_stock">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_stock_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_stock_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_stock_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_stock_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_stock_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_stock->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_stock_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fp_stocklist" id="fp_stocklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_stock_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_stock_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_stock">
<div id="gmp_p_stock" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($p_stock_list->TotalRecs > 0 || $p_stock->isGridEdit()) { ?>
<table id="tbl_p_stocklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$p_stock_list->RowType = ROWTYPE_HEADER;

// Render list options
$p_stock_list->renderListOptions();

// Render list options (header, left)
$p_stock_list->ListOptions->render("header", "left");
?>
<?php if ($p_stock->id->Visible) { // id ?>
	<?php if ($p_stock->sortUrl($p_stock->id) == "") { ?>
		<th data-name="id" class="<?php echo $p_stock->id->headerCellClass() ?>"><div id="elh_p_stock_id" class="p_stock_id"><div class="ew-table-header-caption"><?php echo $p_stock->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $p_stock->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->id) ?>',2);"><div id="elh_p_stock_id" class="p_stock_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->location->Visible) { // location ?>
	<?php if ($p_stock->sortUrl($p_stock->location) == "") { ?>
		<th data-name="location" class="<?php echo $p_stock->location->headerCellClass() ?>"><div id="elh_p_stock_location" class="p_stock_location"><div class="ew-table-header-caption"><?php echo $p_stock->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $p_stock->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->location) ?>',2);"><div id="elh_p_stock_location" class="p_stock_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->s_date->Visible) { // s_date ?>
	<?php if ($p_stock->sortUrl($p_stock->s_date) == "") { ?>
		<th data-name="s_date" class="<?php echo $p_stock->s_date->headerCellClass() ?>"><div id="elh_p_stock_s_date" class="p_stock_s_date"><div class="ew-table-header-caption"><?php echo $p_stock->s_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_date" class="<?php echo $p_stock->s_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->s_date) ?>',2);"><div id="elh_p_stock_s_date" class="p_stock_s_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->s_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->s_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->s_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->rid->Visible) { // rid ?>
	<?php if ($p_stock->sortUrl($p_stock->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $p_stock->rid->headerCellClass() ?>"><div id="elh_p_stock_rid" class="p_stock_rid"><div class="ew-table-header-caption"><?php echo $p_stock->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $p_stock->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->rid) ?>',2);"><div id="elh_p_stock_rid" class="p_stock_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->b_stock->Visible) { // b_stock ?>
	<?php if ($p_stock->sortUrl($p_stock->b_stock) == "") { ?>
		<th data-name="b_stock" class="<?php echo $p_stock->b_stock->headerCellClass() ?>"><div id="elh_p_stock_b_stock" class="p_stock_b_stock"><div class="ew-table-header-caption"><?php echo $p_stock->b_stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_stock" class="<?php echo $p_stock->b_stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->b_stock) ?>',2);"><div id="elh_p_stock_b_stock" class="p_stock_b_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->b_stock->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_stock->b_stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->b_stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->p_stock->Visible) { // p_stock ?>
	<?php if ($p_stock->sortUrl($p_stock->p_stock) == "") { ?>
		<th data-name="p_stock" class="<?php echo $p_stock->p_stock->headerCellClass() ?>"><div id="elh_p_stock_p_stock" class="p_stock_p_stock"><div class="ew-table-header-caption"><?php echo $p_stock->p_stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="p_stock" class="<?php echo $p_stock->p_stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->p_stock) ?>',2);"><div id="elh_p_stock_p_stock" class="p_stock_p_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->p_stock->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_stock->p_stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->p_stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->remarks->Visible) { // remarks ?>
	<?php if ($p_stock->sortUrl($p_stock->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $p_stock->remarks->headerCellClass() ?>"><div id="elh_p_stock_remarks" class="p_stock_remarks"><div class="ew-table-header-caption"><?php echo $p_stock->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $p_stock->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->remarks) ?>',2);"><div id="elh_p_stock_remarks" class="p_stock_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_stock->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->remarks_1->Visible) { // remarks_1 ?>
	<?php if ($p_stock->sortUrl($p_stock->remarks_1) == "") { ?>
		<th data-name="remarks_1" class="<?php echo $p_stock->remarks_1->headerCellClass() ?>"><div id="elh_p_stock_remarks_1" class="p_stock_remarks_1"><div class="ew-table-header-caption"><?php echo $p_stock->remarks_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks_1" class="<?php echo $p_stock->remarks_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->remarks_1) ?>',2);"><div id="elh_p_stock_remarks_1" class="p_stock_remarks_1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->remarks_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_stock->remarks_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->remarks_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->operator->Visible) { // operator ?>
	<?php if ($p_stock->sortUrl($p_stock->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $p_stock->operator->headerCellClass() ?>"><div id="elh_p_stock_operator" class="p_stock_operator"><div class="ew-table-header-caption"><?php echo $p_stock->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $p_stock->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->operator) ?>',2);"><div id="elh_p_stock_operator" class="p_stock_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->datetime->Visible) { // datetime ?>
	<?php if ($p_stock->sortUrl($p_stock->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $p_stock->datetime->headerCellClass() ?>"><div id="elh_p_stock_datetime" class="p_stock_datetime"><div class="ew-table-header-caption"><?php echo $p_stock->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $p_stock->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->datetime) ?>',2);"><div id="elh_p_stock_datetime" class="p_stock_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->packing_type->Visible) { // packing_type ?>
	<?php if ($p_stock->sortUrl($p_stock->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $p_stock->packing_type->headerCellClass() ?>"><div id="elh_p_stock_packing_type" class="p_stock_packing_type"><div class="ew-table-header-caption"><?php echo $p_stock->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $p_stock->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->packing_type) ?>',2);"><div id="elh_p_stock_packing_type" class="p_stock_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->shortage->Visible) { // shortage ?>
	<?php if ($p_stock->sortUrl($p_stock->shortage) == "") { ?>
		<th data-name="shortage" class="<?php echo $p_stock->shortage->headerCellClass() ?>"><div id="elh_p_stock_shortage" class="p_stock_shortage"><div class="ew-table-header-caption"><?php echo $p_stock->shortage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shortage" class="<?php echo $p_stock->shortage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->shortage) ?>',2);"><div id="elh_p_stock_shortage" class="p_stock_shortage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->shortage->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->shortage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->shortage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->stock_id->Visible) { // stock_id ?>
	<?php if ($p_stock->sortUrl($p_stock->stock_id) == "") { ?>
		<th data-name="stock_id" class="<?php echo $p_stock->stock_id->headerCellClass() ?>"><div id="elh_p_stock_stock_id" class="p_stock_stock_id"><div class="ew-table-header-caption"><?php echo $p_stock->stock_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock_id" class="<?php echo $p_stock->stock_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->stock_id) ?>',2);"><div id="elh_p_stock_stock_id" class="p_stock_stock_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->stock_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_stock->stock_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->stock_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->lot_no->Visible) { // lot_no ?>
	<?php if ($p_stock->sortUrl($p_stock->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $p_stock->lot_no->headerCellClass() ?>"><div id="elh_p_stock_lot_no" class="p_stock_lot_no"><div class="ew-table-header-caption"><?php echo $p_stock->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $p_stock->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->lot_no) ?>',2);"><div id="elh_p_stock_lot_no" class="p_stock_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($p_stock->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->b_stock_packets->Visible) { // b_stock_packets ?>
	<?php if ($p_stock->sortUrl($p_stock->b_stock_packets) == "") { ?>
		<th data-name="b_stock_packets" class="<?php echo $p_stock->b_stock_packets->headerCellClass() ?>"><div id="elh_p_stock_b_stock_packets" class="p_stock_b_stock_packets"><div class="ew-table-header-caption"><?php echo $p_stock->b_stock_packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_stock_packets" class="<?php echo $p_stock->b_stock_packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->b_stock_packets) ?>',2);"><div id="elh_p_stock_b_stock_packets" class="p_stock_b_stock_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->b_stock_packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->b_stock_packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->b_stock_packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->p_stock_packets->Visible) { // p_stock_packets ?>
	<?php if ($p_stock->sortUrl($p_stock->p_stock_packets) == "") { ?>
		<th data-name="p_stock_packets" class="<?php echo $p_stock->p_stock_packets->headerCellClass() ?>"><div id="elh_p_stock_p_stock_packets" class="p_stock_p_stock_packets"><div class="ew-table-header-caption"><?php echo $p_stock->p_stock_packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="p_stock_packets" class="<?php echo $p_stock->p_stock_packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->p_stock_packets) ?>',2);"><div id="elh_p_stock_p_stock_packets" class="p_stock_p_stock_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->p_stock_packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->p_stock_packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->p_stock_packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($p_stock->shortage_packets->Visible) { // shortage_packets ?>
	<?php if ($p_stock->sortUrl($p_stock->shortage_packets) == "") { ?>
		<th data-name="shortage_packets" class="<?php echo $p_stock->shortage_packets->headerCellClass() ?>"><div id="elh_p_stock_shortage_packets" class="p_stock_shortage_packets"><div class="ew-table-header-caption"><?php echo $p_stock->shortage_packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shortage_packets" class="<?php echo $p_stock->shortage_packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $p_stock->SortUrl($p_stock->shortage_packets) ?>',2);"><div id="elh_p_stock_shortage_packets" class="p_stock_shortage_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $p_stock->shortage_packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($p_stock->shortage_packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($p_stock->shortage_packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$p_stock_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($p_stock->ExportAll && $p_stock->isExport()) {
	$p_stock_list->StopRec = $p_stock_list->TotalRecs;
} else {

	// Set the last record to display
	if ($p_stock_list->TotalRecs > $p_stock_list->StartRec + $p_stock_list->DisplayRecs - 1)
		$p_stock_list->StopRec = $p_stock_list->StartRec + $p_stock_list->DisplayRecs - 1;
	else
		$p_stock_list->StopRec = $p_stock_list->TotalRecs;
}
$p_stock_list->RecCnt = $p_stock_list->StartRec - 1;
if ($p_stock_list->Recordset && !$p_stock_list->Recordset->EOF) {
	$p_stock_list->Recordset->moveFirst();
	$selectLimit = $p_stock_list->UseSelectLimit;
	if (!$selectLimit && $p_stock_list->StartRec > 1)
		$p_stock_list->Recordset->move($p_stock_list->StartRec - 1);
} elseif (!$p_stock->AllowAddDeleteRow && $p_stock_list->StopRec == 0) {
	$p_stock_list->StopRec = $p_stock->GridAddRowCount;
}

// Initialize aggregate
$p_stock->RowType = ROWTYPE_AGGREGATEINIT;
$p_stock->resetAttributes();
$p_stock_list->renderRow();
while ($p_stock_list->RecCnt < $p_stock_list->StopRec) {
	$p_stock_list->RecCnt++;
	if ($p_stock_list->RecCnt >= $p_stock_list->StartRec) {
		$p_stock_list->RowCnt++;

		// Set up key count
		$p_stock_list->KeyCount = $p_stock_list->RowIndex;

		// Init row class and style
		$p_stock->resetAttributes();
		$p_stock->CssClass = "";
		if ($p_stock->isGridAdd()) {
		} else {
			$p_stock_list->loadRowValues($p_stock_list->Recordset); // Load row values
		}
		$p_stock->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$p_stock->RowAttrs = array_merge($p_stock->RowAttrs, array('data-rowindex'=>$p_stock_list->RowCnt, 'id'=>'r' . $p_stock_list->RowCnt . '_p_stock', 'data-rowtype'=>$p_stock->RowType));

		// Render row
		$p_stock_list->renderRow();

		// Render list options
		$p_stock_list->renderListOptions();
?>
	<tr<?php echo $p_stock->rowAttributes() ?>>
<?php

// Render list options (body, left)
$p_stock_list->ListOptions->render("body", "left", $p_stock_list->RowCnt);
?>
	<?php if ($p_stock->id->Visible) { // id ?>
		<td data-name="id"<?php echo $p_stock->id->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_id" class="p_stock_id">
<span<?php echo $p_stock->id->viewAttributes() ?>>
<?php echo $p_stock->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->location->Visible) { // location ?>
		<td data-name="location"<?php echo $p_stock->location->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_location" class="p_stock_location">
<span<?php echo $p_stock->location->viewAttributes() ?>>
<?php echo $p_stock->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->s_date->Visible) { // s_date ?>
		<td data-name="s_date"<?php echo $p_stock->s_date->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_s_date" class="p_stock_s_date">
<span<?php echo $p_stock->s_date->viewAttributes() ?>>
<?php echo $p_stock->s_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $p_stock->rid->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_rid" class="p_stock_rid">
<span<?php echo $p_stock->rid->viewAttributes() ?>>
<?php echo $p_stock->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->b_stock->Visible) { // b_stock ?>
		<td data-name="b_stock"<?php echo $p_stock->b_stock->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_b_stock" class="p_stock_b_stock">
<span<?php echo $p_stock->b_stock->viewAttributes() ?>>
<?php echo $p_stock->b_stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->p_stock->Visible) { // p_stock ?>
		<td data-name="p_stock"<?php echo $p_stock->p_stock->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_p_stock" class="p_stock_p_stock">
<span<?php echo $p_stock->p_stock->viewAttributes() ?>>
<?php echo $p_stock->p_stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $p_stock->remarks->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_remarks" class="p_stock_remarks">
<span<?php echo $p_stock->remarks->viewAttributes() ?>>
<?php echo $p_stock->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->remarks_1->Visible) { // remarks_1 ?>
		<td data-name="remarks_1"<?php echo $p_stock->remarks_1->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_remarks_1" class="p_stock_remarks_1">
<span<?php echo $p_stock->remarks_1->viewAttributes() ?>>
<?php echo $p_stock->remarks_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $p_stock->operator->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_operator" class="p_stock_operator">
<span<?php echo $p_stock->operator->viewAttributes() ?>>
<?php echo $p_stock->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $p_stock->datetime->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_datetime" class="p_stock_datetime">
<span<?php echo $p_stock->datetime->viewAttributes() ?>>
<?php echo $p_stock->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $p_stock->packing_type->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_packing_type" class="p_stock_packing_type">
<span<?php echo $p_stock->packing_type->viewAttributes() ?>>
<?php echo $p_stock->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->shortage->Visible) { // shortage ?>
		<td data-name="shortage"<?php echo $p_stock->shortage->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_shortage" class="p_stock_shortage">
<span<?php echo $p_stock->shortage->viewAttributes() ?>>
<?php echo $p_stock->shortage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->stock_id->Visible) { // stock_id ?>
		<td data-name="stock_id"<?php echo $p_stock->stock_id->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_stock_id" class="p_stock_stock_id">
<span<?php echo $p_stock->stock_id->viewAttributes() ?>>
<?php echo $p_stock->stock_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $p_stock->lot_no->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_lot_no" class="p_stock_lot_no">
<span<?php echo $p_stock->lot_no->viewAttributes() ?>>
<?php echo $p_stock->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->b_stock_packets->Visible) { // b_stock_packets ?>
		<td data-name="b_stock_packets"<?php echo $p_stock->b_stock_packets->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_b_stock_packets" class="p_stock_b_stock_packets">
<span<?php echo $p_stock->b_stock_packets->viewAttributes() ?>>
<?php echo $p_stock->b_stock_packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->p_stock_packets->Visible) { // p_stock_packets ?>
		<td data-name="p_stock_packets"<?php echo $p_stock->p_stock_packets->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_p_stock_packets" class="p_stock_p_stock_packets">
<span<?php echo $p_stock->p_stock_packets->viewAttributes() ?>>
<?php echo $p_stock->p_stock_packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($p_stock->shortage_packets->Visible) { // shortage_packets ?>
		<td data-name="shortage_packets"<?php echo $p_stock->shortage_packets->cellAttributes() ?>>
<span id="el<?php echo $p_stock_list->RowCnt ?>_p_stock_shortage_packets" class="p_stock_shortage_packets">
<span<?php echo $p_stock->shortage_packets->viewAttributes() ?>>
<?php echo $p_stock->shortage_packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$p_stock_list->ListOptions->render("body", "right", $p_stock_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$p_stock->isGridAdd())
		$p_stock_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$p_stock->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($p_stock_list->Recordset)
	$p_stock_list->Recordset->Close();
?>
<?php if (!$p_stock->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$p_stock->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($p_stock_list->Pager)) $p_stock_list->Pager = new PrevNextPager($p_stock_list->StartRec, $p_stock_list->DisplayRecs, $p_stock_list->TotalRecs, $p_stock_list->AutoHidePager) ?>
<?php if ($p_stock_list->Pager->RecordCount > 0 && $p_stock_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($p_stock_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($p_stock_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $p_stock_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($p_stock_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($p_stock_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $p_stock_list->pageUrl() ?>start=<?php echo $p_stock_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_stock_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($p_stock_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $p_stock_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $p_stock_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $p_stock_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($p_stock_list->TotalRecs > 0 && (!$p_stock_list->AutoHidePageSizeSelector || $p_stock_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="p_stock">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($p_stock_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($p_stock_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($p_stock_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($p_stock_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($p_stock_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($p_stock->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $p_stock_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($p_stock_list->TotalRecs == 0 && !$p_stock->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $p_stock_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$p_stock_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$p_stock->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$p_stock->isExport()) { ?>
<script>
ew.scrollableTable("gmp_p_stock", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$p_stock_list->terminate();
?>