<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$p_stock_search = new p_stock_search();

// Run the page
$p_stock_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_stock_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($p_stock_search->IsModal) { ?>
var fp_stocksearch = currentAdvancedSearchForm = new ew.Form("fp_stocksearch", "search");
<?php } else { ?>
var fp_stocksearch = currentForm = new ew.Form("fp_stocksearch", "search");
<?php } ?>

// Form_CustomValidate event
fp_stocksearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fp_stocksearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fp_stocksearch.lists["x_location"] = <?php echo $p_stock_search->location->Lookup->toClientList() ?>;
fp_stocksearch.lists["x_location"].options = <?php echo JsonEncode($p_stock_search->location->lookupOptions()) ?>;
fp_stocksearch.lists["x_rid"] = <?php echo $p_stock_search->rid->Lookup->toClientList() ?>;
fp_stocksearch.lists["x_rid"].options = <?php echo JsonEncode($p_stock_search->rid->lookupOptions()) ?>;
fp_stocksearch.lists["x_operator"] = <?php echo $p_stock_search->operator->Lookup->toClientList() ?>;
fp_stocksearch.lists["x_operator"].options = <?php echo JsonEncode($p_stock_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fp_stocksearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->s_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_b_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->b_stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_p_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->p_stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->packing_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_shortage");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->shortage->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_b_stock_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->b_stock_packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_p_stock_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->p_stock_packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_shortage_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($p_stock->shortage_packets->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $p_stock_search->showPageHeader(); ?>
<?php
$p_stock_search->showMessage();
?>
<form name="fp_stocksearch" id="fp_stocksearch" class="<?php echo $p_stock_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($p_stock_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $p_stock_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="p_stock">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$p_stock_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($p_stock->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_id"><?php echo $p_stock->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->id->cellAttributes() ?>>
			<span id="el_p_stock_id">
<input type="text" data-table="p_stock" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($p_stock->id->getPlaceHolder()) ?>" value="<?php echo $p_stock->id->EditValue ?>"<?php echo $p_stock->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_location"><?php echo $p_stock->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->location->cellAttributes() ?>>
			<span id="el_p_stock_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_stock" data-field="x_location" data-value-separator="<?php echo $p_stock->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $p_stock->location->editAttributes() ?>>
		<?php echo $p_stock->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $p_stock->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->s_date->Visible) { // s_date ?>
	<div id="r_s_date" class="form-group row">
		<label for="x_s_date" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_s_date"><?php echo $p_stock->s_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_date" id="z_s_date" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->s_date->cellAttributes() ?>>
			<span id="el_p_stock_s_date">
<input type="text" data-table="p_stock" data-field="x_s_date" name="x_s_date" id="x_s_date" placeholder="<?php echo HtmlEncode($p_stock->s_date->getPlaceHolder()) ?>" value="<?php echo $p_stock->s_date->EditValue ?>"<?php echo $p_stock->s_date->editAttributes() ?>>
<?php if (!$p_stock->s_date->ReadOnly && !$p_stock->s_date->Disabled && !isset($p_stock->s_date->EditAttrs["readonly"]) && !isset($p_stock->s_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_stocksearch", "x_s_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_rid"><?php echo $p_stock->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->rid->cellAttributes() ?>>
			<span id="el_p_stock_rid">
<input type="text" data-table="p_stock" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($p_stock->rid->getPlaceHolder()) ?>" value="<?php echo $p_stock->rid->EditValue ?>"<?php echo $p_stock->rid->editAttributes() ?>>
<?php echo $p_stock->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->b_stock->Visible) { // b_stock ?>
	<div id="r_b_stock" class="form-group row">
		<label for="x_b_stock" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_b_stock"><?php echo $p_stock->b_stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_stock" id="z_b_stock" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->b_stock->cellAttributes() ?>>
			<span id="el_p_stock_b_stock">
<input type="text" data-table="p_stock" data-field="x_b_stock" name="x_b_stock" id="x_b_stock" size="30" placeholder="<?php echo HtmlEncode($p_stock->b_stock->getPlaceHolder()) ?>" value="<?php echo $p_stock->b_stock->EditValue ?>"<?php echo $p_stock->b_stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->p_stock->Visible) { // p_stock ?>
	<div id="r_p_stock" class="form-group row">
		<label for="x_p_stock" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_p_stock"><?php echo $p_stock->p_stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_p_stock" id="z_p_stock" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->p_stock->cellAttributes() ?>>
			<span id="el_p_stock_p_stock">
<input type="text" data-table="p_stock" data-field="x_p_stock" name="x_p_stock" id="x_p_stock" size="30" placeholder="<?php echo HtmlEncode($p_stock->p_stock->getPlaceHolder()) ?>" value="<?php echo $p_stock->p_stock->EditValue ?>"<?php echo $p_stock->p_stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_remarks"><?php echo $p_stock->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->remarks->cellAttributes() ?>>
			<span id="el_p_stock_remarks">
<input type="text" data-table="p_stock" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($p_stock->remarks->getPlaceHolder()) ?>" value="<?php echo $p_stock->remarks->EditValue ?>"<?php echo $p_stock->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->remarks_1->Visible) { // remarks_1 ?>
	<div id="r_remarks_1" class="form-group row">
		<label for="x_remarks_1" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_remarks_1"><?php echo $p_stock->remarks_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks_1" id="z_remarks_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->remarks_1->cellAttributes() ?>>
			<span id="el_p_stock_remarks_1">
<input type="text" data-table="p_stock" data-field="x_remarks_1" name="x_remarks_1" id="x_remarks_1" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($p_stock->remarks_1->getPlaceHolder()) ?>" value="<?php echo $p_stock->remarks_1->EditValue ?>"<?php echo $p_stock->remarks_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_operator"><?php echo $p_stock->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->operator->cellAttributes() ?>>
			<span id="el_p_stock_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="p_stock" data-field="x_operator" data-value-separator="<?php echo $p_stock->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $p_stock->operator->editAttributes() ?>>
		<?php echo $p_stock->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $p_stock->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_datetime"><?php echo $p_stock->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->datetime->cellAttributes() ?>>
			<span id="el_p_stock_datetime">
<input type="text" data-table="p_stock" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($p_stock->datetime->getPlaceHolder()) ?>" value="<?php echo $p_stock->datetime->EditValue ?>"<?php echo $p_stock->datetime->editAttributes() ?>>
<?php if (!$p_stock->datetime->ReadOnly && !$p_stock->datetime->Disabled && !isset($p_stock->datetime->EditAttrs["readonly"]) && !isset($p_stock->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fp_stocksearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_packing_type"><?php echo $p_stock->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->packing_type->cellAttributes() ?>>
			<span id="el_p_stock_packing_type">
<input type="text" data-table="p_stock" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($p_stock->packing_type->getPlaceHolder()) ?>" value="<?php echo $p_stock->packing_type->EditValue ?>"<?php echo $p_stock->packing_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->shortage->Visible) { // shortage ?>
	<div id="r_shortage" class="form-group row">
		<label for="x_shortage" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_shortage"><?php echo $p_stock->shortage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shortage" id="z_shortage" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->shortage->cellAttributes() ?>>
			<span id="el_p_stock_shortage">
<input type="text" data-table="p_stock" data-field="x_shortage" name="x_shortage" id="x_shortage" size="30" placeholder="<?php echo HtmlEncode($p_stock->shortage->getPlaceHolder()) ?>" value="<?php echo $p_stock->shortage->EditValue ?>"<?php echo $p_stock->shortage->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->stock_id->Visible) { // stock_id ?>
	<div id="r_stock_id" class="form-group row">
		<label for="x_stock_id" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_stock_id"><?php echo $p_stock->stock_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_stock_id" id="z_stock_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->stock_id->cellAttributes() ?>>
			<span id="el_p_stock_stock_id">
<input type="text" data-table="p_stock" data-field="x_stock_id" name="x_stock_id" id="x_stock_id" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($p_stock->stock_id->getPlaceHolder()) ?>" value="<?php echo $p_stock->stock_id->EditValue ?>"<?php echo $p_stock->stock_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_lot_no"><?php echo $p_stock->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->lot_no->cellAttributes() ?>>
			<span id="el_p_stock_lot_no">
<input type="text" data-table="p_stock" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($p_stock->lot_no->getPlaceHolder()) ?>" value="<?php echo $p_stock->lot_no->EditValue ?>"<?php echo $p_stock->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->b_stock_packets->Visible) { // b_stock_packets ?>
	<div id="r_b_stock_packets" class="form-group row">
		<label for="x_b_stock_packets" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_b_stock_packets"><?php echo $p_stock->b_stock_packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_stock_packets" id="z_b_stock_packets" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->b_stock_packets->cellAttributes() ?>>
			<span id="el_p_stock_b_stock_packets">
<input type="text" data-table="p_stock" data-field="x_b_stock_packets" name="x_b_stock_packets" id="x_b_stock_packets" size="30" placeholder="<?php echo HtmlEncode($p_stock->b_stock_packets->getPlaceHolder()) ?>" value="<?php echo $p_stock->b_stock_packets->EditValue ?>"<?php echo $p_stock->b_stock_packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->p_stock_packets->Visible) { // p_stock_packets ?>
	<div id="r_p_stock_packets" class="form-group row">
		<label for="x_p_stock_packets" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_p_stock_packets"><?php echo $p_stock->p_stock_packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_p_stock_packets" id="z_p_stock_packets" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->p_stock_packets->cellAttributes() ?>>
			<span id="el_p_stock_p_stock_packets">
<input type="text" data-table="p_stock" data-field="x_p_stock_packets" name="x_p_stock_packets" id="x_p_stock_packets" size="30" placeholder="<?php echo HtmlEncode($p_stock->p_stock_packets->getPlaceHolder()) ?>" value="<?php echo $p_stock->p_stock_packets->EditValue ?>"<?php echo $p_stock->p_stock_packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($p_stock->shortage_packets->Visible) { // shortage_packets ?>
	<div id="r_shortage_packets" class="form-group row">
		<label for="x_shortage_packets" class="<?php echo $p_stock_search->LeftColumnClass ?>"><span id="elh_p_stock_shortage_packets"><?php echo $p_stock->shortage_packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shortage_packets" id="z_shortage_packets" value="="></span>
		</label>
		<div class="<?php echo $p_stock_search->RightColumnClass ?>"><div<?php echo $p_stock->shortage_packets->cellAttributes() ?>>
			<span id="el_p_stock_shortage_packets">
<input type="text" data-table="p_stock" data-field="x_shortage_packets" name="x_shortage_packets" id="x_shortage_packets" size="30" placeholder="<?php echo HtmlEncode($p_stock->shortage_packets->getPlaceHolder()) ?>" value="<?php echo $p_stock->shortage_packets->EditValue ?>"<?php echo $p_stock->shortage_packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$p_stock_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $p_stock_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$p_stock_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_stock_search->terminate();
?>